<?php
namespace App\Controllers;

use Illuminate\Container\Container;
use Illuminate\Database\Capsule\Manager as Capsule;
use Illuminate\Cache\CacheManager;
use ORM;

require_once __DIR__ . '/../Connection.php';

class BaseController
{
    public $db;
    public $eloquentDB;
    protected $capsule;
    public $connection;
    public $cache;
    public $config;
    public $container;

    public function __construct()
    {
        $this->eloquentDB = new \App\Connection();
        $this->initErrorReporting();
        $this->initCache();
        date_default_timezone_set($this->config['timezone'] ?? 'UTC');
    }

    protected function initErrorReporting()
    {
        if (strtolower(APP_STAGE) === 'dev') {
            ini_set('display_errors', 1);
            ini_set('display_startup_errors', 1);
            error_reporting(E_ALL);
            $whoops = new \Whoops\Run();
            $whoops->pushHandler(new \Whoops\Handler\PrettyPageHandler());
            $whoops->register();
        }
    }

    protected function initCache()
    {
        $this->container = new Container();
        $this->container->instance('app', $this->container);

        $env = require APP_SYSTEM_PATH . '/env.php';
        $this->container['config'] = new \Illuminate\Config\Repository($env);
        $this->container['files'] = new \Illuminate\Filesystem\Filesystem();

        $cacheManager = new CacheManager($this->container);
        $this->cache = $cacheManager->store();
    }

    protected function defineURLs()
    {
        if ($this->config['url_rewrite'] == '1') {
            define('U', APP_URL . '/');
            define('BASE_URL', APP_URL . '/');
        } else {
            define('U', APP_URL . '/?ng=');
            define('BASE_URL', APP_URL . '/?ng=');
        }
        define('BASE_URL_ALT', APP_URL . '/?ng=');
    }
}
