<?php
namespace App\Controllers;

use Smarty;

class UIController
{
    public $ui;

    public function __construct($config, $language = [])
    {
        $this->ui = new Smarty();
        $app_theme = $config['theme'] ?? 'default';

        $this->ui->setTemplateDir("ui/theme/{$app_theme}/");
        $this->ui->setCompileDir("storage/compiled/");
        $this->ui->setCacheDir("storage/cache/");

        $this->ui->assign('config', $config);
        $this->ui->assign('_L', $language);
        $this->ui->assign('app_theme', $app_theme);
        $this->ui->assign('app_url', APP_URL . '/');

        $this->assignURLs($config);
        $this->assignNotifications();
        $this->registerNativeModifiers();
    }

    protected function assignURLs($config)
    {
        if ($config['url_rewrite'] == '1') {
            $this->ui->assign('_url', APP_URL . '/');
            $this->ui->assign('base_url', APP_URL . '/');
        } else {
            $this->ui->assign('_url', APP_URL . '/?ng=');
            $this->ui->assign('base_url', APP_URL . '/?ng=');
        }
    }

    protected function assignNotifications()
    {
        if (!empty($_SESSION['notify'])) {
            $notify = $_SESSION['notify'];
            $ntype = $_SESSION['ntype'] ?? 'warning';
            $alertType = ($ntype === 's' || $ntype === 'success') ? 'success' : 'warning';

            $html = "<div class='alert alert-{$alertType} alert-dismissible fade show' role='alert'>
                {$notify}
                <button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='Close'></button>
            </div>";

            $this->ui->assign('notify', $html);

            unset($_SESSION['notify'], $_SESSION['ntype']);
        }
    }

    protected function registerNativeModifiers()
    {
        // PHP built-ins wrappers as Smarty functions/modifiers
        $dateFn = function($params) {
            $format = $params['format'] ?? ($params[0] ?? 'Y-m-d');
            $time   = $params['time'] ?? ($params[1] ?? time());
            $ts = is_numeric($time) ? (int)$time : strtotime($time);
            return date($format, $ts);
        };
        $strtotimeFn = function($params) {
            $time = $params['time'] ?? ($params[0] ?? '');
            return strtotime($time);
        };
        $formatCurrencyFn = function($params) {
            $amount   = $params['amount'] ?? ($params[0] ?? 0);
            $currency = $params['currency'] ?? ($params[1] ?? false);
            return formatCurrency($amount, $currency);
        };

        // Register functions
        $this->ui->registerPlugin('function', 'date', $dateFn);
        $this->ui->registerPlugin('function', 'strtotime', $strtotimeFn);
        $this->ui->registerPlugin('function', 'formatCurrency', $formatCurrencyFn);

        // Register modifiers
        $this->ui->registerPlugin('modifier', 'date', $dateFn);
        $this->ui->registerPlugin('modifier', 'strtotime', $strtotimeFn);
        $this->ui->registerPlugin('modifier', 'formatCurrency', $formatCurrencyFn);

        $this->ui->registerPlugin('modifier', 'number_format', 'number_format');
        $this->ui->registerPlugin('modifier', 'explode', 'explode');
        //$this->ui->registerPlugin('modifier', '__', fn($str) => $str);
        $this->ui->registerPlugin('modifier', '_raid', '_raid');
        $this->ui->registerPlugin('modifier', 'str_pad', 'str_pad');
        $this->ui->registerPlugin('modifier', 'predict_next_serial', 'predict_next_serial');
        $this->ui->registerPlugin('modifier', 'numberFormatUsingCurrency', 'numberFormatUsingCurrency');
        $this->ui->registerPlugin('modifier', 'sp_transform_string_template', 'sp_transform_string_template');
    
        $this->ui->registerPlugin('function', '__', function($params, $smarty) {
            return __($params['text']);
        });
    }

    public function getUI()
    {
        return $this->ui;
    }
}
