<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Connection;
use ORM;

class Tags extends Model
{
    protected $table = 'sys_tags';

    protected static function booted()
    {
        $capsule = new Connection();
        static::setConnectionResolver($capsule->getCapsule()->getDatabaseManager());
    }

    public static function saveTags($tags = [], $type = 'Contacts')
    {
        if (is_array($tags)) {
            foreach ($tags as $element) {
                $tg = ORM::for_table('sys_tags')
                    ->where('text', $element)
                    ->where('type', $type)
                    ->first();
                if (!$tg) {
                    $tc = ORM::for_table('sys_tags')->create();
                    $tc->text = $element;
                    $tc->type = $type;
                    $tc->save();
                }
            }

            return true;
        } else {
            return false;
        }
    }

    public static function get_all($type = 'Contacts')
    {
        return ORM::for_table('sys_tags')
            ->where('type', $type)
            ->find_many();
    }

}
