<?php
//require_once __DIR__ . '/../../../vendor/autoload.php';

use Bramus\Router\Router;

$API_PATH = "/api";

$router = new Router();
$router->setNamespace('\App\Controllers');


// Suprimir warnings en json
error_reporting(E_ALL & ~E_WARNING & ~E_NOTICE);

/*error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);*/

$path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
if ($path != '/' && substr($path, -1) == '/') {
    $newPath = rtrim($path, '/');

    $query = $_SERVER['QUERY_STRING'] ? '?' . $_SERVER['QUERY_STRING'] : '';
    header("Location: $newPath$query", true, 301);
    exit();
}


// Dashboard Controller
$router->get("{$API_PATH}/dashboard/data", 'DashboardController@getDashboardData');
$router->get("{$API_PATH}/dashboard/user/data", 'EmployeeDashboardController@getDashboardData');
$router->post("{$API_PATH}/dashboard/user/data", 'EmployeeDashboardController@getDashboardData');

// Smarty API Controller
$router->get("{$API_PATH}/address/suggest", 'SmartyAPIController@suggestAddress');
$router->get("{$API_PATH}/address/select-unit", 'SmartyAPIController@selectUnit');

// Customer Controller
$router->post("{$API_PATH}/contacts/list", 'CustomerController@list');
$router->get("{$API_PATH}/contacts/summary/{id}", 'CustomerController@getSummary');
$router->post("{$API_PATH}/contacts/update/{id}", 'CustomerController@updateContact');

// Plaid Controller
$router->post("{$API_PATH}/plaid/create_link_token", 'PlaidController@createLinkToken');
$router->post("{$API_PATH}/plaid/exchange_public_token", 'PlaidController@exchangePublicToken');
$router->post("{$API_PATH}/plaid/transactions", 'PlaidController@getTransactions');
$router->get("{$API_PATH}/plaid/connection/status", 'PlaidController@connectionStatus');

// Company Controller
$router->post("{$API_PATH}/company/list", 'CompanyController@list');

// 404
$router->set404(function() {});

$router->run();
