{extends file="$layouts_client"}

{block name="head"}

<style>
    .finance-hero-intro {
        color: #6b7280;
        font-size: 14px;
        margin-bottom: 12px;
    }
    .finance-hero-card {
        background: #fff;
        border-radius: 14px;
        box-shadow: 0 12px 40px rgba(17, 24, 39, 0.12);
        padding: 90px 90px 60px;
        text-align: center;
        border: 1px solid #edf1f9;
        margin-bottom: 35px;
    }
    .finance-hero-icon {
        width: 96px;
        height: 96px;
        border-radius: 50%;
        background: linear-gradient(180deg, #f4f7ff 0%, #e6edff 100%);
        display: grid;
        place-items: center;
        margin: 0 auto 16px;
        position: relative;
    }
    .finance-hero-icon svg {
        width: 42px;
        height: 42px;
    }
    .finance-hero-icon .checkmark svg {
        width: 13px;
        height: 24px;
        color: #ffffff;
    }
    .finance-hero-icon .checkmark{
        position: absolute;
        bottom: 6px;
        right: 6px;
        background: #16a34a;
        border: 2px solid #fff;
        border-radius: 50%;
        width: 26px;
        height: 26px;
        display: grid;
        place-items: center;
        color: #fff;
        box-shadow: 0 6px 16px rgba(22, 163, 74, 0.28);
    }
    .finance-hero-title{
        font-size: 1.4rem;
        margin-bottom: 10px;
        color: #0f172a;
    }
    .finance-hero-copy{
        color: #4b5563;
        max-width: 620px;
        margin: 0 auto 18px;
        line-height: 1.6;
    }



    .plaid-connection-act {
        display: flex;
        flex-direction: column;
        gap: 15px;
        justify-content: center;
        align-items: center;
        width: 100%;
        margin: 50px 0 40px;
    }
    .plaid-primary-btn{
        background: linear-gradient(90deg, #1f6ae6 0%, #1b56d0 100%);
        border: none;
        color: #fff;
        font-weight: 600;
        padding: 12px 20px;
        border-radius: 8px;
        box-shadow: 0 10px 22px rgba(31, 106, 230, 0.35);
        transition: transform 0.1s ease, box-shadow 0.2s ease;
        display: inline-flex;
        align-items: center;
        gap: 8px;
    }
    .plaid-primary-btn:disabled{
        opacity: .75;
        cursor: not-allowed;
        box-shadow: none;
    }
    .plaid-primary-btn:not(:disabled):hover{
        transform: translateY(-1px);
        box-shadow: 0 12px 24px rgba(31, 106, 230, 0.4);
    }
    .plaid-secured{
        display: inline-flex;
        align-items: center;
        gap: 8px;
        color: #6b7280;
        font-size: 12px;
        text-transform: uppercase;
        letter-spacing: 0.6px;
        margin: 16px 0 10px;
    }
    .finance-feature-grid{
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(180px, 1fr));
        gap: 14px;
        margin-top: 18px;
    }
    .finance-feature{
        background: #f8fafc;
        border: 1px solid #edf1f9;
        border-radius: 12px;
        padding: 12px 14px;
        text-align: left;
        display: flex;
        gap: 10px;
        align-items: flex-start;
    }
    .finance-feature .icon{
        width: 38px;
        height: 38px;
        border-radius: 10px;
        background: #e8efff;
        color: #1f6ae6;
        display: grid;
        place-items: center;
    }
    .finance-feature h4{
        margin: 0;
        font-size: 14px;
        color: #111827;
    }
    .finance-feature p{
        margin: 2px 0 0;
        color: #6b7280;
        font-size: 12px;
    }
    .finance-footnote{
        margin-top: 14px;
        color: #9ca3af;
        font-size: 12px;
        text-align: center;
    }
    .finance-footnote a{
        color: #1f6ae6;
        text-decoration: none;
    }
    .finance-connected-bar{
        background: linear-gradient(90deg, #e8efff 0%, #f8fafc 100%);
        border: 1px solid #e3e8f5;
        border-radius: 12px;
        padding: 16px;
        display: flex;
        flex-wrap: wrap;
        gap: 12px;
        align-items: center;
        justify-content: space-between;
        margin-bottom: 12px;
    }
    .finance-connected-info{
        display: flex;
        gap: 12px;
        align-items: center;
        color: #0f172a;
        font-weight: 600;
    }
    .connected-chip {
        background: #d1fae5;
        color: #01976d;
        padding: 6px 10px;
        border-radius: 999px;
        border: 1px solid #01976d;
        font-weight: 500;
        font-size: 12px;
        display: inline-flex;
        align-items: center;
        gap: 6px;
    }
    .finance-actions{
        display: flex;
        gap: 8px;
        flex-wrap: wrap;
        align-items: center;
    }
    .finance-search{
        max-width: 240px;
    }
    .table-striped tbody tr:nth-of-type(odd) {
        background-color: #F7F9FC;
    }

    .h2, h2 {
        font-size: 1.25rem;
    }
    .h1, .h2, .h3, .h4, .h5, .h6, h1, h2, h3, h4, h5, h6 {
        font-family: inherit;
        font-weight: 600;
        line-height: 1.5;
        margin-bottom: .5rem;
        color: #32325d;
    }
    .text-info{
        color: #6772E5!important;
    }
    .text-success{
        color: #2CCE89!important;
    }
    .skeleton-table{
        background: #fff;
        border-radius: 10px;
        padding: 12px;
        box-shadow: 0 2px 6px rgba(17,24,39,0.06);
    }
    .skeleton-row{
        display: grid;
        grid-template-columns: 1fr 1fr 1fr 1fr 1fr;
        gap: 12px;
        padding: 10px 0;
        align-items: center;
        border-bottom: 1px solid #f1f3f7;
    }
    .skeleton-cell{
        height: 14px;
        border-radius: 6px;
        background: linear-gradient(90deg, #f1f3f7 0%, #e4e8ef 50%, #f1f3f7 100%);
        background-size: 200% 100%;
        animation: shimmer 1.2s ease-in-out infinite;
    }
    @keyframes shimmer{
        0% { background-position: -200% 0; }
        100% { background-position: 200% 0; }
    }
    .sort-icon{
        width: 12px;
        height: 12px;
        margin-left: 6px;
        color: #cbd0d8;
        transition: color 0.2s ease, transform 0.2s ease;
    }
    .sort-icon.is-asc,
    .sort-icon.is-desc{
        color: #6772E5;
    }
    .sort-icon.is-asc{
        transform: rotate(180deg);
    }

</style>
{/block}

{block name="content"}
<div id="plaid-app">

    <div v-if="!connected" class="finance-hero">
        <div class="finance-hero-intro">Manage your connected financial accounts and data sources securely.</div>
        <div class="finance-hero-card">
            <div class="finance-hero-icon">
                <svg xmlns="http://www.w3.org/2000/svg" width="800px" height="800px" viewBox="0 0 24 24" fill="none">
                    <path d="M8 6.75C5.10051 6.75 2.75 9.10051 2.75 12C2.75 14.8995 5.10051 17.25 8 17.25H9C9.41421 17.25 9.75 17.5858 9.75 18C9.75 18.4142 9.41421 18.75 9 18.75H8C4.27208 18.75 1.25 15.7279 1.25 12C1.25 8.27208 4.27208 5.25 8 5.25H9C9.41421 5.25 9.75 5.58579 9.75 6C9.75 6.41421 9.41421 6.75 9 6.75H8Z" fill="#1f6ae6"/>
                    <path d="M8.24991 11.9999C8.24991 11.5857 8.58569 11.2499 8.99991 11.2499H14.9999C15.4141 11.2499 15.7499 11.5857 15.7499 11.9999C15.7499 12.4142 15.4141 12.7499 14.9999 12.7499H8.99991C8.58569 12.7499 8.24991 12.4142 8.24991 11.9999Z" fill="#1f6ae6"/>
                    <path d="M15 5.25C14.5858 5.25 14.25 5.58579 14.25 6C14.25 6.41421 14.5858 6.75 15 6.75H16C18.8995 6.75 21.25 9.10051 21.25 12C21.25 14.8995 18.8995 17.25 16 17.25H15C14.5858 17.25 14.25 17.5858 14.25 18C14.25 18.4142 14.5858 18.75 15 18.75H16C19.7279 18.75 22.75 15.7279 22.75 12C22.75 8.27208 19.7279 5.25 16 5.25H15Z" fill="#1f6ae6"/>
                </svg>
                <span class="checkmark">
                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="3" stroke-linecap="round" stroke-linejoin="round">
                        <polyline points="20 6 9 17 4 12"></polyline>
                    </svg>
                </span>
            </div>
            <div class="finance-hero-title">Link your bank account to start tracking</div>
            <p class="finance-hero-copy">
                Connect your primary business account to automatically sync transactions. We use Plaid to securely access your financial data without ever storing your login credentials.
            </p>

            <div class="plaid-connection-act">
                    
                <button type="button" class="plaid-primary-btn" @click="connect" :disabled="loading">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M21 12H3"></path><path d="M15 18l6-6-6-6"></path>
                    </svg>
                    {{ loading ? 'Connecting...' : 'Connect with Plaid' }}
                </button>
                <div class="plaid-secured">
                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect>
                        <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
                    </svg>
                    Secured by Plaid
                </div>
            
            </div>

            <div class="finance-feature-grid">
                <div class="finance-feature">
                    <span class="icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"></path>
                        </svg>
                    </span>
                    <div>
                        <h4>Bank-grade Security</h4>
                        <p>256-bit encryption standard</p>
                    </div>
                </div>
                <div class="finance-feature">
                    <span class="icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <circle cx="12" cy="12" r="10"></circle>
                            <circle cx="12" cy="12" r="3"></circle>
                        </svg>
                    </span>
                    <div>
                        <h4>Read-only Access</h4>
                        <p>We cannot move your money</p>
                    </div>
                </div>
                <div class="finance-feature">
                    <span class="icon">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" fill="currentColor" version="1.1" width="18" height="18" viewBox="0 0 538.842 538.842" xml:space="preserve">
                            <g><g><polygon points="392.326,200.43 325.083,200.43 423.691,0 280.813,0 133.933,298.54 210.513,298.54 115.151,538.842   "/></g></g>
                        </svg>
                    </span>
                    <div>
                        <h4>Real-time Updates</h4>
                        <p>Syncs every few hours</p>
                    </div>
                </div>
            </div>
        </div>

        
        <div class="finance-footnote">
            <p>Supports 11,000+ financial institutions including Chase, Wells Fargo, and Bank of America.<br>
            By clicking "Connect with Plaid", you agree to our <a href="#" tabindex="-1">Terms of Service</a> and <a href="#" tabindex="-1">Privacy Policy</a>.</p>
        </div>
    </div>

    <div v-else class="panel">
    
        <div class="panel-hdr">
            <h2>Finance</h2>
        </div>

        <div class="panel-container">

            <div class="panel-content">

                <div class="finance-connected">
                    <div class="finance-connected-bar">
                        <div class="finance-connected-info">
                            <div class="connected-chip">
                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <polyline points="20 6 9 17 4 12"></polyline>
                                </svg>
                                Connected
                            </div>
                            <div>{{ institution || 'Linked bank account' }}</div>
                        </div>
                        <div class="finance-actions">
                            <input type="search" v-model="search" class="form-control input-search-table finance-search" placeholder="Search transactions">
                            <button type="button" class="button" @click="getTransactions" :disabled="loading">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <polyline points="23 4 23 10 17 10"></polyline>
                                    <polyline points="1 20 1 14 7 14"></polyline>
                                    <path d="M3.51 9a9 9 0 0 1 14.85-3.36L23 10"></path>
                                    <path d="M20.49 15a9 9 0 0 1-14.85 3.36L1 14"></path>
                                </svg>
                                {{ loading ? 'Refreshing...' : 'Refresh' }}
                            </button>
                        </div>
                    </div>

                    <div class="table-container transactions-table mt-3">
                        <div v-if="loading" class="skeleton-table">
                            <div class="skeleton-row" v-for="n in 6" :key="n">
                                <div class="skeleton-cell" style="width: 120px;"></div>
                                <div class="skeleton-cell" style="width: 60%;"></div>
                                <div class="skeleton-cell" style="width: 40%;"></div>
                                <div class="skeleton-cell" style="width: 50%;"></div>
                                <div class="skeleton-cell" style="width: 80px;"></div>
                            </div>
                        </div>
                        <table v-else id="transactions">
                            <thead>
                                <tr>
                                    <th @click="toggleSort('date')" role="button">
                                        Date
                                        <svg class="sort-icon" :class="sortKey === 'date' ? (sortDir === 'asc' ? 'is-asc' : 'is-desc') : 'is-neutral'" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true">
                                            <path d="M12 16l-6-6h12z"></path>
                                        </svg>
                                    </th>
                                    <th @click="toggleSort('name')" role="button">
                                        Description
                                        <svg class="sort-icon" :class="sortKey === 'name' ? (sortDir === 'asc' ? 'is-asc' : 'is-desc') : 'is-neutral'" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true">
                                            <path d="M12 16l-6-6h12z"></path>
                                        </svg>
                                    </th>
                                    <th class="text-start" @click="toggleSort('amount')" role="button">
                                        Amount
                                        <svg class="sort-icon" :class="sortKey === 'amount' ? (sortDir === 'asc' ? 'is-asc' : 'is-desc') : 'is-neutral'" viewBox="0 0 24 24" fill="currentColor" aria-hidden="true">
                                            <path d="M12 16l-6-6h12z"></path>
                                        </svg>
                                    </th>
                                    <th>Account Name</th>
                                    <th>Account Type</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr v-if="!paged.length && !loading">
                                    <td colspan="5">No transactions found.</td>
                                </tr>
                                <tr v-for="tx in paged" :key="tx.transaction_id || (tx.name + tx.date)">
                                    <td>{{ tx.date }}</td>
                                    <td>{{ tx.name }}</td>
                                    <td class="text-start" :class="tx.amount < 0 ? 'text-negative' : 'text-positive'">
                                        {{ tx.amount }} {{ tx.iso_currency_code }}
                                    </td>
                                    <td>{{ accountName(tx.account_id) }}</td>
                                    <td>{{ accountSubtype(tx.account_id) }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <div class="table-footer mt-2" v-if="filtered.length">
                        <div>Showing {{ pageStart + 1 }} to {{ Math.min(pageStart + pageSize, filtered.length) }} of {{ filtered.length }} entries</div>
                        <div class="d-flex align-items-center gap-2">
                            <select v-model.number="pageSize" class="form-control select-per-page">
                                <option :value="10">10 per page</option>
                                <option :value="25">25 per page</option>
                                <option :value="50">50 per page</option>
                            </select>
                            <div class="table-paging">
                                <button class="button" @click="goToPage(currentPage - 1)" :disabled="currentPage === 1"><</button>
                                <button
                                    v-for="page in pageNumbers"
                                    :key="page"
                                    class="button"
                                    :class="page === currentPage ? 'button-active-page' : ''"
                                    @click="goToPage(page)"
                                >
                                    {{ page }}
                                </button>
                                <button class="button" @click="goToPage(currentPage + 1)" :disabled="currentPage >= totalPages">></button>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

        </div>

    </div>

</div>
{/block}

{block name="script"}
<script>
const { createApp, ref, computed, onMounted } = Vue;

createApp({
    setup() {
        const loading = ref(false);
        const connected = ref(false);
        const institution = ref(null);
        const transactions = ref([]);
        const accounts = ref([]);
        const search = ref('');
        const sortKey = ref(null);
        const sortDir = ref('asc');
        const pageSize = ref(10);
        const currentPage = ref(1);

        const pageNumbers = computed(() => {
            const total = totalPages.value;
            const current = currentPage.value;
            const windowSize = 5;
            let start = Math.max(1, current - 2);
            let end = Math.min(total, start + windowSize - 1);
            if (end - start < windowSize - 1) {
                start = Math.max(1, end - windowSize + 1);
            }
            const pages = [];
            for (let i = start; i <= end; i++) {
                pages.push(i);
            }
            return pages;
        });

        const filtered = computed(() => {
            const term = search.value.trim().toLowerCase();
            let list = transactions.value;
            if (term) {
                list = list.filter(tx => {
                    return (tx.name || '').toLowerCase().includes(term)
                        || (tx.date || '').toLowerCase().includes(term)
                        || String(tx.amount || '').includes(term);
                });
            }
            if (sortKey.value) {
                list = [...list].sort((a, b) => {
                    const dir = sortDir.value === 'asc' ? 1 : -1;
                    const va = a[sortKey.value] ?? '';
                    const vb = b[sortKey.value] ?? '';
                    if (typeof va === 'number' && typeof vb === 'number') {
                        return (va - vb) * dir;
                    }
                    return String(va).localeCompare(String(vb)) * dir;
                });
            }
            return list;
        });

        const totalPages = computed(() => Math.max(1, Math.ceil(filtered.value.length / pageSize.value)));
        const pageStart = computed(() => (currentPage.value - 1) * pageSize.value);
        const paged = computed(() => filtered.value.slice(pageStart.value, pageStart.value + pageSize.value));

        const accountMap = computed(() => {
            const map = {};
            (accounts.value || []).forEach(acc => {
                if (acc && acc.account_id) {
                    map[acc.account_id] = {
                        name: acc.name || '',
                        subtype: acc.subtype || ''
                    };
                }
            });
            return map;
        });

        const accountName = (accountId) => (accountMap.value[accountId] && accountMap.value[accountId].name) || '';
        const accountSubtype = (accountId) => (accountMap.value[accountId] && accountMap.value[accountId].subtype) || '-';

        const toggleSort = (key) => {
            if (sortKey.value === key) {
                sortDir.value = sortDir.value === 'asc' ? 'desc' : 'asc';
            } else {
                sortKey.value = key;
                sortDir.value = 'asc';
            }
        };

        const goToPage = (page) => {
            if (page < 1) page = 1;
            if (page > totalPages.value) page = totalPages.value;
            currentPage.value = page;
        };

        const ensurePageInRange = () => {
            if (currentPage.value > totalPages.value) {
                currentPage.value = totalPages.value;
            }
        };

        const fetchStatus = async () => {
            try {
                const res = await fetch('{$app_url}api/plaid/connection/status');
                if (!res.ok) {
                    connected.value = false;
                    toastr.error('Connection error');
                    return;
                }
                const data = await res.json();
                connected.value = !!data.connected;
                institution.value = data.institution_name || null;
            } catch (err) {
                console.error('No se pudo obtener el estado de Plaid', err);
                connected.value = false;
            }
        };

        const handleTransactionsResponse = (data) => {
            if (!data || typeof data !== 'object') {
                toastr.error('No se pudo leer la respuesta de transacciones. Intenta nuevamente.');
                return false;
            }
            if (data.error_code === 'ITEM_LOGIN_REQUIRED') {
                toastr.error('Tu banco requiere que vuelvas a conectarte. Presiona "Connect bank account" para actualizar el acceso.');
                connected.value = false;
                return false;
            }
            if (data.error || data.error_message || data.error_type) {
                const msg = data.error_message || data.display_message || data.error || 'Error al obtener transacciones.';
                toastr.error(msg);
                return false;
            }
            if (!Array.isArray(data.transactions)) {
                toastr.error('No se recibieron transacciones en la respuesta.');
                return false;
            }
            return true;
        };

        const getTransactions = async () => {
            loading.value = true;
            try {
                const response = await fetch('{$app_url}api/plaid/transactions', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({})
                });
                const data = await response.json();
                if (!handleTransactionsResponse(data)) return;
                transactions.value = data.transactions || [];
                accounts.value = data.accounts || [];
                ensurePageInRange();
            } catch (err) {
                console.error('Fallo al obtener transacciones', err);
                toastr.error('No se pudieron obtener transacciones. Intenta nuevamente.');
            } finally {
                loading.value = false;
            }
        };

        const connect = async () => {
            loading.value = true;
            try {
                const res = await fetch('{$app_url}api/plaid/create_link_token', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' }
                });
                if (!res.ok) {
                    const err = await res.json().catch(() => ({}));
                    toastr.error('Error obteniendo link token: ' + (err.error || res.status));
                    return;
                }
                const body = await res.json();
                const linkToken = body.link_token;
                if (!linkToken) {
                    toastr.error('Link token invalido.');
                    return;
                }

                const handler = Plaid.create({
                    token: linkToken,
                    onSuccess: async function(public_token) {
                        try {
                            const exchangeRes = await fetch('{$app_url}api/plaid/exchange_public_token', {
                                method: 'POST',
                                headers: { 'Content-Type': 'application/json' },
                                body: JSON.stringify({ public_token })
                            });
                            const exchangeBody = await exchangeRes.json();
                            if (!exchangeRes.ok) {
                                toastr.error(exchangeBody.error || 'Connection error');
                                return;
                            }
                            toastr.success('Connected account');
                            await fetchStatus();
                            if (connected.value) {
                                getTransactions();
                            }
                        } catch (err) {
                            console.error(err);
                            toastr.error('Connection error');
                        }
                    },
                    onExit: function(err) {
                        if (err) {
                            console.error('Plaid Link exit with error:', err);
                        }
                    },
                    onEvent: function(eventName, metadata) {
                        console.log('Plaid event', eventName, metadata);
                    }
                });
                handler.open();
            } catch (err) {
                console.error(err);
                toastr.error('Plaid Link error: ' + err.message);
            } finally {
                loading.value = false;
            }
        };

        onMounted(async () => {
            await fetchStatus();
            if (connected.value) {
                getTransactions();
            }
        });

        return {
            loading,
            connected,
            institution,
            transactions,
            search,
            filtered,
            paged,
            pageSize,
            currentPage,
            totalPages,
            pageStart,
            toggleSort,
            goToPage,
            pageNumbers,
            sortKey,
            sortDir,
            connect,
            getTransactions,
            accountName,
            accountSubtype
        };
    }
}).mount('#plaid-app');
</script>
{/block}
