{extends file="$layouts_admin"}

{block name="content"}
<div class="row">

    <div class="col-md-12">

        <div class="panel">

		<!-- panel hdr -->
            <div class="panel-hdr">
                <h2>{'List Companies'}</h2>

                <div class="panel-toolbar">
					<button type="button" class="btn btn-primary add_company">
						<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="currentColor">
							<path d="M5 10.0002H15.0006M10.0002 5V15.0006" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
						</svg>
						{'Add Company'}
					</button>
                </div>
            </div>
			<!-- panel hdr -->


			<!-- panel container -->
			<div class="panel-container show">

				<div class="panel-content">
					<div class="table-responsive" id="ib_data_panel">

						<div class="table-data-content">
						
							<table id="crm_table_records">
								<thead>
									<tr>
										<th></th>
                                        <th>{$_L['Logo']}</th>
                                        <th>{$_L['Company Name']}</th>
                                        <th>{$_L['Email']}</th>
										<th>{$_L['Phone']}</th>
										<th width="80">{$_L['Manage']}</th>
									</tr>
								</thead>
								<tbody></tbody>
							</table>

						</div>

					</div>
				</div>


			</div>
			<!-- panel container -->

        </div>
    </div>

</div>
{/block}

{block name="script"}
<script>
window.crmDataTableConfig = {
    baseUrl: "{$_url}",
    ajaxUrl: "{$app_url}api/company/list",
    tableSelector: "#crm_table_records",
	paths: {
		base: "{$app_url}/",
		storage: "{$app_url}storage/companies/",
        view: "{$_url}company/view/[[id]]",
        groupList: "{$_url}company/list/customer/"
    },
    translations: {
        noItems: "{$_L['No items to display']}",
        showing: "{$_L['Showing _START_ to _END_ of _TOTAL_ entries']}",
        searchPlaceholder: "{__('Search')}"
    },
	columns: [
		{ data: 'id' },
		{
			data: 'logo_url',
			render: function(data, type, row) {
				return renderImage(data, 'display', row);
			}
		},
		{ data: 'company_name' },
		{ data: 'email' },
		{ data: 'phone' },
        {
            data: null,
            render: function(row, type, data) {
                return `<div class="float-end d-flex">
                            <button class="btn btn-icon me-2 item-view" data-id="`+row.id+`" data-action="view" title="View">
                                <svg class="fill-current" width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M8.0254 6.17845C8.0254 4.90629 9.05669 3.875 10.3289 3.875C11.601 3.875 12.6323 4.90629 12.6323 6.17845C12.6323 7.45061 11.601 8.48191 10.3289 8.48191C9.05669 8.48191 8.0254 7.45061 8.0254 6.17845ZM10.3289 2.375C8.22827 2.375 6.5254 4.07786 6.5254 6.17845C6.5254 8.27904 8.22827 9.98191 10.3289 9.98191C12.4294 9.98191 14.1323 8.27904 14.1323 6.17845C14.1323 4.07786 12.4294 2.375 10.3289 2.375ZM8.92286 11.03C5.7669 11.03 3.2085 13.5884 3.2085 16.7444V17.0333C3.2085 17.4475 3.54428 17.7833 3.9585 17.7833C4.37271 17.7833 4.7085 17.4475 4.7085 17.0333V16.7444C4.7085 14.4169 6.59533 12.53 8.92286 12.53H11.736C14.0635 12.53 15.9504 14.4169 15.9504 16.7444V17.0333C15.9504 17.4475 16.2861 17.7833 16.7004 17.7833C17.1146 17.7833 17.4504 17.4475 17.4504 17.0333V16.7444C17.4504 13.5884 14.8919 11.03 11.736 11.03H8.92286Z" fill=""></path></svg>
                            </button>
                            <button class="btn btn-icon me-2 item-edit" data-id="`+row.id+`" data-action="edit" title="Edit">
                                <svg class="fill-current" width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M17.0911 3.53206C16.2124 2.65338 14.7878 2.65338 13.9091 3.53206L5.6074 11.8337C5.29899 12.1421 5.08687 12.5335 4.99684 12.9603L4.26177 16.445C4.20943 16.6931 4.286 16.9508 4.46529 17.1301C4.64458 17.3094 4.90232 17.3859 5.15042 17.3336L8.63507 16.5985C9.06184 16.5085 9.45324 16.2964 9.76165 15.988L18.0633 7.68631C18.942 6.80763 18.942 5.38301 18.0633 4.50433L17.0911 3.53206ZM14.9697 4.59272C15.2626 4.29982 15.7375 4.29982 16.0304 4.59272L17.0027 5.56499C17.2956 5.85788 17.2956 6.33276 17.0027 6.62565L16.1043 7.52402L14.0714 5.49109L14.9697 4.59272ZM13.0107 6.55175L6.66806 12.8944C6.56526 12.9972 6.49455 13.1277 6.46454 13.2699L5.96704 15.6283L8.32547 15.1308C8.46772 15.1008 8.59819 15.0301 8.70099 14.9273L15.0436 8.58468L13.0107 6.55175Z" fill=""></path></svg>
                            </button>
                        </div>
                    `;
            }
        }
	],
    onInitComplete: function(dt) {
        //console.log("Tabla inicializada", dt);
    }
};
</script>
<script>
var tab = 'summary';

function updateDiv(action, base_url, cid, cb) {

    var $ibox_form = $('#ibox_form');
    $ibox_form.block({ message: block_msg });

    $('.list-group a.active').removeClass('active');
    $("#"+action).addClass("active");

    $.post(base_url +  "contacts/company_" +action + '/', { cid: cid })
        .done(function (data) {

        $("#application_ajaxrender").html(data);
        $ibox_form.unblock();

        cb();

        $('.amount').autoNumeric('init');

    });
}

var cb = function cb() {

    switch(tab) {
        case "memo":

            break;

        default:
    }

};

// add company
$('.add_company').on('click', function(e){

    e.preventDefault();

    $.fancybox.open({
        src: base_url + 'contacts/modal_add_company',
        type: 'ajax',
        opts: {
            afterShow : function( instance, current ) {
                $("#ajax-modal .country").select2();
            }
        },
    });

});


var $modal = $('#cloudonex_body');
var _url = $("#_url").val();

// modal submit
$modal.on('click', '.modal_submit', function(e){

    e.preventDefault();

    $.post( _url + "contacts/add_company_post/", $("#ib_modal_form").serialize())
        .done(function( data ) {

            if ($.isNumeric(data)) {
                location.reload();
            }

            else {
                toastr.error(data);
            }
        });

});

// view row
$modal.on('click', '.item-view', function(e){

    e.preventDefault();
    var id = $(this).data("id");

    $.fancybox.open({
        src  :  base_url + 'contacts/modal_view_company/'+id,
        type : 'ajax',
        opts : {
            afterShow : function( instance, current ) {
                updateDiv('summary',base_url,id,cb);
            }
        },
    });

});

// edit row
$modal.on('click', '.item-edit', function(e){

    e.preventDefault();
    var id = $(this).data("id");

    $.fancybox.open({
        src  :  base_url + 'contacts/modal_add_company/' + id,
        type : 'ajax',
        opts : {
            afterShow : function( instance, current ) {
                $("#ajax-modal .country").select2();
            }
        },
    });

});


////
$modal.on('click', '.act_memo_update', function(e){
    e.preventDefault();

    $.post( base_url + "contacts/company_update_notes/", { id: $('#base_cid').val(), memo:$("#v_memo").val() })
        .done(function( data ) {
            toastr.success(data);
        });
});


$modal.on('click', '.li_memo', function(e){
    var cid = $('#base_cid').val();
    e.preventDefault();
    tab = 'memo';
    updateDiv(tab,base_url,cid,cb);
});


$modal.on('click', '.li_customers', function(e){
    var cid = $('#base_cid').val();
    e.preventDefault();
    tab = 'customers';
    updateDiv(tab,base_url,cid,cb);
});

$modal.on('click', '.li_summary', function(e){
    var cid = $('#base_cid').val();
    e.preventDefault();
    tab = 'summary';
    updateDiv(tab,base_url,cid,cb);
});


$modal.on('click', '.li_summary', function(e){
    var cid = $('#base_cid').val();
    e.preventDefault();
    tab = 'summary';
    updateDiv(tab,base_url,cid,cb);
});

$modal.on('click', '.li_invoices', function(e){
    var cid = $('#base_cid').val();
    e.preventDefault();
    tab = 'invoices';
    updateDiv(tab,base_url,cid,cb);
});


$modal.on('click', '.li_quotes', function(e){
    var cid = $('#base_cid').val();
    e.preventDefault();
    tab = 'quotes';
    updateDiv(tab,base_url,cid,cb);
});


$modal.on('click', '.li_orders', function(e){
    var cid = $('#base_cid').val();
    e.preventDefault();
    tab = 'orders';
    updateDiv(tab,base_url,cid,cb);
});


$modal.on('click', '.li_files', function(e){
    var cid = $('#base_cid').val();
    e.preventDefault();
    tab = 'files';
    updateDiv(tab,base_url,cid,cb);
});


$modal.on('click', '.li_transactions', function(e){
    var cid = $('#base_cid').val();
    e.preventDefault();
    tab = 'transactions';
    updateDiv(tab,base_url,cid,cb);
});


$modal.on('click', '.li_tickets', function(e){
    var cid = $('#base_cid').val();
    e.preventDefault();
    tab = 'tickets';
    updateDiv(tab,base_url,cid,cb);
});


$modal.on('click', '.send_email', function(e){
    e.preventDefault();
    sendEmail($(this).html(),true);
});

$("#ib_data_table").on('click', '.send_email', function(e){
    e.preventDefault();
    sendEmail($(this).html(),false);
});


$modal.on('click', '#btn_send_email', function(e){
    e.preventDefault();
    $modal.modal('loading');
    $.post( base_url + "handler/send_email_post/", {
        to: $('#toemail').val(),
        subject: $('#subject').val(),
        message: tinyMCE.activeEditor.getContent()

    })
        .done(function( data ) {

            if ($.isNumeric(data)) {

                location.reload();

            }

            else {
                $modal.modal('loading');
                toastr.error(data);
            }

        });
});
</script>
{/block}