{extends file="$layouts_admin"}

{block name="head"}
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
{/block}


{block name="content"}


    <div class="container-xxl">

        <div class="overview-header">

            <div class="title">
                <h1>Overview</h1>
            </div>

            <div class="datepicker-cta">
                <div class="range-toggle" role="group" aria-label="Date range preset">
                    <button type="button" class="range-btn is-active" data-range="weekly">Weekly</button>
                    <button type="button" class="range-btn" data-range="monthly">Monthly</button>
                    <button type="button" class="range-btn" data-range="yearly">Yearly</button>
                </div>

                <button type="button" class="date-display" aria-label="Open date range picker">
                    <span class="icon" aria-hidden="true">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.6" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M8 7V4m8 3V4m-9 7h10M5 20h14a1 1 0 001-1V7a1 1 0 00-1-1H5a1 1 0 00-1 1v12a1 1 0 001 1z" />
                        </svg>
                    </span>
                    <span class="date-display-text">Select range</span>
                </button>
                <input type="text" id="dashboard-date-range" class="date-range-input" aria-hidden="true" />
            </div>

        </div>

        <div class="row">

            <div class="col-12">
                <div id="cards-all-data" class="row" style="display:none;">
                    <div class="col-md-4">
                        <div class="card-box">
                            <div class="card-content">  
                                <h3 class="title-lg">Total Sales</h3>
                                <p class="value" id="stat-total-sales">--</p>
                                <!--<div class="trending text-positive" id="trend-sales-wrap">
                                    <span class="trending-icon" id="trend-sales-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"><path d="M1.41421 16.4322L0 15.018L7.07107 7.94693L13.435 14.3109L17.6777 10.0682L15.9353 8.32587L22.6274 6.53271L20.8343 13.2248L19.0919 11.4825L13.435 17.1393L7.07107 10.7754L1.41421 16.4322Z" fill="#039855"/></svg>
                                    </span>
                                    <p class="trending-value" id="trend-sales">--</p>
                                    <span style="color:#667085;font-size:12px;font-weight:400;">From last week</span>
                                </div>-->
                            </div>
                            <div class="card-end">
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="card-box">
                            <div class="card-content">
                                <h3 class="title-lg">Total Invoices</h3>
                                <p class="value" id="stat-total-invoices">--</p>
                                <!--<div class="trending text-positive" id="trend-invoices-wrap">
                                    <span class="trending-icon" id="trend-invoices-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"><path d="M1.41421 16.4322L0 15.018L7.07107 7.94693L13.435 14.3109L17.6777 10.0682L15.9353 8.32587L22.6274 6.53271L20.8343 13.2248L19.0919 11.4825L13.435 17.1393L7.07107 10.7754L1.41421 16.4322Z" fill="#039855"/></svg>
                                    </span>
                                    <p class="trending-value" id="trend-invoices">--</p>
                                    <span style="color:#667085;font-size:12px;font-weight:400;">From last week</span>
                                </div>-->
                            </div>
                            <div class="card-end">
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="card-box">
                            <div class="card-content">
                                <h3 class="title-lg">Paid / Partially Paid</h3>
                                <p class="value"><span id="stat-paid-count">--</span> / <span id="stat-partially-paid-count">--</span></p>
                                <!--<div class="trending text-positive" id="trend-paid-wrap">
                                    <span class="trending-icon" id="trend-paid-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"><path d="M1.41421 16.4322L0 15.018L7.07107 7.94693L13.435 14.3109L17.6777 10.0682L15.9353 8.32587L22.6274 6.53271L20.8343 13.2248L19.0919 11.4825L13.435 17.1393L7.07107 10.7754L1.41421 16.4322Z" fill="#039855"/></svg>
                                    </span>
                                    <p class="trending-value" id="trend-paid">--</p>
                                    <span style="color:#667085;font-size:12px;font-weight:400;">From last week</span>
                                </div>-->
                            </div>
                            <div class="card-end">
                            </div>
                        </div>
                    </div>
                </div>

                <div id="cards-limited-data" class="row" style="display:none;">
                    <div class="col-md-4">
                        <div class="card-box">
                            <div class="card-content">  
                                <h3 class="title-lg">Customers</h3>
                                <p class="value" id="customers-total">--</p>
                                <div class="trending text-positive">
                                    <span class="trending-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"><path d="M1.41421 16.4322L0 15.018L7.07107 7.94693L13.435 14.3109L17.6777 10.0682L15.9353 8.32587L22.6274 6.53271L20.8343 13.2248L19.0919 11.4825L13.435 17.1393L7.07107 10.7754L1.41421 16.4322Z" fill="#039855"/></svg>
                                    </span>
                                    <span style="color:#667085;font-size:12px;font-weight:400;">From last month</span>
                                </div>
                            </div>
                            <div class="card-end">
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="card-box">
                            <div class="card-content">
                                <h3 class="title-lg">Companies</h3>
                                <p class="value" id="companies-total">--</p>
                                <div class="trending text-positive">
                                    <span class="trending-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"><path d="M1.41421 16.4322L0 15.018L7.07107 7.94693L13.435 14.3109L17.6777 10.0682L15.9353 8.32587L22.6274 6.53271L20.8343 13.2248L19.0919 11.4825L13.435 17.1393L7.07107 10.7754L1.41421 16.4322Z" fill="#039855"/></svg>
                                    </span>
                                    <span style="color:#667085;font-size:12px;font-weight:400;">From last month</span>
                                </div>
                            </div>
                            <div class="card-end">
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="card-box">
                            <div class="card-content">
                                <h3 class="title-lg">Leads</h3>
                                <p class="value" id="leads-total">--</p>
                                <div class="trending text-positive">
                                    <span class="trending-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"><path d="M1.41421 16.4322L0 15.018L7.07107 7.94693L13.435 14.3109L17.6777 10.0682L15.9353 8.32587L22.6274 6.53271L20.8343 13.2248L19.0919 11.4825L13.435 17.1393L7.07107 10.7754L1.41421 16.4322Z" fill="#039855"/></svg>
                                    </span>
                                    <span style="color:#667085;font-size:12px;font-weight:400;">From last month</span>
                                </div>
                            </div>
                            <div class="card-end">
                            </div>
                        </div>
                    </div>
                </div>
            </div>


        </div>


        <div class="row">

            <div class="col-md-9">
                <div class="card-box" style="min-height: 469px;">
                    <div class="card-content">
                        <h3 class="title-lg">Profit and Loss</h3>
                        <div id="income_vs_expenses_chart"></div>
                    </div>
                </div>
            </div>

            <div class="col-md-3">

                <div class="card-box" style="min-height: 469px;">
                    <div class="card-content">
                        <h2 class="title-lg">Recent Activity</h2>
                        <div id="recent-sales-container">
                            <p class="text-muted small" id="recent-sales-empty" style="display:none;">No recent sales to display</p>
                            <ul class="list-unstyled recent-sales" id="recent-sales-list"></ul>
                        </div>

                    </div>
                </div>

            </div>

        </div>

        
        
        <div class="row mb-3">

            <div class="col-md-4">
                <div class="card-box" style="min-height: 600px;">
                    <div class="card-content">
                        <h3 class="title-lg">Payment Methods</h3>
                        <div id="payment_methods_chart"></div>
                        <div id="payment_methods_legend" class="mt-2"></div>
                        <p class="text-muted" id="payment_methods_empty" style="display:none;">No data available.</p>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card-box" style="min-height: 600px;">
                    <div class="card-content">
                        <h3 class="title-lg">Invoices</h3>

                        <div class="d-flex justify-content-between align-items-center mt-3">
                            <div>
                                <div class="small text-muted">You sold</div>
                                <div class="h4 mb-0" id="inv-sold-total">--</div>
                            </div>
                            <!--<div class="text-end">
                                <div class="small text-muted">Stripe Deposit</div>
                                <div class="h5 mb-0" id="inv-stripe-total">--</div>
                            </div>-->
                        </div>

                        <div class="d-flex justify-content-between align-items-center mt-4">
                            <div>
                                <div class="small text-muted">Total invoice (Paid + Partially Paid)</div>
                                <div class="h4 mb-0" id="inv-total-paid-partial">--</div>
                            </div>
                            <!--<div class="text-end">
                                <div class="small text-muted">Bank deposit</div>
                                <div class="h5 mb-0" id="inv-bank-total">--</div>
                            </div>-->
                        </div>

                        <div class="mt-4">
                            <div class="d-flex justify-content-between text-muted mb-2">
                                <div>Total Invoices</div>
                                <div id="inv-count-sales">--</div>
                            </div>
                            <div class="d-flex justify-content-between text-muted mb-2">
                                <div>Paid</div>
                                <div id="inv-count-paid">--</div>
                            </div>
                            <div class="d-flex justify-content-between text-muted mb-2">
                                <div>Partially paid</div>
                                <div id="inv-count-partial">--</div>
                            </div>
                            <div class="d-flex justify-content-between text-muted mb-2">
                                <div>Not Paid</div>
                                <div id="inv-count-unpaid">--</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card-box" style="min-height: 600px;">
                    <div class="card-content">
                        <h3 class="title-lg">Top Services</h3>
                        <div id="top_services_chart"></div>
                        <div id="top_services_legend" class="mt-2"></div>
                        <p class="text-muted" id="top_services_empty" style="display:none;">No data available.</p>
                    </div>
                </div>
            </div>

        </div>

        <div class="row mb-3">
            <div class="col-md-8">
                <div class="card-box" style="min-height: 500px;">
                    <div class="card-content">
                        <h3 class="title-lg">Staff Sales (selected range)</h3>
                        <div id="staff_sales_chart"></div>
                        <p class="text-muted" id="staff_sales_empty" style="display:none;">No data available.</p>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card-box" style="min-height: 400px;">
                    <div class="card-content">
                        <h3 class="title-lg">Staff Sales Detail</h3>
                        <style>
                            #staff_sales_list { counter-reset: staff-counter; }
                            #staff_sales_list li {
                                counter-increment: staff-counter;
                                position: relative;
                                padding-left: 1.75rem;
                            }
                            #staff_sales_list li.total-row {
                                counter-increment: none;
                            }
                            #staff_sales_list li::before {
                                content: counter(staff-counter) ".";
                                position: absolute;
                                left: 0;
                                color: #6c757d;
                                font-weight: 600;
                            }
                            #staff_sales_list li.total-row::before {
                                content: '';
                                display: none;
                            }
                        </style>
                        <ol class="ps-3" style="list-style: decimal inside !important; padding-left: 1.25rem;" id="staff_sales_list"></ol>
                    </div>
                </div>
            </div>
        </div>

    </div> 

{/block}

{block name="script"}
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script>


        $(function () {

            var dashboardApiUrl = "{$app_url}api/dashboard/data";
            var currentRange = 'weekly';
            var currentStart = null;
            var currentEnd = null;
            var chartInstances = {
                paymentMethods: null,
                topServices: null,
                incomeVsExp: null,
                staffSales: null
            };
            var dateDisplayBtn = document.querySelector('.date-display');
            var dateDisplayText = document.querySelector('.date-display-text');
            var dateRangeInput = document.querySelector('#dashboard-date-range');
            var rangePicker;

            var formatDateLabel = function (date) {
                if (!(date instanceof Date)) { return ''; }
                try {
                    return date.toLocaleDateString('en-US', { month: 'short', day: 'numeric', year: 'numeric' });
                } catch (e) {
                    return '';
                }
            };

            var setRangeLabel = function (dates) {
                if (!dateDisplayText) { return; }
                if (!dates || !dates.length) {
                    dateDisplayText.textContent = 'Select range';
                    return;
                }
                if (dates.length === 1) {
                    dateDisplayText.textContent = formatDateLabel(dates[0]);
                    return;
                }
                dateDisplayText.textContent = formatDateLabel(dates[0]) + ' - ' + formatDateLabel(dates[1]);
            };

            var initRangePicker = function () {
                if (typeof flatpickr === 'undefined' || !dateRangeInput) { return; }

                var endDate = new Date();
                var startDate = new Date(endDate);
                // Lunes de la semana actual
                var day = startDate.getDay(); // 0 domingo, 1 lunes
                var diffToMonday = (day === 0 ? 6 : day - 1);
                startDate.setDate(startDate.getDate() - diffToMonday);

                rangePicker = flatpickr(dateRangeInput, {
                    mode: 'range',
                    defaultDate: [startDate, endDate],
                    dateFormat: 'M j, Y',
                    onReady: function (selectedDates) { setRangeLabel(selectedDates); },
                    onChange: function (selectedDates) {
                        setRangeLabel(selectedDates);
                        if (selectedDates.length === 2) {
                            currentRange = 'custom';
                            currentStart = selectedDates[0];
                            currentEnd = selectedDates[1];
                            loadDashboard();
                        }
                    }
                });

                if (dateDisplayBtn) {
                    dateDisplayBtn.addEventListener('click', function () {
                        rangePicker.open();
                    });
                }

                setRangeLabel([startDate, endDate]);
            };

            initRangePicker();

            var buildParams = function() {
                var params = { range: currentRange };
                if (currentRange === 'custom' && currentStart) {
                    var startIso = currentStart.toISOString().slice(0,10);
                    var endIso = (currentEnd || currentStart).toISOString().slice(0,10);
                    params.start_date = startIso;
                    params.end_date = endIso;
                }
                return params;
            };

            var loadDashboard = function() {
                var params = buildParams();
                var query = $.param(params);
                $.getJSON( dashboardApiUrl + (query ? ('?' + query) : ''), function( data ) {
                    renderDashboard(data);
                });
            };

            var setActiveRangeButton = function(range) {
                var buttons = document.querySelectorAll('.range-btn');
                buttons.forEach(function(btn) {
                    var val = (btn.dataset.range || '').toLowerCase();
                    var match = val === range;
                    if (match) { btn.classList.add('is-active'); }
                    else { btn.classList.remove('is-active'); }
                });
            };

            var renderDashboard = function(data) {
                var dashboard_data = data;

                var formatCurrency = (function() {
                    try {
                        var formatter = new Intl.NumberFormat('en-US', { style: 'currency', currency: '{$config['home_currency']}' });
                        return function (val) {
                            var num = Number(val);
                            return formatter.format(isNaN(num) ? 0 : num);
                        };
                    } catch (e) {
                        return function (val) { return val; };
                    }
                })();

                var setText = function(selector, value, formatter) {
                    var el = document.querySelector(selector);
                    if (!el) { return; }
                    el.textContent = formatter ? formatter(value) : value;
                };

                setText('#stat-total-sales', dashboard_data.total_sales, formatCurrency);
                setText('#stat-total-invoices', dashboard_data.total_invoices_count);
                setText('#stat-paid-count', dashboard_data.paid_invoices_count);
                setText('#stat-partially-paid-count', dashboard_data.partially_paid_invoices_count);

                var trending = dashboard_data.trending || {};
                var formatPercent = function(val) {
                    if (val === null || typeof val === 'undefined') { return '--'; }
                    var num = Number(val);
                    if (isNaN(num)) { return '--'; }
                    var sign = num > 0 ? '+' : '';
                    return sign + num.toFixed(1) + '%';
                };

                var applyTrend = function(value, wrapSelector, iconSelector, textSelector) {
                    var wrap = document.querySelector(wrapSelector);
                    var iconEl = document.querySelector(iconSelector);
                    var textEl = document.querySelector(textSelector);
                    var num = Number(value);
                    var isPositive = !isNaN(num) && num >= 0;
                    if (wrap) {
                        wrap.classList.remove('text-positive', 'text-negative');
                        wrap.classList.add(isPositive ? 'text-positive' : 'text-negative');
                    }
                    if (iconEl) {
                        iconEl.innerHTML = isPositive
                            ? '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"><path d="M1.41421 16.4322L0 15.018L7.07107 7.94693L13.435 14.3109L17.6777 10.0682L15.9353 8.32587L22.6274 6.53271L20.8343 13.2248L19.0919 11.4825L13.435 17.1393L7.07107 10.7754L1.41421 16.4322Z" fill="#039855"/></svg>'
                            : '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"><path d="M22.5858 7.5678L24 8.98203L16.9289 16.0531L10.565 9.68918L6.32233 13.9318L8.06467 15.6741L1.3726 17.4673L3.16575 10.7752L4.90809 12.5175L10.565 6.86073L16.9289 13.2246L22.5858 7.5678Z" fill="#D92D20"/></svg>';
                    }
                    if (textEl) {
                        textEl.textContent = formatPercent(value);
                    }
                };

                applyTrend(trending.sales_pct, '#trend-sales-wrap', '#trend-sales-icon', '#trend-sales');
                applyTrend(trending.invoices_pct, '#trend-invoices-wrap', '#trend-invoices-icon', '#trend-invoices');
                applyTrend(trending.paid_partial_pct, '#trend-paid-wrap', '#trend-paid-icon', '#trend-paid');

                var metrics = dashboard_data.metrics_invoices365 || {};
                var setProgress = function(selector, percent) {
                    var el = document.querySelector(selector);
                    if (!el) { return; }
                    var val = Math.max(0, Math.min(100, percent || 0));
                    el.style.width = val + '%';
                    el.setAttribute('aria-valuenow', val);
                };

                setText('#inv-sold-total', metrics.sold_total, formatCurrency);
                setText('#inv-stripe-total', metrics.stripe_deposits_total, formatCurrency);
                setText('#inv-total-paid-partial', metrics.invoice_total_paid_partial, formatCurrency);
                setText('#inv-bank-total', metrics.bank_deposits_total, formatCurrency);
                setText('#inv-count-sales', metrics.count_sales);
                setText('#inv-count-paid', metrics.count_paid);
                setText('#inv-count-partial', metrics.count_partial);
                setText('#inv-count-unpaid', metrics.count_unpaid);

                var hasAllData = typeof dashboard_data.total_sales !== 'undefined';
                var allDataEl = document.querySelector('#cards-all-data');
                var limitedDataEl = document.querySelector('#cards-limited-data');
                if (allDataEl) { allDataEl.style.display = hasAllData ? 'flex' : 'none'; }
                if (limitedDataEl) { limitedDataEl.style.display = hasAllData ? 'none' : 'flex'; }

                if (!hasAllData) {
                    setText('#customers-total', dashboard_data.customers_total);
                    setText('#companies-total', dashboard_data.companies_total);
                    setText('#leads-total', dashboard_data.leads_total);
                }

                var renderPaymentMethods = function(pmData) {
                var chartEl = document.querySelector('#payment_methods_chart');
                var emptyEl = document.querySelector('#payment_methods_empty');

                if (!chartEl) { return; }
                // Limpiar instancia previa
                if (chartInstances.paymentMethods) {
                    chartInstances.paymentMethods.destroy();
                    chartInstances.paymentMethods = null;
                }
                chartEl.innerHTML = '';

                if (pmData && !Array.isArray(pmData)) {
                    var tmp = [];
                    for (var key in pmData) {
                            if (Object.prototype.hasOwnProperty.call(pmData, key)) {
                                tmp.push(pmData[key]);
                            }
                        }
                        pmData = tmp;
                    }

                    if (!pmData || !pmData.length) {
                        if (emptyEl) { emptyEl.style.display = 'block'; }
                        return;
                    }
                    if (emptyEl) { emptyEl.style.display = 'none'; }

                    if (typeof ApexCharts === 'undefined') {
                        console.warn('ApexCharts is not loaded.');
                        return;
                    }

                    var toTitle = function (str) {
                        if (!str) { return ''; }
                        return String(str)
                            .toLowerCase()
                            .replace(/\b\w/g, function (c) { return c.toUpperCase(); });
                    };
                    pmData.sort(function(a, b) {
                        var va = (a && typeof a.total_amount !== 'undefined') ? Number(a.total_amount) : 0;
                        var vb = (b && typeof b.total_amount !== 'undefined') ? Number(b.total_amount) : 0;
                        return vb - va;
                    });

                    var pmLabels = pmData.map(function(pm) { return toTitle(pm.payment_type); });
                    var pmSeries = pmData.map(function(pm) {
                        if (pm && typeof pm.total_amount !== 'undefined' && pm.total_amount !== null) {
                            return Number(pm.total_amount);
                        }
                        return 0;
                    });

                    var isDark = Boolean({if !empty($config['admin_dark_theme'])}true{else}false{/if});
                    var colors = isDark ? ['#35C28F', '#3699ff', '#A3A3A3'] : ['#1782c3', '#a8d885', '#3ab5b1', '#0891b2', '#ddb43b', '#533afd']; //#4caf50, #691bcc, #A3A3A3

                    var options = {
                        chart: {
                            fontFamily: 'Outfit, sans-serif',
                            type: 'donut',
                            height: 320,
                            toolbar: { show: false }
                        },
                        labels: pmLabels,
                        series: pmSeries,
                        colors: colors,
                        legend: { show: false },
                        dataLabels: { enabled: true },
                        tooltip: {
                            y: {
                                formatter: function (val) {
                                    try { return new Intl.NumberFormat('en-US', { style: 'currency', currency: '{$config['home_currency']}' }).format(val); }
                                    catch(e) { return val; }
                                }
                            }
                        },
                        theme: { mode: isDark ? 'dark' : 'light' }
                    };

                    chartInstances.paymentMethods = new ApexCharts(chartEl, options);
                    chartInstances.paymentMethods.render();

                    var legendEl = document.querySelector('#payment_methods_legend');
                    if (legendEl) {
                        var total = pmSeries.reduce(function(sum, n) { return sum + (Number(n) || 0); }, 0);
                        var legendHtml = pmLabels.map(function(label, idx) {
                            var val = pmSeries[idx] || 0;
                            var pct = total ? ((val / total) * 100).toFixed(1) + '%' : '';
                            var valText = (typeof formatCurrency === 'function') ? formatCurrency(val || 0) : (val || 0);
                            return '' +
                                '<li class="d-flex justify-content-between align-items-center py-1 border-bottom small">' +
                                    '<span class="d-flex align-items-center text-truncate">' +
                                        '<span class="me-2" style="display:inline-block;width:12px;height:12px;border-radius:3px;background:' + (colors[idx % colors.length] || '#888') + ';"></span>' +
                                        '<span class="text-truncate">' + htmlEscape(label) + '</span>' +
                                    '</span>' +
                                    '<span class="ms-2 text-muted">' + valText + (pct ? ' (' + pct + ')' : '') + '</span>' +
                                '</li>';
                        }).join('');
                        legendEl.innerHTML = '<ul class="list-unstyled mb-0">' + legendHtml + '</ul>';
                    }
                };

                var htmlEscape = function(str) {
                    if (str === null || typeof str === 'undefined') { return ''; }
                    return String(str)
                        .replace(/&/g, '&amp;')
                        .replace(/</g, '&lt;')
                        .replace(/>/g, '&gt;')
                        .replace(/"/g, '&quot;')
                        .replace(/'/g, '&#39;');
                };

                var timeAgo = function(dateInput) {
                    if (!dateInput && dateInput !== 0) { return ''; }
                    var dt;
                    if (typeof dateInput === 'number' && isFinite(dateInput)) {
                        dt = new Date(dateInput);
                    } else if (dateInput instanceof Date) {
                        dt = dateInput;
                    } else if (typeof dateInput === 'string') {
                        var clean = dateInput.trim();
                        // Normaliza formatos "YYYY-MM-DD HH:MM:SS"
                        dt = new Date(clean.replace(' ', 'T'));
                    }
                    if (!dt || isNaN(dt.getTime())) { return ''; }
                    var now = new Date();
                    var diffMs = now - dt;
                    if (diffMs < 0) { diffMs = 0; }
                    var minutes = Math.floor(diffMs / 60000);
                    if (minutes < 1) { return 'just now'; }
                    if (minutes < 60) { return minutes + ' minute' + (minutes === 1 ? '' : 's') + ' ago'; }
                    var hours = Math.floor(minutes / 60);
                    if (hours < 24) { return hours + ' hour' + (hours === 1 ? '' : 's') + ' ago'; }
                    var days = Math.floor(hours / 24);
                    if (days < 30) { return days + ' day' + (days === 1 ? '' : 's') + ' ago'; }
                    var months = Math.floor(days / 30);
                    if (months < 12) { return months + ' month' + (months === 1 ? '' : 's') + ' ago'; }
                    var years = Math.floor(months / 12);
                    return years + ' year' + (years === 1 ? '' : 's') + ' ago';
                };

                var renderRecentSales = function (sales) {
                    var listEl = document.querySelector('#recent-sales-list');
                    var emptyEl = document.querySelector('#recent-sales-empty');
                    if (!listEl) { return; }

                    if (!sales || !sales.length) {
                        listEl.innerHTML = '';
                        if (emptyEl) { emptyEl.style.display = 'block'; }
                        return;
                    }

                    if (emptyEl) { emptyEl.style.display = 'none'; }

                    var formatter;
                    try {
                        formatter = new Intl.NumberFormat('en-US', { style: 'currency', currency: '{$config['home_currency']}' });
                    } catch (e) { formatter = null; }

                    var itemsHtml = sales.map(function (item) {
                        var title = item.title || '';
                        var staff = item.staff_name || '';
                        var date = item.date || '';
                        var relative = timeAgo(item.timestamp_ms || date);
                        var metaParts = [];
                        if (staff) { metaParts.push('by ' + staff); }
                        if (relative) { metaParts.push(relative); }
                        else if (date) { metaParts.push(date); }
                        var meta = metaParts.join(' | ');
                        var amount = Number(item.amount || 0);
                        var amountText = formatter ? formatter.format(amount) : amount;

                        return '' +
                            '<li class="d-flex justify-content-between align-items-start py-2">' +
                                '<div class="me-2">' +
                                    '<div class="h6 mb-0">' + htmlEscape(title) + '</div>' +
                                    '<div class="text-muted small">' + (htmlEscape(meta) || '&nbsp;') + '</div>' +
                                '</div>' +
                                '<div class="text-positive h6">+' + amountText + '</div>' +
                            '</li>';
                    }).join('');

                listEl.innerHTML = itemsHtml;
            };

            var renderTopServices = function (data) {
                var chartEl = document.querySelector('#top_services_chart');
                var emptyEl = document.querySelector('#top_services_empty');

                if (!chartEl) { return; }
                if (chartInstances.topServices) {
                    chartInstances.topServices.destroy();
                    chartInstances.topServices = null;
                }
                chartEl.innerHTML = '';

                var labels = (data && data.labels) ? data.labels : [];
                var series = (data && data.values) ? data.values : [];

                if (!labels || !labels.length || !series || !series.length) {
                    chartEl.innerHTML = '';
                    if (emptyEl) { emptyEl.style.display = 'block'; }
                    return;
                }
                if (emptyEl) { emptyEl.style.display = 'none'; }

                if (typeof ApexCharts === 'undefined') {
                    console.warn('ApexCharts is not loaded.');
                    return;
                }

                var isDark = Boolean({if !empty($config['admin_dark_theme'])}true{else}false{/if});
                var colors = isDark
                    ? ['#35C28F', '#3699ff', '#ddb43b', '#eb5757', '#8b5cf6', '#3ab5b1']
                    : ['#1782c3', '#a8d885', '#ddb43b', '#eb5757', '#533afd', '#3ab5b1', '#f2994a'];
                var options = {
                    chart: {
                        fontFamily: 'Outfit, sans-serif',
                        type: 'bar',
                        height: 320,
                        toolbar: { show: false },
                        {if !empty($config['admin_dark_theme'])}
                        background: '#000',
                        foreColor: '#fff',
                        {/if}
                    },
                    series: [{ name: 'Units', data: series }],
                    colors: colors,
                    plotOptions: { bar: { horizontal: false, columnWidth: '50%', distributed: true } },
                    dataLabels: { enabled: false },
                    xaxis: { categories: labels, labels: { rotate: -15, trim: true } },
                    grid: {
                        {if !empty($config['admin_dark_theme'])}
                        borderColor: "#2B2C3F",
                        {else}
                        borderColor: "#f1f1f1",
                        {/if}
                        strokeDashArray: 4
                    },
                    legend: { show: false },
                    theme: { mode: isDark ? 'dark' : 'light' }
                };

                chartInstances.topServices = new ApexCharts(chartEl, options);
                chartInstances.topServices.render();

                var legendEl = document.querySelector('#top_services_legend');
                if (legendEl) {
                    var total = series.reduce(function(sum, n) { return sum + (Number(n) || 0); }, 0);
                    var legendHtml = labels.map(function(label, idx) {
                        var val = Number(series[idx] || 0);
                        var pct = total ? ((val / total) * 100).toFixed(1) + '%' : '';
                        return '' +
                            '<li class="d-flex justify-content-between align-items-center py-1 border-bottom small">' +
                                '<span class="d-flex align-items-center text-truncate">' +
                                    '<span class="me-2" style="display:inline-block;width:12px;height:12px;border-radius:3px;background:' + (colors[idx % colors.length] || '#888') + ';"></span>' +
                                    '<span class="text-truncate">' + htmlEscape(label) + '</span>' +
                                '</span>' +
                                '<span class="ms-2 text-muted">' + val + (pct ? ' (' + pct + ')' : '') + '</span>' +
                            '</li>';
                    }).join('');
                    legendEl.innerHTML = '<ul class="list-unstyled mb-0">' + legendHtml + '</ul>';
                }
            };

            var renderStaffSales = function (data) {
                var chartEl = document.querySelector('#staff_sales_chart');
                var listEl = document.querySelector('#staff_sales_list');
                var emptyEl = document.querySelector('#staff_sales_empty');

                if (chartInstances.staffSales) {
                    chartInstances.staffSales.destroy();
                    chartInstances.staffSales = null;
                }
                if (chartEl) { chartEl.innerHTML = ''; }
                if (listEl) { listEl.innerHTML = ''; }

                var rows = (data && Array.isArray(data.rows)) ? data.rows : [];
                if (!chartEl || !rows.length) {
                    if (emptyEl) { emptyEl.style.display = 'block'; }
                    return;
                }
                if (emptyEl) { emptyEl.style.display = 'none'; }

                var labels = rows.map(function (r) { return r.fullname || 'N/A'; });
                var series = rows.map(function (r) { return Number(r.total_amount || 0); });
                var isDark = Boolean({if !empty($config['admin_dark_theme'])}true{else}false{/if});

                var options = {
                    chart: {
                        fontFamily: 'Outfit, sans-serif',
                        type: 'bar',
                        height: 400,
                        toolbar: { show: false },
                        {if !empty($config['admin_dark_theme'])}
                        background: '#000',
                        foreColor: '#fff',
                        {/if}
                    },
                    series: [{ name: 'Amount', data: series }],
                    colors: ["#1782c3"],
                    plotOptions: { bar: { horizontal: true, barHeight: '60%' } },
                    dataLabels: { enabled: false },
                    xaxis: { categories: labels, labels: { trim: true, rotate: -10 } },
                    grid: {
                        {if !empty($config['admin_dark_theme'])}
                        borderColor: "#2B2C3F",
                        {else}
                        borderColor: "#f1f1f1",
                        {/if}
                        strokeDashArray: 4
                    },
                    legend: { show: false },
                    theme: { mode: isDark ? 'dark' : 'light' }
                };

                chartInstances.staffSales = new ApexCharts(chartEl, options);
                chartInstances.staffSales.render();

                if (listEl) {
                    var formatter;
                    try {
                        formatter = new Intl.NumberFormat('en-US', { style: 'currency', currency: '{$config['home_currency']}' });
                    } catch (e) { formatter = null; }

                    var listHtml = rows.map(function (r) {
                        var amount = Number(r.total_amount || 0);
                        var amountText = formatter ? formatter.format(amount) : amount;
                        return '' +
                            '<li class="d-flex justify-content-between align-items-center py-2 border-bottom">' +
                                '<span class="fw-semibold text-truncate">' + htmlEscape(r.fullname || 'N/A') + '</span>' +
                                '<span class="text-positive">' + amountText + '</span>' +
                            '</li>';
                    }).join('');

                    var totalAmount = (data && typeof data.total !== 'undefined') ? Number(data.total) : 0;
                    var totalText = formatter ? formatter.format(totalAmount) : totalAmount;
                    listEl.innerHTML = listHtml + '<li class="d-flex justify-content-between align-items-center py-2 fw-semibold total-row"><span>Total</span><span>' + totalText + '</span></li>';
                }
            };

            var renderIncomeVsExpenses = function (data, netWorthVal) {
                if (!data || !data.Months || !data.Income || !data.Expense) { return; }

                var chartContainer = document.querySelector("#income_vs_expenses_chart");
                if (chartInstances.incomeVsExp) {
                    chartInstances.incomeVsExp.destroy();
                    chartInstances.incomeVsExp = null;
                }
                if (chartContainer) { chartContainer.innerHTML = ''; }

                var options1 = {
                    chart: {
                        fontFamily: 'Outfit, sans-serif',
                        height: 380,
                        {if !empty($config['admin_dark_theme'])}
                        foreColor: '#fff',
                        {/if}
                        toolbar: { show: false },
                        events: {
                            mounted: function(ctx) {
                                var highest1 = ctx.getHighestValueInSeries(0);
                                var highest2 = ctx.getHighestValueInSeries(1);

                                ctx.addPointAnnotation({
                                    x: new Date(ctx.w.globals.seriesX[0][ctx.w.globals.series[0].indexOf(highest1)]).getTime(),
                                    y: highest1,
                                    label: { style: { cssClass: 'd-none' } },
                                    customSVG: {
                                        SVG: '<svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 24 24" fill="#4caf50" stroke="#fff" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" class="feather feather-circle"><circle cx="12" cy="12" r="10"></circle></svg>',
                                        offsetX: -8,
                                        offsetY: 5
                                    }
                                });

                                ctx.addPointAnnotation({
                                    x: new Date(ctx.w.globals.seriesX[1][ctx.w.globals.series[1].indexOf(highest2)]).getTime(),
                                    y: highest2,
                                    label: { style: { cssClass: 'd-none' } },
                                    customSVG: {
                                        SVG: '<svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 24 24" fill="#14b1d4" stroke="#fff" stroke-width="3" stroke-linecap="round" stroke-linejoin="round" class="feather feather-circle"><circle cx="12" cy="12" r="10"></circle></svg>',
                                        offsetX: -8,
                                        offsetY: 5
                                    }
                                });
                            }
                        }
                    },
                    {if !empty($config['admin_dark_theme'])}
                    colors: ["#4586DB", "#C23C3E"],
                    {else}
                    colors: ["#51b20c", "#05a4b5"],
                    {/if}
                    dataLabels: { enabled: false },
                    stroke: { width: [0, 2, 5], curve: 'smooth' },
                    fill: {
                        opacity: [0.5, 0.25, 1],
                        gradient: { shade: '#1449DC', shadeIntensity: .8, opacityFrom: .8, opacityTo: .25, stops: [0, 95, 100] }
                    },
                    markers: { size: 3 },
                    /*subtitle: {
                        text: '{$_L['Net Worth']}',
                        align: 'left',
                        margin: 0,
                        offsetX: -10,
                        offsetY: 35,
                        floating: false,
                        style: {
                            fontSize: '14px',
                            {if !empty($config['admin_dark_theme'])}
                            color:  '#fff',
                            {else}
                            color:  '#565674',
                            {/if}
                        }
                    },*/
                    /*title: {
                        text: (typeof formatCurrency === 'function') ? formatCurrency(netWorthVal || 0) : (netWorthVal || 0),
                        align: 'left',
                        margin: 0,
                        offsetX: -10,
                        offsetY: 0,
                        floating: false,
                        style: {
                            fontSize: '25px',
                            {if !empty($config['admin_dark_theme'])}
                            color:  '#fff',
                            {else}
                            color:  '#0e1726'
                            {/if}
                        }
                    },*/
                    series: [
                        { type: 'area', name: 'Income', data: data.Income },
                        { type: 'area', name: 'Expenses', data: data.Expense }
                    ],
                    labels: data.Months,
                    xaxis: {
                        crosshairs: { show: true },
                        labels: {
                            offsetX: 0,
                            offsetY: 5,
                            style: { fontSize: '12px', fontFamily: 'Outfit, sans-serif', cssClass: 'apexcharts-xaxis-title' }
                        }
                    },
                    yaxis: {
                        labels: {
                            formatter: function(value) { return (value / 1000) + 'K'; },
                            offsetX: -22,
                            offsetY: 0,
                            style: { fontSize: '12px', fontFamily: 'Outfit, sans-serif', cssClass: 'apexcharts-yaxis-title' }
                        }
                    },
                    grid: {
                        {if !empty($config['admin_dark_theme'])}
                        borderColor: "#2B2C3F",
                        {else}
                        borderColor: "#f1f1f1",
                        {/if}
                        padding: { top: 10 },
                        strokeDashArray: 4,
                        yaxis: { lines: { show: true } }
                    },
                    legend: {
                        position: 'top',
                        horizontalAlign: 'right',
                        offsetY: -50,
                        fontSize: '16px',
                        fontFamily: 'Outfit, sans-serif',
                        markers: { width: 10, height: 10, strokeWidth: 0, strokeColor: '#fff', radius: 12 },
                        itemMargin: { horizontal: 0, vertical: 20 }
                    },
                    tooltip: {
                        theme: 'dark',
                        marker: { show: true },
                        x: { show: false }
                    },
                    responsive: [{ breakpoint: 575, options: { legend: { offsetY: -30 } } }],
                    plotOptions: { bar: { horizontal: !1, columnWidth: "15%", endingShape: "rounded" } },
                    {if !empty($config['admin_dark_theme'])}
                    background: '#000',
                    foreColor: '#fff',
                    {/if}
                };

                var chart1 = new ApexCharts(document.querySelector("#income_vs_expenses_chart"), options1);
                chart1.render();
            };
                renderPaymentMethods(dashboard_data.payment_methods_comparison);
                renderRecentSales(dashboard_data.recent_sales);
                renderTopServices(dashboard_data.top_services);
                renderStaffSales(dashboard_data.staff_sales_week);
                renderIncomeVsExpenses(dashboard_data.income_vs_exp, dashboard_data.net_worth);
            };

            // Botones de rango
            var rangeButtons = document.querySelectorAll('.range-btn');
            rangeButtons.forEach(function(btn) {
                btn.addEventListener('click', function() {
                    var val = (btn.dataset.range || '').toLowerCase();
                    currentRange = val || 'weekly';
                    currentStart = null;
                    currentEnd = null;
                    setActiveRangeButton(currentRange);
                    loadDashboard();
                });
            });

            // Carga inicial
            setActiveRangeButton(currentRange);
            loadDashboard();


            
            $('.clickable-row').on('click',function () {
                window.location = base_url + 'invoices/view/' + $(this).data('id');
            });

        });
    </script>
{/block}
