{extends file="$layouts_admin"}

{block name="head"}
    <link rel="stylesheet" href="{$app_url}ui/custom/css/users-edit.scss?v=1">
{if $d['img'] neq ''}

<style>
    #croppic{

        background-image: url({$app_url}{$d['img']});

    }
</style>

{/if}


{/block}


{block name="content"}

<div class="user-edit-page container-xxl">
    <div class="user-edit-hero">
        <div class="user-hero-left">
            <div class="user-avatar-ring">
                {if $d['img'] eq ''}
                    <div class="user-avatar-initials">{if $d['fullname']}{$d['fullname']|substr:0:1}{else}{$d['username']|substr:0:1}{/if}</div>
                {else}
                    <img src="{$app_url}{$d['img']}" class="rounded-circle profile-image" alt="{$user->fullname}">
                {/if}
            </div>
            <div>
                <h2 class="hero-title mb-1">{$d['fullname']|default:$d['username']}</h2>
            </div>
        </div>
        <div class="user-hero-right">
            <span class="pill badge-soft {if $d['status'] eq 'Active'}pill-success{else}pill-warning{/if}">{$d['status']|default:'Active'}</span>
            <span class="pill pill-muted">{if $d['user_type'] eq 'Admin'}{$_L['Full Administrator']}{else}{$_L['User']}{/if}</span>
        </div>
    </div>

    <form role="form" name="accadd" method="post" action="{$_url}settings/users-edit-post" class="user-edit-form">
        <div class="row g-4">
            <div class="col-lg-8">
                <div class="ue-card" id="application_ajaxrender">
                    <div class="ue-card-title">{$_L['Account']} &amp; {$_L['Profile']}</div>
                    <div class="row g-3">
                        <div class="col-md-6 ue-field">
                            <label for="username">{$_L['Username']}</label>
                            <input type="text" class="form-control" id="username" name="username" value="{$d['username']}">
                        </div>
                        <div class="col-md-6 ue-field">
                            <label for="fullname">{$_L['Full Name']}</label>
                            <input type="text" class="form-control" id="fullname" name="fullname" value="{$d['fullname']}">
                        </div>
                        <div class="col-md-6 ue-field">
                            <label for="phonenumber">{$_L['Phone']}</label>
                            <input type="text" class="form-control" id="phonenumber" name="phonenumber" value="{$d['phonenumber']}">
                        </div>
                        <div class="col-md-6 ue-field">
                            <label for="user_language">{$_L['Default_Language']}</label>
                            <select class="form-select" name="user_language" id="user_language">
                                {foreach $languages as $language}
                                    <option value="{$language['iso_code']}" {if $selected_language eq $language['iso_code']} selected="selected" {/if}>{$language['name']}</option>
                                {/foreach}
                            </select>
                        </div>
                        <div class="col-md-6 ue-field">
                            <label for="twi_phone"><span class="h6"></span>Twilio Phones</label>
                            <select id="twi_phone" name="twi_phone" class="form-control">
                                <option value="0">{$_L['None']}</option>
                                {foreach $phones as $phone}
                                    <option value="{$phone['id']}" {if $d['id_number'] eq ($phone['id'])}selected{/if}>
                                        {$phone['number_twilio']}
                                    </option>
                                {/foreach}
                            </select>
                        </div>
                        <div class="col-md-6 ue-field">
                            <label for="config_ws_sm"><span class="h6"></span>Config. Whatsapp/SMS</label>
                            <select id="config_ws_sm" name="config_ws_sm" class="form-control">
                                <option value="0">{$_L['None']}</option>
                                {foreach $config_whatsapp as $c}
                                    <option value="{$c['id']}" {if $d['config_whatsapp_other_id'] eq ($c['id'])}selected{/if}>
                                        {$c['identifier']}
                                    </option>
                                {/foreach}
                            </select>
                        </div>
                        <div class="col-md-6 ue-field">
                            <label for="configuracion_estatus">Status</label>
                            <select id="configuracion_estatus" name="configuracion_estatus" class="form-control">
                                <option value="Active" {if $d['status'] eq ("Active")} selected {/if} >Active</option>
                                <option value="Inactive" {if $d['status'] eq ("Inactive")}selected{/if}>Inactive</option>
                            </select>
                        </div>
                    </div>

                    <div class="ue-divider"></div>

                    <div class="row g-3 align-items-center">
                        <div class="col-md-6">
                            <div id="croppic" class="ue-cropper"></div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-wrap gap-2">
                                <button type="button" id="cropContainerHeaderButton" class="btn btn-primary">{$_L['Upload Picture']}</button>
                                {*<button type="button" id="opt_gravatar" class="btn btn-info">{$_L['Use Gravatar']}</button>*}
                                <button type="button" id="no_image" class="btn btn-light">{$_L['No Image']}</button>
                            </div>
                            <div class="mt-3 ue-field">
                                <label for="fullname">{$_L['Picture']}</label>
                                <input type="text" class="form-control picture" id="picture" readonly name="picture" value="{$d['img']}">
                            </div>
                        </div>
                    </div>

                    {if ($user['id']) neq ($d['id'])}
                    <div class="ue-divider"></div>
                    <div class="ue-subtitle">{$_L['User']} {$_L['Type']}</div>
                    <div class="row g-2">
                        <div class="col-md-6">
                            <div class="i-checks">
                                <label>
                                    <input type="radio" value="Admin" name="user_type" {if $d['user_type'] eq 'Admin'}checked{/if}> <i></i> {$_L['Full Administrator']}
                                </label>
                            </div>
                        </div>
                        {foreach $roles as $role}
                        <div class="col-md-6">
                            <div class="i-checks">
                                <label>
                                    <input type="radio" value="{$role['id']}" name="user_type" {if $d->roleid eq $role['id']}checked{/if}> <i></i> {$role['rname']}
                                </label>
                            </div>
                        </div>
                        {/foreach}
                    </div>
                    {/if}

                    <div class="ue-divider"></div>
                    <div class="row g-3">
                        <div class="col-md-6 ue-field">
                            <label for="password">{$_L['Password']}</label>
                            <input type="password" class="form-control" id="password" name="password" autocomplete="new-password">
                            <small class="text-muted d-block mt-1">{$_L['password_change_help']}</small>
                        </div>
                        <div class="col-md-6 ue-field">
                            <label for="cpassword">{$_L['Confirm Password']}</label>
                            <input type="password" class="form-control" id="cpassword" name="cpassword" autocomplete="cpassword">
                        </div>
                    </div>

                    {if $user->roleid == 0}
                    <div class="ue-divider"></div>
                    <div class="ue-subtitle">{$_L['Job title']} &amp; HR</div>
                    <div class="row g-3">
                        <div class="col-md-6 ue-field">
                            <label>{$_L['Job title']}</label>
                            <input class="form-control" name="job_title" value="{$d['job_title']}">
                        </div>
                        <div class="col-md-6 ue-field">
                            <label>{$_L['Pay frequency']}</label>
                            <select class="form-select" name="pay_frequency">
                                <option value="Monthly" {if $d['pay_frequency'] == 'Monthly'} selected{/if}>{$_L['Monthly']}</option>
                                <option value="Hourly" {if $d['pay_frequency'] == 'Hourly'} selected{/if}>{$_L['Hourly']}</option>
                            </select>
                        </div>
                        <div class="col-md-12 ue-field">
                            <label>{$_L['Address']}</label>
                            <input class="form-control" name="address" value="{$d['address_line_1']}">
                        </div>
                        <div class="col-md-6 ue-field">
                            <label>{$_L['City']}</label>
                            <input class="form-control" name="city" value="{$d['city']}">
                        </div>
                        <div class="col-md-6 ue-field">
                            <label>{$_L['State Region']}</label>
                            <input class="form-control" name="state" value="{$d['state']}">
                        </div>
                        <div class="col-md-6 ue-field">
                            <label>{$_L['ZIP Postal Code']}</label>
                            <input class="form-control" name="zip" value="{$d['zip']}">
                        </div>
                        <div class="col-md-6 ue-field">
                            <label>{$_L['Country']}</label>
                            <select class="form-select" name="country">
                                {if $d->country != ''}
                                    {Countries::all($d['country'])}
                                {else}
                                    {Countries::all($config['country'])}
                                {/if}
                            </select>
                        </div>
                        <div class="col-md-6 ue-field">
                            <label>{$_L['Date Joined']}</label>
                            <input class="form-control" name="date_hired" datepicker data-date-format="yyyy-mm-dd" data-auto-close="true" value="{$d['date_hired']}">
                        </div>
                        <div class="col-md-6 ue-field">
                            <label>{$_L['Amount']}</label>
                            <input class="form-control amount" name="amount" value="{$d['amount']}">
                        </div>
                        <div class="col-md-12 ue-field">
                            <label>{$_L['Summary']}</label>
                            <textarea class="form-control" rows="8" name="summary">{$d['summary']}</textarea>
                        </div>
                    </div>
                    {/if}

                    <div class="d-flex align-items-center gap-3 mt-4">
                        {csrf_field()}
                        <input type="hidden" name="id" value="{$d['id']}">
                        <button type="submit" class="btn btn-primary"> {$_L['Submit']}</button>
                        <a class="btn btn-soft" href="{$_url}settings/users">{$_L['Cancel']}</a>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="ue-card" id="ui_settings">
                    <div class="ue-card-title d-flex justify-content-between align-items-center">
                        <span>{$_L['Notifications']}</span>
                    </div>
                    <div class="table-responsive">
                        <table class="table table-hover table-bordered mb-0">
                            <tbody>
                                <tr>
                                    <td width="70%"><label for="config_email_notify" class="mb-0">{$_L['Email']}</label></td>
                                    <td class="text-end"><input type="checkbox" {if $user->email_notify eq '1'}checked{/if} data-toggle="toggle" data-size="small" data-on="{$_L['Yes']}" data-off="{$_L['No']}" id="config_email_notify"></td>
                                </tr>
                                <tr>
                                    <td width="70%"><label for="config_sms_notify" class="mb-0">{$_L['SMS']}</label></td>
                                    <td class="text-end"><input type="checkbox" {if $user->sms_notify eq '1'}checked{/if} data-toggle="toggle" data-size="small" data-on="{$_L['Yes']}" data-off="{$_L['No']}" id="config_sms_notify"></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                {if $user->roleid == 0}
                <div class="ue-card">
                    <div class="ue-card-title">{$_L['Departments']}</div>
                    <div class="ue-field-stack">
                        {foreach $departments as $department}
                            <label class="form-switch">
                                <input type="checkbox" class="custom-control-input on_change_department" id="department_{$department->id}" {if isset($assigned_departments[$department->id])} checked{/if}>
                                <span class="switch-label"></span>
                                <span class="switch-text">{$department->dname}</span>
                            </label>
                        {/foreach}
                    </div>
                </div>
                {/if}
            </div>
        </div>
    </form>
</div>



{/block}


{block name="script"}




<script>




    $(function () {


        $('.amount').autoNumeric('init', {

            aSign: '{$config['currency_code']} ',
            dGroup: {$config['thousand_separator_placement']},
            aPad: {$config['currency_decimal_digits']},
            pSign: '{$config['currency_symbol_position']}',
            aDec: '{$config['dec_point']}',
            aSep: '{$config['thousands_sep']}',
            vMax: '9999999999999999.00',
            vMin: '-9999999999999999.00'

        });

        $('#config_email_notify').change(function() {

            $('#ui_settings').block({ message: null });


            if($(this).prop('checked')){

                $.post( base_url+'settings/set_notify/', { opt: "email_notify", val: "1" })
                .done(function( data ) {
                    $('#ui_settings').unblock();
                    location.reload();
                });

            }
            else{
                $.post( _url+'settings/set_notify/', { opt: "email_notify", val: "0" })
                .done(function( data ) {
                    $('#ui_settings').unblock();
                    location.reload();
                });
            }
        });

        $('#config_sms_notify').change(function() {

            $('#ui_settings').block({ message: null });


            if($(this).prop('checked')){

                $.post( base_url+'settings/set_notify/', { opt: "sms_notify", val: "1" })
                .done(function( data ) {
                    $('#ui_settings').unblock();
                    location.reload();
                });

            }
            else{
                $.post( _url+'settings/set_notify/', { opt: "sms_notify", val: "0" })
                .done(function( data ) {
                    $('#ui_settings').unblock();
                    location.reload();
                });
            }
        });


        var _url = $("#_url").val();


        var croppicHeaderOptions = {

            uploadUrl: _url + 'sys_imgcrop/save/',
            cropData:{
                "email":1,
                "rnd":"rnd"
            },
            cropUrl:  _url + 'sys_imgcrop/crop/',
            outputUrlId:'picture',
            customUploadButtonId:'cropContainerHeaderButton',
            modal:false,
            loaderHtml:'<div class="loader bubblingG"><span id="bubblingG_1"></span><span id="bubblingG_2"></span><span id="bubblingG_3"></span></div> ',
            onBeforeImgUpload: function(){ console.log('onBeforeImgUpload') },
            onAfterImgUpload: function(){ console.log('onAfterImgUpload') },
            onImgDrag: function(){ console.log('onImgDrag') },
            onImgZoom: function(){ console.log('onImgZoom') },
            onBeforeImgCrop: function(){ console.log('onBeforeImgCrop') },
            onAfterImgCrop:function(){ console.log('onAfterImgCrop') }
        }
        var croppic = new Croppic('croppic', croppicHeaderOptions);


        var sysrender = $('#application_ajaxrender');




        sysrender.on('click', '#no_image', function(e){
            e.preventDefault();
            $('#picture').val('');

        });

        sysrender.on('click', '#more_submit', function(e){
            e.preventDefault();


            $('#ibox_form').block({ message: null });
            var _url = $("#_url").val();
            $.post(_url + 'contacts/edit-more/', {
                cid: $('#cid').val(),
                picture: $('#picture').val(),
                facebook: $('#facebook').val(),
                google: $('#google').val(),
                linkedin: $('#linkedin').val()

            })
            .done(function (data) {

                setTimeout(function () {
                    var sbutton = $("#more_submit");
                    var _url = $("#_url").val();
                    if ($.isNumeric(data)) {

                        window.location = _url + 'contacts/view/' + data + '/';
                    }
                    else {
                        $('#ibox_form').unblock();

                        $("#emsgbody").html(data);
                        $("#emsg").show("slow");
                    }
                }, 2000);
            });

        });


        $('.on_change_department').on('change',function () {
            let that = $(this);
            let id = that.attr('id');
            let status = 0;
            if(that.prop('checked'))
            {
                status = 1;
            }
            $.post(base_url + 'settings/set-user-ticket-department/', {
                department_id: id,
                user_id: {$d['id']},
                status: status,
            })
            .done(function (data) {
                toastr.success('{$_L['Updated']}');
            });
        });



    })

</script>


{/block}
