<?php
use Illuminate\Database\Eloquent\Model;

class Contact extends Model
{
    protected $table = 'crm_accounts';

    /**
     * @return array
     */
    public static function asArray()
    {
        return Contact::all()
        ->keyBy('id')
        ->toArray();
    }

    public static function hasLoginToken()
    {
        if (isset($_COOKIE['cloudonex_client_token'])) {
            return true;
        }
        return isset($_SESSION['cloudonex_client_token']);
    }

    /**
     * @return bool
     */
    public static function isLoggedIn()
    {
        if (isset($_COOKIE['cloudonex_client_token'])) {
            $cloudonex_client_token = $_COOKIE['cloudonex_client_token'];
        } elseif (isset($_SESSION['cloudonex_client_token'])) {
            $cloudonex_client_token = $_SESSION['cloudonex_client_token'];
        } else {
            return false;
        }

        return self::where('token', $cloudonex_client_token)->first();
    }

    /**
     * @return mixed
     */
    public static function getAllContacts()
    {
        return Contact::select(['id', 'account', 'email', 'phone', 'company'])
        ->orderBy('id', 'desc')
        ->get();
    }

    public static function customers()
    {
        return self::select(['id', 'account', 'email', 'phone', 'company'])
        ->orderBy('id', 'desc')
        ->limit(2000)
        ->get();
    }

    public function verificationadress($address, $city,  $state, $zip){
        $address=str_replace(" ", "+", $address);
        $city=str_replace(" ", "+", $city);
        $state=str_replace(" ", "+", $state);
        $zip=str_replace(" ", "+", $zip);

        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://us-street.api.smarty.com/street-address?auth-id=3dadaa18-e8dc-c515-2949-34143a71d983&auth-token=VhYXG5hydMiGmbim2ErS&license=us-core-cloud&street='.$address.'&city='.$city.'&state='.$state.'&zipcode='.$zip.'',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'GET',
      ));

        $response = curl_exec($curl);
        curl_close($curl);
        $datos=json_decode($response);

        if (count($datos) > 0) {
            return true;
        }
        return false;


    }


}
