{extends file="$layouts_admin"}
{block name="head"}

   <link href="{$theme}default/css/grupo.css?v={$config['version']}" rel="stylesheet">
   <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/1.6.2/css/buttons.dataTables.min.css" />

   <link
   href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css"
   rel="stylesheet"
   />


{/block}

{block name="content"}

<style type="text/css">

    .list-group{
        max-height: 150px;
        margin-bottom: 10px;
        overflow:scroll;
        -webkit-overflow-scrolling: touch;
    }    

    table.estilosTabla > :not(caption) > * > * {
        /*
        padding-top: 5px !important;
        padding-bottom: 5px !important;
        */
    }

    .quitar_borde_puntos_suspencivos{
        border: none;
        background: transparent;
    }

    .quitar_borde_puntos_suspencivos.dropdown-toggle::after {
        display: none;
    }

    table.estilosTabla > :not(caption) > tr {
        border-bottom: 1px solid #dee2e6; /* Bootstrap's default border color */
    }

    table.estilosTabla > :not(caption) > * > * {
        border-bottom: 1px solid #dee2e6; /* Bootstrap's default border color */
        
    }

    .consultar_filtros
    {
      border-color: #d3cac0;
      border: 1px solid #d3cac0;
      float: right;
    }

</style>
<div class="row">
   <div class="col-md-12">
      <div class="panel">
         <div class="panel-hdr">
            <h2 style="color: #666; font-weight: 600">
               <span></span>Collection report
            </h2>
            <input
               type="text"
               class="tener_url_base"
               value="{$url_base}"
               disabled
               hidden
            />
         </div>

         <div class="panel-container show" id="ibox_form">
            <div class="panel-content">
               <div class="px-2">
                  <div class="row contenedor" style="padding: 10px">

                     {*
                        <div class="col-12 col-sm-6 pt-3">
                           <label for="fecha_desde"
                              ><span style="color: #666">Date from</span>
                           </label>
                           <input
                              type="date"
                              id="fecha_desde"
                              name="fecha_desde"
                              class="form-control form-control-sm tener_fecha_desde"
                           />
                        </div>

                        <div class="col-12 col-sm-6 pt-3">
                           <label for="fecha_hasta"
                              ><span style="color: #666">Date to date</span>
                           </label>
                           <input
                              type="date"
                              id="fecha_hasta"
                              name="fecha_hasta"
                              class="form-control form-control-sm tener_fecha_hasta"
                           />
                        </div>
                     
                     *}

 
                     <div class="col-12 col-sm-12 pt-3">

                        <label for="plan_pago"
                           ><span style="color: #666">Payment plan</span>
                        </label>
                        <select
                           class="form-control form-control-sm plan_pago"
                           name="plan_pago"
                           id="plan_pago"
                           style="width: 100%"
                           placeholder="Select a option"
                        >
                           <option value="">All</option>
                           {foreach $listado_plan as $item}
                              <option value="{$item['id']}">
                                 {$item['plan_nombre']} ({$item['tasa_interes']}% - {$item['descripcion_modalidad_cobro']})
                              </option>
                           {/foreach}
                        </select>

                     </div>

                     <div class="col-12 col-sm-12 pt-3">
                        <span style="color: #666; font-weight: 600;">Download daily payment reports.</span>
                        <br>
                        <br>
                        <span style="color: #666; font-weight: 600;">In this section, you can download payment reports for users who are pending or have already paid today. You can also view payments from previous dates, but only those that are overdue.</span>
                     </div>

                     <div class="col-12 col-sm-12 pt-3">

                        {**}

                        <button
                           type="button"
                           class="btn btn-default consultar_filtros"
                           id="consultar_filtros"
                           style="
                              border-color: #d3cac0;
                              border: 1px solid #d3cac0;
                              float: right;
                           "
                        >
                           Filter
                        </button>

                        <button
                           class="btn btn-default loading_consultar_filtros"
                           style="
                              display: none;
                              border-color: #d3cac0;
                              border: 1px solid #d3cac0;
                              float: right;
                           "
                           disabled
                        >
                           <div style="display: flex; align-items: center">
                              <span
                                 class="spinner-border spinner-border-sm"
                                 style="
                                    height: 20px;
                                    width: 20px;
                                    margin-right: 5px;
                                 "
                                 role="status"
                                 aria-hidden="true"
                              ></span>
                              Filter
                           </div>
                        </button>

 
                        {**}  

                        <button
                           type="button"
                           class="btn btn-success descargar_filtros"
                           id="descargar_filtros"
                           style="
                              
                              float: right;
                              margin-right: 10px;
                           "
                        >
                          <i class="fas fa-file-download"></i> Download filter
                        </button>

                        <button
                           class="btn btn-success loading_descargar_filtros"
                           style="
                              display: none;
                              float: right;
                              margin-right: 10px;
                           "
                           disabled
                        >
                           <div style="display: flex; align-items: center">
                              <span
                                 class="spinner-border spinner-border-sm"
                                 style="
                                    height: 20px;
                                    width: 20px;
                                    margin-right: 5px;
                                 "
                                 role="status"
                                 aria-hidden="true"
                              ></span>
                            Download filter
                           </div>
                        </button>

                     </div>

                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>

   {**}
   <div class="col-md-12">
      <div class="panel">
         <div class="panel-container show" id="ibox_form">
            <div class="panel-content" style="padding: 0px">
               <div class="table-responsive">
                  <table
                     class="table table-striped table-hover estilosTabla"
                     id="clx_datatable"
                     style="margin: 0px"
                  >
                     <thead>
                        <tr>
                           <th class="centrar">DISBURSEMENT DATE</th>
                           <th class="centrar">NO. CREDIT</th>
                           <th class="centrar">QUOTA NUMBER</th>
                           <th class="centrar">COUNTRY</th>
                           <th class="centrar">ADDRESS</th>
                           <th class="centrar">ACCOUNT</th>
                           <th class="centrar">AMOUNT</th>
                           <th class="centrar">STAFF</th>
                           <th class="centrar">STATUS</th>
                        </tr>
                     </thead>

                     <tbody class="tbody_envios">
                     
                     </tbody>
                  </table>
               </div>
            </div>
         </div>
      </div>
   </div>

</div>

 

{**}
<div
   class="modal fade"
   id="ventana_confirmacion"
   tabindex="-1"
   aria-labelledby="exampleModalLabel__ventanaconfirmacion"
   aria-hidden="true"
   data-bs-backdrop="static"
   data-bs-keyboard="false"
>
   <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content" style="background-color: white">
         <div class="modal-header">
            <h3 class="titulo_modal_confirmar">Estas seguro de eliminar</h3>
            <button
               type="button"
               class="btn-close"
               id="btn_close_ventana_confirmacion"
            ></button>
         </div>
         <div
            class="modal-body"
            style="background-color: white; border-radius: 10px"
         >
            <div class="row">
               <div class="col-md-12">
                  <div class="panel-container show" id="ibox_form">
                     <div class="panel-content">
                        <div class="px-2">
                           <div
                              class="alert alert-danger"
                              id="emsg"
                              style="display: none"
                           >
                              <span id="emsgbody"></span>
                           </div>
                           <input
                              class="tipo_modal_confirmar"
                              hidden
                              disabled
                           />
                           <input class="data_id" hidden disabled />
                           <div class="row">
                              <div class="col-md-12 col-sm-12">
                                 <h4
                                    class="mensaje_modal_confirmar"
                                    style="text-align: center; color: black"
                                 >
                                    Estas seguro de eliminar
                                 </h4>
                                 <p
                                    class="mensaje_espera_moda_confirmacion mt-3"
                                    style="
                                       text-align: center;
                                       color: red;
                                       font-weight: 600;
                                    "
                                 >
                                    Espere mientras termina el proceso
                                 </p>
                              </div>
                           </div>
                           <div class="row mt-2">
                              <div class="col-md-12">
                                 <div style="float: inline-end">
                                    <button
                                       class="btn me-2"
                                       type="button"
                                       id="btn_cerrar_ventana_confirmacion"
                                       style="background: #001b3b"
                                    >
                                       close
                                    </button>
                                    <button
                                       class="btn"
                                       type="button"
                                       id="btn_aplicar_ventana_confirmacion"
                                       style="background: red"
                                    >
                                       Remove
                                    </button>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>

{/block}

{block name="script"}


<script>

   const URL_BASE = $(".tener_url_base").val();

   var COLOR_FONDO_VENTANA_CERRAR = "#001b3b";
   var COLOR_TEXT_VENTANA_CERRAR = "white";

   var COLOR_FONDO_VENTANA_CONFIRMACION = "red";
   var COLOR_TEXT_VENTANA_CONFIRMACION = "white";

   var COLOR_FONDO_VENTANA_IR = "#001b3b";
   var COLOR_TEXT_VENTANA_IR = "white";

   $(".tbody_envios").html(
      '<tr><th colspan="10" class="centrar pt-4"> No information</th></tr>',
   );


   $('#submit_modal_confirmacion_correo').on('click', function() {
      window.location = url_dashboard;    
   });
 
   $("#btn_aplicar_ventana_confirmacion").off("click")
   .on("click", function () {

      $('#btn_aplicar_ventana_confirmacion').prop('disabled', true);
      $('#btn_close_ventana_confirmacion').prop('disabled', true);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', true);
       
      let opcion_predefinida = $(".tipo_modal_confirmar").val();
      let data_id = $(".data_id").val();

      if(opcion_predefinida == "eliminar_card_documento")
      {
         $(".mensaje_espera_moda_confirmacion").text("Please wait while the process finishes...");

         $(".card_eliminar_" + data_id).remove();

         $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
         $('#btn_close_ventana_confirmacion').prop('disabled', false);
         $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
         
         //$("#ventana_confirmacion").modal("hide");

         ventanaRegistroExito("Record deleted", "¡The record has been successfully deleted!");
      }

      if(opcion_predefinida == "navegar_pantalla_siguiente")
      {
         window.location = URL_BASE + "credit/search-loans";
      }

      if(opcion_predefinida == "navegar_otras_pantallas")
      {
         window.location = URL_BASE + data_id;
      }
 
   });

   $("#btn_cerrar_ventana_confirmacion").off("click")
   .on("click", function () {
      
      $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
      $('#btn_close_ventana_confirmacion').prop('disabled', false);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
      $("#ventana_confirmacion").modal("hide");
    
   });

   $("#btn_close_ventana_confirmacion").off("click")
   .on("click", function () {

      $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
      $('#btn_close_ventana_confirmacion').prop('disabled', false);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
      
      $("#ventana_confirmacion").modal("hide");
    
   });

   $('.btn_cerrar_confirmacion_modal').click(function() {
      $("#modalMensaje").modal("hide");
   });

   let fecha = cargar_fecha();
   $(".tener_fecha_desde").val(fecha);
   $(".tener_fecha_hasta").val(fecha);


   $("#consultar_filtros").click(function () {

      let plan_pago = $(".plan_pago").val() || "";

      let enviar_informacion = {
         plan_pago: plan_pago,
         descargar: 2, 
      };

      //console.log(JSON.stringify(enviar_informacion));
      //return;
      //$("#consultar_filtros").prop("disabled", true);

      $('input, select, button, textarea').prop('disabled', true);

      $('.loading_consultar_filtros').css('display', '');
      $('.consultar_filtros').css('display', 'none');

      $.ajax({
            type: "POST",
            url: URL_BASE + "credit/get-fee-collection-report",
            data: JSON.stringify(enviar_informacion), // Convertir datos a formato JSON
            contentType: "application/json", // Tipo de contenido JSON
            success: function (response) {

               $('input, select, button, textarea').prop('disabled', false);
               $('.loading_consultar_filtros').css('display', 'none');
               $('.consultar_filtros').css('display', '');

               try {
                  let info = JSON.parse(response);

                  if (info.type == "success") {


                     let data = info.data || [];

                     if(data.length == 0)
                     {
                        $(".tbody_envios").html(
                           '<tr><th colspan="10" class="centrar pt-4"> No information</th></tr>',
                        );
                     }else{

                        var newRow = "";

                        data.forEach((element) => {
                           let {
                                 id,
                                 fecha_cobro,
                                 numero_credito,
                                 cuotas,
                                 country_hi,
                                 address,
                                 account,
                                 valor_cuota,
                                 nombre_staff_recibio_pago = "",
                                 status = "",
                                 status_id,
                           } = element; 

                           if(isEmpty(nombre_staff_recibio_pago))
                           {
                              nombre_staff_recibio_pago = "";
                           }

                           if(isEmpty(fecha_cobro))
                           {
                              fecha_cobro = "";
                           }

                           if(isEmpty(numero_credito))
                           {
                              numero_credito = "";
                           }

                           if(isEmpty(address))
                           {
                              address = "";
                           }
 
                              newRow +=
                                 "<tr>" +
                                 '<td class="centrar">' + fecha_cobro + "</td>" +
                                 '<td class="centrar">' + numero_credito + "</td>" +
                                 '<td class="centrar">' + cuotas + "</td>" +
                                 '<td class="centrar">' + country_hi + "</td>" +
                                 '<td class="centrar">' + address + "</td>" +
                                 '<td class="centrar">' + account + "</td>" +
                                 '<td class="centrar">' + valor_cuota + "</td>" +
                                 '<td class="centrar">' + nombre_staff_recibio_pago + "</td>" +
                                 '<td class="centrar">' + status + "</td>" +
                                 "</tr>";
                        });

                        // Agregar la nueva fila al tbody
                        $(".tbody_envios").html(newRow);

                     }
 
 
                  } else if (info.type == "error") {

                     //Swal.fire({
                     //   icon: "error",
                     //   title: "Oops...",
                     //   text: info.message,
                     //});

                     ventanaError("Opps there was an error", info.message);
                  }
               } catch (error) {

                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: error,
                  //});

                  ventanaError("Opps there was an error", error);
               }
            },
            error: function (xhr, status, error) {
               console.error("Error en la solicitud:", error);
            
               //Swal.fire({
               //   icon: "error",
               //   title: "Oops...",
               //   text: error,
               //});

               ventanaError("Opps there was an error", error);

               $('input, select, button, textarea').prop('disabled', false);
               $('.loading_consultar_filtros').css('display', 'none');
               $('.consultar_filtros').css('display', '');
            },
         });

  
   });

   $("#descargar_filtros").click(function () {

 
      let plan_pago = $(".plan_pago").val() || "";

      let enviar_informacion = {
         plan_pago: plan_pago,
         descargar: 1, 
      };

      //console.log(JSON.stringify(enviar_informacion));
      //return;

      $('input, select, button, textarea').prop('disabled', true);

      $('.loading_descargar_filtros').css('display', '');
      $('.descargar_filtros').css('display', 'none');

      console.log(JSON.stringify(enviar_informacion));
      //return;

      $.ajax({
            type: "POST",
            url: URL_BASE + "credit/get-fee-collection-report",
            data: JSON.stringify(enviar_informacion), // Convertir datos a formato JSON
            contentType: "application/json", // Tipo de contenido JSON
            success: function (response) {

               $('input, select, button, textarea').prop('disabled', false);
               $('.loading_descargar_filtros').css('display', 'none');
               $('.descargar_filtros').css('display', '');

               try {
                  let info = JSON.parse(response);

                  if (info.type == "success") {

                     let data = info.data || [];

                     if(data.length == 0)
                     {
                        //$(".tbody_envios").html(
                        //   '<tr><th colspan="10" class="centrar pt-4"> No information</th></tr>',
                        //);
                     }else{
                        
                        if( isEmpty(info.base_excel) == false )
                        {
                           const fileName = 'report.xlsx'; // Nombre del archivo
                           downloadExcel(info.base_excel || '', fileName);
                        }

                        var newRow = "";

                        data.forEach((element) => {
                           let {
                                 id,
                                 fecha_cobro,
                                 numero_credito,
                                 cuotas,
                                 country_hi,
                                 address,
                                 account,
                                 valor_cuota,
                                 nombre_staff_recibio_pago = "",
                                 status = "",
                                 status_id,
                           } = element; 

                           if(isEmpty(nombre_staff_recibio_pago))
                           {
                              nombre_staff_recibio_pago = "";
                           }

                           if(isEmpty(fecha_cobro))
                           {
                              fecha_cobro = "";
                           }

                           if(isEmpty(numero_credito))
                           {
                              numero_credito = "";
                           }

                           if(isEmpty(address))
                           {
                              address = "";
                           }
 
                              newRow +=
                                 "<tr>" +
                                 '<td class="centrar">' + fecha_cobro + "</td>" +
                                 '<td class="centrar">' + numero_credito + "</td>" +
                                 '<td class="centrar">' + cuotas + "</td>" +
                                 '<td class="centrar">' + country_hi + "</td>" +
                                 '<td class="centrar">' + address + "</td>" +
                                 '<td class="centrar">' + account + "</td>" +
                                 '<td class="centrar">' + valor_cuota + "</td>" +
                                 '<td class="centrar">' + nombre_staff_recibio_pago + "</td>" +
                                 '<td class="centrar">' + status + "</td>" +
                                 "</tr>";
                        });

                        // Agregar la nueva fila al tbody
                        $(".tbody_envios").html(newRow);

                     }
 
                  } else if (info.type == "error") {

                     //Swal.fire({
                     //   icon: "error",
                     //   title: "Oops...",
                     //   text: info.message,
                     //});

                     ventanaError("Opps there was an error", info.message);
                  }
               } catch (error) {

                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: error,
                  //});

                  ventanaError("Opps there was an error", error);
               }
            },
            error: function (xhr, status, error) {
               console.error("Error en la solicitud:", error);
            
               //Swal.fire({
               //   icon: "error",
               //   title: "Oops...",
               //   text: error,
               //});

               ventanaError("Opps there was an error", error);

               $('input, select, button, textarea').prop('disabled', false);
               $('.loading_descargar_filtros').css('display', 'none');
               $('.descargar_filtros').css('display', '');
            },
         });
 
   });

   function downloadExcel(base64String, fileName) {
      // Convertir la cadena Base64 a binario
      const binaryString = atob(base64String); // Decodificar Base64
      const binaryLength = binaryString.length;
      const bytes = new Uint8Array(binaryLength);

      for (let i = 0; i < binaryLength; i++) {
         bytes[i] = binaryString.charCodeAt(i);
      }

      // Crear un Blob con el contenido del archivo Excel
      const blob = new Blob([bytes], {
         type: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
      });

      // Crear un enlace temporal para descargar el archivo
      const link = document.createElement('a');
      link.href = window.URL.createObjectURL(blob);
      link.download = fileName;
      link.click();

      // Limpia la URL temporal
      window.URL.revokeObjectURL(link.href);
   }

   function isEmpty(value) {
       // Verificar si es null o undefined
       if (value == null) return true;

       // Verificar si es una cadena vacía
       if (typeof value === "string" && value.trim() === "") return true;

       // Verificar si es un array vacío
       if (Array.isArray(value) && value.length === 0) return true;

       // Verificar si es un objeto vacío
       if (typeof value === "object" && Object.keys(value).length === 0) return true;

       return false;
   }
 
   function cargar_fecha() {
      const today = new Date();

      // Formatear la fecha como YYYY-MM-DD
      const year = today.getFullYear();
      const month = String(today.getMonth() + 1).padStart(2, "0"); // Mes de 2 dígitos
      const day = String(today.getDate()).padStart(2, "0"); // Día de 2 dígitos

      const formattedDate = year + "-" + month + "-" + day;
      return formattedDate;
   }

   function select_html_usuario_sistema(arr) {
      if (arr.length == 0) {
         return;
      }

      var html = '<option value="">' + "None" + "</option>";

      arr.forEach((element) => {
         let value = element;

         html +=
            '<option value="' +
            value["id"] +
            '">' +
            value["fullname"] +
            "</option>";
      });

      return html;
   }

   function ventanaError(titulo, mensaje) {
      $(".titulo_modal_confirmar").text(titulo);
      $(".mensaje_modal_confirmar").text(mensaje);
      $(".mensaje_espera_moda_confirmacion").text("");
      $(".tipo_modal_confirmar").val("registro_exito");
      $(".data_id").val("");

      $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
      $('#btn_close_ventana_confirmacion').prop('disabled', false);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
 
      $('#btn_cerrar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR
      });

      $('#btn_aplicar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CONFIRMACION,
         'color': COLOR_TEXT_VENTANA_CONFIRMACION,
         'display': "none"
      });
 
      $("#ventana_confirmacion").modal("show");
   }
     

</script>
{/block}