{extends file="$layouts_admin"}


{block name="head"}
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/1.6.2/css/buttons.dataTables.min.css" />
{/block}




{block name="content"}
    <div class="row">
        <div class="col-md-12">
            <div class="panel">
                <div class="panel-hdr">
                    <h2>List of Email configuration</h2>

                    <div class="panel-toolbar">
                        <a href="{$_url}settings/add-config-email" class="btn btn-primary"> Add New</a>

                    </div>

                </div>
                <div class="panel-container">
                    <div class="panel-content">

                        <div class="table-responsive">
                            <table class="table table-striped" id="clx_datatable">
                                <thead style="background: #f0f2ff">
                                <tr>
                                    <th style="width: 60px;background: #f0f2ff">Identifier</th>
                                    <th>Token</th>
                                    <th>Email</th>
                                    <th>Name</th>
                                    <th>Created At</th>
                                    <th>Update At</th>
                                    <th>Status</th>
                                    <th class="text-end">Manager</th>
                                </tr>
                                </thead>
 
                                {foreach $d as $ds}
                                    <tr>
                                        <td>{$ds['identifier']}</td>
                                        <td>{$ds['token']}</td>
                                        <td>{$ds['email']}</td>
                                        <td>{$ds['nombre']}</td>
                                        <td>{$ds['fecha_post']}</td>
                                        <td>{$ds['fecha_update']}</td>
                                         
                                        <td>
                                            {if $ds['status'] == 1}
                                                  Active
                                            {/if}

                                            {if $ds['status'] == 2}
                                                  Inactive
                                            {/if}
                                        
                                        </td>
                                         
                                        <td>
                                            <div class="btn-group float-end">
                                                <a href="{$_url}settings/update-config-email/{$ds['id']}" class="btn btn-primary btn-sm"><i class="fal fa-pencil"></i> </a>
                                                {if ($_user['username']) neq ($ds['username'])}
                                                    <a href="{$_url}settings/disabled-config-email/{$ds['id']}" id="{$ds['id']}" class="btn btn-danger btn-sm cdelete"><i class="fal fa-trash-alt"></i> </a>
                                                {/if}

                                            </div>

                                        </td>
                                    </tr>
                                {/foreach}


                            </table>
                        </div>


                    </div>





                </div>
            </div>



        </div>



    </div>



{/block}

{block name="script"}


    <script>
        $(function () {
            $('#clx_datatable').dataTable({
                responsive: true,
                "language": {
                    "emptyTable": "{$_L['No items to display']}",
                    "info":      "{$_L['Showing _START_ to _END_ of _TOTAL_ entries']}",
                    "infoEmpty":      "{$_L['Showing 0 to 0 of 0 entries']}",
                    buttons: {
                        pageLength: '{$_L['Show all']}'
                    },
                    searchPlaceholder: "{__('Search')}"
                },
            });
        });
    </script>

{/block}
