<?php
namespace App\Controllers;
use ORM;
use PDO;
use Contact;
use App\Models\Tags;
use App\Models\User as User;

require_once __DIR__ . '/BaseController.php';
require_once __DIR__ . '/../Models/User.php';
require_once __DIR__ . '/../Models/Tags.php';
require_once __DIR__ . '/../util/global.php';

class CustomerController extends BaseController
{

    public function list()
    {
        header('Content-Type: application/json');
        $user = User::_info();

        $has_delete_permission = _hasaccess($user->roleid, 'customers', 'delete');
        $has_edit_permission   = _hasaccess($user->roleid, 'customers', 'edit');

        $pdo = ORM::get_db();
        $stmt = $pdo->prepare("
            SELECT id, account, email, phone, company, gname, gid, code, address
            FROM crm_accounts
            WHERE type = 'Customer'
            ORDER BY id DESC
        ");
        $stmt->execute();
        $contacts = $stmt->fetchAll(PDO::FETCH_ASSOC);

        $response = [
            'data' => $contacts,
            'has_delete_permission' => $has_delete_permission,
            'has_edit_permission' => $has_edit_permission,
        ];

        http_response_code(200);
        echo json_encode($response);
        exit;
    }

    public function getSummary($cid)
    {
        header('Content-Type: application/json');

        if (!$cid) {
            http_response_code(400);
            echo json_encode(['error' => 'Customer ID is required']);
            exit;
        }

        $customer = ORM::for_table('crm_accounts')->find($cid);

        if (!$customer) {
            http_response_code(404);
            echo json_encode(['error' => 'Customer not found']);
            exit;
        }

        // Total In (cr) y Total Out (dr)
        $totalIn  = ORM::for_table('sys_transactions')->where('payerid', $cid)->sum('cr') ?: 0;
        $totalOut = ORM::for_table('sys_transactions')->where('payeeid', $cid)->sum('dr') ?: 0;

        // Profit / Loss
        if ($totalIn > $totalOut) {
            $status = 'Profit';
            $amount = $totalIn - $totalOut;
            $cssClass = 'green';
        } else {
            $status = 'Loss';
            $amount = $totalOut - $totalIn;
            $cssClass = 'danger';
        }

        // Custom fields
        $customFields = ORM::for_table('crm_customfields')
            ->where('ctype', 'crm')
            ->order_by_asc('id')
            ->find_many();

        // Staffs
        $staffs = User::all()->keyBy('id')->all();

        $response = [
            'customer'       => $customer->as_array(),
            'total_in'       => $totalIn,
            'total_out'      => $totalOut,
            'status'         => $status,
            'amount'         => $amount,
            'css_class'      => $cssClass,
            'custom_fields'  => $customFields->as_array(),
            'staffs'         => $staffs,
        ];

        //Event::trigger('contacts/summary_display', [&$response]);

        http_response_code(200);
        echo json_encode($response);
        exit;
    }


    public function updateContact($id)
    {
        global $_L, $config;

        header('Content-Type: application/json');

        $user = User::_info();

        if (!has_access($user->roleid, 'customers', 'edit')) {
            http_response_code(403); // Forbidden
            echo json_encode(
                ['error' => 'Permission Denied']
            );
            exit;
        }

        $id = $id ?: _post('fcid');
        $d = ORM::for_table('crm_accounts')->find($id);

        if ($d) {
            $clientDb = null;

            try {
                $clientDb = makeClientDb();
            } catch (\Exception $e) {
                echo json_encode($e->getMessage());
                exit;
            }

            $companies = json_decode(_post('companies'), true);
            $review_rating = _post('review_rating');

            $review_rating = ($review_rating == '2' || empty($review_rating)) ? null : 1;
            //$review_rating = $review_rating == '2' || empty($review_rating) ? null : 1;

            $arrCompanies = [];

            if (!is_array($companies) || count($companies) < 1) {
                http_response_code(200);
                echo json_encode([
                    'status'  => 'error',
                    'code'    => 'COMPANY_SELECTION_MISSING',
                    'message' => 'You must select at least one company.',
                ]);
                exit;
            }

            $arrCompanies = $companies;

            $companies_deletes = _post('companies_deletes');

            if (!empty($companies_deletes)) {
                $arrCompaniesDelete = json_decode($companies_deletes, true) ?: [];

                $arrCompaniesDelete = array_values(array_filter($arrCompaniesDelete, function ($v) {
                    return is_numeric($v);
                }));

                if (!empty($arrCompaniesDelete)) {
                    $placeholders = implode(',', array_fill(0, count($arrCompaniesDelete), '?'));
                    $stmtDelete = $clientDb->prepare("DELETE FROM `crm_accounts_company` WHERE idCompany IN ($placeholders)");
                    if ($stmtDelete) {
                        $stmtDelete->execute($arrCompaniesDelete);
                    }
                }
            }

            foreach ($arrCompanies as $item) {
                $id_compania = $item['id'] ?? null;
                $UUID = $item['UUID'] ?? null;
                $UUID_ENC = $item['UUID_ENC'] ?? null;
                $idCompany = $item['idCompany'] ?? null;

                if (empty($id_compania) && $UUID && $UUID_ENC && $idCompany) {
                    $sql = "INSERT INTO `crm_accounts_company`(
                                `UUID`,
                                `UUID_ENC`,
                                `idCompany`,
                                `crm_account_id`
                            )
                            VALUES(
                                ?,
                                ?,
                                ?,
                                ?
                            )";

                    $stmt_detalles = $clientDb->prepare($sql);
                    if (!$stmt_detalles) {
                        continue;
                    }

                    $stmt_detalles->execute([
                        $UUID,
                        $UUID_ENC,
                        $idCompany,
                        $id
                    ]);
                }
            }

            $old_account = $d->account;

            $account = _post('account');

            $company_id = _post('company_id');

            $company = '';
            $cid = 0;

            if ($company_id != '' || $company_id != '0') {
                $company_db = db_find_one('sys_companies', $company_id);

                if ($company_db) {
                    $company = $company_db->company_name;
                    $cid = $company_id;
                }
            }

            $email = _post('edit_email');

            $tagsInput = _post('tags', '');
            $tags = $tagsInput ? array_filter(array_map('trim', explode(',', $tagsInput))) : [];

            $currency = _post('currency', '0');

            if ($currency == '') {
                $currency = '0';
            }

            $phone = _post('phone');
            $address = _post('address');
            $city = _post('city');
            $state = _post('state');
            $zip = _post('zip');
            $country = _post('country');
            $nationality = _post('nationality');

            $username = _post('username');

            $type_customer = _post('customer');
            $type_supplier = _post('supplier');

            $type = $type_customer . ',' . $type_supplier;
            $type = trim($type, ',');

            if ($type == '') {
                $type = 'Customer';
            }

            $msg = '';

            if ($account == '') {
                $msg .= $_L['Account Name is required'] . ' <br>';
            }


            Tags::saveTags($tags, 'Contacts');

            if ($email != '') {
                if ($email != $d['email']) {
                    $f = ORM::for_table('crm_accounts')
                        ->where('email', $email)
                        ->first();

                    if ($f) {
                        $msg .= $_L['Email already exist'] . ' <br>';
                    }
                }
                if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                    $msg .= $_L['Invalid Email'] . ' <br>';
                }
            }

            $gid = _post('group');

            $secondary_email = _post('secondary_email');

            if (!filter_var($secondary_email, FILTER_VALIDATE_EMAIL)) {
                $secondary_email = '';
            }
            $gname = '';

            if ($gid != '') {
                $g = db_find_one('crm_groups', $gid);
                if ($g) {
                    $gname = $g['gname'];
                }
            } else {
                $gid = 0;
                $gname = '';
            }

            $owner_id = _post('owner_id', 0);

            $password = _post('password');

            if ($msg == '') {
                $position = _post('position');
                $notas = _post('notas');
                $codigo_pais = _post('codigo_pais');

                $d = ORM::for_table('crm_accounts')->find($id);
                $d->account = $account;
                $d->company = $company;
                $d->o = $owner_id;
                $d->nationality = $nationality;

                $d->email = $email;
                $d->tags = \Arr::arr_to_str($tags);

                $d->phone = $codigo_pais . $phone;
                $d->position = $position;
                $d->notas = $notas;
                $d->notes = $notas;
                $d->codigo_pais = $codigo_pais;
                $d->telephone_number = $phone;

                $d->address = $address;
                $d->city = $city;
                $d->zip = $zip;
                $d->state = $state;
                $d->country = $country;

                $d->type = $type;

                $d->username = $username;

                $d->gname = $gname;
                $d->gid = $gid;

                $d->currency = $currency;
                $d->rating_review = $review_rating;

                $d->fax = _post('fax');

                $d->code = _post('code');

                $d->secondary_email = $secondary_email;

                if ($config['show_business_number']) {
                    $d->business_number = _post('business_number');
                }

                if ($password != '') {
                    $d->password = \Password::_crypt($password);
                }

                $d->save();

                ORM::for_table('crm_customfieldsvalues')
                    ->where('relid', $id)
                    ->delete_many();

                $fs = ORM::for_table('crm_customfields')
                    ->order_by_asc('id')
                    ->find_many();

                foreach ($fs as $f) {
                    $fvalue = _post('cf' . $f['id']);
                    $fc = ORM::for_table('crm_customfieldsvalues')->create();
                    $fc->fieldid = $f['id'];
                    $fc->relid = $id;
                    $fc->fvalue = $fvalue;
                    $fc->save();
                }

                if ($account != $old_account) {
                    $sql = "update sys_invoices set account='$account' where account='$old_account'";

                    ORM::execute($sql);
                }

                //$successMessage = is_array($_L) && isset($_L['account_updated_successfully']) ? $_L['account_updated_successfully'] : 'Account updated successfully';
                //_msglog('s', $successMessage);

                $clientDb = null;

                http_response_code(200);
                echo json_encode([
                    'status' => 'success',
                    'id' => $id // Customer Id
                ]);
                exit;

            } else {
                $clientDb = null;
                echo $msg;
            }
        } else {

            http_response_code(200);
            echo json_encode([
                'status' => 'error',
                'code' => 'ACCOUNT_NOT_FOUND',
                'message' => 'The requested account does not exist.'
            ]);
            exit;
            
        }
    }

}
