<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Connection;

class Transaction extends Model
{
    protected $table = 'sys_transactions';

    protected static function booted()
    {
        $capsule = new Connection();
        static::setConnectionResolver($capsule->getCapsule()->getDatabaseManager());
    }

    public static function totalAmount(
        $type,
        $currency_id,
        $time = 'all',
        $all_data = true
    ) {
        global $user;

        $mdate = date('Y-m-d');
        $tdate = date('Y-m-d', strtotime('today - 30 days'));

        $first_day_month = date('Y-m-01');
        //
        $this_week_start = date('Y-m-d', strtotime('previous sunday'));

        $before_30_days = date('Y-m-d', strtotime('today - 30 days'));

        $month_n = date('n');

        $total = self::where('type', $type);

        if ($time == 'current_month') {
            $total
                ->where('date', '>=', $first_day_month)
                ->where('date', '<=', $mdate);
        } elseif ($time == 'current_week') {
            $total
                ->where('date', '>=', $this_week_start)
                ->where('date', '<=', $mdate);
        } elseif ($time == 'last_30_days') {
            $total
                ->where('date', '>=', $before_30_days)
                ->where('date', '<=', $mdate);
        }

        if (!$all_data) {
            $total->where('aid', $user->id);
        }

//        if ($type == 'Income') {
//            return $total->sum('cr');
//        }
//
//        return $total->sum('dr');


        if($type === 'Income')
        {
            $total->where('type', 'Income');
        }
        else{
            $total->where('type', 'Expense');
        }

        $transactions = $total->get();

        $total_amount = 0;

        foreach ($transactions as $transaction) {
            $total_amount += $transaction->amount*$transaction->currency_rate;
        }

        return $total_amount;

    }

    public static function remove($id)
    {
        global $user, $config;

        if (!has_access($user->roleid, 'transactions', 'delete')) {
            permissionDenied();
        }

        $t = ORM::for_table('sys_transactions')->find($id);
        if ($t) {
            $a = Account::where('account', $t['account'])
                ->first();
            $cr = $t['cr'];
            $dr = $t['dr'];
            if ($a) {
                $cbal = $a['balance'];
                $nbal = $cr != '0.00' ? $cbal - $cr : $cbal + $dr;

                $a->balance = $nbal;
                $a->save();

                $home_currency = Currency::where(
                    'iso_code',
                    $config['home_currency']
                )->first();
                $account_balance = Balance::where('account_id', $a->id)
                    ->where('currency_id', $home_currency->id)
                    ->first();

                if ($account_balance) {
                    $cbal = $account_balance->balance;

                    $nbal = $cr != '0.00' ? $cbal - $cr : $cbal + $dr;
                    $account_balance->balance = $nbal;
                    $account_balance->save();
                }
            }

            if ($t->iid != 0) {
                $invoice = Invoice::find($t->iid);

                if ($invoice) {
                    $transaction_amount = $t->amount;
                    $current_invoice_credit = $invoice->credit;
                    $new_invoice_credit =
                        $current_invoice_credit - $transaction_amount;
                    $invoice->credit = $new_invoice_credit;
                    $invoice->save();
                }
            }

            if ($t->purchase_id != 0 || $t->purchase_id != '') {
                $purchase = Purchase::find($t->purchase_id);

                if ($purchase) {
                    $transaction_amount = $t->amount;
                    $current_purchase_credit = $purchase->credit;
                    $new_purchase_credit =
                        $current_purchase_credit - $transaction_amount;
                    $purchase->credit = $new_purchase_credit;
                    $purchase->save();
                }
            }

            $t->delete();
            return true;
        } else {
            return false;
        }
    }

    public static function deposit()
    {
        $data = request()->all();
        global $_L, $config, $user;
        $account = _post('account');
        $date = _post('date');
        $amount = _post('amount');
        $amount = Finance::amount_fix($amount);
        $payerid = _post('payer');
        $ref = _post('ref');
        $pmethod = _post('pmethod');
        $cat = _post('cats');
        $tags = $data['tags'] ?? '';

        $attachments = _post('attachments');

        if ($payerid == '') {
            $payerid = '0';
        }
        $description = _post('description');
        $msg = '';
        if ($description == '') {
            $msg .= $_L['description_error'] . '<br>';
        }

        if ($account == '') {
            $msg .= $_L['Choose an Account'] . ' ' . '<br>';
        }

        if (is_numeric($amount) == false) {
            $msg .= $_L['amount_error'] . '<br>';
        }

        if ($msg == '') {
            Tags::save($tags, 'Income');

            $a = Account::where('account', $account)
                ->first();
            $cbal = $a['balance'];
            $nbal = $cbal + $amount;
            $a->balance = $nbal;
            $a->save();
            $d = new Transaction();
            $d->account = $account;
            $d->type = 'Income';
            $d->payerid = $payerid;
            $d->tags = Arr::arr_to_str($tags);
            $d->amount = $amount;
            $d->category = $cat;
            $d->method = $pmethod;
            $d->ref = $ref;

            $d->description = $description;
            $d->attachments = $attachments;
            $d->date = $date;
            $d->dr = '0.00';
            $d->cr = $amount;
            $d->bal = $nbal;

            $d->payer = '';
            $d->payee = '';
            $d->payeeid = '0';
            $d->status = 'Cleared';
            $d->tax = '0.00';
            $d->iid = 0;
            if ($user) {
                $d->aid = $user->id;
            }
            $d->updated_at = date('Y-m-d H:i:s');

            $currency = _post('currency');

            $currency_find = Currency::find($currency);

            if (!$currency_find) {
                $currency_find = Currency::where(
                    'iso_code',
                    $config['home_currency']
                )->first();
            }

            //

            $d->save();
            $tid = $d->id();
            _log(
                'New Deposit: ' .
                    $description .
                    ' [TrID: ' .
                    $tid .
                    ' | Amount: ' .
                    $amount .
                    ']',
                'Admin',
                $user['id']
            );
            _msglog('s', $_L['Transaction Added Successfully']);
            return $tid;
        }

        return $msg;
    }

    public static function rebuildCatData()
    {
        $transactions = Transaction::where('type', 'Income')->get();

        foreach ($transactions as $transaction) {
            $tr_cat = $transaction->category;

            $category = TransactionCategory::where('type', 'Income')
                ->where('name', $tr_cat)
                ->first();

            if (!$category && $tr_cat != '') {
                $c = new TransactionCategory();
                $c->name = $tr_cat;
                $c->type = 'Income';
                $c->save();
            }
        }

        $transactions = Transaction::where('type', 'Expense')->get();

        foreach ($transactions as $transaction) {
            $tr_cat = $transaction->category;

            $category = TransactionCategory::where('type', 'Expense')
                ->where('name', $tr_cat)
                ->first();

            if (!$category && $tr_cat != '') {
                $c = new TransactionCategory();
                $c->name = $tr_cat;
                $c->type = 'Expense';
                $c->save();
            }
        }

        $categories = TransactionCategory::where('type', 'Income')->get();

        foreach ($categories as $category) {
            $total = categoryCalculateTotalByName($category->name, 'Income');
            $category->total_amount = $total;
            $category->save();
        }

        $categories = TransactionCategory::where('type', 'Expense')->get();

        foreach ($categories as $category) {
            $total = categoryCalculateTotalByName($category->name, 'Expense');
            $category->total_amount = $total;
            $category->save();
        }
    }
}
