<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Connection;

class User extends Model
{
    protected $table = 'sys_users';

    protected static function booted()
    {
        $capsule = new Connection();
        static::setConnectionResolver($capsule->getCapsule()->getDatabaseManager());
    }

    public static function _info()
    {
        $id = $_SESSION['uid'] ?? null;

        if (!$id) {
            echo 'You have logged out. <a href="'.APP_URL.'/login/">Click Here to Login.</a>';
            exit;
        }

        return self::find($id);
    }

    public static function admin()
    {
        if(isset($_SESSION['uid']))
        {
            return self::find($_SESSION['uid']);
        }
        return false;
    }

}
