<?php
// ¡Necesita el archivo /config.php! (Uso de constantes)
// ¡Necesita el archivo /vendor/autoload.php!

/*if (session_status() === PHP_SESSION_NONE) {
    session_start();
}*/

// autoload.php
spl_autoload_register(function ($class) {
    $prefix = 'App\\';
    $base_dir = __DIR__ . '/app/';

    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) {
        return;
    }

    $relative_class = substr($class, $len);
    $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';

    if (file_exists($file)) {
        require $file;
    }
});


spl_autoload_register(function ($class) {
    $prefix = 'App\\Models\\';
    $base_dir = __DIR__ . '/Models/';
    $len = strlen($prefix);

    if (strncmp($prefix, $class, $len) !== 0) return;

    $relative_class = substr($class, $len);
    $file = $base_dir . $relative_class . '.php';

    if (file_exists($file)) {
        require $file;
    }
});

spl_autoload_register(function ($class) {
    $prefix = 'App\\Controllers\\';
    $base_dir = __DIR__ . '/Controllers/';
    $len = strlen($prefix);

    if (strncmp($prefix, $class, $len) !== 0) return;

    $relative_class = substr($class, $len);
    $file = $base_dir . $relative_class . '.php';

    if (file_exists($file)) require $file;
});


// Composer Autoload
/*if (file_exists(__DIR__ . '/../vendor/autoload.php')) {
    require_once __DIR__ . '/../vendor/autoload.php';
}*/

require_once __DIR__ . '/Connection.php';
// Routes
require __DIR__ . '/routes/api.php';

// Models
require_once __DIR__ . '/Models/User.php';

// Controllers
require_once __DIR__ . '/util/global.php';
require_once __DIR__ . '/Controllers/BaseController.php';
require_once __DIR__ . '/Controllers/UIController.php';

// Call
use App\Controllers\BaseController;
use App\Controllers\UIController;
use App\Connection;
use function App\Controllers\{_post, _get, _log, _auth};


$base = new BaseController();

/*$lang_file = 'system/i18n/' . ($base->config['language'] ?? 'en') . '.php';
$_L = file_exists($lang_file) ? require $lang_file : [];

$uiController = new UIController($base->config, $_L);
$ui = $uiController->getUI();


$ui->assign('selected_navigation', 'mnu-2');
$ui->assign('_title', $_L['Customers'] . ' - ' . $config['CompanyName']);

$user = User::_info();
$ui->assign('user', $user);


$ui->assign('base_datos_para_socket', DB_NAME);
$ui->assign('config_whatsapp_other_id_para_socket', empty($user["config_whatsapp_other_id"]) == true ? "No_existe" : $user["config_whatsapp_other_id"] );
$ui->assign('url_ir_chat_empleado', U . "social/social-chat-employee");
$ui->assign('url_ir_chat_admin', U . "social/social-chat");

$ui->assign('url_ir_chat_crm', U . "social/chat-crm");

$ui->assign('url_base_plantilla_admintpl', U);

$ui->assign('APP_URL_ORIGINAL_SOCKET', APP_URL_ORIGINAL_SOCKET);
$ui->assign('ws_nombre_socket', ws_nombre_socket);

$ui->assign('url_setting_CRM_Parnerts_prepared', url_setting_CRM_Parnerts_prepared);

$ui->assign('url_base', U);*/