<?php

function _isauth() {
    if (isset($_SESSION['uid'])) return true;
}

function _hasaccess($rid, $shortname, $action = 'view')
{
    if ($rid == 0) {
        return true;
    }

    $d = ORM::for_table('sys_staffpermissions')
        ->where('rid', $rid)
        ->where('shortname', $shortname)
        ->first();
    if ($d) {
        switch ($action) {
            case 'view':
                if ($d->can_view == 1) {
                    return true;
                } else {
                    return false;
                }

                break;

            case 'edit':
                if ($d->can_edit == 1) {
                    return true;
                } else {
                    return false;
                }

                break;

            case 'create':
                if ($d->can_create == 1) {
                    return true;
                } else {
                    return false;
                }

                break;

            case 'delete':
                if ($d->can_delete == 1) {
                    return true;
                } else {
                    return false;
                }

                break;

            case 'all_data':
                if ($d->all_data == 1) {
                    return true;
                } else {
                    return false;
                }

                break;

            default:
                return false;
        }
    } else {
        return false;
    }
}

function makeClientDb()
{
    static $clientDb = null;
    if ($clientDb instanceof PDO) {
        return $clientDb;
    }

    $dbConfig = require __DIR__ . '/../config/database.php';

    $driver  = $dbConfig['driver'] ?? 'mysql';
    $host    = $dbConfig['host'] ?? 'localhost';
    $port    = $dbConfig['port'] ?? '';
    $dbname  = $dbConfig['database'] ?? '';
    $user    = $dbConfig['username'] ?? '';
    $pass    = $dbConfig['password'] ?? '';
    $options = $dbConfig['options'] ?? [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES => false,
    ];

    $dsnParts = array_filter([
        "host={$host}",
        $port ? "port={$port}" : null,
        "dbname={$dbname}",
        "charset=utf8",
    ]);
    $dsn = $driver . ':' . implode(';', $dsnParts);

    $clientDb = new PDO($dsn, $user, $pass, $options);
    return $clientDb;
}
