<div class="">
    <h3>Banking Movements</h3>

    <div class="d-flex gap-2">
        <button id="btnConnect" type="button" class="button">Connect bank account</button>
        <button id="btnGetTransactions" type="button" class="button hidden" onclick="getTransactions()">
            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="20" height="20" viewBox="0 0 24 24" version="1.1">
                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><rect x="0" y="0" width="20" height="20"></rect><path d="M8.43296491,7.17429118 L9.40782327,7.85689436 C9.49616631,7.91875282 9.56214077,8.00751728 9.5959027,8.10994332 C9.68235021,8.37220548 9.53982427,8.65489052 9.27756211,8.74133803 L5.89079566,9.85769242 C5.84469033,9.87288977 5.79661753,9.8812917 5.74809064,9.88263369 C5.4720538,9.8902674 5.24209339,9.67268366 5.23445968,9.39664682 L5.13610134,5.83998177 C5.13313425,5.73269078 5.16477113,5.62729274 5.22633424,5.53937151 C5.384723,5.31316892 5.69649589,5.25819495 5.92269848,5.4165837 L6.72910242,5.98123382 C8.16546398,4.72182424 10.0239806,4 12,4 C16.418278,4 20,7.581722 20,12 C20,16.418278 16.418278,20 12,20 C7.581722,20 4,16.418278 4,12 L6,12 C6,15.3137085 8.6862915,18 12,18 C15.3137085,18 18,15.3137085 18,12 C18,8.6862915 15.3137085,6 12,6 C10.6885336,6 9.44767246,6.42282109 8.43296491,7.17429118 Z" fill="#000000" fill-rule="nonzero"></path></g>
            </svg> Refresh
        </button>
    </div>


    <!-- table -->
    <div class="table-container transactions-table hidden">
        <table id="transactions">
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Description</th>
                    <th>Amount</th>
                </tr>
            </thead>
            <tbody></tbody>
        </table>
    </div>
    <!-- table -->
</div>

{block name="script"}
<script src="https://cdn.plaid.com/link/v2/stable/link-initialize.js"></script>
<script>
checkTokenAndRenderUI();

function checkTokenAndRenderUI() {
    const token = localStorage.getItem('plaid_access_token');
    const btnConnect = document.getElementById('btnConnect');
    const tableSection = document.querySelector(".transactions-table");
    const table = document.getElementById('transactions');
    const btnUpdate = document.getElementById('btnGetTransactions');

    if (token) {
        btnConnect.style.display = 'none';
        tableSection.classList.remove('hidden');
        btnUpdate.classList.remove('hidden');

        getTransactions();
    } else {
        btnConnect.style.display = '';
        table.classList.add('hidden');
        btnUpdate.classList.add('hidden');
    }
}
async function getTransactions() {
    const access_token = localStorage.getItem('plaid_access_token');
    if (!access_token) {
        alert('No hay access_token guardado');
        return;
    }

    //POST /sandbox/transactions/fire_webhook
    const response = await fetch('{$app_url}api/plaid/transactions', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ access_token }),
    });

    const data = await response.json();
    console.log('Transacciones:', data);

    const tbody = document.querySelector('#transactions tbody');
    tbody.innerHTML = '';

    data.transactions.forEach(tx => {
        console.log("transaction", tx);
        const amountClass = tx.amount < 0 ? 'text-negative' : 'text-positive';

        const row = `
        <tr>
            <td>`+tx.date+`</td>
            <td>`+tx.name+`</td>
            <td><span class="`+amountClass+`">`+tx.amount + " " + tx.iso_currency_code+`</span></td>
        </tr>
        `;
        tbody.insertAdjacentHTML('beforeend', row);
    });
}

document.getElementById('btnConnect').addEventListener('click', async function () {
    try {
        // 1 - Request link token
        const res = await fetch('{$app_url}api/plaid/create_link_token', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' }
        });

        if (!res.ok) {
            const err = await res.json().catch(function() {

            });
            alert('Error obteniendo link token: ' + (err.error || res.status));
            return;
        }

        const body = await res.json();
        const linkToken = body.link_token;

        if (!linkToken) {
            console.error(body);
            console.error('Link token inválido. Revisa logs del servidor.');
            return;
        }

        // 2 - Init Plaid Link
        const handler = Plaid.create({
            token: linkToken,
            onSuccess: async function(public_token, metadata) {
                // Public token recibido
                try {
                    const exchangeRes = await fetch('{$app_url}api/plaid/exchange_public_token', {
                        method: 'POST',
                        headers: { 'Content-Type': 'application/json' },
                        body: JSON.stringify({ public_token })
                    });

                    const exchangeBody = await exchangeRes.json();
                    if (!exchangeRes.ok) {
                        console.error('Exchange fail', exchangeBody);
                        console.error('Error intercambiando public_token: ' + (exchangeBody.error || exchangeRes.status));
                        return;
                    }
               
                    console.log('Intercambio exitoso:', exchangeBody);
                    console.log('Cuenta conectada. Revisa consola para detalles.');

                    localStorage.setItem('plaid_access_token', exchangeBody.access_token);
                    checkTokenAndRenderUI();

                } catch (err) {
                    console.error(err);
                    console.error('Error en el intercambio: ' + err.message);
                }
            },
            onExit: function(err, metadata) {
                // Usuario error
                if (err) {
                    console.error('Plaid Link exit with error:', err);
                } else {
                    console.log('Plaid Link exit:', metadata);
                }
            },
            onEvent: function(eventName, metadata) {
                console.log('Plaid event', eventName, metadata);
            }
        });

        // Open Plaid Link modal
        handler.open();

    } catch (err) {
        console.error(err);
        console.error(' Plaid Link error: ' + err.message);
    }
});
</script>
<script>
/*$('.transactions-table table').dataTable({
    responsive: false,
    lengthChange: false,
    dom: `
        <'datatable-header d-flex flex-wrap align-items-center justify-content-between mb-3'
            <'datatable-search'f>
            <'datatable-buttons'B>
        >
        <'table-container datatable-wrapper'tr>
        <'datatable-footer d-flex flex-wrap align-items-center justify-content-between mt-3'
            <'datatable-info'i>
            <'datatable-paging'p>
        >
    `,
    responsive: {
        details: { type: 'column' }
    },
    buttons: [
		{
			extend: 'copyHtml5',
			titleAttr: 'Copy to clipboard',
			text: '<svg xmlns="http://www.w3.org/2000/svg" height="25" width="25" viewBox="0 0 55.699 55.699" version="1.1" xml:space="preserve"><g><path fill="#667085" d="M51.51,18.001c-0.006-0.085-0.022-0.167-0.05-0.248c-0.012-0.034-0.02-0.067-0.035-0.1   c-0.049-0.106-0.109-0.206-0.194-0.291v-0.001l0,0c0,0-0.001-0.001-0.001-0.002L34.161,0.293c-0.086-0.087-0.188-0.148-0.295-0.197   c-0.027-0.013-0.057-0.02-0.086-0.03c-0.086-0.029-0.174-0.048-0.265-0.053C33.494,0.011,33.475,0,33.453,0H22.177   c-3.678,0-6.669,2.992-6.669,6.67v1.674h-4.663c-3.678,0-6.67,2.992-6.67,6.67V49.03c0,3.678,2.992,6.669,6.67,6.669h22.677   c3.677,0,6.669-2.991,6.669-6.669v-1.675h4.664c3.678,0,6.669-2.991,6.669-6.669V18.069C51.524,18.045,51.512,18.025,51.51,18.001z    M34.454,3.414l13.655,13.655h-8.985c-2.575,0-4.67-2.095-4.67-4.67V3.414z M38.191,49.029c0,2.574-2.095,4.669-4.669,4.669H10.845   c-2.575,0-4.67-2.095-4.67-4.669V15.014c0-2.575,2.095-4.67,4.67-4.67h5.663h4.614v10.399c0,3.678,2.991,6.669,6.668,6.669h10.4   v18.942L38.191,49.029L38.191,49.029z M36.777,25.412h-8.986c-2.574,0-4.668-2.094-4.668-4.669v-8.985L36.777,25.412z    M44.855,45.355h-4.664V26.412c0-0.023-0.012-0.044-0.014-0.067c-0.006-0.085-0.021-0.167-0.049-0.249   c-0.012-0.033-0.021-0.066-0.036-0.1c-0.048-0.105-0.109-0.205-0.194-0.29l0,0l0,0c0-0.001-0.001-0.002-0.001-0.002L22.829,8.637   c-0.087-0.086-0.188-0.147-0.295-0.196c-0.029-0.013-0.058-0.021-0.088-0.031c-0.086-0.03-0.172-0.048-0.263-0.053   c-0.021-0.002-0.04-0.013-0.062-0.013h-4.614V6.67c0-2.575,2.095-4.67,4.669-4.67h10.277v10.4c0,3.678,2.992,6.67,6.67,6.67h10.399   v21.616C49.524,43.26,47.429,45.355,44.855,45.355z"/></g></svg>',
			className: 'button'
		},
		{
			extend: 'csvHtml5',
			titleAttr: 'Generate CSV',
			text: '<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 548.29 548.291" fill="#2fb344" version="1.1" xml:space="preserve"><g><path fill="#2fb344" d="M486.2,196.121h-13.164V132.59c0-0.399-0.064-0.795-0.116-1.2c-0.021-2.52-0.824-5-2.551-6.96L364.656,3.677   c-0.031-0.034-0.064-0.044-0.085-0.075c-0.629-0.707-1.364-1.292-2.141-1.796c-0.231-0.157-0.462-0.286-0.704-0.419   c-0.672-0.365-1.386-0.672-2.121-0.893c-0.199-0.052-0.377-0.134-0.576-0.188C358.229,0.118,357.4,0,356.562,0H96.757   C84.893,0,75.256,9.649,75.256,21.502v174.613H62.093c-16.972,0-30.733,13.756-30.733,30.73v159.81   c0,16.966,13.761,30.736,30.733,30.736h13.163V526.79c0,11.854,9.637,21.501,21.501,21.501h354.777   c11.853,0,21.502-9.647,21.502-21.501V417.392H486.2c16.966,0,30.729-13.764,30.729-30.731v-159.81   C516.93,209.872,503.166,196.121,486.2,196.121z M96.757,21.502h249.053v110.006c0,5.94,4.818,10.751,10.751,10.751h94.973v53.861   H96.757V21.502z M258.618,313.18c-26.68-9.291-44.063-24.053-44.063-47.389c0-27.404,22.861-48.368,60.733-48.368   c18.107,0,31.447,3.811,40.968,8.107l-8.09,29.3c-6.43-3.107-17.862-7.632-33.59-7.632c-15.717,0-23.339,7.149-23.339,15.485   c0,10.247,9.047,14.769,29.78,22.632c28.341,10.479,41.681,25.239,41.681,47.874c0,26.909-20.721,49.786-64.792,49.786   c-18.338,0-36.449-4.776-45.497-9.77l7.38-30.016c9.772,5.014,24.775,10.006,40.264,10.006c16.671,0,25.488-6.908,25.488-17.396   C285.536,325.789,277.909,320.078,258.618,313.18z M69.474,302.692c0-54.781,39.074-85.269,87.654-85.269   c18.822,0,33.113,3.811,39.549,7.149l-7.392,28.816c-7.38-3.084-17.632-5.939-30.491-5.939c-28.822,0-51.206,17.375-51.206,53.099   c0,32.158,19.051,52.4,51.456,52.4c10.947,0,23.097-2.378,30.241-5.238l5.483,28.346c-6.672,3.34-21.674,6.919-41.208,6.919   C98.06,382.976,69.474,348.424,69.474,302.692z M451.534,520.962H96.757v-103.57h354.777V520.962z M427.518,380.583h-42.399   l-51.45-160.536h39.787l19.526,67.894c5.479,19.046,10.479,37.386,14.299,57.397h0.709c4.048-19.298,9.045-38.352,14.526-56.693   l20.487-68.598h38.599L427.518,380.583z"/></g></svg>',
			className: 'button'
		},
		{
			extend: 'excelHtml5',
			titleAttr: 'Generate Excel',
			text: '<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 550.801 550.801" fill="#2fb344" version="1.1" xml:space="preserve"><g><path fill="#2fb344" d="M488.432,197.019h-13.226v-63.816c0-0.398-0.063-0.799-0.111-1.205c-0.021-2.531-0.833-5.021-2.568-6.992L366.325,3.694   c-0.032-0.031-0.063-0.042-0.085-0.076c-0.633-0.707-1.371-1.295-2.151-1.804c-0.231-0.155-0.464-0.285-0.706-0.422   c-0.676-0.366-1.393-0.675-2.131-0.896c-0.2-0.053-0.38-0.135-0.58-0.188C359.87,0.119,359.037,0,358.193,0H97.2   c-11.918,0-21.6,9.693-21.6,21.601v175.413H62.377c-17.049,0-30.873,13.818-30.873,30.873v160.545   c0,17.038,13.824,30.87,30.873,30.87h13.224V529.2c0,11.907,9.682,21.601,21.6,21.601h356.4c11.907,0,21.6-9.693,21.6-21.601   V419.302h13.226c17.044,0,30.871-13.827,30.871-30.87v-160.54C519.297,210.832,505.48,197.019,488.432,197.019z M97.2,21.601   h250.193v110.51c0,5.967,4.841,10.8,10.8,10.8h95.407v54.108H97.2V21.601z M339.562,354.344v31.324H236.509V220.704h37.46v133.64   H339.562z M74.25,385.663l47.73-83.458l-46.019-81.501h42.833l14.439,30.099c4.899,10.03,8.572,18.116,12.49,27.414h0.483   c3.926-10.529,7.101-17.872,11.259-27.414l13.954-30.099h42.588l-46.509,80.525l48.961,84.438h-43.081l-14.929-29.858   c-6.115-11.507-10.036-20.07-14.684-29.615h-0.49c-3.431,9.55-7.583,18.119-12.722,29.615l-13.711,29.858H74.25V385.663z    M453.601,523.353H97.2V419.302h356.4V523.353z M401.963,388.125c-18.837,0-37.446-4.904-46.738-10.04l7.578-30.839   c10.04,5.136,25.46,10.283,41.375,10.283c17.139,0,26.188-7.099,26.188-17.867c0-10.283-7.831-16.157-27.659-23.256   c-27.411-9.55-45.282-24.722-45.282-48.718c0-28.15,23.498-49.684,62.427-49.684c18.594,0,32.305,3.927,42.093,8.322l-8.322,30.109   c-6.607-3.186-18.361-7.834-34.509-7.834c-16.152,0-23.983,7.338-23.983,15.913c0,10.525,9.291,15.18,30.591,23.258   c29.125,10.769,42.836,25.936,42.836,49.191C468.545,364.627,447.257,388.125,401.963,388.125z"/></g></svg>',
			className: 'button'
		},
		{
			extend: 'pdfHtml5',			
			titleAttr: 'Generate PDF',
			text: '<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 550.801 550.801" fill="#f72015" version="1.1" xml:space="preserve"><g><path fill="#f72015" d="M160.381,282.225c0-14.832-10.299-23.684-28.474-23.684c-7.414,0-12.437,0.715-15.071,1.432V307.6   c3.114,0.707,6.942,0.949,12.192,0.949C148.419,308.549,160.381,298.74,160.381,282.225z"/><path d="M272.875,259.019c-8.145,0-13.397,0.717-16.519,1.435v105.523c3.116,0.729,8.142,0.729,12.69,0.729   c33.017,0.231,54.554-17.946,54.554-56.474C323.842,276.719,304.215,259.019,272.875,259.019z"/><path d="M488.426,197.019H475.2v-63.816c0-0.398-0.063-0.799-0.116-1.202c-0.021-2.534-0.827-5.023-2.562-6.995L366.325,3.694   c-0.032-0.031-0.063-0.042-0.085-0.076c-0.633-0.707-1.371-1.295-2.151-1.804c-0.231-0.155-0.464-0.285-0.706-0.419   c-0.676-0.369-1.393-0.675-2.131-0.896c-0.2-0.056-0.38-0.138-0.58-0.19C359.87,0.119,359.037,0,358.193,0H97.2   c-11.918,0-21.6,9.693-21.6,21.601v175.413H62.377c-17.049,0-30.873,13.818-30.873,30.873v160.545   c0,17.043,13.824,30.87,30.873,30.87h13.224V529.2c0,11.907,9.682,21.601,21.6,21.601h356.4c11.907,0,21.6-9.693,21.6-21.601   V419.302h13.226c17.044,0,30.871-13.827,30.871-30.87v-160.54C519.297,210.838,505.47,197.019,488.426,197.019z M97.2,21.605   h250.193v110.513c0,5.967,4.841,10.8,10.8,10.8h95.407v54.108H97.2V21.605z M362.359,309.023c0,30.876-11.243,52.165-26.82,65.333   c-16.971,14.117-42.82,20.814-74.396,20.814c-18.9,0-32.297-1.197-41.401-2.389V234.365c13.399-2.149,30.878-3.346,49.304-3.346   c30.612,0,50.478,5.508,66.039,17.226C351.828,260.69,362.359,280.547,362.359,309.023z M80.7,393.499V234.365   c11.241-1.904,27.042-3.346,49.296-3.346c22.491,0,38.527,4.308,49.291,12.928c10.292,8.131,17.215,21.534,17.215,37.328   c0,15.799-5.25,29.198-14.829,38.285c-12.442,11.728-30.865,16.996-52.407,16.996c-4.778,0-9.1-0.243-12.435-0.723v57.67H80.7   V393.499z M453.601,523.353H97.2V419.302h356.4V523.353z M484.898,262.127h-61.989v36.851h57.913v29.674h-57.913v64.848h-36.593   V232.216h98.582V262.127z"/></g></svg>',
			className: 'button'
		},
		{
			extend: 'print',
			titleAttr: 'Print Table',
			text: '<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 512 512" version="1.1" xml:space="preserve"><g><rect x="168.084" y="335.709" fill="#667085"/><rect x="168.084" y="387.871" fill="#667085" width="175.831" height="20.29"/><rect x="168.084" y="434.242" fill="#667085" width="83.085" height="20.29"/><path fill="#667085" d="M488.338,163.731c-8.009-8.029-19.199-13.028-31.44-13.028h-47.304V78.276L331.319,0h-4.798H102.405v150.703   H55.102c-12.253,0-23.44,5-31.448,13.028c-8.02,8.013-13.02,19.199-13.012,31.436v169.958   c-0.008,12.245,4.983,23.432,13.012,31.453c8.017,8.012,19.208,13.02,31.448,13.004h47.303V512h307.189V409.582h47.304   c12.233,0.016,23.419-4.992,31.428-13.004c8.033-7.996,13.04-19.2,13.033-31.453V195.168   C501.366,182.922,496.359,171.744,488.338,163.731z M324.587,26.048l57.024,57.041h-57.024V26.048z M386.409,488.819H125.59V398   h-0.012v-94.655H386.4v106.238h0.008V488.819z M335.813,230.287c0-9.216,7.475-16.679,16.675-16.679   c9.216,0,16.679,7.463,16.679,16.679c0,9.208-7.463,16.671-16.679,16.671C343.289,246.958,335.813,239.495,335.813,230.287z    M386.409,150.703H125.59V23.189h175.811v83.074h85.007V150.703z M423.467,246.958c-9.204,0-16.667-7.463-16.667-16.671   c0-9.216,7.463-16.679,16.667-16.679c9.212,0,16.675,7.463,16.675,16.679C440.142,239.495,432.679,246.958,423.467,246.958z"/></g></svg>',
			className: 'button'
		}
	],
    language: {
        "emptyTable": "{$_L['No items to display']}",
        "info":      "{$_L['Showing _START_ to _END_ of _TOTAL_ entries']}",
        "infoEmpty":      "{$_L['Showing 0 to 0 of 0 entries']}",
        buttons: {
            pageLength: '{$_L['Show all']}'
        },
        searchPlaceholder: "{__('Search')}",
        paginate: {
            first: "«",
            last: "»",
            next: "›",
            previous: "‹"
        }
    },
    responsive: {
        details: { type: 'column' }
    },
    autoWidth: false,
    processing: false,
    serverSide: false,
    info: true,
    order: [[1, 'asc']]
});*/
</script>
{/block}
