<form id="rform" class="profile-panel" autocomplete="off">

    <textarea hidden class="tener_compania">{$companies_json}</textarea>
    <textarea hidden class="micompanias">{$myCompanies}</textarea>

    <div class="profile-panel-header">
        <h3>Edit Profile</h3>
    </div>

    <div class="card-box">
        <h2>Personal Information</h2>

        <div class="card-grid mb-4">
            <div class="card-row">
                <label class="key" for="account">Full name</label>
                <input type="text" class="form-control value-input" id="account" name="account" value="{$d['account']}">
            </div>

            {if ($d['company']) neq ''}
            <div class="card-row">
                <label class="key" for="company_id">Company Name</label>
                <select id="company_id" name="company_id" class="form-control value-input">
                    <option value="0">{$_L['None']}</option>
                    {foreach $companies as $company}
                        <option value="{$company['id']}" {if $d->cid eq ($company['id'])}selected{/if}>{$company['company_name']}</option>
                    {/foreach}
                </select>
            </div>
            {/if}

            <div class="card-row">
                <label class="key" for="edit_email">Email address</label>
                <input type="email" class="form-control value-input" id="edit_email" name="edit_email" value="{$d['email']}">
            </div>

            <div class="card-row">
                <label class="key" for="phone">Phone</label>
                <input type="text" class="form-control value-input" id="phone" name="phone" value="{$d['telephone_number']|default:$d['phone']}">
            </div>

            {if $config['fax_field'] eq '1'}
                <div class="card-row">
                    <label class="key" for="fax">{$_L['Fax']}</label>
                    <input type="text" class="form-control value-input" id="fax" name="fax" value="{$d['fax']}">
                </div>
            {/if}

            <div class="card-row">
                <label class="key" for="address">Address</label>
                <input type="text" class="form-control value-input" id="address" name="address" value="{$d['address']}">
            </div>
        </div>

        <div class="card-grid">
            <div class="card-row">
                <label class="key" for="country">Country</label>
                <select id="country" name="country" class="form-control value-input">
                    <option value="">{$_L['Select Country']}</option>
                    {$countries}
                </select>
            </div>

            <div class="card-row">
                <label class="key" for="city">City/State</label>
                <input type="text" class="form-control value-input" id="city" name="city" value="{$d['city']}">
            </div>

            <div class="card-row">
                <label class="key" for="state">State/Region</label>
                <input type="text" class="form-control value-input" id="state" name="state" value="{$d['state']}">
            </div>

            <div class="card-row">
                <label class="key" for="zip">ZIP/Postal Code</label>
                <input type="text" class="form-control value-input" id="zip" name="zip" value="{$d['zip']}">
            </div>
        </div>

    </div>


    <div class="card-box">
        <h2>Group Information</h2>

        <div class="card-grid">
            <div class="card-row">
                <label class="key" for="group">Group</label>
                <select id="group" name="group" class="form-control value-input">
                    <option value="">{$_L['Select']}</option>
                    {foreach $gs as $g}
                        <option value="{$g['id']}" {if ($d['gid'] eq $g['id']) || ($g_selected_id eq $g['id'])}selected{/if}>{$g['gname']}</option>
                    {/foreach}
                </select>
            </div>

            <div class="card-row">
                <label class="key" for="code">Code</label>
                <input type="text" class="form-control value-input" id="code" name="code" value="{$d['code']}">
            </div>

            <div class="card-row">
                <label class="key" for="tags">Tags</label>
                <input type="text" class="form-control value-input" id="tags" name="tags" value="{$d['tags']}">
            </div>

            <div class="card-row">
                <label class="key" for="owner_id">Owner</label>
                <select class="form-control value-input" name="owner_id" id="owner_id">
                    {foreach $owners as $owner}
                        <option value="{$owner->id}" {if $owner->id == $d->o}selected{/if}>{$owner->fullname}</option>
                    {/foreach}
                </select>
            </div>

            <div class="card-row">
                <label class="key" for="nationality">Nationality</label>
                <select class="form-control value-input nationality" name="nationality" id="nationality">
                    <option value="">Select Nationality</option>
                    {if isset($countries_nationality)}{$countries_nationality}{else}{$countries}{/if}
                </select>
            </div>

            <!-- Type -->
            <div class="card-row">
                <label class="key" for="cid">{$_L['Type']}</label>
                <div class="checkbox">
                    <label>
                        <input type="checkbox" class="custom-checkbox" name="customer" value="Customer" {if $d->type == 'Customer,Supplier' || $d->type == 'Customer' } checked {/if}>
                        {$_L['Customer']}
                    </label>
                </div>

                {if $config['suppliers'] eq '1'}
                <div class="checkbox">
                    <label>
                        <input type="checkbox" class="custom-checkbox" name="supplier" value="Supplier"  {if $d->type == 'Customer,Supplier' || $d->type == 'Supplier' } checked {/if}>
                        {$_L['Supplier']}
                    </label>
                </div>
                {/if}
            </div>

            <!-- Position -->
            <div class="card-row">
                <label class="key" for="position">Position</label>
                <input type="text" class="form-control value-input" id="position" name="position" value="{$d['position']}">
            </div>


            <!-- Currency -->
            {if $config['accounting'] eq '1'}

                <div class="card-row">
                    <label class="key control-label h6" for="currency">{$_L['Currency']}</label>
                    <select id="currency" name="currency" class="form-control value-input">
    
                        {foreach $currencies as $currency}
                        <option value="{$currency['id']}" {if ($d['currency']) eq ($currency['id'])}selected="selected" {/if}>{$currency['cname']}</option>
                        {foreachelse}
                        <option value="0">{$config['home_currency']}</option>
                        {/foreach}
    
                    </select>
                </div>
    
            {/if}

            <div class="card-row">
                <span class="key">{$_L['Primary Contact']}?</span>
                <div>
                    <input type="hidden" name="is_primary_contact" value="0">
                    <label class="switch s-icons s-outline s-outline-primary mb-0">
                        <input type="checkbox" name="is_primary_contact" id="is_primary_contact" value="1" {if $d['is_primary_contact'] eq '1'}checked{/if}>
                        <span class="slider round"></span>
                    </label>
                </div>
            </div>

        </div>
    </div>

    <div class="card-box">
        <h2>Notes</h2>

        <div class="card-row">
            <textarea class="form-control value-input notas" id="notas" name="notas" rows="6">{$d['notas']}</textarea>
        </div>
    </div>


    <input type="hidden" name="fcid" id="fcid" value="{$d['id']}">


    {if $config['client_dashboard'] eq '1'}
        <hr>
        <h3>Update Login</h3>
        <div class="card-box">
            <div class="card-top">
                <svg class="icon-svg" xmlns="http://www.w3.org/2000/svg" width="24" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="#000000" class="size-6">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 5.25a3 3 0 0 1 3 3m3 0a6 6 0 0 1-7.029 5.912c-.563-.097-1.159.026-1.563.43L10.5 17.25H8.25v2.25H6v2.25H2.25v-2.818c0-.597.237-1.17.659-1.591l6.499-6.499c.404-.404.527-1 .43-1.563A6 6 0 1 1 21.75 8.25Z" />
                </svg>
            </div>

            
            <div class="card-grid">
                
                {if $config['customer_custom_username']}
                <div class="card-row">
                    <label class="key" for="username">Username</label>
                    <input type="text" class="form-control value-input" id="username" name="username" value="{$d['username']}" autocomplete="new-username">
                </div>
                {/if}

                <div class="card-row">
                    <label class="key" for="password">Password</label>
                    <input type="password" class="form-control value-input" id="password" name="password" autocomplete="new-password">
                    <span class="help-block h6">{$_L['password_change_help']}</span>
                </div>

            </div>

        </div>

    {/if}


    <hr>
    <h3>Add Company</h3>
    <div class="card-box">

        <div class="card-row">

            <div class="addon-action-panel">

                <div class="input-element">

                    <label class="key" for="compania">Company <span class="text-danger">*</span></label>
                    <select id="compania" name="compania" class="form-control value-input compania">
                        <option value="">Select a company</option>
                        {foreach $companies as $company}
                        <option value="{$company['id']}" {if $c_selected_id eq ($company['id'])}selected{/if}>
                            {$company['company_name']}
                        </option>
                        {/foreach}
                    </select>

                </div>
                
                <button type="button" class="button guardar_tabla_compania">
                    <svg width="24" height="24" viewBox="0 0 24 24" stroke-width="0.5" fill="none" xmlns="http://www.w3.org/2000/svg" class="menu-item-icon-inactive">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M14 2.75C14 2.33579 14.3358 2 14.75 2C15.1642 2 15.5 2.33579 15.5 2.75V5.73291L17.75 5.73291H19C19.4142 5.73291 19.75 6.0687 19.75 6.48291C19.75 6.89712 19.4142 7.23291 19 7.23291H18.5L18.5 12.2329C18.5 15.5691 15.9866 18.3183 12.75 18.6901V21.25C12.75 21.6642 12.4142 22 12 22C11.5858 22 11.25 21.6642 11.25 21.25V18.6901C8.01342 18.3183 5.5 15.5691 5.5 12.2329L5.5 7.23291H5C4.58579 7.23291 4.25 6.89712 4.25 6.48291C4.25 6.0687 4.58579 5.73291 5 5.73291L6.25 5.73291L8.5 5.73291L8.5 2.75C8.5 2.33579 8.83579 2 9.25 2C9.66421 2 10 2.33579 10 2.75L10 5.73291L14 5.73291V2.75ZM7 7.23291L7 12.2329C7 14.9943 9.23858 17.2329 12 17.2329C14.7614 17.2329 17 14.9943 17 12.2329L17 7.23291L7 7.23291Z" fill="currentColor"></path>
                    </svg>Add
                </button>

            </div>
        </div>
        

        <div class="table-container mt-3">
            <table id="clx_datatable">
                <thead>
                    <tr>
                        <th>Company</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody class="tbody_envios_identificador">
                    <tr>
                        <td colspan="2">No information</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-end">
                <button type="submit" class="btn btn-primary">{$_L['Submit']}</button>
            </div>
        </div>
    </div>

</form>

{literal}
<script>
function generateUUIDv4() {
    const time_low = Date.now().toString(16).padStart(8, '0') + Math.random().toString(16).slice(2, 6);

    const array = new Uint8Array(8);
    crypto.getRandomValues(array);
    const extra_bytes = Array.from(array, byte => byte.toString(16).padStart(2, '0')).join('');

    const uuid = [
        time_low.slice(0, 8),
        time_low.slice(8, 12),
        '4' + extra_bytes.slice(0, 3),
        ((parseInt(extra_bytes.slice(3, 7), 16) & 0x3fff) | 0x8000).toString(16),
        extra_bytes.slice(7, 12) + Math.random().toString(16).slice(2, 7)
    ].join('-');

    return uuid;
}

function uuidToBase64UrlRFC7515(uuid) {
    const cleanUuid = uuid.replace(/-/g, '');
    const hexBytes = cleanUuid.match(/.{1,2}/g) || [];
    const binaryUuid = hexBytes.map(byte => parseInt(byte, 16));
    const base64 = btoa(String.fromCharCode(...binaryUuid));
    const base64Url = base64.replace(/\+/g, '-').replace(/\//g, '_').replace(/=/g, '');

    return base64Url;
}

function isEmpty(value) {

    if (value === null || value === undefined) return true;

    if (typeof value === 'string') {
       return value.trim().length === 0;
    }
    
    if (Array.isArray(value)) {
       return value.length === 0;
    }

    if (typeof value === 'object') {
       return Object.keys(value).length === 0;
    }

    return false;
}





// Formatear la opción para mostrar la bandera y el nombre del país
function formatOption(option) {
    if (!option.id) {
        return option.text; // Placeholder o texto por defecto
    }
    const $option = $(
        '<span>' +
        '<img src="' + option.element.dataset.icon + '" class="img-flag" style="width: 20px; margin-right: 8px; vertical-align: middle;" />' +
        option.text +
        '</span>'
    );
    return $option;
}

// Función para permitir búsqueda por nombre del país
function matchCustom(params, data) {
    if (!params.term || params.term.trim() === '') {
        return data;
    }
    const term = params.term.toLowerCase();
    if (data.text.toLowerCase().indexOf(term) > -1) {
        return data;
    }
    return null;
}

//$('#codigo_pais').html(options);

$('#codigo_pais').select2({
    templateResult: formatOption,
    templateSelection: formatOption,
    matcher: matchCustom,
    dropdownParent: $('#codigo_pais').parent() // Asegura que el dropdown se alinee con el contenedor padre
}).on('select2:open', function() {
    $('.select2-container--open .select2-dropdown').css('z-index', '1060'); // Ajusta este valor según el z-index del modal
});

$("#codigo_pais").val($(".codigo_pais_tener").val()).trigger('change');


//Nationality
    $('#nationality').select2();

    var $submitBtn = $('#rform').find("button[type='submit']");
    var submitOriginalHtml = $submitBtn.html();

    function toggleSubmitLoading(isLoading) {
        if (isLoading) {
            $submitBtn.data('loading', true);
            $submitBtn.prop('disabled', true);
            $submitBtn.html('<i class="fas fa-spinner fa-spin" style="margin-right: 8px;"></i> Saving');
            return;
        }

        $submitBtn.data('loading', false);
        $submitBtn.prop('disabled', false);
        $submitBtn.html(submitOriginalHtml);
    }


    function serach_address(address,secundary,option = 1) {
    var country = $('#country').val();
    let x=address.trim();

    if (x.length > 2 && country === "United States") {
        var settings = {
            "url": "https://us-autocomplete-pro.api.smarty.com/lookup?key=188805315395749398&search="+address+"&selected="+secundary+"&include_only_cities=&include_only_states=&include_only_zip_codes=&exclude_states=&prefer_cities=&prefer_states=&prefer_zip_codes=&source=all",
            "method": "GET",
            "timeout": 0,
            "headers": {
                "Host": "us-autocomplete-pro.api.smarty.com",
                "Referer": "https://hispanosdeexitollc.com"
            },
        };

        $('#browsers').html('');
        $('#browsers').show();

        $.ajax(settings).done(function (response) {

            $.each(response.suggestions, function (k, v) {
                let text=v.street_line+' '+v.secondary+' '+v.city+', '+v.state+' '+v.zipcode;
                let line=v.street_line+' '+v.secondary+' ('+v.entries+') '+v.city+', '+v.state+' '+v.zipcode;
                let line2=v.street_line+' '+v.secondary;
                let entries=(v.entries > 1) ? '<a href="#" data-data1="'+line+'" data-data2="'+line2+'" class="addresssec"><span class="badge bg-primary rounded-pill">+ '+v.entries+' Address</span></a>' : "" ;
                let option='<li class="list-group-item d-flex justify-content-between align-items-start "><div class="ms-2 me-auto address1" data-data1="'+v.city+'" data-data2="'+v.state+'" data-data3="'+v.zipcode+'" data-data4="'+v.street_line+' '+v.secondary+'"><div class="fw-bold">'+text+'</div></div>'+entries+'</li>';
                $('#browsers').append(option);
                x++;
            });

        })
    }
}


$("input[name='address']").on('input', function(e){
  var address = $(this).val();
  var country = $('#country').val();
  let x=address.trim();
  if (x.length > 2 && country === "United States") {
    address = address.replace(/,/g, "");
    address = address.replace(/ /g, "+");
    address = address.replace(/#/g, "%23");
    serach_address(address,"",1);    
}
});


$(document).on('click', '.address1', function(e){
    e.preventDefault();
    $('#city').val($(this).data('data1'));
    $('#state').val($(this).data('data2'));
    $('#zip').val($(this).data('data3'));
    $('#address').val($(this).data('data4'));
    $('#browsers').hide();

});


$(document).on('click', '.addresssec', function(e){
    e.preventDefault();
    let address=$(this).data('data2');
    $('#address').val(address);
    let secundary=$(this).data('data1');
    secundary = secundary.replace(/,/g, "");
    secundary = secundary.replace(/ /g, "+");
    secundary = secundary.replace(/#/g, "%23");
    address = address.replace(/,/g, "");
    address = address.replace(/ /g, "+");
    address = address.replace(/#/g, "%23");
    serach_address(address,secundary,2);
});

$(document).ready(function () {

var compania_ = $('.compania');
    compania_.select2();

    var arrCompania = [];
    var arrCompaniaBackend = [];
    var arrCompaniaEliminados = [];

    const tomarContactos = $('.tener_compania').text();
    //console.log(tomarContactos);

    try {
        
        if(!isEmpty(tomarContactos))
        {
            let parsearContacto = JSON.parse(tomarContactos);

            if (Array.isArray(parsearContacto)) {
                arrCompania = parsearContacto || [];

                console.log("arrCompania");
                console.log(arrCompania);
            }
        }

    } catch (error) {
        console.error('Error al parsear los compania:', error);
    }

    const tomarMiCompanias = $('.micompanias').text();

    try {
        
        if(!isEmpty(tomarMiCompanias))
        {
            let parsearMiCompania = JSON.parse(tomarMiCompanias);

            if (Array.isArray(parsearMiCompania)) {
                arrCompaniaBackend = parsearMiCompania || [];

                console.log("arrCompaniaBackend");
                console.log(arrCompaniaBackend);

                $(".tbody_envios_identificador").html(tabla_html_identificador(arrCompaniaBackend));
                eventosTablaIdentificador();
            }
        }

    } catch (error) {
        console.error('Error al parsear los mis compania:', error);
    }
     

    $(".guardar_tabla_compania").click(function(e){

        const selectedValue = $('#compania').val();
        const selectedText = $('#compania option:selected').text();

        if (!isEmpty(selectedValue)) {

            const findCompany = arrCompania.find((data) => data.id == selectedValue  )
           
            if(findCompany)
            {
                let existeData = arrCompaniaBackend.find((data) => data.idCompany == selectedValue  );

                if(existeData)
                {
                    toastr.error(
                        "The company has already been added to the table",
                    );   
                    return;
                }

                let UUID = generateUUIDv4();
                let UUID_ENC = uuidToBase64UrlRFC7515(UUID);

                const informacion = {
                    UUID:UUID,
                    UUID_ENC:UUID_ENC,
                    idCompany: selectedValue,
                    nameCompany: findCompany.company_name,
                    accion: "guardar",
                };

                arrCompaniaBackend.push(informacion);

                $(".tbody_envios_identificador").html(tabla_html_identificador(arrCompaniaBackend));
                eventosTablaIdentificador();

                $('#compania').val("").trigger("change");

                //console.log("informacion");
                //console.log(informacion);
            }

           return;
        }

        toastr.error(
            "The company field is required",
            "Select a company",
        );

    });

    function tabla_html_identificador(arreglo) {
        let html = "";
        
        arreglo.forEach(function (element) {

            let {
                UUID,
                UUID_ENC,
                idCompany,
                nameCompany,
            } = element;
    

            html +=
                "<tr>" +
                "<td>" + nameCompany + "</td>" +
     
                "<td>" +
                "<div class='row'>" +
                "<div class='col-12'>" +
     
                "<button type='button' class='btn btn-sm btn-remove-company waves-effect waves-themed' data-id='" + UUID_ENC + "'>" +
                "<i class='fas fa-trash tamano-icono' aria-hidden='true'></i>" +
                "</button>" +
                "</div>" +
                "</div>" +
                "</td>" +

                "</tr>";
        });

        return html;
    }

    function eventosTablaIdentificador() {
        $('.btn-remove-company').off('click');

        $('.btn-remove-company').on('click', function() {
            var dataId = $(this).data('id');
            console.log('ID de la referencia:', dataId);
    
            Swal.fire({
                title: "You are sure?",
                text: "Are you sure you want to delete a record?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Delete',
                cancelButtonText: 'Close'
            }).then((result) => {
                if (result.isConfirmed) {
                    console.log('producto eliminado');     
                    
                    let infoEncontrada = arrCompaniaBackend.find((data) => data.UUID_ENC == dataId);

                    if (infoEncontrada) {
                        arrCompaniaBackend = arrCompaniaBackend.filter(data => data.UUID_ENC !== dataId);

                        // Usa el identificador real
                        if (infoEncontrada.idCompany) {
                            arrCompaniaEliminados.push(infoEncontrada.idCompany);
                        } else if (infoEncontrada.id) {
                            arrCompaniaEliminados.push(infoEncontrada.id);
                        }

                        $(".tbody_envios_identificador").html(tabla_html_identificador(arrCompaniaBackend));
                        eventosTablaIdentificador();
                    }                     

                }
            });
 
        });
        

    }

   

    $('#rform').on('submit', function (e) {
        e.preventDefault();

        if ($submitBtn.data('loading')) {
            return;
        }

        toggleSubmitLoading(true);

        var base_url = $('#_url').val().split("?ng=")[0];
        let groupValue =  $("#group").val();

        
        if(isEmpty(groupValue) || (groupValue == 0 || groupValue == "0")) {

            var body = $("html, body");
            Swal.fire({
                icon: "error",
                title: "Oops...",
                text: "Please select a group",
            });
            toggleSubmitLoading(false);
            return;
        }

        
        var formData = $(this).serializeArray();

        formData.push({
            name: 'companies',
            value: JSON.stringify(arrCompaniaBackend)
        });

        formData.push({
            name: 'companies_deletes',
            value: JSON.stringify(arrCompaniaEliminados)
        });

        console.log("formData", formData);

        if (typeof $('#ibox_form').block === 'function') {
            $('#ibox_form').block({ message: block_msg });
        }

        var contactId = $('#fcid').val(); 
        var api_url = base_url + 'api/contacts/update/' + contactId;


        $.ajax({
            url: api_url,
            type: 'POST',
            data: $.param(formData)
        })
        .done(function (res) {

            if (res.status === 'success') {

                Swal.fire({
                    toast: true,
                    position: 'top-end',
                    icon: 'success',
                    title: res.message || 'Operación realizada con éxito',
                    showConfirmButton: false,
                    timer: 2000,
                    timerProgressBar: true
                });
                
                /*if (res.id) {
                    // window.location = base_url + 'contacts/view/' + res.id + '/edit/';
                }*/

            } else if (res.status === 'error') {

                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: res.message || 'Error desconocido del servidor.'
                });

            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'Respuesta inesperada del servidor.'
                });
            }

        })
        .fail(function (xhr) {

            Swal.fire({
                icon: 'error',
                title: 'Error HTTP',
                text: xhr.message || 'El servidor devolvió un código no-200'
            });

        })
        .always(function () {
            toggleSubmitLoading(false);
            if (typeof $('#ibox_form').unblock === 'function') {
                $('#ibox_form').unblock();
            }
        });


    });
});
</script>
{/literal}
