<div id="profile_panel" class="profile-panel">

    <div class="profile-panel-header">
        <h3>Profile</h3>

        <div class="panel-toolbar">
            <a href="{$_url}contacts/view/{$d->id}/edit/" class="btn btn-primary">
                <svg class="fill-current" width="21" height="21" viewBox="0 0 21 21" fill="#fff" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M17.0911 3.53206C16.2124 2.65338 14.7878 2.65338 13.9091 3.53206L5.6074 11.8337C5.29899 12.1421 5.08687 12.5335 4.99684 12.9603L4.26177 16.445C4.20943 16.6931 4.286 16.9508 4.46529 17.1301C4.64458 17.3094 4.90232 17.3859 5.15042 17.3336L8.63507 16.5985C9.06184 16.5085 9.45324 16.2964 9.76165 15.988L18.0633 7.68631C18.942 6.80763 18.942 5.38301 18.0633 4.50433L17.0911 3.53206ZM14.9697 4.59272C15.2626 4.29982 15.7375 4.29982 16.0304 4.59272L17.0027 5.56499C17.2956 5.85788 17.2956 6.33276 17.0027 6.62565L16.1043 7.52402L14.0714 5.49109L14.9697 4.59272ZM13.0107 6.55175L6.66806 12.8944C6.56526 12.9972 6.49455 13.1277 6.46454 13.2699L5.96704 15.6283L8.32547 15.1308C8.46772 15.1008 8.59819 15.0301 8.70099 14.9273L15.0436 8.58468L13.0107 6.55175Z" fill=""></path></svg>
                {$_L['Edit']}
            </a>
        </div>
    </div>

    <div class="card-box">
        <h2>Personal Information</h2>

        <div class="card-grid mb-4">
            <div class="card-row">
                <span class="key">Full name</span>
                <span class="value">{$d['account']}</span>
            </div>

            {if ($d['company']) neq ''}
            <div class="card-row">
                <span class="key">Company Name</span>
                <span class="value">{$d['company']}</span>
            </div>
            {/if}

            <div class="card-row">
                <span class="key">Email address</span>
                <a class="value" href="mailto:{$d['email']}">{$d['email']}</a>
            </div>

            <div class="card-row">
                <span class="key">Phone</span>
                <span class="value" style="display:flex;align-items:center;gap:8px;">
                    <a href="tel:{$d['phone']}">{$d['phone']}</a>
                    {if ($d['phone']|trim) neq ''}
                        {assign var=wa_number value=$d['phone']|regex_replace:'/[^0-9]/':''}
                        <a class="btn btn-success btn-sm" href="https://wa.me/{$wa_number}" target="_blank" rel="noopener" title="WhatsApp">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="#ffffff" width="16" height="16" viewBox="0 0 32 32" version="1.1">
                            <title>whatsapp</title>
                            <path d="M26.576 5.363c-2.69-2.69-6.406-4.354-10.511-4.354-8.209 0-14.865 6.655-14.865 14.865 0 2.732 0.737 5.291 2.022 7.491l-0.038-0.070-2.109 7.702 7.879-2.067c2.051 1.139 4.498 1.809 7.102 1.809h0.006c8.209-0.003 14.862-6.659 14.862-14.868 0-4.103-1.662-7.817-4.349-10.507l0 0zM16.062 28.228h-0.005c-0 0-0.001 0-0.001 0-2.319 0-4.489-0.64-6.342-1.753l0.056 0.031-0.451-0.267-4.675 1.227 1.247-4.559-0.294-0.467c-1.185-1.862-1.889-4.131-1.889-6.565 0-6.822 5.531-12.353 12.353-12.353s12.353 5.531 12.353 12.353c0 6.822-5.53 12.353-12.353 12.353h-0zM22.838 18.977c-0.371-0.186-2.197-1.083-2.537-1.208-0.341-0.124-0.589-0.185-0.837 0.187-0.246 0.371-0.958 1.207-1.175 1.455-0.216 0.249-0.434 0.279-0.805 0.094-1.15-0.466-2.138-1.087-2.997-1.852l0.010 0.009c-0.799-0.74-1.484-1.587-2.037-2.521l-0.028-0.052c-0.216-0.371-0.023-0.572 0.162-0.757 0.167-0.166 0.372-0.434 0.557-0.65 0.146-0.179 0.271-0.384 0.366-0.604l0.006-0.017c0.043-0.087 0.068-0.188 0.068-0.296 0-0.131-0.037-0.253-0.101-0.357l0.002 0.003c-0.094-0.186-0.836-2.014-1.145-2.758-0.302-0.724-0.609-0.625-0.836-0.637-0.216-0.010-0.464-0.012-0.712-0.012-0.395 0.010-0.746 0.188-0.988 0.463l-0.001 0.002c-0.802 0.761-1.3 1.834-1.3 3.023 0 0.026 0 0.053 0.001 0.079l-0-0.004c0.131 1.467 0.681 2.784 1.527 3.857l-0.012-0.015c1.604 2.379 3.742 4.282 6.251 5.564l0.094 0.043c0.548 0.248 1.25 0.513 1.968 0.74l0.149 0.041c0.442 0.14 0.951 0.221 1.479 0.221 0.303 0 0.601-0.027 0.889-0.078l-0.031 0.004c1.069-0.223 1.956-0.868 2.497-1.749l0.009-0.017c0.165-0.366 0.261-0.793 0.261-1.242 0-0.185-0.016-0.366-0.047-0.542l0.003 0.019c-0.092-0.155-0.34-0.247-0.712-0.434z"/>
                        </svg>
                        </a>
                    {/if}
                </span>
            </div>

            {if $config['fax_field'] eq '1'}
                <div class="card-row">
                    <span class="key">{$_L['Fax']}</span>
                    <span class="value">{if ($d['fax']) neq ''} {$d['fax']} {else} N/A {/if}</span>
                </div>
            {/if}

            <div class="card-row">
                <span class="key">Address</span>
                <span class="value">{$d['address']}</span>
            </div>
        </div>

        <!--<h2>Address</h2>-->

        <div class="card-grid">
            <div class="card-row">
                <span class="key">Country</span>
                <span class="value">{$d['country']}</span>
            </div>

            <div class="card-row">
                <span class="key">City/State</span>
                <span class="value">{$d['city']}</span>
            </div>

            <div class="card-row">
                <span class="key">State/Region</span>
                <span class="value">{$d['state']}</span>
            </div>

            <div class="card-row">
                <span class="key">ZIP/Postal Code</span>
                <span class="value">{$d['zip']}</span>
            </div>

        </div>

        
        <hr>
        <h3 class="h5">Companies</h3>

        <div class="table-container">
                
            <table>
                <thead>
                    <tr>
                        <th colspan="2">Company Name</th>
                    </tr>
                </thead>
                <tbody>
                    {if $companies|@count gt 0}
                        {foreach $companies as $company}
                        <tr>
                            <td>
                                <span class="company" style="font-size: 13px;">{$company['company_name']}</span>
                            </td>
                        </tr>
                        {/foreach}
                    {else}
                        <tr>
                            <td colspan="2">No linked companies.</td>
                        </tr>
                    {/if}
                </tbody>
            </table>

        </div>

    </div>


    <div class="card-box">
        <h2>Group Information</h2>

        <div class="card-grid">
            <div class="card-row">
                <span class="key">Group</span>
                <span class="value">{if ($d['gname']) neq ''} {$d['gname']} {else} N/A {/if}</span>
            </div>

            <div class="card-row">
                <span class="key">Code</span>
                <span class="value">{if ($d['code']) neq ''} {$d['code']} {else} N/A {/if}</span>
            </div>

            <div class="card-row">
                <span class="key">Tags</span>
                <span class="value">{if ($d['tags']) neq ''} {$d['tags']} {else} N/A {/if}</span>
            </div>

            <div class="card-row">
                <span class="key">Owner</span>
                <span class="value">{if isset($staffs[$d->o])}
                    {$staffs[$d->o]->fullname}
                {/if}</span>
            </div>

            <div class="card-row">
                <span class="key">{$_L['Primary Contact']}?</span>
                <label class="switch s-icons s-outline s-outline-primary">
                    <input type="checkbox" id="is_primary_contact" {if $d['is_primary_contact'] eq '1'}checked{/if}>
                    <span class="slider round"></span>
                </label>
            </div>

        </div>
    </div>


    <input type="hidden" id="cid" value="{$cid}">


    {if $config['client_dashboard'] eq '1'}
        <hr>
        <h3>Auto Login</h3>
        <div class="card-box">
            <div class="card-top">
                <svg class="icon-svg" xmlns="http://www.w3.org/2000/svg" width="24" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="#000000" class="size-6">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M15.75 5.25a3 3 0 0 1 3 3m3 0a6 6 0 0 1-7.029 5.912c-.563-.097-1.159.026-1.563.43L10.5 17.25H8.25v2.25H6v2.25H2.25v-2.818c0-.597.237-1.17.659-1.591l6.499-6.499c.404-.404.527-1 .43-1.563A6 6 0 1 1 21.75 8.25Z" />
                </svg>
            </div>
            
            {if $d->autologin neq ''}
                <form class="form-horizontal" method="post">
                    <div class="mb-3">
                        <div class="col-xs-12">
                            <div class="mb-3 h5">
                                <label for="auto_login_url">{$_L['Auto Login URL']}</label>
                                <input class="form-control" type="text" id="auto_login_url" name="auto_login_url" value="{$_url}client/autologin/{$d->autologin}">
                            </div>
                            
                            <div class="btn-group">
                                <a class="btn btn-primary" href="{$_url}client/autologin/{$d->autologin}" target="_blank">{$_L['Login As Customer']}</a>
                                <a class="btn" href="{$_url}contacts/revoke_auto_login/{$d->id}/">{$_L['Revoke Auto Login']}</a>
                                <a class="btn" href="{$_url}contacts/gen_auto_login/{$d->id}/">{$_L['Re Generate URL']}</a>
                            </div>
                        </div>
                    </div>
                </form>
                {$extra_html_1}
            {else}
                <a href="{$_url}contacts/gen_auto_login/{$d->id}/" class="button"> {$_L['Create Auto Login URL']}</a>
            {/if}
        </div>

    {/if}

    {if $config.add_fund eq '1' or $config.accounting eq '1'}
    <hr>
    <h3>Finance</h3>
    {/if}

    {if $config['add_fund'] eq '1'}
    <div class="card-box">

        <div class="card-top">
            <svg class="icon-svg" width="25" height="24" viewBox="0 0 25 24" xmlns="http://www.w3.org/2000/svg">
                <path fill-rule="evenodd" clip-rule="evenodd" d="M13.4164 2.79175C13.4164 2.37753 13.0806 2.04175 12.6664 2.04175C12.2522 2.04175 11.9164 2.37753 11.9164 2.79175V4.39876C9.94768 4.67329 8.43237 6.36366 8.43237 8.40795C8.43237 10.0954 9.47908 11.6058 11.0591 12.1984L13.7474 13.2066C14.7419 13.5795 15.4008 14.5303 15.4008 15.5925C15.4008 16.9998 14.2599 18.1407 12.8526 18.1407H11.7957C10.7666 18.1407 9.93237 17.3064 9.93237 16.2773C9.93237 15.8631 9.59659 15.5273 9.18237 15.5273C8.76816 15.5273 8.43237 15.8631 8.43237 16.2773C8.43237 18.1348 9.9382 19.6407 11.7957 19.6407H11.9164V21.2083C11.9164 21.6225 12.2522 21.9583 12.6664 21.9583C13.0806 21.9583 13.4164 21.6225 13.4164 21.2083V19.6017C15.3853 19.3274 16.9008 17.6369 16.9008 15.5925C16.9008 13.905 15.8541 12.3946 14.2741 11.8021L11.5858 10.7939C10.5912 10.4209 9.93237 9.47013 9.93237 8.40795C9.93237 7.00063 11.0732 5.85976 12.4806 5.85976H13.5374C14.5665 5.85976 15.4008 6.69401 15.4008 7.72311C15.4008 8.13732 15.7366 8.47311 16.1508 8.47311C16.565 8.47311 16.9008 8.13732 16.9008 7.72311C16.9008 5.86558 15.395 4.35976 13.5374 4.35976H13.4164V2.79175Z"/>
            </svg>
        </div>
        
        <div class="card-content">
            <p class="title">{$_L['Balance']}</p>
        </div>
        
        <div class="card-end">
            <div>
                <h4 class="value">
                    <span class="amount">{$d->balance}</span>
                </h4>
            </div>

            <div>
                <div class="btn-group">
                    <a href="javascript:void(0)" class="btn btn-primary add_fund">
                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20" fill="currentColor">
						    <path d="M5 10.0002H15.0006M10.0002 5V15.0006" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
						</svg>{$_L['Add Fund']}
                    </a>
                    <a href="javascript:void(0)" class="btn return_fund">{$_L['Return Fund']}</a>
                </div>
            </div>
        </div>
    </div>
    {/if}


    {if $config['accounting'] eq '1'}
    <div class="invoice-total">

        <div class="table-container">
        
            <table>
                <thead>
                    <tr>
                        <th colspan="2">{$_L['Accounting Summary']}</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>
                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M7.60141 2.33683C7.73885 2.18084 7.9401 2.08243 8.16435 2.08243C8.16475 2.08243 8.16516 2.08243 8.16556 2.08243C8.35773 2.08219 8.54998 2.15535 8.69664 2.30191L12.6968 6.29924C12.9898 6.59203 12.9899 7.0669 12.6971 7.3599C12.4044 7.6529 11.9295 7.65306 11.6365 7.36027L8.91435 4.64004L8.91435 13.5C8.91435 13.9142 8.57856 14.25 8.16435 14.25C7.75013 14.25 7.41435 13.9142 7.41435 13.5L7.41435 4.64442L4.69679 7.36025C4.4038 7.65305 3.92893 7.6529 3.63613 7.35992C3.34333 7.06693 3.34348 6.59206 3.63646 6.29926L7.60141 2.33683Z" fill="#039855"></path>
                            </svg> {$_L['Total Income']}</td>
                        <td>
                            <span class="amount" data-a-dec="{$config['dec_point']}" data-a-sep="{$config['thousands_sep']}" data-a-pad="{$config['currency_decimal_digits']}" data-p-sign="{$config['currency_symbol_position']}" data-a-sign="{$config['currency_code']} " data-d-group="{$config['thousand_separator_placement']}">{$ti}</span>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M7.26816 13.6632C7.4056 13.8192 7.60686 13.9176 7.8311 13.9176C7.83148 13.9176 7.83187 13.9176 7.83226 13.9176C8.02445 13.9178 8.21671 13.8447 8.36339 13.6981L12.3635 9.70076C12.6565 9.40797 12.6567 8.9331 12.3639 8.6401C12.0711 8.34711 11.5962 8.34694 11.3032 8.63973L8.5811 11.36L8.5811 2.5C8.5811 2.08579 8.24531 1.75 7.8311 1.75C7.41688 1.75 7.0811 2.08579 7.0811 2.5L7.0811 11.3556L4.36354 8.63975C4.07055 8.34695 3.59568 8.3471 3.30288 8.64009C3.01008 8.93307 3.01023 9.40794 3.30321 9.70075L7.26816 13.6632Z" fill="#D92D20"></path>
                            </svg> {$_L['Total Expense']}
                        </td>
                        <td>
                            <span class="amount" data-a-dec="{$config['dec_point']}" data-a-sep="{$config['thousands_sep']}" data-a-pad="{$config['currency_decimal_digits']}" data-p-sign="{$config['currency_symbol_position']}" data-a-sign="{$config['currency_code']} " data-d-group="{$config['thousand_separator_placement']}">{$te}</span>
                        </td>
                    </tr>
                </tbody>
                <tfoot>
                    <tr>
                        <td><strong>{$happened}</strong></td>
                        <td>
                            <strong>
                                <span class="amount" data-a-dec="{$config['dec_point']}" data-a-sep="{$config['thousands_sep']}" data-a-pad="{$config['currency_decimal_digits']}" data-p-sign="{$config['currency_symbol_position']}" data-a-sign="{$config['currency_code']}" data-d-group="{$config['thousand_separator_placement']}">{$d_amount}</span>
                            </strong>
                        </td>
                    </tr>
                </tfoot>
            </table>

        </div>

    </div>
    {/if}

</div>
