{extends file="$layouts_admin"}

{block name="content"}

    <div class="row">
        <div class="col-md-12">
            <div class="panel">
                <div class="panel-hdr">
                    <h2>{{__('Files uploaded by Customers')}}</h2>
                </div>
                <div class="panel-container">
                    <div class="panel-content">
                        <form class="form-horizontal" method="post" action="">
                            <div class="mb-3 mb-4">
                                <div class="input-group">
                                    <input type="text" name="name" id="foo_filter" class="form-control" placeholder="{$_L['Search']}..."/>

                                </div>
                            </div>
                        </form>

                        {if $files->count() > 0}
                        <div class="files-panel">

                            <div class="files-grid">
                                {foreach $files as $file}
                                <div class="file-item">

                                    <div class="file-icon">
                                        <a href="{$_url}client/dl/{$file->id}_{$file->file_dl_token}/">
                                            {if $file->file_mime_type eq 'jpg' || $file->file_mime_type eq 'png' || $file->file_mime_type eq 'gif'}
                                                <i class="fal fa-file-image"></i>
                                            {elseif $file->file_mime_type eq 'pdf'}
                                                <i class="fal fa-file-pdf"></i>
                                            {elseif $file->file_mime_type eq 'zip'}
                                                <i class="fal fa-file-archive"></i>
                                            {else}
                                                <i class="fal fa-file"></i>
                                            {/if}
                                        </a>
                                    </div>

                                    <div class="file-info">
                                        <a class="file-title" href="{$_url}client/dl/{$file->id}_{$file->file_dl_token}/">
                                            {$file->title}
                                        </a>

                                        <div class="file-meta">
                                            {if isset($contacts[$file->cid][0]['account'])}
                                                <span class="file-customer">
                                                    {$_L['Customer']}: 
                                                    <a href="{$_url}contacts/view/{$file->cid}">{$contacts[$file->cid][0]['account']}</a>
                                                </span>
                                                <span class="meta-sep">•</span>
                                            {/if}

                                            <span class="file-date">
                                                {$_L['Uploaded at']}: {date( $config['df'], strtotime($file->created_at))}
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                {/foreach}
                            </div>

                        </div>
                        {else}
                        <div class="files-panel empty">
                            <span>{$_L['No Data Available']}</span>
                        </div>
                        {/if}


                    </div>

                </div>
            </div>
        </div>

    </div>

{/block}

{block name=script}

{/block}
