{extends file="$layouts_admin"}
{block name="content"}

<div class="panel">
    <div class="panel-hdr">
        <h2>{$_L['Groups']}</h2>
        <div class="panel-toolbar">
            <div class="btn-group">
                <a href="#" class="btn btn-primary" id="add_new_group"><i class="fal fa-plus"></i> {$_L['Add New Group']}</a>
                <a href="{$_url}reorder/groups/" class="btn"><i class="fal fa-download"></i> {$_L['Reorder']}</a>
            </div>
        </div>
    </div>
    <div class="panel-container">
        <div class="panel-content">

            <div class="table-container">
                <table>
                    <thead>
                        <tr>
                            <th>{__('Group Name')}</th>
                            <th>{__('Customers')}</th>
                            <th>{$_L['Manage']}</th>
                        </tr>
                    </thead>
                    <tbody>
                        {foreach $gs as $g}
                            <tr>
                                <td>{$g['gname']}</td>
                                <td>{Contact::where('gid',$g['id'])->count()}</td>
                                <td>
                                    <div class="float-end d-flex">
                                        <a href="{$_url}contacts/find_by_group/{$g['id']}/" class="btn btn-icon me-2" title="List">
                                            <svg class="fill-current" width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M8.0254 6.17845C8.0254 4.90629 9.05669 3.875 10.3289 3.875C11.601 3.875 12.6323 4.90629 12.6323 6.17845C12.6323 7.45061 11.601 8.48191 10.3289 8.48191C9.05669 8.48191 8.0254 7.45061 8.0254 6.17845ZM10.3289 2.375C8.22827 2.375 6.5254 4.07786 6.5254 6.17845C6.5254 8.27904 8.22827 9.98191 10.3289 9.98191C12.4294 9.98191 14.1323 8.27904 14.1323 6.17845C14.1323 4.07786 12.4294 2.375 10.3289 2.375ZM8.92286 11.03C5.7669 11.03 3.2085 13.5884 3.2085 16.7444V17.0333C3.2085 17.4475 3.54428 17.7833 3.9585 17.7833C4.37271 17.7833 4.7085 17.4475 4.7085 17.0333V16.7444C4.7085 14.4169 6.59533 12.53 8.92286 12.53H11.736C14.0635 12.53 15.9504 14.4169 15.9504 16.7444V17.0333C15.9504 17.4475 16.2861 17.7833 16.7004 17.7833C17.1146 17.7833 17.4504 17.4475 17.4504 17.0333V16.7444C17.4504 13.5884 14.8919 11.03 11.736 11.03H8.92286Z" fill=""></path></svg>
                                        </a>
                                        <a id="e{$g['id']}" href="#" class="btn btn-icon me-2 edit_group" title="Edit">
                                            <svg class="fill-current" width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M17.0911 3.53206C16.2124 2.65338 14.7878 2.65338 13.9091 3.53206L5.6074 11.8337C5.29899 12.1421 5.08687 12.5335 4.99684 12.9603L4.26177 16.445C4.20943 16.6931 4.286 16.9508 4.46529 17.1301C4.64458 17.3094 4.90232 17.3859 5.15042 17.3336L8.63507 16.5985C9.06184 16.5085 9.45324 16.2964 9.76165 15.988L18.0633 7.68631C18.942 6.80763 18.942 5.38301 18.0633 4.50433L17.0911 3.53206ZM14.9697 4.59272C15.2626 4.29982 15.7375 4.29982 16.0304 4.59272L17.0027 5.56499C17.2956 5.85788 17.2956 6.33276 17.0027 6.62565L16.1043 7.52402L14.0714 5.49109L14.9697 4.59272ZM13.0107 6.55175L6.66806 12.8944C6.56526 12.9972 6.49455 13.1277 6.46454 13.2699L5.96704 15.6283L8.32547 15.1308C8.46772 15.1008 8.59819 15.0301 8.70099 14.9273L15.0436 8.58468L13.0107 6.55175Z" fill=""></path></svg>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        {/foreach}
                    </tbody>
                </table>
            </div>

        </div>
    </div>
</div>

<input type="hidden" name="_msg_add_new_group" id="_msg_add_new_group" value="{$_L['Add New Group']}">
<input type="hidden" name="_msg_group_name" id="_msg_group_name" value="{$_L['Group Name']}">
<input type="hidden" name="_msg_edit" id="_msg_edit" value="{$_L['Edit']}">
<input type="hidden" name="_msg_ok" id="_msg_ok" value="{$_L['OK']}">
<input type="hidden" name="_msg_cancel" id="_msg_cancel" value="{$_L['Cancel']}">
{/block}

{block name="script"}

<script>
$(document).ready(function () {
    var _url = $("#_url").val();

    $("#add_new_group").click(function(e){
        e.preventDefault();

        (async () => {

            const { value: group_name } = await Swal.fire({
                title: '{$_L['Add New Group']}',
                input: 'text',
                inputLabel: '{$_L['Group Name']}',
                inputPlaceholder: '{$_L['Group Name']}',
            })

            if (group_name) {
                $.post(  _url + "contacts/add_group/", { group_name: group_name })
                    .done(function( data ) {

                        if ($.isNumeric(data)) {

                            location.reload();

                        }

                        else {
                            Swal.fire({
                                title: '{__('Error')}',
                                text: data,
                                type: 'error',
                                confirmButtonText: '{$_L['Close']}'
                            })
                        }

                    });
            }

        })()
    });


    $(".cdelete").click(function (e) {
        e.preventDefault();
        var id = this.id;
        app.confirm(_L['are_you_sure'], function(result) {
            if(result){
                var _url = $("#_url").val();
                window.location.href = _url + "delete/crm-group/" + id;
            }
        });
    });


    $(".edit_group").click(function (e) {
        e.preventDefault();
        var eid = this.id;
        var gname = $( this ).attr( "data-name" );

        (async () => {
            const { value: group_name } = await Swal.fire({
                title: '{$_L['Edit']}',
                input: 'text',
                inputLabel: '{$_L['Group Name']}',
                inputPlaceholder: '{$_L['Group Name']}',
                inputValue: gname,
            })

            if (group_name) {
                $.post(  _url + "contacts/group_edit/", { id: eid, gname: group_name })
                    .done(function( data ) {
                        location.reload();
                    });
            }
        })()

    });
});
</script>
{/block}