{extends file="$layouts_admin"}

{block name="head"}
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
{/block}

{block name="content"}
    <div class="row">

        <input type="text" hidden disabled name="url_api" id="url_api" value="{$_url}">

        <div class="overview-header">

            <div class="title">
                <h1>Overview</h1>
            </div>

            <div class="datepicker-cta">
                <div class="range-toggle" role="group" aria-label="Date range preset">
                    <button type="button" class="range-btn is-active" data-range="weekly">Weekly</button>
                    <button type="button" class="range-btn" data-range="monthly">Monthly</button>
                    <button type="button" class="range-btn" data-range="yearly">Yearly</button>
                </div>

                <button type="button" class="date-display" aria-label="Open date range picker">
                    <span class="icon" aria-hidden="true">
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.6" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M8 7V4m8 3V4m-9 7h10M5 20h14a1 1 0 001-1V7a1 1 0 00-1-1H5a1 1 0 00-1 1v12a1 1 0 001 1z" />
                        </svg>
                    </span>
                    <span class="date-display-text">Select range</span>
                </button>
                <input type="text" id="dashboard-date-range" class="date-range-input" aria-hidden="true" />
            </div>

        </div>

        {if $user->roleid == "3"}
        <div class="col-lg-12">
            <div class="panel">
                <div class="panel-hdr">
                    <h2 class="fw-bolder">Invoices</h2>
                </div>

                <div class="panel-container show">
                    <div class="panel-content">
                        <div class="table-responsive">

                            <div class="table-data-content">
                                <div class="skeleton-wrapper" id="invoices-skeleton">
                                    {section name=i loop=15}
                                        <div class="skeleton-row">
                                            <div class="skeleton-line sm"></div>
                                            <div class="skeleton-line"></div>
                                            <div class="skeleton-line sm"></div>
                                            <div class="skeleton-line"></div>
                                            <div class="skeleton-line sm"></div>
                                            <div class="skeleton-line sm"></div>
                                            <div class="skeleton-line sm"></div>
                                        </div>
                                    {/section}
                                </div>

                                <table id="crm_table_records">
                                    <thead>
                                        <tr>
                                            <th class="h6">#</th>
                                            <th class="h6">{$_L['Account']}</th>
                                            <th class="h6">{$_L['Amount']}</th>
                                            <th class="h6">{$_L['Title']}</th>
                                            <th class="h6">{$_L['Invoice Date']}</th>
                                            <th class="h6">{$_L['Due Date']}</th>
                                            <th class="h6">{$_L['Status']}</th>
                                        </tr>
                                    </thead>
                                    {$total=0}
                                    {$mon=''}                                    
								    <tbody class="invoices_tabla"></tbody>
                                    <tfoot>
                                        <tr>
                                            <th></th>
                                            <th></th>
                                            <th colspan="5" class="h6 total_invoices_tabla" style="text-align: left;">{formatCurrency($total,$mon)}</th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>

                            <div id="invoice_stats"></div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        {/if}


        <div class="col-lg-12">
            <div id="panel-11" class="panel border-0">
                <div class="panel-hdr">
                    <h2 class="fw-bolder">
                        Appointments
                    </h2>
                </div>
                <div class="panel-container show p-5 calendar-container">
                    <div id="dashboard-calendar"></div>
                </div>
            </div>
        </div>

    </div>
{/block}



{block name="script"}
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script>

    var API_URL = $("#url_api").val().split("?ng")[0];

    window.crmDataTableConfig = {
        baseUrl: "{$_url}",
        ajaxUrl: "",
        tableSelector: "#crm_table_records",
        buttons: false,
        lengthMenu: [[10, 25, 50, 100], [10, 25, 50, 100]],
        pageLength: 10,
        paths: {
            view: "{$_url}contacts/view/[[id]]",
            groupList: "{$_url}contacts/list/customer/"
        },
        translations: {
            noItems: "{$_L['No items to display']}",
            showing: "{$_L['Showing _START_ to _END_ of _TOTAL_ entries']}",
            searchPlaceholder: "{__('Search')}"
        },
        responsiveControl: false,
        columns: [
            { data: 'invoicenum' },
            { data: 'account' },
            { data: 'amount' },
            { data: 'title' },
            { data: 'date' },
            { data: 'duedate' },
            { data: 'status' }
        ],
        onInitComplete: function(dt) {
            //console.log("Tabla inicializada", dt);
        }
    };

    $(function () {
        var currentRange = 'weekly';
        var currentStart = null;
        var currentEnd = null;
        var baseUrl = window.base_url || $('#url_api').val() || '';
        var chartInstances = {
            paymentMethods: null,
            topServices: null,
            incomeVsExp: null,
            staffSales: null
        };
        var dateDisplayBtn = document.querySelector('.date-display');
        var dateDisplayText = document.querySelector('.date-display-text');
        var dateRangeInput = document.querySelector('#dashboard-date-range');
        var rangePicker;

        var formatDateLabel = function (date) {
            if (!(date instanceof Date)) { return ''; }
            try {
                return date.toLocaleDateString('en-US', { month: 'short', day: 'numeric', year: 'numeric' });
            } catch (e) {
                return '';
            }
        };

        var setRangeLabel = function (dates) {
            if (!dateDisplayText) { return; }
            if (!dates || !dates.length) {
                dateDisplayText.textContent = 'Select range';
                return;
            }
            if (dates.length === 1) {
                dateDisplayText.textContent = formatDateLabel(dates[0]);
                return;
            }
            dateDisplayText.textContent = formatDateLabel(dates[0]) + ' - ' + formatDateLabel(dates[1]);
        };

        var formatIso = function(date) {
            if (!(date instanceof Date)) { return ''; }
            var y = date.getFullYear();
            var m = String(date.getMonth() + 1).padStart(2, '0');
            var d = String(date.getDate()).padStart(2, '0');
            return y + '-' + m + '-' + d;
        };

        var computeRangeDates = function(range) {
            var today = new Date();
            var start = new Date(today);
            var end = new Date(today);

            switch (range) {
                case 'weekly':
                    var day = today.getDay(); // 0 = Sunday, 1 = Monday
                    var diffToMonday = (day === 0 ? 6 : day - 1);
                    start.setDate(today.getDate() - diffToMonday);
                    var diffToSunday = (day === 0 ? 0 : 7 - day);
                    end.setDate(today.getDate() + diffToSunday);
                    break;
                case 'monthly':
                    start = new Date(today.getFullYear(), today.getMonth(), 1);
                    end = new Date(today.getFullYear(), today.getMonth() + 1, 0);
                    break;
                case 'yearly':
                    start = new Date(today.getFullYear(), 0, 1);
                    end = new Date(today.getFullYear(), 11, 31);
                    break;
                case 'custom':
                    if (currentStart) {
                        start = new Date(currentStart);
                        end = new Date(currentEnd || currentStart);
                    }
                    break;
                default:
                    break;
            }

            return { start: start, end: end };
        };

        var initRangePicker = function () {
            if (typeof flatpickr === 'undefined' || !dateRangeInput) { return; }

            var endDate = new Date();
            var startDate = new Date(endDate);
            // Lunes de la semana actual
            var day = startDate.getDay(); // 0 domingo, 1 lunes
            var diffToMonday = (day === 0 ? 6 : day - 1);
            startDate.setDate(startDate.getDate() - diffToMonday);

            rangePicker = flatpickr(dateRangeInput, {
                mode: 'range',
                defaultDate: [startDate, endDate],
                dateFormat: 'M j, Y',
                onReady: function (selectedDates) { setRangeLabel(selectedDates); },
                onChange: function (selectedDates) {
                    setRangeLabel(selectedDates);
                    if (selectedDates.length === 2) {
                        currentRange = 'custom';
                        currentStart = selectedDates[0];
                        currentEnd = selectedDates[1];
                        loadDashboard();
                    }
                }
            });

            if (dateDisplayBtn) {
                dateDisplayBtn.addEventListener('click', function () {
                    rangePicker.open();
                });
            }

            setRangeLabel([startDate, endDate]);
        };

        initRangePicker();

        var buildParams = function() {
            var params = { range: currentRange };
            if (currentRange === 'custom' && currentStart) {
                var startIso = currentStart.toISOString().slice(0,10);
                var endIso = (currentEnd || currentStart).toISOString().slice(0,10);
                params.start_date = startIso;
                params.end_date = endIso;
            }
            return params;
        };


        

        var loadDashboard = function() {
            var params = buildParams();
            var rangeDates = (currentRange === 'custom' && currentStart) ? { start: new Date(currentStart), end: new Date(currentEnd || currentStart) } : computeRangeDates(currentRange);
            var startDate = rangeDates.start;
            var endDate = rangeDates.end;

            var payload = {
                startDate: formatIso(startDate),
                endDate: formatIso(endDate)
            };

            setRangeLabel([startDate, endDate]);

            if (rangePicker && currentRange !== 'custom' && startDate && endDate) {
                rangePicker.setDate([startDate, endDate], true);
            }

            const showSkeleton = function() {
                $('#invoices-skeleton').show();
                $('#crm_table_records_wrapper, #crm_table_records').hide();
            };
            const hideSkeleton = function() {
                $('#invoices-skeleton').hide();
                $('#crm_table_records_wrapper, #crm_table_records').show();
            };

            showSkeleton();

            $.ajax({
                url: API_URL + 'api/dashboard/user/data',
                method: 'POST',
                data: JSON.stringify(payload),
                contentType: 'application/json',
                success: function (data) {
                    try {
                        const info = typeof data === 'string' ? JSON.parse(data) : data;

                        if (info.type === "success") {
                            const invoices = Array.isArray(info.invoices) ? info.invoices : [];

                            const rows = invoices.map(function (inv) {
                                const statusText = inv.status_label || inv.status || '';
                                const statusBadge = inv.status === 'Unpaid'
                                    ? '<span class="badge badge-outline badge-outline-danger">' + statusText + '</span>'
                                    : '<span class="badge badge-outline badge-outline-success">' + statusText + '</span>';

                                return {
                                    invoicenum: '<a href="' + inv.invoice_url + '" class="text-success"><strong>' + (inv.invoice_number || '') + '</strong></a>',
                                    account: '<strong>' + (inv.account || '') + '</strong>',
                                    amount: inv.credit_formatted || inv.credit || '',
                                    title: inv.title || '',
                                    date: inv.date_formatted || '--',
                                    duedate: inv.duedate_formatted || '--',
                                status: statusBadge
                            };
                        });

                        if (invoices.length === 0) {
                            $('.total_invoices_tabla').hide();
                        } else {
                            $('.total_invoices_tabla').show();
                        }

                        if (!window.wp_table && $.fn.DataTable) {
                            window.wp_table = $(window.crmDataTableConfig.tableSelector || '#crm_table_records').DataTable();
                        }

                        if (window.wp_table) {
                            window.wp_table.clear();
                            window.wp_table.rows.add(rows).draw();
                            if (window.wp_table.columns && window.wp_table.responsive) {
                                window.wp_table.columns.adjust().responsive.recalc();
                            }
                        } else {
                            $('.invoices_tabla').html('');
                        }

                            $('.total_invoices_tabla').html(info.total_invoices);
                            hideSkeleton();
                        } else {
                            toastr.error(info.message || 'Error');
                            hideSkeleton();
                        }
                    } catch (error) {
                        toastr.error('Error parsing response');
                        hideSkeleton();
                    }
                },
                error: function () {
                    toastr.error('Error loading invoices');
                    hideSkeleton();
                }
            });

        };

        var setActiveRangeButton = function(range) {
            var buttons = document.querySelectorAll('.range-btn');
            buttons.forEach(function(btn) {
                var val = (btn.dataset.range || '').toLowerCase();
                var match = val === range;
                if (match) { btn.classList.add('is-active'); }
                else { btn.classList.remove('is-active'); }
            });
        };

        // Botones de rango
        var rangeButtons = document.querySelectorAll('.range-btn');
        rangeButtons.forEach(function(btn) {
            btn.addEventListener('click', function() {
                var val = (btn.dataset.range || '').toLowerCase();
                currentRange = val || 'weekly';
                currentStart = null;
                currentEnd = null;
                setActiveRangeButton(currentRange);
                var computed = computeRangeDates(currentRange);
                setRangeLabel([computed.start, computed.end]);
                if (rangePicker && computed.start && computed.end) {
                    rangePicker.setDate([computed.start, computed.end], true);
                }
                loadDashboard();
            });
        });

        // Carga inicial
        setActiveRangeButton(currentRange);
        loadDashboard();

    });


    function strTrunc(str, length) {
        return str.length > length ? str.substring(0, length) + '...' : str;
    }

    function displayEvent(event_id=0,date=0) {
        $.fancybox.open({
            src  :  base_url + 'dashboard/modal-calendar/'+event_id+'/'+date,
            type : 'ajax',
            opts : {
                afterShow : function( instance, current ) {
                    // $('[data-toggle="datepicker"]').datepicker();
                    // $start_time.timepicker();
                    // $end_time.timepicker();

                    $('#start').datepicker();
                    $('#start_time').timepicker();
                    $('#end').datepicker();

                    let eventForm = $('#eventForm');
                    eventForm.on('submit',function (e) {
                        e.preventDefault();
                        $.post( base_url + "calendar/save_event/", eventForm.serialize())
                            .done(function( data ) {



                                if ($.isNumeric(data)) {

                                    location.reload();

                                }

                                else {
                                    toastr.error(data);
                                }

                            });


                        return false;
                    });

                }
            },
        });
    }

    $(function () {

        var calendarEl = document.getElementById('dashboard-calendar');

        var calendar = new FullCalendar.Calendar(calendarEl,
            {
                plugins: ['dayGrid', 'list', 'timeGrid', 'interaction', 'bootstrap'],
                themeSystem: 'bootstrap',
                timeZone: 'UTC',
                //dateAlignment: "month", //week, month
                buttonText:
                    {
                        today: 'today',
                        month: 'month',
                        week: 'week',
                        day: 'day',
                        list: 'list'
                    },
                eventTimeFormat:
                    {
                        hour: 'numeric',
                        minute: '2-digit',
                        meridiem: 'short'
                    },
                navLinks: false,
                header:
                    {
                        left: 'title',
                        center: '',
                        right: 'today prev,next'
                    },
                footer:
                    {
                        left: 'dayGridMonth,timeGridWeek,timeGridDay,listWeek',
                        center: '',
                        right: ''
                    },
                editable: true,
                eventLimit: true, // allow "more" link when too many events
                eventSources: [{
                    url: base_url + 'dashboard/data-calendar/',
                    type: 'GET',
                    error: function() {

                    }
                } ],
                viewSkeletonRender: function()
                {
                    $('.fc-toolbar .btn-default').addClass('btn-sm');
                    $('.fc-header-toolbar h2').addClass('fs-md');
                    $('#dashboard-calendar').addClass('fc-reset-order')
                },

                dateClick: function(info) {
                    displayEvent(0,info.dateStr);
                },
                eventClick: function(info) {
                    displayEvent(info.event.id);
                }


            });

        calendar.render();
    });

</script>
{/block}
