<?php

use GuzzleHttp\Client;

class Dashboard
{
    public static function dataLastTwelveMonthsIncExp_old()
    {
        global $user;

        $all_data = true;
        if (!has_access($user->roleid, 'transactions', 'all_data')) {
            $all_data = false;
        }

        $months = [];

        global $_L;

        for ($i = 1; $i <= 11; $i++) {
            $months[] = date("M Y", strtotime(date('Y-m-01') . " -$i months"));
        }

        $months = array_reverse($months);

        $months[12] = date("M Y", strtotime(date('Y-m-01')));

        $inc = [];
        $exp = [];
        $m = [];

        foreach ($months as $month) {
            $d_array = explode(' ', $month);

            $m_short = '';

            if (isset($d_array['0'])) {
                $m_short = $d_array[0];
            }

            if (isset($_L[$m_short])) {
                $m_short = $_L[$m_short];
            }

            $y = '';
            if (isset($d_array[1])) {
                $y = $d_array[1];
            }

            $m[] = $m_short . ' ' . $y;
        }

        $i = 0;


        foreach ($months as $month) {
            $first_day_this_month = date(
                "Y-m-d",
                strtotime("first day of $month")
            );
            $last_day_this_month = date(
                "Y-m-d",
                strtotime("last day of $month")
            );

            $transactions = new Transaction();

            $transactions = $transactions->where('type', 'Income')
                ->where(function ($query) use ($first_day_this_month, $last_day_this_month) {
                    $query->where('date', '>=', $first_day_this_month)
                        ->where('date', '<=', $last_day_this_month);
                });

            if (!$all_data) {
                $transactions = $transactions->where('aid', $user->id);
            }

            $transactions = $transactions->get();



            $total = 0;

            foreach ($transactions as $transaction) {
                $total += $transaction->amount * $transaction->currency_rate;
            }

            $inc[] = $total;

            $inc[$i] = $inc[$i] == '' ? '0.00' : round($inc[$i]);

            $i++;
        }

        $i = 0;

        foreach ($months as $month) {
            //            $first_day_this_month = date(
            //                "Y-m-d",
            //                strtotime("first day of $month")
            //            );
            //            $last_day_this_month = date(
            //                "Y-m-d",
            //                strtotime("last day of $month")
            //            );
            //
            //            $x = ORM::for_table('sys_transactions')
            //                ->where('type', 'Expense')
            //                ->where_gte('date', $first_day_this_month)
            //                ->where_lte('date', $last_day_this_month);
            //
            //            if (!$all_data) {
            //                $x->where('aid', $user->id);
            //            }
            //
            //            $exp[] = $x->sum('dr');
            //
            //            $exp[$i] = $exp[$i] == '' ? '0.00' : round($exp[$i]);
            //
            //            $i++;

            $first_day_this_month = date(
                "Y-m-d",
                strtotime("first day of $month")
            );
            $last_day_this_month = date(
                "Y-m-d",
                strtotime("last day of $month")
            );

            $transactions = new Transaction();

            $transactions = $transactions->where('type', 'Expense')->where(function ($query) use ($first_day_this_month, $last_day_this_month) {
                $query->where('date', '>=', $first_day_this_month)
                    ->where('date', '<=', $last_day_this_month);
            });

            if (!$all_data) {
                $transactions = $transactions->where('aid', $user->id);
            }

            $transactions = $transactions->get();

            $total = 0;

            foreach ($transactions as $transaction) {
                $total += $transaction->amount * $transaction->currency_rate;
            }

            $exp[] = $total;

            $exp[$i] = $exp[$i] == '' ? '0.00' : round($exp[$i]);

            $i++;
        }

        return [
            'Months' => $m,
            'Income' => $inc,
            'Expense' => $exp,
        ];
    }

    public static function dataLastTwelveMonthsIncExp()
    {
        global $user, $_L;

        $all_data = has_access($user->roleid, 'transactions', 'all_data');

        // Rango de fecha
        $start_date = date('Y-m-01', strtotime('-11 months'));
        $end_date = date('Y-m-t');

        // Base query
        $query = ORM::for_table('sys_transactions')
            ->select_expr("YEAR(date) AS y")
            ->select_expr("MONTH(date) AS m")
            ->select('type')
            ->select_expr("SUM(amount * currency_rate) AS total")
            ->where_gte('date', $start_date)
            ->where_lte('date', $end_date);

        if (!$all_data) {
            $query->where('aid', $user->id);
        }

        $query->group_by_expr('YEAR(date), MONTH(date), type');

        $results = $query->find_array();

        // Inicializar meses
        $months = [];
        $income = [];
        $expense = [];

        for ($i = 11; $i >= 0; $i--) {
            $timestamp = strtotime("-$i months", strtotime(date('Y-m-01')));
            $months_key = date('Y-m', $timestamp);
            $months[] = $_L[date('M', $timestamp)] . ' ' . date('Y', $timestamp);
            $income[$months_key] = '0.00';
            $expense[$months_key] = '0.00';
        }

        // Mapear resultados
        foreach ($results as $row) {
            $key = sprintf('%04d-%02d', $row['y'], $row['m']);
            if ($row['type'] === 'Income') {
                $income[$key] = round((float) $row['total']);
            } elseif ($row['type'] === 'Expense') {
                $expense[$key] = round((float) $row['total']);
            }
        }

        // Formatear respuesta
        $inc_array = [];
        $exp_array = [];

        foreach (array_keys($income) as $k) {
            $inc_array[] = $income[$k];
            $exp_array[] = $expense[$k];
        }

        return [
            'Months' => $months,
            'Income' => $inc_array,
            'Expense' => $exp_array,
        ];
    }


    public static function dataLastTwelveMonthsIncExpByFecha($fecha_inicio)
    {

        $month_start_date = date('Y-m-01', strtotime($fecha_inicio));
        $month_end_date = date('Y-m-t', strtotime($fecha_inicio));

        global $user;

        $all_data = true;
        if (!has_access($user->roleid, 'transactions', 'all_data')) {
            $all_data = false;
        }

        $months = [];

        global $_L;

        for ($i = 1; $i <= 11; $i++) {
            //$months[] = date("M Y", strtotime(date('Y-m-01') . " -$i months"));
            $months[] = date("M Y", strtotime(date('Y-m-01', strtotime($fecha_inicio)) . " -$i months"));
        }

        $months = array_reverse($months);

        $months[12] = date("M Y", strtotime(date('Y-m-01', strtotime($fecha_inicio))));
        //$months[12] = date("M Y", strtotime(date('Y-m-01')));

        $inc = [];
        $exp = [];
        $m = [];

        foreach ($months as $month) {
            $d_array = explode(' ', $month);

            $m_short = '';

            if (isset($d_array['0'])) {
                $m_short = $d_array[0];
            }

            if (isset($_L[$m_short])) {
                $m_short = $_L[$m_short];
            }

            $y = '';
            if (isset($d_array[1])) {
                $y = $d_array[1];
            }

            $m[] = $m_short . ' ' . $y;
        }

        $i = 0;

        foreach ($months as $month) {
            $first_day_this_month = date(
                "Y-m-d",
                strtotime("first day of $month")
            );
            $last_day_this_month = date(
                "Y-m-d",
                strtotime("last day of $month")
            );

            $total = 0;

            if (true)
            //if((strtotime($first_day_this_month) == strtotime($month_start_date)) && (strtotime($last_day_this_month) == strtotime($month_end_date)) )
            {
                $transactions = new Transaction();

                $transactions = $transactions->where('type', 'Income')
                    ->where(function ($query) use ($first_day_this_month, $last_day_this_month) {
                        $query->where('date', '>=', $first_day_this_month)
                            ->where('date', '<=', $last_day_this_month);
                    });

                if (!$all_data) {
                    $transactions = $transactions->where('aid', $user->id);
                }

                $transactions = $transactions->get();

                foreach ($transactions as $transaction) {
                    $total += $transaction->amount * $transaction->currency_rate;
                }

                $inc[] = $total;

                $inc[$i] = $inc[$i] == '' ? '0.00' : round($inc[$i]);
            } else {
                $inc[] = 0;
            }

            $i++;
        }

        $i = 0;

        $xd = [];

        foreach ($months as $month) {
            //            $first_day_this_month = date(
            //                "Y-m-d",
            //                strtotime("first day of $month")
            //            );
            //            $last_day_this_month = date(
            //                "Y-m-d",
            //                strtotime("last day of $month")
            //            );
            //
            //            $x = ORM::for_table('sys_transactions')
            //                ->where('type', 'Expense')
            //                ->where_gte('date', $first_day_this_month)
            //                ->where_lte('date', $last_day_this_month);
            //
            //            if (!$all_data) {
            //                $x->where('aid', $user->id);
            //            }
            //
            //            $exp[] = $x->sum('dr');
            //
            //            $exp[$i] = $exp[$i] == '' ? '0.00' : round($exp[$i]);
            //
            //            $i++;

            $first_day_this_month = date(
                "Y-m-d",
                strtotime("first day of $month")
            );
            $last_day_this_month = date(
                "Y-m-d",
                strtotime("last day of $month")
            );

            $total = 0;

            if (true)
            //if((strtotime($first_day_this_month) == strtotime($month_start_date)) && (strtotime($last_day_this_month) == strtotime($month_end_date)) )
            {
                $transactions = new Transaction();

                $transactions = $transactions->where('type', 'Expense')->where(function ($query) use ($first_day_this_month, $last_day_this_month) {
                    $query->where('date', '>=', $first_day_this_month)
                        ->where('date', '<=', $last_day_this_month);
                });

                if (!$all_data) {
                    $transactions = $transactions->where('aid', $user->id);
                }

                $transactions = $transactions->get();

                foreach ($transactions as $transaction) {
                    $total += $transaction->amount * $transaction->currency_rate;
                }

                $exp[] = $total;

                $exp[$i] = $exp[$i] == '' ? '0.00' : round($exp[$i]);
            } else {
                $exp[] = 0;
            }

            $xd[] = array(
                "inicio_mes" => $first_day_this_month,
                "fin_mes" => $last_day_this_month,
                "es igual" => (strtotime($first_day_this_month) == strtotime($month_start_date)) && (strtotime($last_day_this_month) == strtotime($month_end_date)) ? "es igual" : "no es igual",
                "inicio_mes_comparar" => $month_start_date,
                "fin_mes_comparar" => $month_end_date,
            );

            $i++;
        }

        return [
            'Months' => $m,
            'Income' => $inc,
            'Expense' => $exp,
            'xd' => $xd,
        ];
    }

    public static function dataIncExpD_OLD($select)
    {
        global $user;

        $all_data = true;
        if (!has_access($user->roleid, 'transactions', 'all_data')) {
            $all_data = false;
        }

        $inc = [];
        $exp = [];

        $i = 1;

        for ($i = 0; $i <= 31; $i++) {
            $d_i = $i;
            $date_string = str_pad($d_i, 2, '0', STR_PAD_LEFT);
            $d1 = date("Y-m-$date_string");

            $x = ORM::for_table('sys_transactions')
                ->where('type', 'Income')
                ->where('date', $d1);
            if (!$all_data) {
                $x->where('aid', $user->id);
            }
            $d1i = $x->sum('cr');
            if ($d1i == '') {
                $d1i = '0.00';
            }

            $inc[] = $d1i;

            $x = ORM::for_table('sys_transactions')
                ->where('type', 'Expense')
                ->where('date', $d1);
            if (!$all_data) {
                $x->where('aid', $user->id);
            }
            $d1e = $x->sum('dr');
            if ($d1e == '') {
                $d1e = '0.00';
            }

            $exp[] = $d1e;
        }

        return [
            'Income' => $inc,
            'Expense' => $exp,
        ];
    }

    public static function dataIncExpD($select)
    {
        global $user;

        $all_data = has_access($user->roleid, 'transactions', 'all_data');
        $mes_actual = date('Y-m');

        // Consulta única para agrupar por tipo y fecha
        $query = ORM::for_table('sys_transactions')
            ->select('type')
            ->select_expr('DATE(date)', 'fecha_transaccion')
            ->select_expr('SUM(cr)', 'ingreso')
            ->select_expr('SUM(dr)', 'gasto')
            ->where_like('date', "$mes_actual%")
            ->group_by('type', 'fecha_transaccion');

        if (!$all_data) {
            $query->where('aid', $user->id);
        }

        $resultados = $query->find_array();

        // Inicializar arreglos para 31 días
        $inc = array_fill(0, 31, '0.00');
        $exp = array_fill(0, 31, '0.00');

        // Procesar resultados
        foreach ($resultados as $row) {
            $dia = (int) substr($row['fecha_transaccion'], -2) - 1; // Extraer día (0-30)
            if ($dia >= 0 && $dia < 31) {
                if ($row['type'] === 'Income') {
                    $inc[$dia] = $row['ingreso'] ?: '0.00';
                } elseif ($row['type'] === 'Expense') {
                    $exp[$dia] = $row['gasto'] ?: '0.00';
                }
            }
        }

        return [
            'Income' => $inc,
            'Expense' => $exp,
        ];
    }

    public static function dataIncExpDByDate($select, $startDate)
    {
        global $user;

        $all_data = true;
        if (!has_access($user->roleid, 'transactions', 'all_data')) {
            $all_data = false;
        }

        $inc = [];
        $exp = [];

        $i = 1;

        $dias_en_el_mes = date('t', strtotime($startDate));
        $dias_del_mes = [];

        for ($i = 1; $i <= $dias_en_el_mes; $i++) {
            $d_i = $i;
            $date_string = str_pad($d_i, 2, '0', STR_PAD_LEFT);
            //$d1 = date("Y-m-$date_string");
            $d1 = date("Y-m-$date_string", strtotime($startDate));

            $x = ORM::for_table('sys_transactions')
                //->where_raw('date BETWEEN ? AND ?', [$startDate , $endDate  ])
                ->where('type', 'Income')
                ->where('date', $d1);
            if (!$all_data) {
                $x->where('aid', $user->id);
            }
            $d1i = $x->sum('cr');
            if ($d1i == '') {
                $d1i = '0.00';
            }

            $inc[] = $d1i;

            $x = ORM::for_table('sys_transactions')
                //->where_raw('date BETWEEN ? AND ?', [$startDate , $endDate  ])
                ->where('type', 'Expense')
                ->where('date', $d1);
            if (!$all_data) {
                $x->where('aid', $user->id);
            }
            $d1e = $x->sum('dr');
            if ($d1e == '') {
                $d1e = '0.00';
            }

            $exp[] = $d1e;

            $dias_del_mes[] = str_pad($d_i, 2, '0', STR_PAD_LEFT);
        }

        return [
            'Income' => $inc,
            'Expense' => $exp,
            'DiasMes' => $dias_del_mes,
            'TotalDays' => $dias_en_el_mes,
        ];
    }

    public static function graphUpdate($user, $config)
    {
        $ib_now = time();
        $ib_u_t = $config['ib_u_t'];
        $msg = '';

        //Dashboard check version
        $u_a_m =
            'aHR0cHM6Ly93d3cuY2xvdWRvbmV4LmNvbS9hcGkvdmVyc2lvbi1jaGVjaz9maWxlX2lkPWQwNTBkMDY5LWM0M2QtNGM3Yy1hNDc4LThjOTkxN2MzYWMyZg==';
        $p = 'cHVyY2hhc2Vfa2V5';

        $graph_p = base64_decode($p);

        try {
            $client = new Client();

            $response = $client->request('POST', base64_decode($u_a_m), [
                'form_params' => [
                    'version' => $config['build'],
                    'app_url' => APP_URL,
                    'fullname' => $user->fullname,
                    'email' => $user->username,
                    $graph_p => $config[$graph_p] ?? '',
                    'ip' => get_client_ip(),
                    'language' => $user->language,
                ],
            ]);

            $data = \json_decode((string) $response->getBody());

            if (defined('DISABLE_AUN')) {
                return [
                    'graph' => false,
                ];
            }

            if (property_exists($data, 'build') && $data->build !== null && $config['build'] < $data->build) {
                return [
                    'graph' => true,
                    'data' => $data->message,
                ];
            }
        } catch (Exception $e) {
        }

        return [
            'graph' => false,
        ];
    }

    public static function dataIncVsExp($month = '')
    {
        $mdate = date('Y-m-d');

        $first_day_month = $month == '' ? date('Y-m-01') : $month;

        $mi = ORM::for_table('sys_transactions')
            ->where('type', 'Income')
            ->where_gte('date', $first_day_month)
            ->where_lte('date', $mdate)
            ->sum('cr');
        if ($mi == '') {
            $mi = '0.00';
        }

        $me = ORM::for_table('sys_transactions')
            ->where('type', 'Expense')
            ->where_gte('date', $first_day_month)
            ->where_lte('date', $mdate)
            ->sum('dr');
        if ($me == '') {
            $me = '0.00';
        }

        return [
            'Income' => $mi,
            'Expense' => $me,
        ];
    }
}
