<?php

/*
|--------------------------------------------------------------------------
| Controller
|--------------------------------------------------------------------------
|
*/


/* API Route */
$request_uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);

if (str_starts_with($request_uri, '/api')) {

    $api_path = __DIR__ . '/../app/routes/api.php';

    if (file_exists($api_path)) {
        require $api_path;
        return;
    } else {
        http_response_code(404);
        echo "API route file not found: $api_path";
        return;
    }
}


$app->emit('onBeforeDefaultController');

if (isset($config['default_landing_page'])) {
    if (
        !empty($config['frontend_theme']) &&
        ($config['default_landing_page'] === 'client' ||
            $config['default_landing_page'] === 'client/login')
    ) {
        $route_controller_directory =
            $config['route_controller_directory'] ?? 'default';
        require 'system/controllers/' .
            $route_controller_directory .
            '/client/default.php';
    } else {
        r2(U . $config['default_landing_page'] . '/');
    }
} else {
    r2(U . 'login' . '/');
}
