<?php

//para socket estaremos usando
//composer require elephantio/elephant.io
//lo usamos porque en socket.io de nuestro servidor tiene ejemplo este plugin

//formato de mensajes recibidos
//https://developers.facebook.com/docs/whatsapp/on-premises/webhooks/inbound?locale=es_ES
//https://developers.facebook.com/docs/whatsapp/cloud-api/reference/media?locale=es_ES#retrieve-media-url

//tipos de archivos valido para enviae
//https://developers.facebook.com/docs/whatsapp/on-premises/reference/media#upload


//codigo de plantillas por paise
//https://developers.facebook.com/docs/whatsapp/api/messages/message-templates?locale=es_ES

//permisos para tener plantillas que se necesitan
//https://developers.facebook.com/docs/permissions#whatsapp_business_management

//tipos de plantillas
//https://developers.facebook.com/docs/whatsapp/business-management-api/message-templates/components#example-requests

//tener plantillsa por filtro: status, nombres entre otras
//https://developers.facebook.com/docs/graph-api/reference/whats-app-business-account/message_templates

//tener plantillas pero por paginacion
//https://developers.facebook.com/docs/whatsapp/business-management-api/message-templates?locale=es_ES

ini_set('memory_limit', '-1');

set_time_limit(36000);
use ElephantIO\Client;
use ElephantIO\Engine\SocketIO\Version4X;
use Carbon\Carbon;


/* header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Headers: *"); */
header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
header("Allow: GET, POST, OPTIONS, PUT, DELETE");

//header("Access-Control-Max-Age: 3600");
//header('Content-Type: audio/ogg');



if ($_SERVER['REQUEST_METHOD'] == 'GET') {


    $mode = isset($_GET['hub_mode']) ? $_GET['hub_mode'] : null;
    $verify_token = isset($_GET['hub_verify_token']) ? $_GET['hub_verify_token'] : null;
    $challenge = isset($_GET['hub_challenge']) ? $_GET['hub_challenge'] : null;

   
    $info = array(
        "mode"         => $mode,
        "verify_token" => $verify_token,
        "challenge"    => $challenge,
    );
    
     //echo json_encode($verify_token);exit;


    // Verificar el token
    //$token = "itg";  
    $token = APP_DIRECTORIO;  

    if ($mode && $verify_token) {
        if ($mode == 'subscribe' && $verify_token == $token) {
            
            http_response_code(200);

            echo $challenge;
        } else {
            http_response_code(500);
            echo json_encode(["error" => "Token de verificación incorrecto."]);
        }
    } else {
        http_response_code(500);

        echo json_encode(["error" => "Faltan parámetros requeridos."]);
    }

    //http_response_code(200);

    exit;
}


if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    

     

    //este token es el que se encuentra por 23 horas, en este caso usaremos uno permanente
    //$token_acceso = "EAADxTGyoEmwBO9ypxfXW0bge2Da8Fc0SbTEThvB3kwxjTjg8enxCHh0tqiPUB7fhZCfulZCm7eevUNLV0ZAVPeLFO35ZAF4bBigWnKNLUNTYqpwMdD1QzRu7vIegrkIaZAZA3cCZAvj2x5EpG0Eo78HSyATmySTEVmKTZCTAuf0zVZA5X97OejJa4bmRHlWrQQJtD";
     
    //$datos = json_decode(file_get_contents("php://input"),true);
    //asi traemos data
    //$d =  $datos["arr"] ?? 3;
    
    $datos = json_decode(file_get_contents("php://input"),true);

    $mi = $datos;
    $mi["id"] = "1000_ejemplo";

    //enviarSocketGeneral($mi);
    //exit;

    //Error, aqui verificamos si existe algun tipo de error
    $Error           = $datos['entry'][0]['changes'][0]['value']['statuses'][0]['errors'];
    $Status          = $datos['entry'][0]['changes'][0]['value']['statuses'];
    $MetaData        = $datos['entry'][0]['changes'][0]['value']['metadata'];
    $Mensajes        = $datos['entry'][0]['changes'][0]['value']['messages'];
    $Contacto        = $datos['entry'][0]['changes'][0]['value']['contacts']; // cuando una persona(cliente) envia un whatsapp esta info viene con el nombre y numero 

    
    /*

        Status:
                delivered  // se entrego pero no se envio
                failed     // hubo una falla no se envio
                read       // recibio el mensaje y fue leido
                sent       // enviado

    */
    
    //creacion de variables
    $token_acceso              = '';
    $errorMensaje              = '';
    $errorCodigo               = '';
    $status                    = '';
    $wam_id                    = ''; // es importante lo veo como el id del mensaje
    $tipo_mensaje              = '';
    $mensaje                   = '';
    $from                      = '';
    $to                        = '';
    $url                       = '';
    $id_chat_number            = '';
    $tipo_producto             = '';
    $staff_id                  = '';
    $filename                  = '';
    $config_whatsapp_other_id  = '';
    $zona_horaria              = '';

    $user_img                  = '';
    $user_fullname             = '';

    $esContacto                = (isset($Contacto) == true && count($Contacto) != 0 ) ? true : false; //si es contacto es true si no false

    $tipo_mensajes_programadas = ["text","image","document","audio","video"];
 
    $fechaActual               = Carbon::now();
    $formatoFecha              = $fechaActual->format('d-m-Y h:i A');

    $custumer_id               = '';
    $nombre_custumers          = '';
    $email_custumers           = '';
    $phone_custumers           = '';
    $company_custumers         = '';
    $address_custumers         = '';

    $template_original         = "";   
    $template_data             = "";   
        
    
    //enviarSocket($datos);
    //exit;

    $mysqli = null;
    try {
        $mysqli = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);
        $mysqli->set_charset("utf8");
        
        // Verificar la conexión
        if ($mysqli->connect_errno) {
            //echo "Falló la conexión a MySQL: (" . $mysqli->connect_errno . ") " . $mysqli->connect_error;
             
            enviarSocket(array(
                "mensaje" => "whatsapp",
                "donde_estamos" => "error base de datos",
                "error" => $mysqli->connect_errno // Capturar el mensaje de la excepción
            ));
            $mysqli->close();
            print_r(json_encode( $response)) ; exit;
        }
    } catch (\Throwable $th) {
        enviarSocket(array(
            "mensaje" => "whatsapp",
            "donde_estamos" => "error base de datos",
            "error" => $th->getMessage() // Capturar el mensaje de la excepción
        ));
        exit;
    }

    //PASO #1 Validar Error
    //validamos si existe algun error y que error no sea un arreglo vacio
    if (isset($Error) == true && count($Error) != 0 ) {
        $errorMensaje = $Error[0]['error_data']["details"];
        $errorCodigo  = $Error[0]['code'];
        $status       = $Status[0]['status'];
        $wam_id       = $Status[0]['id'];

        $existe_info  = $mysqli->query("SELECT * FROM chat_social WHERE wam_id = '$wam_id'")->fetch_assoc();
         
        if ($existe_info) {
            //echo "se hizo";
            $sql = "UPDATE chat_social SET `status`= '$status', error_codigo='$errorCodigo', error_mensaje='$errorMensaje'  WHERE wam_id = '$wam_id' ";
            $mysqli->query($sql);

            //$consulta        = $mysqli->query("SELECT * FROM chat_social WHERE wam_id = '$wam_id'")->fetch_assoc();
            $consulta        = $mysqli->query("SELECT 
                                                    cs.id,
                                                    cs.wam_id,
                                                    cs.chat_number_id,
                                                    cs.from,
                                                    cs.to,
                                                    cs.mensaje,
                                                    cs.url,
                                                    cs.filename,
                                                    cs.template_original,
                                                    cs.template_data,
                                                    cs.tipo_mensaje,
                                                    cs.esContacto,
                                                    cs.error_codigo,
                                                    cs.error_mensaje,
                                                    cs.phone_number_id,
                                                    cs.tipo_producto,
                                                    LOWER(DATE_FORMAT(cs.fecha_creacion, '%d-%m-%Y %I:%i %p')) AS fecha_creacion,
                                                    cs.status,

                                                    cn.id AS 'chat_number_id',
                                                    cn.number AS 'chat_number_number',
                                                    cn.custumer_id AS 'chat_number_custumer_id',
                                                    cn.staff_id AS 'chat_number_staff_id',
                                                    su.img AS user_img,
                                                    su.fullname AS user_fullname

                                                FROM 
                                                    chat_social AS cs
                                                    LEFT JOIN sys_users AS su  ON su.id = cs.user_id  
                                                LEFT JOIN
                                                    chat_number AS cn ON cn.id=cs.chat_number_id
                                                WHERE cs.wam_id = '$wam_id'")->fetch_assoc();


            $mensaje         = $consulta['mensaje'];
            $tipo_mensaje    = $consulta['tipo_mensaje'];
            $esContacto      = $consulta['esContacto'];
            $errorCodigo     = $consulta['error_codigo'];
            $errorMensaje    = $consulta['error_mensaje'];
            $status          = $consulta['status'];
            $formatoFecha    = $consulta['fecha_creacion'];
            $to              = $consulta['to'];
            $url             = $consulta['url'];
            $filename        = $consulta['filename'];

            $staff_id        = $consulta['chat_number_staff_id'];
            $id_chat_number  = $consulta['chat_number_id'];

            $from            = $consulta['from'];
            $phone_number_id = $consulta['phone_number_id'];

            $template_original = $consulta['template_original'];   
            $template_data     = $consulta['template_data'];  

            $user_img          = $consulta['user_img'];
            $user_fullname     = $consulta['user_fullname'];
            

            $formatoFecha = strtolower(Carbon::parse($formatoFecha)->format('d-m-Y h:i A'));
        } else {
            //echo "no se hizo";
            $from         = $MetaData["display_phone_number"];
            $to           = $Status[0]['recipient_id'];

            $from = $MetaData["phone_number_id"];
            $version_api_whatapp = "v19.0";

            $url_api = "https://graph.facebook.com/$version_api_whatapp/$from/messages";

            $message_texto = "*Hello, we are Hispanos de Exito. This message could not be sent*";
            $message_texto .= "\n";  
            $message_texto .= "\n";  
            $message_texto .= "Error Detail:".$errorMensaje;  
            $message_texto .= "\n";
            $message_texto .= "Error Code:".$errorCodigo;  

            //reply_mensaje_texto($url_api, $wam_id, $message_texto, $to, $token_acceso);
        }

         

        //imprimir esta informacion
        $salida = array(
            "tipo_producto"         => "whatsapp",
            "error_codigo"          => $errorCodigo,
            "error_mensaje"         => $errorMensaje,
            "status"                => $status,
            "wam_id"                => $wam_id, // podriamos decir que es el mero id de la conversacion
            //OJO no confundir phone_number_id y display_phone_number con el numero de telefono de la persona
            "phone_number_id"       => $MetaData["phone_number_id"], //cuando se selecciona un numero en developer.facebook este seria el Identificador del número de teléfono
            "from"                  => $from,  // este seria el numero de telefono como tal, el que esta configurado en developer.facebook
            "to"                    => $to,  // este seria el numero de telefono como tal, el que esta configurado en developer.facebook
            "mensaje"               => $mensaje,  // este seria cuerpo o contenido del mensaje
            "tipo_mensaje"          => $tipo_mensaje,  // este seria text, imagen etc...
            "db"                    => DB_NAME,   
            "esContacto"            => $esContacto,   
            "fecha_creacion"        => $formatoFecha,   
            "url"                   => $url, 
            "filename"              => $filename,   
            "template_original"     => $template_original,   
            "template_data"         => $template_data,   
            "id_chat_number"        => $id_chat_number, 
            "staff_id"              => $staff_id,   
            "donde_estamos"         => "Estamos en un error",   

            "user_img"              => $user_img,   
            "user_fullname"         => $user_fullname,   
            
        );

        print_r(json_encode($salida));

        //funcion para disparar el socket
        enviarSocket($salida);

        exit;
    }
    //Nota: el phone_number_id y display_phone_number vienen siendo ( TO ) y el from es from

    // si no tiene errores es porque se envio, realizaremos otros procesos

    $tipo_mensaje = $Mensajes[0]['type']; // me servira para 2 cosas una para ver el tipo de mensaje y otra para verificar si la persona me escribio a mi
    //note que cuando yo envio un mensaje el tipo no me aparece. pero al recibir uno si

    $status       = $Status[0]['status'];
    if(empty($status) == true)
    {
        $status = "delivered";
    }

    //cuando no tienen estatus, son mensajes que pasan a crearse.
    //Si tienen estatus pasan a modificarses
    if (isset($Status) == false)
    {
        //pasamos a crear el registro en la base de datos y lo enviamos al socket

        $wam_id           = $Mensajes[0]['id'];

        $from             = $MetaData["display_phone_number"];  // esta informacion es del telefono facebook
        $phone_number_id  = $MetaData["phone_number_id"]; //  esta informacion es del telefono facebook
        $to               = $Mensajes[0]['from'];
        
        $select_configuracion = "SELECT * FROM config_whatsapp_other 
                                 WHERE phone_identifier='$phone_number_id' AND phone='$from' ";

        $data_configuracion = $mysqli->query($select_configuracion)->fetch_assoc();

        if(!$data_configuracion)
        {
            exit;
        }


        if($data_configuracion)
        {
            $zona_horaria             = $data_configuracion["zona_horaria"];
            $token_acceso             = $data_configuracion["token"];
            $config_whatsapp_other_id = $data_configuracion["id"];
            $status_conf              = $data_configuracion["status"];

            $enable_whatsapp          = $data_configuracion["enable_whatsapp"];

            if($status_conf != "1" || $status_conf != 1)
            {
                exit;
            }

            if($enable_whatsapp == "2" || $enable_whatsapp == 2)
            {
                exit;
            }

        }
 

        //Punto validacion existe tipo mensaje
        if (in_array($tipo_mensaje, $tipo_mensajes_programadas) == false) {


            /* $consulta     = $mysqli->query("SELECT * FROM chat_social WHERE wam_id = '$wam_id'")->fetch_assoc();
            $mensaje      = $consulta['mensaje'];
            $tipo_mensaje = $consulta['tipo_mensaje'];
            $esContacto   = $consulta['esContacto'];
            $errorCodigo  = $consulta['error_codigo'];
            $errorMensaje = $consulta['error_mensaje'];
            $status       = $consulta['status'];
            $formatoFecha = $consulta['fecha_creacion']; */

            $salida = array(
                "tipo_producto"              => "whatsapp",
                "error_codigo"               => $errorCodigo,
                "error_mensaje"              => $errorMensaje,
                "status"                     => $status,
                "wam_id"                     => $wam_id, // podriamos decir que es el mero id de la conversacion
                //OJO no confundir phone_number_id y display_phone_number con el numero de telefono de la persona
                "phone_number_id"            => $MetaData["phone_number_id"], //cuando se selecciona un numero en developer.facebook este seria el Identificador del número de teléfono
                "from"                       => $from,  // este seria el numero de telefono como tal, el que esta configurado en developer.facebook
                "to"                         => $to,  // este seria el numero de telefono como tal, el que esta configurado en developer.facebook
                "mensaje"                    => $mensaje,  // este seria cuerpo o contenido del mensaje,
                "tipo_mensaje"               => $tipo_mensaje,  // este seria text, imagen etc...
                "db"                         => DB_NAME, 
                "esContacto"                 => $esContacto,   
                "fecha_creacion"             => $formatoFecha,   
                "url"                        => $url,
                "filename"                   => $filename,   
                "id_chat_number"             => $id_chat_number, 
                "staff_id"                   => $staff_id,   
                "config_whatsapp_other_id"   => $config_whatsapp_other_id,   
                "donde_estamos"              => "Punto validacion existe tipo mensaje",   
            );

            //funcion para disparar el socket
            enviarSocket($salida);

            print_r(json_encode($salida));

            exit;
        }

        $existe_mensaje  = $mysqli->query("SELECT * FROM chat_social WHERE wam_id = '$wam_id'")->fetch_assoc();

        if($existe_mensaje)
        {
            exit;
        }

        $nombre_whatsapp = $Contacto[0]['profile']["name"];

        if($tipo_mensaje == "text")
        {
            $mensaje = $Mensajes[0]['text']["body"];

            //$fechaActual = Carbon::now();
            if(empty($zona_horaria) == true)
            {
                $fechaActual   = Carbon::now();
            }else{
                $fechaActual   = Carbon::now()->setTimezone($zona_horaria);
            }

            $formatoFecha      = $fechaActual->format('d-m-Y h:i A');

            $phone_number_id = $MetaData["phone_number_id"];

            //creacion de registros para el cliente

            $info = crear_registro($mysqli, $wam_id, $from, $to, $mensaje, $tipo_mensaje, $esContacto, $errorCodigo, $errorMensaje, $phone_number_id, $fechaActual, $status, $url, "", $config_whatsapp_other_id, $nombre_whatsapp);
            $id_chat_number                 = $info["id"];
            $staff_id                       = $info["staff_id"];

            $custumer_id                    = $info["custumer_id"];
            $nombre_custumers               = $info["nombre"];
            $email_custumers                = $info["email_custumers"];
            $phone_custumers                = $info["phone_custumers"];
            $company_custumers              = $info["company_custumers"];
            $address_custumers              = $info["address_custumers"];

        }

        if($tipo_mensaje == "image")
        {

            if(empty($zona_horaria) == true)
            {
                $fechaActual   = Carbon::now();
            }else{
                $fechaActual   = Carbon::now()->setTimezone($zona_horaria);
            }

            $formatoFecha      = $fechaActual->format('d-m-Y h:i A');

            $phone_number_id = $MetaData["phone_number_id"];

            $media_id  = $Mensajes[0]['image']["id"];
            $mensaje   = $Mensajes[0]['image']["caption"] ?? "";

            $url_media = getUrlMedia($media_id,$token_acceso);

            $mime_type = $url_media["mime_type"];
            $mime_type = explode('/', $url_media["mime_type"])[1] ?? "png";
            /* 
            esta es la informacion de $url_media
            {
                "url": "https://lookaside.fbsbx.com/whatsapp_business/attachments/?mid=1463700434511026&ext=1721073765&hash=ATvzU6W3G8LubhTqQfup5xSMixaQoKf-gyJQYKbc9uQtFg",
                "mime_type": "image/jpeg",
                "sha256": "23539f089862ef4ce26abb28b779a10aeb7d863a2afcc2a746252374ca025830",
                "file_size": 25623,
                "id": "1463700434511026",
                "messaging_product": "whatsapp"
            }
            */

            $binarios = archivoBinario($url_media["url"], $token_acceso);
            
            $ruta_root = $_SERVER['DOCUMENT_ROOT'];   

            // Verificar si la ruta tiene una barra al final
            if (substr($ruta_root, -1) === '/') {
                // Si hay una barra al final, eliminarla
                $ruta_root = rtrim($ruta_root, '/');
            }

            $tipo_proyecto_produccion = APP_DIRECTORIO;

            $basePath = $ruta_root . "/$tipo_proyecto_produccion/storage/whatsapp/imagen/";
            $path_db = "/storage/whatsapp/imagen/";


            if (!file_exists($basePath))
            {
               mkdir($basePath, 0777, true);
            
               createHtmlFile($basePath."/index.html");
            } 

            $numero_aleatorio = rand(1, 1000000); 

            $formato = date('Y-m-d-H-i-s');
                    
            $idImagen = $formato . "_" . $numero_aleatorio . "_from" . $from . "_to" . $to . "_recibido.$mime_type";
            $folderPath = $basePath;
            //$image_base64 = base64_encode($binarios);

            $file =   $folderPath . $idImagen;

            $imagen = imagecreatefromstring($binarios);

            if ($imagen !== false)
            {
                $anchoOriginal = imagesx($imagen);
                $altoOriginal  = imagesy($imagen);

                $creado = DimensionesImagen($imagen,500,500,$anchoOriginal, $altoOriginal,  $file);

                if($creado == false)
                {
                    file_put_contents($file, $binarios);
                }

            }else{
                file_put_contents($file, $binarios);
            }
               

            $url_final = APP_URL . $path_db . $idImagen;

            //si coloco file me estaria dando la direccion del archivo
            $url = $url_final;

            $info = crear_registro($mysqli, $wam_id, $from, $to, $mensaje, $tipo_mensaje, $esContacto, $errorCodigo, $errorMensaje, $phone_number_id, $fechaActual, $status, $url, $filename, $config_whatsapp_other_id, $nombre_whatsapp);
            $id_chat_number                 = $info["id"];
            $staff_id                       = $info["staff_id"];

            $custumer_id                    = $info["custumer_id"];
            $nombre_custumers               = $info["nombre"];
            $email_custumers                = $info["email_custumers"];
            $phone_custumers                = $info["phone_custumers"];
            $company_custumers              = $info["company_custumers"];
            $address_custumers              = $info["address_custumers"];
        }

        if($tipo_mensaje == "document")
        {

            if(empty($zona_horaria) == true)
            {
                $fechaActual   = Carbon::now();
            }else{
                $fechaActual   = Carbon::now()->setTimezone($zona_horaria);
            }

            $formatoFecha      = $fechaActual->format('d-m-Y h:i A');

            $phone_number_id = $MetaData["phone_number_id"];
            $media_id        = $Mensajes[0]['document']["id"];
            $filename        = $Mensajes[0]['document']["filename"];

            //$mensaje   = $Mensajes[0]['image']["caption"] ?? "";

            $url_media = getUrlMedia($media_id,$token_acceso);
            
            $binarios  = archivoBinario($url_media["url"], $token_acceso);

            $mime_type = $url_media["mime_type"];

            $filename  = trim($filename);
            $extension = pathinfo($filename, PATHINFO_EXTENSION);

            //parametros- nombre_directorio y tipo de archivo y binario
            $url = guardar_archivos($extension, $extension, $binarios, $from, $to);   

            $info = crear_registro($mysqli, $wam_id, $from, $to, $mensaje, $tipo_mensaje, $esContacto, $errorCodigo, $errorMensaje, $phone_number_id, $fechaActual, $status, $url, $filename, $config_whatsapp_other_id, $nombre_whatsapp);
            $id_chat_number                 = $info["id"];
            $staff_id                       = $info["staff_id"];

            $custumer_id                    = $info["custumer_id"];
            $nombre_custumers               = $info["nombre"];
            $email_custumers                = $info["email_custumers"];
            $phone_custumers                = $info["phone_custumers"];
            $company_custumers              = $info["company_custumers"];
            $address_custumers              = $info["address_custumers"];

        }

        if($tipo_mensaje == "audio")
        {

            if(empty($zona_horaria) == true)
            {
                $fechaActual   = Carbon::now();
            }else{
                $fechaActual   = Carbon::now()->setTimezone($zona_horaria);
            }

            $formatoFecha      = $fechaActual->format('d-m-Y h:i A');

            $phone_number_id = $MetaData["phone_number_id"];
            $media_id        = $Mensajes[0]['audio']["id"];
            $voice        = $Mensajes[0]['audio']["voice"];
            $filename        = '';

            //$mensaje   = $Mensajes[0]['image']["caption"] ?? "";

            $url_media = getUrlMedia($media_id,$token_acceso);
            
            $binarios  = archivoBinario($url_media["url"], $token_acceso);

            $mime_type = $url_media["mime_type"];
            $extension = "";
            //$filename  = trim($filename);
            //$extension = pathinfo($filename, PATHINFO_EXTENSION);
            if($mime_type == "audio/aac"){$extension = "aac";}
            if($mime_type == "audio/amr"){$extension = "amr";}
            if($mime_type == "audio/mpeg"){$extension = "mp3";}
            if($mime_type == "audio/mp4"){$extension = "m4a";}
            if($mime_type == "audio/ogg"){$extension = "ogg";}

            //$url = guardar_archivos("ogg", "ogg", $binarios);   

            //$url = $url_media;
             
            if($extension != "")
            {
                if($voice == true)
                {
                    //parametros- nombre_directorio y tipo de archivo y binario
                    //$url = guardar_archivos($extension, $extension, $binarios);   
                    $url = guardar_archivos($extension, $extension, $binarios, $from, $to);   
                }

                $info = crear_registro($mysqli, $wam_id, $from, $to, $mensaje, $tipo_mensaje, $esContacto, $errorCodigo, $errorMensaje, $phone_number_id, $fechaActual, $status, $url, $filename, $config_whatsapp_other_id, $nombre_whatsapp);
                $id_chat_number                 = $info["id"];
                $staff_id                       = $info["staff_id"];

                $custumer_id                    = $info["custumer_id"];
                $nombre_custumers               = $info["nombre"];
                $email_custumers                = $info["email_custumers"];
                $phone_custumers                = $info["phone_custumers"];
                $company_custumers              = $info["company_custumers"];
                $address_custumers              = $info["address_custumers"];
            }

            /* header('Content-Type: ' . $mime_type);
            header('Content-Length: ' . filesize($url));
            readfile($url); */
            ///home/hispano6072/public_html/app_dev/storage/whatsapp/ogg/2024-07-25-18-28-36_484838_recibido.ogg;


        }
        
        if($tipo_mensaje == "video")
        {

            if(empty($zona_horaria) == true)
            {
                $fechaActual   = Carbon::now();
            }else{
                $fechaActual   = Carbon::now()->setTimezone($zona_horaria);
            }

            $formatoFecha      = $fechaActual->format('d-m-Y h:i A');

            $phone_number_id = $MetaData["phone_number_id"];
            $media_id        = $Mensajes[0]['video']["id"];
            //$filename      = $Mensajes[0]['video']["filename"];
            $mensaje         = $Mensajes[0]['video']["caption"] ?? "";

            $tipo         = $Mensajes[0]['video']["mime_type"];

            $mimeTypesArray = ['video/mp4', 'video/3gpp'];

            // Validar el tipo MIME
            if (!in_array($tipo, $mimeTypesArray)) {
                exit;
            }

            $url_media = getUrlMedia($media_id,$token_acceso);
            
            $binarios  = archivoBinario($url_media["url"], $token_acceso);

            $mime_type = $url_media["mime_type"];
            $extension = $parts = explode('/', $mime_type)[1];

            //$filename  = trim($filename);
            //$extension = pathinfo($filename, PATHINFO_EXTENSION);

            //parametros- nombre_directorio y tipo de archivo y binario
            $url  = guardar_archivos($extension, $extension, $binarios, $from, $to);   

            $info = crear_registro($mysqli, $wam_id, $from, $to, $mensaje, $tipo_mensaje, $esContacto, $errorCodigo, $errorMensaje, $phone_number_id, $fechaActual, $status, $url, $filename, $config_whatsapp_other_id, $nombre_whatsapp);
            $id_chat_number                 = $info["id"];
            $staff_id                       = $info["staff_id"];

            $custumer_id                    = $info["custumer_id"];
            $nombre_custumers               = $info["nombre"];
            $email_custumers                = $info["email_custumers"];
            $phone_custumers                = $info["phone_custumers"];
            $company_custumers              = $info["company_custumers"];
            $address_custumers              = $info["address_custumers"];

        }

        $fecha_humana = "";

        if ($fechaActual->isToday()) 
        {
            $fecha_humana = $fechaActual->format('h:i A');
        } elseif ($fechaActual->isYesterday()) {
            $fecha_humana = "Yesterday";
        } else {
            $fecha_humana = $fechaActual->format('m/d/Y');
        }

        //imprimir esta informacion
        $salida = array(
            "tipo_producto"                => "whatsapp",
            "error_codigo"                 => $errorCodigo,
            "error_mensaje"                => $errorMensaje,
            "status"                       => $status,
            "wam_id"                       => $wam_id, // podriamos decir que es el mero id de la conversacion
            //OJO no confundir phone_number_id y display_phone_number con el numero de telefono de la persona
            "phone_number_id"              => $MetaData["phone_number_id"], //cuando se selecciona un numero en developer.facebook este seria el Identificador del número de teléfono
            "from"                         => $from,  // este seria el numero de telefono como tal, el que esta configurado en developer.facebook
            "to"                           => $to,  // este seria el numero de telefono como tal, el que esta configurado en developer.facebook
            "mensaje"                      => $mensaje,  // este seria cuerpo o contenido del mensaje
            "tipo_mensaje"                 => $tipo_mensaje,  // este seria text, imagen etc...
            "db"                           => DB_NAME, 
            "esContacto"                   => $esContacto,   
            "fecha_creacion"               => $formatoFecha,
            "url"                          => $url,   
            "filename"                     => $filename,   
            "template_original"            => $template_original,   
            "template_data"                => $template_data,
            "id_chat_number"               => $id_chat_number, 
            "staff_id"                     => $staff_id,   
            "config_whatsapp_other_id"     => $config_whatsapp_other_id,   

            "custumer_id"                  => $custumer_id,   
            "nombre"                       => $nombre_custumers,   
            "email_custumers"              => $email_custumers,   
            "phone_custumers"              => $phone_custumers,   
            "company_custumers"            => $company_custumers,   
            "address_custumers"            => $address_custumers,   

            "fecha_humana"                 => $fecha_humana,   

            "donde_estamos"                => "Paso punto validacion existe tipo mensaje. y se envio",   

            "user_img"                     => $user_img,   
            "user_fullname"                => $user_fullname,   
             
        );
 

        print_r(json_encode($salida));

        //funcion para disparar el socket
        enviarSocket($salida);

    }else{
        
        $version_api_whatapp = "v19.0";

        $from             = $MetaData["display_phone_number"];  // esta informacion es del telefono facebook
        $phone_number_id  = $MetaData["phone_number_id"]; //  esta informacion es del telefono facebook
        
        $select_configuracion = "SELECT * FROM config_whatsapp_other 
                                 WHERE phone_identifier='$phone_number_id' AND phone='$from' ";

        $data_configuracion = $mysqli->query($select_configuracion)->fetch_assoc();

        if($data_configuracion)
        {
            $zona_horaria             = $data_configuracion["zona_horaria"];
            $token_acceso             = $data_configuracion["token"];
            $config_whatsapp_other_id = $data_configuracion["id"];

            $version_api_whatapp      = $data_configuracion["version"];

        }

        //aqui es donde tomamos el id lo buscamos en la tabla y cambiamos su estado puede ser: sent, delivered, read. Y lo enviamos al sockets

        $wam_id          = $Status[0]['id'];
        $status          = $Status[0]['status'];

        $sql = "UPDATE chat_social SET `status`= '$status' WHERE wam_id = '$wam_id' ";
        $mysqli->query($sql);

        //$consulta        = $mysqli->query("SELECT * FROM chat_social WHERE wam_id = '$wam_id'")->fetch_assoc();
        $sql_tomar = " SELECT 
                                                cs.id,
                                                cs.wam_id,
                                                cs.chat_number_id,
                                                cs.from,
                                                cs.to,
                                                cs.mensaje,
                                                cs.url,
                                                cs.filename,
                                                cs.template_original,
                                                cs.template_data,
                                                cs.tipo_mensaje,
                                                cs.esContacto,
                                                cs.error_codigo,
                                                cs.error_mensaje,
                                                cs.phone_number_id,
                                                cs.tipo_producto,
                                                LOWER(DATE_FORMAT(cs.fecha_creacion, '%d-%m-%Y %I:%i %p')) AS fecha_creacion,
                                                cs.status,

                                                cn.id AS 'chat_number_id',
                                                cn.number AS 'chat_number_number',
                                                cn.custumer_id AS 'chat_number_custumer_id',
                                                cn.staff_id AS 'chat_number_staff_id',
                                                cs.config_whatsapp_other_id,
                                                su.img AS user_img,
                                                su.fullname AS user_fullname

                                            FROM 
                                                chat_social AS cs
                                                LEFT JOIN sys_users AS su  ON su.id = cs.user_id  
                                            LEFT JOIN
                                                chat_number AS cn ON cn.id=cs.chat_number_id
                                             
                                            WHERE cs.wam_id = '$wam_id'
    
                                            ";
        $consulta        = $mysqli->query($sql_tomar)->fetch_assoc();

        $mensaje                   = $consulta['mensaje'];
        $tipo_mensaje              = $consulta['tipo_mensaje'];
        $esContacto                = $consulta['esContacto'];
        $errorCodigo               = $consulta['error_codigo'];
        $errorMensaje              = $consulta['error_mensaje'];
        $status                    = $consulta['status'];
        $formatoFecha              = $consulta['fecha_creacion'];
        $to                        = $consulta['to'];
        $url                       = $consulta['url'];
        $filename                  = $consulta['filename'];

        $tipo_producto             = $consulta['tipo_producto'];
        $staff_id                  = $consulta['chat_number_staff_id'];
        $id_chat_number            = $consulta['chat_number_id'];
        $config_whatsapp_other_id  = $consulta['config_whatsapp_other_id'];

        $from                      = $MetaData["display_phone_number"];
        $phone_number_id           = $MetaData["phone_number_id"];

        $template_original         = $consulta['template_original'];   
        $template_data             = $consulta['template_data']; 

        $user_img                  = $consulta['user_img'];
        $user_fullname             = $consulta['user_fullname'];

        $formatoFecha = Carbon::parse($formatoFecha)->format('d-m-Y h:i A');

        if($status == "delivered"){
            $marcar_leidos = $mysqli->query("SELECT wam_id FROM chat_social WHERE `status`='delivered' AND `from`='$from' AND `to`='$to' AND esContacto=1 AND tipo_producto='whatsapp' AND config_whatsapp_other_id=$config_whatsapp_other_id order by id desc")->fetch_all(MYSQLI_ASSOC) ;

            if(count($marcar_leidos) != 0)
            {
                // ID del mensaje wam_id
                $messageId = $marcar_leidos[0]["wam_id"];

                if($messageId != null)
                {   
 
                    marcar_leidos($messageId, "https://graph.facebook.com/$version_api_whatapp/$phone_number_id/messages", $token_acceso, $mysqli, $from, $to);
                }

            }
        }

        //print_r($mensaje); exit;

        //$datos["pendiente_programar"] = "Tenemos que programar. esta parte es cambiar el estado del mensaje";
        //print_r(json_encode($datos));

        //imprimir esta informacion
        $salida = array(
            "tipo_producto"              => $tipo_producto,
            "error_codigo"               => $errorCodigo,
            "error_mensaje"              => $errorMensaje,
            "status"                     => $status,
            "wam_id"                     => $wam_id, // podriamos decir que es el mero id de la conversacion
            //OJO no confundir phone_number_id y display_phone_number con el numero de telefono de la persona
            "phone_number_id"            => $phone_number_id, //cuando se selecciona un numero en developer.facebook este seria el Identificador del número de teléfono
            "from"                       => $from,  // este seria el numero de telefono como tal, el que esta configurado en developer.facebook
            "to"                         => $to,  // este seria el numero de telefono como tal, el que esta configurado en developer.facebook
            "mensaje"                    => $mensaje,  // este seria cuerpo o contenido del mensaje
            "tipo_mensaje"               => $tipo_mensaje,  // este seria text, imagen etc...
            "db"                         => DB_NAME, 
            "esContacto"                 => $esContacto == 0 ? false:true,   
            "fecha_creacion"             => $formatoFecha,
            "url"                        => $url,   
            "filename"                   => $filename,   
            "template_original"          => $template_original,   
            "template_data"              => $template_data,
            "id_chat_number"             => $id_chat_number, 
            "staff_id"                   => $staff_id,   
            "config_whatsapp_other_id"   => $config_whatsapp_other_id,   

            "nombre"                     => $nombre_custumers,   
            "email_custumers"            => $email_custumers,   
            "phone_custumers"            => $phone_custumers,   
            "company_custumers"          => $company_custumers,   
            "address_custumers"          => $address_custumers,  

            "donde_estamos"              => "Donde se modifica el status: ".$status,   
            "sql"                        => $sql_tomar,   
            "sql_update"                 => $sql,   

            "user_img"                   => $user_img,   
            "user_fullname"              => $user_fullname,   

        );

        print_r(json_encode($salida));
        
        //funcion para disparar el socket
        enviarSocket($salida);
    }


    exit;

 
}


//tenermos la url con esto podriamos descrgar la imagen de forma binaria para pasala a imagen y guardar en disco
function getUrlMedia($id,$accessToken) {
    
    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => "https://graph.facebook.com/v20.0/{$id}",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => array(
            "Authorization: Bearer {$accessToken}"
        ),
    ));

    $response = curl_exec($curl);

    if (curl_errno($curl)) {
        $error_msg = curl_error($curl);
        curl_close($curl);
        return "cURL Error: {$error_msg}";
    }

    curl_close($curl);
    return json_decode($response, true);
}

//retorna informacion binaria
function archivoBinario($url, $accessToken) {
    $curl = curl_init();


    $headers = array(
        'Content-Type: application/json',
        'Authorization: Bearer ' . $accessToken,
        'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.77 Safari/537.36'
    );

    curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => $headers,
    ));

    $response = curl_exec($curl);

    if (curl_errno($curl)) {
        $error_msg = curl_error($curl);
        curl_close($curl);
        return "cURL Error: $error_msg";
    }

    curl_close($curl);
    return $response;
}
    

//crea el archivo index para que nadie ve las imagenes
function createHtmlFile($filename) {
    // Abre el archivo para escritura. Si no existe, lo crea.
    $file = fopen($filename, 'w');
    
    // Verifica si el archivo se abrió correctamente
    if ($file === false) {
        return "Error al abrir el archivo.";
    }

    $content = '
    <html>
    <head>
        <title>403 Forbidden</title>
    </head>
    <body>
    <p>Directory access is forbidden.</p>
    </body>
    </html>
    ';

    // Escribe el contenido en el archivo
    fwrite($file, $content);

    // Cierra el archivo
    fclose($file);
}


function enviarSocket($datos)
{
    $url = 'https://hispanosdeexitollc.com/socket-chat/socket.io/';  
    $options = [
        'client' => Client::CLIENT_4X,
        'context' => [
            'http' => [],
            'ssl' => [],
        ],
        'transports' => ['polling'],
    ];

    try {
        $client = Client::create($url, $options);

        $client->initialize(); // Inicializa la conexión

        // Emitir el evento "position"
        /* $dataPosition =
        [
            'id_order' => 10000,
            'lat' => 140.7128,
            'lng' => -74.006,
            'estadoId' => 12,
        ];

        $client->emit('position', $dataPosition); */

        // Emitir el evento "chat-social"
        $client->emit('chat-social', $datos);

        $client->close(); // Cierra la conexión

        http_response_code(200);

        exit;
        //echo "Se envio la info";

    } catch (Exception $e) {
        http_response_code(500);
        echo 'Error: ', $e->getMessage(), "\n";
        exit;
    }
}

function enviarSocketGeneral($datos)
{
    $url = 'https://hispanosdeexitollc.com/socket-chat/socket.io/';  
    $options = [
        'client' => Client::CLIENT_4X,
        'context' => [
            'http' => [],
            'ssl' => [],
        ],
        'transports' => ['polling'],
    ];

    try {
        $client = Client::create($url, $options);

        $client->initialize(); // Inicializa la conexión

        // Emitir el evento "position"
        /* $dataPosition =
        [
            'id_order' => 10000,
            'lat' => 140.7128,
            'lng' => -74.006,
            'estadoId' => 12,
        ];

        $client->emit('position', $dataPosition); */

        // Emitir el evento "chat-social"
        $client->emit('chat-social', $datos);

        $client->close(); // Cierra la conexión

        http_response_code(200);

        //exit;
        //echo "Se envio la info";

    } catch (Exception $e) {
        http_response_code(500);
        echo 'Error: ', $e->getMessage(), "\n";
        exit;
    }
}


function crear_registro($mysqli, $wam_id, $from, $to, $mensaje, $tipo_mensaje, $esContacto, $errorCodigo, $errorMensaje, $phone_number_id, $fechaActual, $status, $url_archivo, $filename="", $config_whatsapp_other_id, $nombre_whatsapp = "")
{
 
    $custumer_id = null;
    $nombre = null;
    $email_custumers = null;
    $phone_custumers = null;
    $company_custumers = null;
    $address_custumers = null;

    $mysqli->begin_transaction();

    try {

        $id_chat_number           = null;
        $staff_id                 = null;

        //se crea el numero en caso de que no exista
        $sql = "INSERT INTO chat_number (`number`, config_whatsapp_other_id)
                SELECT '$to', '$config_whatsapp_other_id'
                FROM DUAL
                WHERE NOT EXISTS (
                    SELECT 1
                    FROM chat_number
                    WHERE `number` = '$to' AND config_whatsapp_other_id = $config_whatsapp_other_id
                );";

        $mysqli->query($sql);
    
        // Comprobar si se insertó una fila nueva
        if ($mysqli->affected_rows > 0) {
            $id_chat_number = $mysqli->insert_id;

            /* IFNULL(crm_a.account, 'Desconocido') AS nombre,
            crm_a.email AS email_custumers,
            crm_a.phone AS phone_custumers,
            crm_a.company AS company_custumers,
            crm_a.address AS address_custumers, */

            //buscar cliente si existe
            $sql = "SELECT 
                        id AS id,
                        account AS nombre,
                        email AS email_custumers,
                        phone AS phone_custumers,
                        company AS company_custumers,
                        address AS address_custumers
                    FROM crm_accounts WHERE REPLACE(phone, '+', '') = '$to';";
            $result_crm_account = $mysqli->query($sql);
    
            if ($result_crm_account->num_rows > 0) {
                $row_crm_account = $result_crm_account->fetch_assoc();
                $custumer_id                 = $row_crm_account['id'];

                $nombre                      = $row_crm_account['nombre'];
                $email_custumers             = $row_crm_account['email_custumers'];
                $phone_custumers             = $row_crm_account['phone_custumers'];
                $company_custumers           = $row_crm_account['company_custumers'];
                $address_custumers           = $row_crm_account['address_custumers'];

                $sql = "UPDATE `chat_number` SET `custumer_id`='$customer_id' WHERE `id`='$id_chat_number'";
                $result = $mysqli->query($sql);

            }  

        } else {
            //$sql = "SELECT id, staff_id, `number`, custumer_id FROM chat_number WHERE `number`='$to'";
            /* $sql = "SELECT 
                        cn.id, 
                        cn.staff_id, 
                        cn.`number`, 
                        cn.custumer_id, 
                        su.config_whatsapp_other_id 
                    FROM chat_number AS cn 
                    LEFT JOIN sys_users AS su ON su.id=cn.staff_id 
                    WHERE cn.`number`='$to' AND cn.config_whatsapp_other_id=$config_whatsapp_other_id ;"; */

            $sql = "SELECT * FROM chat_number WHERE `number` = '$to' AND config_whatsapp_other_id = $config_whatsapp_other_id";
            $result = $mysqli->query($sql);
    
            if ($result->num_rows > 0) {
                $row = $result->fetch_assoc();
                $id_chat_number                 = $row['id'];
                $staff_id                       = $row['staff_id'];
                //$config_whatsapp_other_id       = $row['config_whatsapp_other_id'];
            }  
        }

        //creacion de registros para el cliente
        /* $sql = "INSERT INTO chat_social (
            wam_id, 
            chat_number_id,
            `from`, 
            `to`, 
            mensaje, 
            `url`,
            `filename`,
            tipo_mensaje, 
            esContacto, 
            error_codigo, 
            error_mensaje, 
            phone_number_id, 
            tipo_producto,
            fecha_creacion, 
            `status`,
            config_whatsapp_other_id,
            nombre_whatsapp
        ) VALUES (
            '$wam_id', 
            '$id_chat_number', 
            '$from', 
            '$to', 
            '$mensaje', 
            '$url_archivo',
            '$filename',
            '$tipo_mensaje', 
            $esContacto, 
            '$errorCodigo', 
            '$errorMensaje', 
            '$phone_number_id', 
            'whatsapp',
            '$fechaActual', 
            '$status',
            '$config_whatsapp_other_id',
            '$nombre_whatsapp'
        )";

        $mysqli->query($sql); */

        $sql = "INSERT INTO chat_social (
            wam_id, 
            chat_number_id,
            `from`, 
            `to`, 
            mensaje, 
            `url`,
            `filename`,
            tipo_mensaje, 
            esContacto, 
            error_codigo, 
            error_mensaje, 
            phone_number_id, 
            tipo_producto,
            fecha_creacion, 
            `status`,
            config_whatsapp_other_id,
            nombre_whatsapp
        ) VALUES (
            ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?
        )";

        $stmt = $mysqli->prepare($sql);
    
        $stmt->bind_param(
            'sssssssssssssssss',
            $wam_id, 
            $id_chat_number, 
            $from, 
            $to, 
            $mensaje, 
            $url_archivo,
            $filename,
            $tipo_mensaje, 
            $esContacto, 
            $errorCodigo, 
            $errorMensaje, 
            $phone_number_id, 
            'whatsapp',
            $fechaActual, 
            $status,
            $config_whatsapp_other_id,
            $nombre_whatsapp
        );
 
        $stmt->execute();
        
        $stmt->close();

        // Confirmar la transacción
        $mysqli->commit();

        //$nombre                      = $row_crm_account['nombre'];
        //$email_custumers             = $row_crm_account['email_custumers'];
        //$phone_custumers             = $row_crm_account['phone_custumers'];
        //$company_custumers           = $row_crm_account['company_custumers'];
        //$address_custumers           = $row_crm_account['address_custumers'];

        return array(
            "id"                           => $id_chat_number,
            "number"                       => $to,
            "staff_id"                     => $staff_id,   
            "custumer_id"                  => $custumer_id,   
            "nombre"                       => $nombre,   
            "email_custumers"              => $email_custumers,   
            "phone_custumers"              => $phone_custumers,   
            "company_custumers"            => $company_custumers,   
            "address_custumers"            => $address_custumers,   
        );

    } catch (Exception $e) {
        // Revertir la transacción en caso de error
        $mysqli->rollback();
        return array(
            /* "id" => $result["id"],
            "number" => $result["number"], */
            "id" => "id_chat_numer:no encontrado",
            "number" => $to,
            "custumer_id"                  => $custumer_id,   
            "nombre"                       => $nombre,   
            "email_custumers"              => $email_custumers,   
            "phone_custumers"              => $phone_custumers,   
            "company_custumers"            => $company_custumers,   
            "address_custumers"            => $address_custumers,   
        );
    }

    //se crea el numero en caso de que no exista
    /* $sql = "INSERT INTO chat_number (`number`)
            SELECT '$to' 
            FROM DUAL
            WHERE NOT EXISTS (
                SELECT 1
                FROM chat_number
                WHERE `number` = '$to'
            );";

    $mysqli->query($sql); */
 
     

    //$result = $mysqli->query("SELECT * from chat_number where `to`='$to'")->fetch_assoc();
    
    $mysqli->close();

     
}


//creacion de imagen renderizada
function DimensionesImagen($imagen, $anchoCanvas, $altoCanvas, $anchoOriginal, $altoOriginal, $rutaGuardarImagen) {
    $escala = min($anchoCanvas / $anchoOriginal, $altoCanvas / $altoOriginal);
    $nuevoAncho = $anchoOriginal * $escala;
    $nuevoAlto = $altoOriginal * $escala;

    // Crear un canvas blanco de 500x500
    $canvas = imagecreatetruecolor($anchoCanvas, $altoCanvas);

    // Definir el color blanco
    $blanco = imagecolorallocate($canvas, 255, 255, 255);

    imagesavealpha($canvas, true);
    $transparente = imagecolorallocatealpha($canvas, 0, 0, 0, 127);

    // Rellenar el fondo del canvas con color blanco
    imagefill($canvas, 0, 0, $transparente);

    // Calcular las coordenadas para centrar la imagen en el canvas
    $x = ($anchoCanvas - $nuevoAncho) / 2;
    $y = ($altoCanvas - $nuevoAlto) / 2;

    // Redimensionar la imagen para que se ajuste al canvas
    $imagenRedimensionada = imagecreatetruecolor($nuevoAncho, $nuevoAlto);
    imagefill($imagenRedimensionada, 0, 0, $blanco);// si queremos trasparente quitamos esto
    imagecopyresampled($imagenRedimensionada, $imagen, 0, 0, 0, 0, $nuevoAncho, $nuevoAlto, $anchoOriginal, $altoOriginal);

    // Copiar la imagen redimensionada al centro del canvas
    imagecopy($canvas, $imagenRedimensionada, $x, $y, 0, 0, $nuevoAncho, $nuevoAlto);

    $seCreo = false;

    // Guardar el canvas con la imagen colocada
    if (imagepng($canvas, $rutaGuardarImagen)) {
        //echo "Canvas con imagen guardado correctamente en $rutaGuardarImagen";
        $seCreo = true;
    } else {
        //echo "Error al guardar el canvas con imagen.";
        $seCreo = false;
    }

    // Liberar la memoria utilizada por la imagen, el canvas y la imagen redimensionada
    imagedestroy($canvas);
    imagedestroy($imagen);
    imagedestroy($imagenRedimensionada);

    return $seCreo;
}

function guardar_archivos($nombre_directorio, $extencion, $binarios, $from, $to)
{
    $ruta_root = $_SERVER['DOCUMENT_ROOT'];   

    // Verificar si la ruta tiene una barra al final
    if (substr($ruta_root, -1) === '/') {
        // Si hay una barra al final, eliminarla
        $ruta_root = rtrim($ruta_root, '/');
    }

    $tipo_proyecto_produccion = APP_DIRECTORIO;

    $basePath = $ruta_root . "/$tipo_proyecto_produccion/storage/whatsapp/$nombre_directorio/";
    $path_db = "/storage/whatsapp/$nombre_directorio/";

    if (!file_exists($basePath))
    {
        mkdir($basePath, 0777, true);
        createHtmlFile($basePath."/index.html");
    } 

    $numero_aleatorio = rand(1, 1000000); 

    $formato = date('Y-m-d-H-i-s');
                        
    $nombre_archivo = $formato . "_" . $numero_aleatorio . "_from" . $from . "_to" . $to . "_recibido.$extencion";
    $folderPath = $basePath;

    $file = $folderPath . $nombre_archivo;

    $url_final = APP_URL . $path_db . $nombre_archivo;

    //si coloco file me estaria dando la direccion del archivo
    //$url = $url_final;

    file_put_contents($file, $binarios);

    return $url_final;
}

function reply_mensaje_texto($url, $wam_id, $texto, $to, $token)
{
    $data = array(
        "messaging_product" => "whatsapp",
        "recipient_type" => "individual",
        "to" => $to,
        "context" => array(
            "message_id" => $wam_id
        ),
        "type" => "text",
        "text" => array(
            "preview_url" => false,
            "body" => $texto
        )
    );

    $jsonData = json_encode($data);

    $curl = curl_init();

    curl_setopt_array($curl, array(
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'POST',
    CURLOPT_POSTFIELDS => $jsonData,
    CURLOPT_HTTPHEADER => array(
        'Content-Type: application/json',
        'Authorization: Bearer ' . $token,
    ),
    ));

    $response = curl_exec($curl);

    //$responseData = json_decode($response, true);
    //$messageId = $responseData['messages'][0]['id'];

    curl_close($curl);
}

function marcar_leidos($wam_id, $url,$token_acceso, $mysqli, $from, $to)
{
    // Datos a enviar en la solicitud
    $data = array(
        "messaging_product" => "whatsapp",
        "status" => "read",
        "message_id" => $wam_id
    );

    // Inicializar una sesión cURL
    $ch = curl_init($url);

    // Configurar opciones de cURL
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); // Retornar la transferencia como cadena del valor de curl_exec()
    curl_setopt($ch, CURLOPT_POST, true); // Establecer el método de solicitud a POST
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Authorization: Bearer ' . $token_acceso,
        'Content-Type: application/json'
    )); // Configurar las cabeceras HTTP

    // Codificar el array de datos como JSON
    $jsonData = json_encode($data);

    // Configurar el cuerpo de la solicitud
    curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);

    // Ejecutar la solicitud y obtener la respuesta
    $response = curl_exec($ch);

    //$inf = "";

    // Verificar si se produjo un error
    if (curl_errno($ch)) {
        //$inf =  curl_error($ch);
        //print_r(json_encode($inf)); 
    } else {
        // Imprimir la respuesta
        //$inf =   $response;
        //print_r(json_encode($inf)); 
        $mysqli->query("UPDATE chat_social SET `status`='read' WHERE `status`='delivered' AND `from`='$from' AND `to`='$to' AND esContacto=1");
    }

    // Cerrar la sesión cURL
    curl_close($ch);

    

}