// crm.datatable.js
let wp_table;
let crmLengthControlInjected = false;

function injectLengthControlStyles() {
    if (crmLengthControlInjected) { return; }
    const css = `
    .per-page-control { position: relative; display: inline-flex; align-items: center; margin-left: 10px; }
    .per-page-trigger { display: inline-flex; align-items: center; gap: 6px; padding: 6px 10px; border: 1px solid #d0d5dd; border-radius: 8px; background: #fff; cursor: pointer; font-size: 13px; color: #344054; }
    .per-page-trigger .caret { font-size: 11px; color: #667085; }
    .per-page-menu { position: absolute; top: 110%; right: 0; min-width: 160px; background: #fff; border: 1px solid #e4e7ec; border-radius: 10px; box-shadow: 0 10px 30px rgba(16, 24, 40, 0.12); padding: 8px; display: none; z-index: 20; }
    .per-page-option { display: flex; align-items: center; gap: 8px; padding: 6px 8px; border-radius: 6px; cursor: pointer; }
    .per-page-option:hover { background: #f2f4f7; }
    .per-page-option input { margin: 0; }
    .per-page-option.active { background: #eef2ff; }
    `;
    const styleTag = document.createElement('style');
    styleTag.id = 'crm-length-control-style';
    styleTag.textContent = css;
    document.head.appendChild(styleTag);
    crmLengthControlInjected = true;
}

function buildLengthControl(tableInstance, config) {
    if (!tableInstance) { return; }
    if (config.lengthControl === false) { return; }

    injectLengthControlStyles();

    const tableSelector = config.tableSelector || '#crm_table_records';
    const $wrapper = $(tableSelector).closest('.dataTables_wrapper');
    const $paging = $wrapper.find('.datatable-footer .datatable-paging');
    if (!$paging.length) { return; }

    $wrapper.find('.per-page-control').remove();

    const values = (Array.isArray(config.lengthMenu) && Array.isArray(config.lengthMenu[0])) ? config.lengthMenu[0] : [10, 25, 50, 100];
    const labels = (Array.isArray(config.lengthMenu) && Array.isArray(config.lengthMenu[1])) ? config.lengthMenu[1] : [];

    const $control = $('<div class="per-page-control" id="per-page-control"></div>');
    const $trigger = $('<button type="button" class="per-page-trigger"><span class="per-page-value"></span><span class="caret">&#9662;</span></button>');
    const $menu = $('<div class="per-page-menu"></div>');

    const currentLen = tableInstance.page.len();
    $trigger.find('.per-page-value').text((labels[values.indexOf(currentLen)] || (currentLen + ' per page')));

    values.forEach(function (opt, idx) {
        const label = labels[idx] || (opt + ' per page');
        const isActive = opt === currentLen;
        const $item = $('<div class="per-page-option"></div>');
        if (isActive) { $item.addClass('active'); }
        const id = 'per-page-' + opt;
        $item.append('<input type="checkbox" ' + (isActive ? 'checked' : '') + ' id="' + id + '">');
        $item.append('<label for="' + id + '">' + label + '</label>');
        $item.on('click', function (e) {
            e.stopPropagation();
            tableInstance.page.len(opt).draw(false);
            $trigger.find('.per-page-value').text(label);
            $menu.find('.per-page-option').removeClass('active').find('input').prop('checked', false);
            $item.addClass('active').find('input').prop('checked', true);
            $menu.hide();
        });
        $menu.append($item);
    });

    $trigger.on('click', function (e) {
        e.stopPropagation();
        $menu.toggle();
    });

    $(document).off('click.crmLengthControl').on('click.crmLengthControl', function () {
        $('.per-page-menu').hide();
    });

    $control.append($trigger).append($menu);
    $paging.prepend($control);
}

// global functions
function renderImage(data, type, row) {
    if (type === 'display') {
        let config = window.crmDataTableConfig || {};

        if (row.logo_url !== "-") {
            let pathStorage = config.paths?.storage || '';
            return `<img height="40" src="${pathStorage}${row.logo_url}"
                    onerror="this.src='${config.paths?.base}/ui/theme/default/img/perfil.jpg';">`;
        } else {
            return `<img height="40" src="${config.paths?.base}/ui/theme/default/img/perfil.jpg">`;
            //return `<span class="clx-avatar">${row.company_name ? row.company_name[0] : '?'}</span>`;
        }        
    }
    return data;
}
function renderCell(data, type, row) {
    if(type === 'display') {
        return `<span>${row.id}</span>`;
    }
    return data; // para sort y filter
}
function renderCodeItem(data, type, row) {
    if (type === 'display') {
        const config = window.crmDataTableConfig || {};
        const pathTemplate = config.paths?.view || '';
        const url = pathTemplate.replace('[[id]]', row.id);

        const code = row.code || 'N/A';
        return `<a class="h6" href="${url}"><strong>${code}</strong></a>`;
    }
    return data;
}


$(function() {

    // Configuración global inyectada desde el template
    const config = window.crmDataTableConfig || {};
    const baseUrl = config.baseUrl || '';
    const translations = config.translations || {};
    const ajaxUrl = config.ajaxUrl || '';
    const tableSelector = config.tableSelector || '#crm_table_records';

    let downloadButtons = [
		{
			extend: 'copyHtml5',
			titleAttr: 'Copy to clipboard',
			text: '<svg xmlns="http://www.w3.org/2000/svg" height="25" width="25" viewBox="0 0 55.699 55.699" version="1.1" xml:space="preserve"><g><path fill="#667085" d="M51.51,18.001c-0.006-0.085-0.022-0.167-0.05-0.248c-0.012-0.034-0.02-0.067-0.035-0.1   c-0.049-0.106-0.109-0.206-0.194-0.291v-0.001l0,0c0,0-0.001-0.001-0.001-0.002L34.161,0.293c-0.086-0.087-0.188-0.148-0.295-0.197   c-0.027-0.013-0.057-0.02-0.086-0.03c-0.086-0.029-0.174-0.048-0.265-0.053C33.494,0.011,33.475,0,33.453,0H22.177   c-3.678,0-6.669,2.992-6.669,6.67v1.674h-4.663c-3.678,0-6.67,2.992-6.67,6.67V49.03c0,3.678,2.992,6.669,6.67,6.669h22.677   c3.677,0,6.669-2.991,6.669-6.669v-1.675h4.664c3.678,0,6.669-2.991,6.669-6.669V18.069C51.524,18.045,51.512,18.025,51.51,18.001z    M34.454,3.414l13.655,13.655h-8.985c-2.575,0-4.67-2.095-4.67-4.67V3.414z M38.191,49.029c0,2.574-2.095,4.669-4.669,4.669H10.845   c-2.575,0-4.67-2.095-4.67-4.669V15.014c0-2.575,2.095-4.67,4.67-4.67h5.663h4.614v10.399c0,3.678,2.991,6.669,6.668,6.669h10.4   v18.942L38.191,49.029L38.191,49.029z M36.777,25.412h-8.986c-2.574,0-4.668-2.094-4.668-4.669v-8.985L36.777,25.412z    M44.855,45.355h-4.664V26.412c0-0.023-0.012-0.044-0.014-0.067c-0.006-0.085-0.021-0.167-0.049-0.249   c-0.012-0.033-0.021-0.066-0.036-0.1c-0.048-0.105-0.109-0.205-0.194-0.29l0,0l0,0c0-0.001-0.001-0.002-0.001-0.002L22.829,8.637   c-0.087-0.086-0.188-0.147-0.295-0.196c-0.029-0.013-0.058-0.021-0.088-0.031c-0.086-0.03-0.172-0.048-0.263-0.053   c-0.021-0.002-0.04-0.013-0.062-0.013h-4.614V6.67c0-2.575,2.095-4.67,4.669-4.67h10.277v10.4c0,3.678,2.992,6.67,6.67,6.67h10.399   v21.616C49.524,43.26,47.429,45.355,44.855,45.355z"/></g></svg>',
			className: 'button'
		},
		{
			extend: 'csvHtml5',
			titleAttr: 'Generate CSV',
			text: '<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 548.29 548.291" fill="#4CAF50" version="1.1" xml:space="preserve"><g><path fill="#4CAF50" d="M486.2,196.121h-13.164V132.59c0-0.399-0.064-0.795-0.116-1.2c-0.021-2.52-0.824-5-2.551-6.96L364.656,3.677   c-0.031-0.034-0.064-0.044-0.085-0.075c-0.629-0.707-1.364-1.292-2.141-1.796c-0.231-0.157-0.462-0.286-0.704-0.419   c-0.672-0.365-1.386-0.672-2.121-0.893c-0.199-0.052-0.377-0.134-0.576-0.188C358.229,0.118,357.4,0,356.562,0H96.757   C84.893,0,75.256,9.649,75.256,21.502v174.613H62.093c-16.972,0-30.733,13.756-30.733,30.73v159.81   c0,16.966,13.761,30.736,30.733,30.736h13.163V526.79c0,11.854,9.637,21.501,21.501,21.501h354.777   c11.853,0,21.502-9.647,21.502-21.501V417.392H486.2c16.966,0,30.729-13.764,30.729-30.731v-159.81   C516.93,209.872,503.166,196.121,486.2,196.121z M96.757,21.502h249.053v110.006c0,5.94,4.818,10.751,10.751,10.751h94.973v53.861   H96.757V21.502z M258.618,313.18c-26.68-9.291-44.063-24.053-44.063-47.389c0-27.404,22.861-48.368,60.733-48.368   c18.107,0,31.447,3.811,40.968,8.107l-8.09,29.3c-6.43-3.107-17.862-7.632-33.59-7.632c-15.717,0-23.339,7.149-23.339,15.485   c0,10.247,9.047,14.769,29.78,22.632c28.341,10.479,41.681,25.239,41.681,47.874c0,26.909-20.721,49.786-64.792,49.786   c-18.338,0-36.449-4.776-45.497-9.77l7.38-30.016c9.772,5.014,24.775,10.006,40.264,10.006c16.671,0,25.488-6.908,25.488-17.396   C285.536,325.789,277.909,320.078,258.618,313.18z M69.474,302.692c0-54.781,39.074-85.269,87.654-85.269   c18.822,0,33.113,3.811,39.549,7.149l-7.392,28.816c-7.38-3.084-17.632-5.939-30.491-5.939c-28.822,0-51.206,17.375-51.206,53.099   c0,32.158,19.051,52.4,51.456,52.4c10.947,0,23.097-2.378,30.241-5.238l5.483,28.346c-6.672,3.34-21.674,6.919-41.208,6.919   C98.06,382.976,69.474,348.424,69.474,302.692z M451.534,520.962H96.757v-103.57h354.777V520.962z M427.518,380.583h-42.399   l-51.45-160.536h39.787l19.526,67.894c5.479,19.046,10.479,37.386,14.299,57.397h0.709c4.048-19.298,9.045-38.352,14.526-56.693   l20.487-68.598h38.599L427.518,380.583z"/></g></svg>',
			className: 'button'
		},
		{
			extend: 'excelHtml5',
			titleAttr: 'Generate Excel',
			text: '<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 550.801 550.801" fill="#009688" version="1.1" xml:space="preserve"><g><path fill="#009688" d="M488.432,197.019h-13.226v-63.816c0-0.398-0.063-0.799-0.111-1.205c-0.021-2.531-0.833-5.021-2.568-6.992L366.325,3.694   c-0.032-0.031-0.063-0.042-0.085-0.076c-0.633-0.707-1.371-1.295-2.151-1.804c-0.231-0.155-0.464-0.285-0.706-0.422   c-0.676-0.366-1.393-0.675-2.131-0.896c-0.2-0.053-0.38-0.135-0.58-0.188C359.87,0.119,359.037,0,358.193,0H97.2   c-11.918,0-21.6,9.693-21.6,21.601v175.413H62.377c-17.049,0-30.873,13.818-30.873,30.873v160.545   c0,17.038,13.824,30.87,30.873,30.87h13.224V529.2c0,11.907,9.682,21.601,21.6,21.601h356.4c11.907,0,21.6-9.693,21.6-21.601   V419.302h13.226c17.044,0,30.871-13.827,30.871-30.87v-160.54C519.297,210.832,505.48,197.019,488.432,197.019z M97.2,21.601   h250.193v110.51c0,5.967,4.841,10.8,10.8,10.8h95.407v54.108H97.2V21.601z M339.562,354.344v31.324H236.509V220.704h37.46v133.64   H339.562z M74.25,385.663l47.73-83.458l-46.019-81.501h42.833l14.439,30.099c4.899,10.03,8.572,18.116,12.49,27.414h0.483   c3.926-10.529,7.101-17.872,11.259-27.414l13.954-30.099h42.588l-46.509,80.525l48.961,84.438h-43.081l-14.929-29.858   c-6.115-11.507-10.036-20.07-14.684-29.615h-0.49c-3.431,9.55-7.583,18.119-12.722,29.615l-13.711,29.858H74.25V385.663z    M453.601,523.353H97.2V419.302h356.4V523.353z M401.963,388.125c-18.837,0-37.446-4.904-46.738-10.04l7.578-30.839   c10.04,5.136,25.46,10.283,41.375,10.283c17.139,0,26.188-7.099,26.188-17.867c0-10.283-7.831-16.157-27.659-23.256   c-27.411-9.55-45.282-24.722-45.282-48.718c0-28.15,23.498-49.684,62.427-49.684c18.594,0,32.305,3.927,42.093,8.322l-8.322,30.109   c-6.607-3.186-18.361-7.834-34.509-7.834c-16.152,0-23.983,7.338-23.983,15.913c0,10.525,9.291,15.18,30.591,23.258   c29.125,10.769,42.836,25.936,42.836,49.191C468.545,364.627,447.257,388.125,401.963,388.125z"/></g></svg>',
			className: 'button'
		},
		{
			extend: 'pdfHtml5',			
			titleAttr: 'Generate PDF',
			text: '<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 550.801 550.801" fill="#f44336" version="1.1" xml:space="preserve"><g><path fill="#f72015" d="M160.381,282.225c0-14.832-10.299-23.684-28.474-23.684c-7.414,0-12.437,0.715-15.071,1.432V307.6   c3.114,0.707,6.942,0.949,12.192,0.949C148.419,308.549,160.381,298.74,160.381,282.225z"/><path d="M272.875,259.019c-8.145,0-13.397,0.717-16.519,1.435v105.523c3.116,0.729,8.142,0.729,12.69,0.729   c33.017,0.231,54.554-17.946,54.554-56.474C323.842,276.719,304.215,259.019,272.875,259.019z"/><path d="M488.426,197.019H475.2v-63.816c0-0.398-0.063-0.799-0.116-1.202c-0.021-2.534-0.827-5.023-2.562-6.995L366.325,3.694   c-0.032-0.031-0.063-0.042-0.085-0.076c-0.633-0.707-1.371-1.295-2.151-1.804c-0.231-0.155-0.464-0.285-0.706-0.419   c-0.676-0.369-1.393-0.675-2.131-0.896c-0.2-0.056-0.38-0.138-0.58-0.19C359.87,0.119,359.037,0,358.193,0H97.2   c-11.918,0-21.6,9.693-21.6,21.601v175.413H62.377c-17.049,0-30.873,13.818-30.873,30.873v160.545   c0,17.043,13.824,30.87,30.873,30.87h13.224V529.2c0,11.907,9.682,21.601,21.6,21.601h356.4c11.907,0,21.6-9.693,21.6-21.601   V419.302h13.226c17.044,0,30.871-13.827,30.871-30.87v-160.54C519.297,210.838,505.47,197.019,488.426,197.019z M97.2,21.605   h250.193v110.513c0,5.967,4.841,10.8,10.8,10.8h95.407v54.108H97.2V21.605z M362.359,309.023c0,30.876-11.243,52.165-26.82,65.333   c-16.971,14.117-42.82,20.814-74.396,20.814c-18.9,0-32.297-1.197-41.401-2.389V234.365c13.399-2.149,30.878-3.346,49.304-3.346   c30.612,0,50.478,5.508,66.039,17.226C351.828,260.69,362.359,280.547,362.359,309.023z M80.7,393.499V234.365   c11.241-1.904,27.042-3.346,49.296-3.346c22.491,0,38.527,4.308,49.291,12.928c10.292,8.131,17.215,21.534,17.215,37.328   c0,15.799-5.25,29.198-14.829,38.285c-12.442,11.728-30.865,16.996-52.407,16.996c-4.778,0-9.1-0.243-12.435-0.723v57.67H80.7   V393.499z M453.601,523.353H97.2V419.302h356.4V523.353z M484.898,262.127h-61.989v36.851h57.913v29.674h-57.913v64.848h-36.593   V232.216h98.582V262.127z"/></g></svg>',
			className: 'button'
		},
		{
			extend: 'print',
			titleAttr: 'Print Table',
			text: '<svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 512 512" version="1.1" xml:space="preserve"><g><rect x="168.084" y="335.709" fill="#667085"/><rect x="168.084" y="387.871" fill="#667085" width="175.831" height="20.29"/><rect x="168.084" y="434.242" fill="#667085" width="83.085" height="20.29"/><path fill="#667085" d="M488.338,163.731c-8.009-8.029-19.199-13.028-31.44-13.028h-47.304V78.276L331.319,0h-4.798H102.405v150.703   H55.102c-12.253,0-23.44,5-31.448,13.028c-8.02,8.013-13.02,19.199-13.012,31.436v169.958   c-0.008,12.245,4.983,23.432,13.012,31.453c8.017,8.012,19.208,13.02,31.448,13.004h47.303V512h307.189V409.582h47.304   c12.233,0.016,23.419-4.992,31.428-13.004c8.033-7.996,13.04-19.2,13.033-31.453V195.168   C501.366,182.922,496.359,171.744,488.338,163.731z M324.587,26.048l57.024,57.041h-57.024V26.048z M386.409,488.819H125.59V398   h-0.012v-94.655H386.4v106.238h0.008V488.819z M335.813,230.287c0-9.216,7.475-16.679,16.675-16.679   c9.216,0,16.679,7.463,16.679,16.679c0,9.208-7.463,16.671-16.679,16.671C343.289,246.958,335.813,239.495,335.813,230.287z    M386.409,150.703H125.59V23.189h175.811v83.074h85.007V150.703z M423.467,246.958c-9.204,0-16.667-7.463-16.667-16.671   c0-9.216,7.463-16.679,16.667-16.679c9.212,0,16.675,7.463,16.675,16.679C440.142,239.495,432.679,246.958,423.467,246.958z"/></g></svg>',
			className: 'button'
		}
	];

    const buttonsConfig = Array.isArray(config.buttons)
        ? config.buttons
        : (config.buttons === false ? [] : downloadButtons);

    const domLayout = (buttonsConfig && buttonsConfig.length)
        ? `<'datatable-header ... <'datatable-buttons'B> > ...`
        : `<'datatable-header d-flex flex-wrap align-items-center justify-content-between mb-3' <'datatable-search'f> > ...`;



    /*const actionModes = {
        view: {
            url: 'contacts/view/[[id]]',
            tooltip: "View",
            svg: `<svg class="fill-current" width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M8.0254 6.17845C8.0254 4.90629 9.05669 3.875 10.3289 3.875C11.601 3.875 12.6323 4.90629 12.6323 6.17845C12.6323 7.45061 11.601 8.48191 10.3289 8.48191C9.05669 8.48191 8.0254 7.45061 8.0254 6.17845ZM10.3289 2.375C8.22827 2.375 6.5254 4.07786 6.5254 6.17845C6.5254 8.27904 8.22827 9.98191 10.3289 9.98191C12.4294 9.98191 14.1323 8.27904 14.1323 6.17845C14.1323 4.07786 12.4294 2.375 10.3289 2.375ZM8.92286 11.03C5.7669 11.03 3.2085 13.5884 3.2085 16.7444V17.0333C3.2085 17.4475 3.54428 17.7833 3.9585 17.7833C4.37271 17.7833 4.7085 17.4475 4.7085 17.0333V16.7444C4.7085 14.4169 6.59533 12.53 8.92286 12.53H11.736C14.0635 12.53 15.9504 14.4169 15.9504 16.7444V17.0333C15.9504 17.4475 16.2861 17.7833 16.7004 17.7833C17.1146 17.7833 17.4504 17.4475 17.4504 17.0333V16.7444C17.4504 13.5884 14.8919 11.03 11.736 11.03H8.92286Z" fill=""></path>
                </svg>`
        },
        edit: {
            url: 'contacts/view/[[id]]/edit',
            tooltip: "Edit",
            svg: `<svg class="fill-current" width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M17.0911 3.53206C16.2124 2.65338 14.7878 2.65338 13.9091 3.53206L5.6074 11.8337C5.29899 12.1421 5.08687 12.5335 4.99684 12.9603L4.26177 16.445C4.20943 16.6931 4.286 16.9508 4.46529 17.1301C4.64458 17.3094 4.90232 17.3859 5.15042 17.3336L8.63507 16.5985C9.06184 16.5085 9.45324 16.2964 9.76165 15.988L18.0633 7.68631C18.942 6.80763 18.942 5.38301 18.0633 4.50433L17.0911 3.53206ZM14.9697 4.59272C15.2626 4.29982 15.7375 4.29982 16.0304 4.59272L17.0027 5.56499C17.2956 5.85788 17.2956 6.33276 17.0027 6.62565L16.1043 7.52402L14.0714 5.49109L14.9697 4.59272ZM13.0107 6.55175L6.66806 12.8944C6.56526 12.9972 6.49455 13.1277 6.46454 13.2699L5.96704 15.6283L8.32547 15.1308C8.46772 15.1008 8.59819 15.0301 8.70099 14.9273L15.0436 8.58468L13.0107 6.55175Z" fill=""></path>
                </svg>`
        },
        delete: {
            url: 'contacts/delete/[[id]]',
            tooltip: "Delete",
            svg: `<svg class="fill-current" width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M7.04142 4.29199C7.04142 3.04935 8.04878 2.04199 9.29142 2.04199H11.7081C12.9507 2.04199 13.9581 3.04935 13.9581 4.29199V4.54199H16.1252H17.166C17.5802 4.54199 17.916 4.87778 17.916 5.29199C17.916 5.70621 17.5802 6.04199 17.166 6.04199H16.8752V8.74687V13.7469V16.7087C16.8752 17.9513 15.8678 18.9587 14.6252 18.9587H6.37516C5.13252 18.9587 4.12516 17.9513 4.12516 16.7087V13.7469V8.74687V6.04199H3.8335C3.41928 6.04199 3.0835 5.70621 3.0835 5.29199C3.0835 4.87778 3.41928 4.54199 3.8335 4.54199H4.87516H7.04142V4.29199ZM15.3752 13.7469V8.74687V6.04199H13.9581H13.2081H7.79142H7.04142H5.62516V8.74687V13.7469V16.7087C5.62516 17.1229 5.96095 17.4587 6.37516 17.4587H14.6252C15.0394 17.4587 15.3752 17.1229 15.3752 16.7087V13.7469ZM8.54142 4.54199H12.4581V4.29199C12.4581 3.87778 12.1223 3.54199 11.7081 3.54199H9.29142C8.87721 3.54199 8.54142 3.87778 8.54142 4.29199V4.54199ZM8.8335 8.50033C9.24771 8.50033 9.5835 8.83611 9.5835 9.25033V14.2503C9.5835 14.6645 9.24771 15.0003 8.8335 15.0003C8.41928 15.0003 8.0835 14.6645 8.0835 14.2503V9.25033C8.0835 8.83611 8.41928 8.50033 8.8335 8.50033ZM12.9168 9.25033C12.9168 8.83611 12.581 8.50033 12.1668 8.50033C11.7526 8.50033 11.4168 8.83611 11.4168 9.25033V14.2503C11.4168 14.6645 11.7526 15.0003 12.1668 15.0003C12.581 15.0003 12.9168 14.6645 12.9168 14.2503V9.25033Z" fill=""></path>
                </svg>`,
            confirm: true
        }
    };*/

    /*function actions(data, type, row) {
        if (type !== 'display') return row.id;

        const cfg = window.crmDataTableConfig || {};
        const config = cfg.actions || {};
        const baseUrl = cfg.baseUrl || '';

        const buttons = Object.keys(config)
            .map(key => {
                const action = config[key];
                const url = action.url.replace('[[id]]', row.id);
                const tooltip = action.tooltip || key;
                const svg = action.svg || '';

                if (action.confirm) {
                    return `
                        <a href="#" 
                            onclick="confirmThenGoToUrl(event, '${baseUrl}${url}')" 
                            class="btn btn-icon me-2" 
                            data-bs-toggle="tooltip" 
                            data-placement="top" 
                            title="${tooltip}">
                            ${svg}
                        </a>`;
                }

                return `
                    <a href="${baseUrl}${url}" 
                        class="btn btn-icon me-2" 
                        data-bs-toggle="tooltip" 
                        data-placement="top" 
                        title="${tooltip}">
                        ${svg}
                    </a>`;
            })
            .join('');

        return `<div class="float-end d-flex">${buttons}</div>`;
    }*/

    const enableControlCol = config.responsiveControl !== false;
    const responsiveOpts = enableControlCol ? { details: { type: 'column' } } : false;
    const columnDefsOpts = enableControlCol ? [{ className: 'control', orderable: false, targets: 0 }] : [];
    const defaultOrder = enableControlCol ? [[1, 'asc']] : [[0, 'asc']];


    // Inicialización del DataTable
    wp_table = $(tableSelector).DataTable({
        dom: `
            <'datatable-header d-flex flex-wrap align-items-center justify-content-between mb-3'
                <'datatable-search'f>
                <'datatable-buttons'B>
            >
            <'table-container datatable-wrapper'tr>
            <'datatable-footer d-flex flex-wrap align-items-center justify-content-between mt-3'
                <'datatable-info'i>
                <'datatable-paging'p>
            >
        `,
        buttons: buttonsConfig,
        lengthMenu: config.lengthMenu || [[10, 25, 50, 100], [10, 25, 50, 100]],
        pageLength: config.pageLength || 10,
        language: {
            emptyTable: translations.noItems || "No items to display",
            info: translations.showing || "Showing _START_ to _END_ of _TOTAL_ entries",
            infoEmpty: translations.showing0 || "Showing 0 to 0 of 0 entries",
            search: "",
            searchPlaceholder: translations.searchPlaceholder || "Search...",
            paginate: {
                first: "«",
                last: "»",
                next: "›",
                previous: "‹"
            }
        },
        responsive: responsiveOpts,
		columnDefs: columnDefsOpts,
        autoWidth: false,
		processing: false,
		serverSide: false,
		info: true,
		order: defaultOrder,
        columns: (config.columns || [])/*.concat([
            { data: 'id', render: actions }
        ])*/
    });

    buildLengthControl(wp_table, config);

    if (ajaxUrl) {
        dataTable_init();
    }

    function dataTable_init() {
		$.post(ajaxUrl)
			.done(function(response) {
				//wp_table = $(tableSelector).DataTable();
				wp_table.clear();

                //console.log("API response", ajaxUrl);
				
				$.each(response.data, function (k, item) {
                    Object.keys(item).forEach(function(key) {
                        if (item[key] === null || item[key] === undefined || item[key] === "") {
                            item[key] = "-";
                        }
                    });

					wp_table.row.add(item);
				});

				wp_table.draw();
				wp_table.columns.adjust().responsive.recalc();
                buildLengthControl(wp_table, config);

		}).fail( function(jqXHR, textStatus, errorThrown) {

		});
	}

    // Filtros por columna
    function filterColumn (i) {
        wp_table
        .columns( i )
        .search($('#col'+i+'_filter').val(), true, false)
        .draw();
    }

    $('input.column_filter').on('keyup', function () {
        var columnData = $(this).data('column');
        filterColumn(columnData);
    } );

    // Abrir - cerrar sección de filtros
    $(document).on('click', '#addfilter', function() {
        $('#filtercam').show();
        $("#addfilter").remove();
        $('#crm_table_records_filter').append('<button class="button" id="closefilter">Close Filters</button>');
    });

    $(document).on('click', '#closefilter', function() {
        $('#filtercam').hide();
        $("#closefilter").remove();
        $('#crm_table_records_filter').append(`
			<button class="button" id="addfilter">
				<svg class="stroke-current fill-white dark:fill-gray-800" width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path d="M2.29004 5.90393H17.7067" stroke="" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
					<path d="M17.7075 14.0961H2.29085" stroke="" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
					<path d="M12.0826 3.33331C13.5024 3.33331 14.6534 4.48431 14.6534 5.90414C14.6534 7.32398 13.5024 8.47498 12.0826 8.47498C10.6627 8.47498 9.51172 7.32398 9.51172 5.90415C9.51172 4.48432 10.6627 3.33331 12.0826 3.33331Z" fill="" stroke="" stroke-width="1.5"></path>
					<path d="M7.91745 11.525C6.49762 11.525 5.34662 12.676 5.34662 14.0959C5.34661 15.5157 6.49762 16.6667 7.91745 16.6667C9.33728 16.6667 10.4883 15.5157 10.4883 14.0959C10.4883 12.676 9.33728 11.525 7.91745 11.525Z" fill="" stroke="" stroke-width="1.5"></path>
				</svg>
				Advanced Filters
			</button>
		`);
    });

    const $filterCam = $('#filtercam');
	if ($filterCam.length) {
		$filterCam.hide();
		$('#crm_table_records_filter').append(`
			<button class="button" id="addfilter">
				<svg class="stroke-current fill-white dark:fill-gray-800" width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
					<path d="M2.29004 5.90393H17.7067" stroke="" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
					<path d="M17.7075 14.0961H2.29085" stroke="" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
					<path d="M12.0826 3.33331C13.5024 3.33331 14.6534 4.48431 14.6534 5.90414C14.6534 7.32398 13.5024 8.47498 12.0826 8.47498C10.6627 8.47498 9.51172 7.32398 9.51172 5.90415C9.51172 4.48432 10.6627 3.33331 12.0826 3.33331Z" fill="" stroke="" stroke-width="1.5"></path>
					<path d="M7.91745 11.525C6.49762 11.525 5.34662 12.676 5.34662 14.0959C5.34661 15.5157 6.49762 16.6667 7.91745 16.6667C9.33728 16.6667 10.4883 15.5157 10.4883 14.0959C10.4883 12.676 9.33728 11.525 7.91745 11.525Z" fill="" stroke="" stroke-width="1.5"></path>
				</svg>
				Advanced Filters
			</button>
		`);

		// Toggle boton filtros
		$(document).on('click', '#addfilter', function (e) {
			e.preventDefault();
			$filterCam.show();
		});
	}

    // Redireccion por select de grupo
    const select_group_id = document.getElementById('select_group_id');
    if (select_group_id) {
        select_group_id.addEventListener('change', function () {
            const config = window.crmDataTableConfig || {};
            const pathTemplate = config.paths?.groupList || '';
            const group_id = this.value;

            if (group_id && group_id !== "0") {
                const targetUrl = pathTemplate.endsWith('/')
                    ? `${pathTemplate}${group_id}`
                    : `${pathTemplate}/${group_id}`;
                window.location.href = targetUrl;
            } else {
                window.location.href = pathTemplate;
            }

        });
    }

    // Callback on init complete
    if (typeof config.onInitComplete === 'function') {
        wp_table.on('init', function() {
            config.onInitComplete(wp_table);
        });
    }

});
