{extends file="$layouts_admin"}
{block name="head"}




{/block}

{block name="content"}

<style type="text/css">

    .list-group{
        max-height: 150px;
        margin-bottom: 10px;
        overflow:scroll;
        -webkit-overflow-scrolling: touch;
    }    

</style>
<div class="row">

    <div class="col-md-12">

         <input type="text" readonly hidden  class="form-control tener_url_base" value="{$url_base}">
         
 
        <div class="panel">
            <div class="panel-hdr">
                <h2><span></span>Add Config Email</h2>

            </div>

            <div class="panel-container show" id="ibox_form">

                <div class="panel-content">

                    <div class="px-2">
                        <div class="alert alert-danger" id="emsg" style="display: none;">
                            <span id="emsgbody"></span>
                        </div>

                        <div class="alert alert-success" id="emsgSuccess" style="display: none;">
                            <span id="emsgbodySuccess"></span>
                        </div>

                        <form id="rform">

                            <div class="row">

                            
                                <div class="col-md-6 col-sm-12">

                                    <div class="mb-3 row">
                                        <label for="identificador" class="col-sm-3"><span class="h6">Identifier</span><span class="text-danger">*</span></label>
                                        <div class="col-sm-9">
                                            <input type="text" id="identificador" name="identificador" class="form-control tener_identificador" autofocus>
                                        </div>
                                    </div>

                                    <div class="mb-3 row">
                                        <label for="email" class="col-sm-3"><span class="h6">Email</span><span class="text-danger">*</span></label>
                                        <div class="col-sm-9">
                                            <input type="text" id="phone_ws" name="email" class="form-control tener_email" autofocus>
                                        </div>
                                    </div>

                                     
                                    <div class="mb-3 row">
                                        <label for="status" class="col-sm-3"><span class="h6">Status</span><span class="text-danger"></span> </label>
                                        <div class="col-sm-9">
                                            <select name="status" id="status" class="form-control tener_status">
                                                <option value="1">Active</option>
                                                <option value="2">Inactive</option>
                                            </select>
                                        </div>
                                    </div>
                                    
 
                                </div>


                                <div class="col-md-6 col-sm-12">
                                    <div class="mb-3 row">
                                        <label for="token" class="col-sm-3"><span class="h6">Token</span><span class="text-danger">*</span></label>
                                        <div class="col-sm-9">
                                            <input type="text" id="token" name="token" class="form-control tener_token" autofocus>
                                        </div>
                                    </div>

  
                                    <div class="mb-3 row">
                                        <label for="nombre" class="col-sm-3"><span class="h6">Name</span><span class="text-danger">*</span> </label>
                                        <div class="col-sm-9">
                                            <input type="text" id="nombre" name="nombre" class="form-control tener_nombre">
                                        </div>
                                    </div>

                           
                                    
                                </div>

                             
 
 
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="mb-3">


                                        <button class="btn btn-primary mt-3 me-3" type="submit" id="submit">{$_L['Save']}</button>


                                    </div>
                                </div>
                            </div>


                        </form>

                       
                    </div>

                  

                </div>
 
                <div class="block bloqueo_v1" style="display:none" hidden></div>
                <div class="block blockOverlay bloqueo_v2" hidden style="z-index: 1000; border: none; margin: 0px; padding: 0px; width: 100%; height: 100%; top: 0px; left: 0px; background-color: rgb(0, 0, 0); opacity: 0.6; cursor: wait; position: absolute;" ></div>
                <div
                    class="block blockMsg blockElement bloqueo_v3"
                    hidden
                    style="
                        z-index: 1011;
                        position: absolute;
                        padding: 0px;
                        margin: 0px;
                        width: 100%;
                        top: 370px;
                         
                        text-align: center;
                        color: rgb(0, 0, 0);
                        cursor: wait;
                    "
                    >
                     
                    <div class="md-preloader text-center">
                        <svg
                            xmlns="http://www.w3.org/2000/svg"
                            version="1.1"
                            height="32"
                            width="32"
                            viewBox="0 0 75 75"
                        >
                            <circle cx="37.5" cy="37.5" r="33.5" stroke-width="6"></circle>
                        </svg>
                    </div>

                     <div class="text-center mt-6" style="
                                                                color: white;
                                                                font-weight: 600;
                                                                font-size: 15px;
                                                            ">
                                    No actualice ni cierre la ventana. Espere el mensaje de confirmación. No actualice ni cierre la ventana.                    
                        </div>
                </div>

               
            </div>
        </div>
    </div>
</div>




{/block}

{block name="script"}

{literal}
<script>

     var url_base   = $(".tener_url_base").val();

 
    var baseImagen = "";

    $(document).ready(function () {


        $("#submit").click(function (e) {
            e.preventDefault();
 

            let tener_identificador     = $(".tener_identificador").val();
            let tener_email          = $(".tener_email").val();
            let tener_status = $(".tener_status").val();
            let tener_token       = $(".tener_token").val();
            let tener_nombre       = $(".tener_nombre").val();
 

            if(isEmpty(tener_identificador) == true)
            {
                toastr.error("!The identifier is required¡");
                return;
            }     

            if(isEmpty(tener_email) == true)
            {
                toastr.error("!Email is required¡");
                return;
            }      

            if(isEmpty(tener_status) == true)
            {
                toastr.error("!Status is required¡");
                return;
            }   

            if(isEmpty(tener_token) == true)
            {
                toastr.error("!Token is required¡");
                return;
            }   

            if(isEmpty(tener_nombre) == true)
            {
                toastr.error("!Name is required¡");
                return;
            }   

            var regex = /^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/;
 
            if(regex.test(tener_email) == false)
            {
                toastr.error("!Email is invalid¡");
                return;
            }   

            $('#ibox_form').block({ message:block_msg });
       
            //console.log(base_url + 'parnerts/add-parnert-post/');
            //console.log($( "#rform" ).serialize());
 
            var informacionEnviar = {
                identificador:   tener_identificador,
                email:           tener_email,
                status:          tener_status,
                token:           tener_token,
                nombre:          tener_nombre,
                
            }; 
    
    
            //console.log(JSON.stringify(informacionEnviar));
            //return;

            //return;

            $.post(url_base + 'social/post-add-config-email/', JSON.stringify(informacionEnviar)  ) //$( "#rform" ).serialize()
            .done(function (data) {
                 
                    //console.log(data);
                    //console.log(data);
                    //return;


                    $('#ibox_form').unblock();

                     try {
                         const info = JSON.parse(data);
                       
                        if( info.type == "success")
                        {
                            //$('#ibox_form').unblock();
                            toastr.success(info.message);
 
                           setTimeout(function() {
                                window.location = info.redirect;
                            }, 1000);
                        }else{
                            //$('#ibox_form').unblock();
                            var body = $("html, body");
                            body.animate({ scrollTop:0 }, '1000', 'swing');
                            $("#emsgbody").html(info.message);
                            $("#emsg").show("slow");
                        }
                    } catch (error) {
                        //$('#ibox_form').unblock();
                        var body = $("html, body");
                        body.animate({ scrollTop:0 }, '1000', 'swing');
                        $("#emsgbody").html(data);
                        $("#emsg").show("slow");
                    }
            });
        });


    });

 
    function isEmpty(value) {
        // Verificar si es null o undefined
        if (value == null) return true;

        // Verificar si es una cadena vacía
        if (typeof value === "string" && value.trim() === "") return true;

        // Verificar si es un array vacío
        if (Array.isArray(value) && value.length === 0) return true;

        // Verificar si es un objeto vacío
        if (typeof value === "object" && Object.keys(value).length === 0) return true;

        return false;
    }

 
    function validarSoloNumeros(input) {
        const number = parseInt(input, 10);
        return !isNaN(number) && number.toString() === input;
    }

 
 
</script>
{/literal}

{/block}