{extends file="$layouts_admin"}
{block name="head"}

  
   <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css">       



{/block}

{block name="content"}

<style type="text/css">

    .list-group{
        max-height: 150px;
        margin-bottom: 10px;
        overflow:scroll;
        -webkit-overflow-scrolling: touch;
    }    

    table.estilosTabla > :not(caption) > * > * {
        /*
        padding-top: 5px !important;
        padding-bottom: 5px !important;
        */
    }

    .quitar_borde_puntos_suspencivos{
        border: none;
        background: transparent;
    }

    .quitar_borde_puntos_suspencivos.dropdown-toggle::after {
        display: none;
    }

    table.estilosTabla > :not(caption) > tr {
        border-bottom: 1px solid #dee2e6; /* Bootstrap's default border color */
    }

    table.estilosTabla > :not(caption) > * > * {
        border-bottom: 1px solid #dee2e6; /* Bootstrap's default border color */
        
    }

    .consultar_filtros
    {
      border-color: #d3cac0;
      border: 1px solid #d3cac0;
      float: right;
    }

    /* Asegurar que los cards tengan la misma altura */
   .row.equal-height {
      display: flex;
      flex-wrap: wrap; /* Permitir que los cards se envuelvan en pantallas pequeñas */
   }

   /* Hacer que cada card ocupe la altura completa */
   .card {
      display: flex;
      flex-direction: column;
      height: 100%; /* El card toma la altura del contenedor más grande */
   }

   /* Hacer que el card-body ocupe todo el espacio y alinee el contenido */
   .card-body {
      display: flex;
      flex-direction: column;
      flex-grow: 1; /* El card-body se expande para llenar el card */
      justify-content: space-between; /* Espacia el contenido para que h3 quede abajo */
   }

   /* Estilos para la clase cardStyle */
   .cardStyle {
      margin-left: 13px;
      margin-right: 13px;
      box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px;
   }

   /* Asegurar que h3 no tenga márgenes que interfieran */
   .card-body h3 {
      margin: 0; /* Eliminar márgenes para mejor control */
   }

   .mi-placeholder {
       background-color: #dbdbdb;
       animation: mi-placeholder-glow 1.2s ease-in-out infinite;
       cursor: wait;
   }

   @keyframes mi-placeholder-glow {
       0% {
           opacity: 0.6;
       }
       50% {
           opacity: 0.3;
       }
       100% {
           opacity: 0.6;
       }
   }

   .clase_placeholder
    {
        box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px;
        user-select: none;
        border-radius: 4px;
        color:transparent;
    }


   #chart-container {
       width: 100%;
       height: 400px;
       margin: 20px auto;
   }

   #chart-container-1 {
       width: 100%;
       height: 400px;
       margin: 20px auto;
   }

   #chart-container-2 {
       width: 100%;
       height: 600px;
       margin: 20px auto;
   }


</style>

<input
   type="text"
   class="tener_url_base"
   value="{$url_base}"
   disabled
   hidden
/>
      
<div class="row">

   {**}
   <div class="row equal-height contenedor_card">
       
   </div>

   <div class="col-md-12 mt-4">
      <div class="panel">

         {*
            <div class="panel-hdr">
               <h2>State of Mora</h2>
            </div>
         *}

         <div class="panel-container show" id="ibox_form">
            <div id="chart-container" style="display: none;" ></div>

            <div class="mostras_placeholder_graficos1 mi-placeholder" style="width: 100%;height: 400px;padding: 10px; border-radius: 4px; box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px; "></div>
            
                <div class="table-responsive"  >
                        <table
                           class="table table-striped table-hover estilosTabla"
                           id="clx_datatable"
                           style="margin: 0px"
                        >
                           <thead>
                              <tr>
                                 <th class="centrar mi-placeholder clase_placeholder quitar_placeholder">Total placement</th>
                                 <th class="centrar mi-placeholder clase_placeholder quitar_placeholder">Total Interest</th>
                                 <th class="centrar mi-placeholder clase_placeholder quitar_placeholder">Total outstanding capital</th>
                                 <th class="centrar mi-placeholder clase_placeholder quitar_placeholder">Total outstanding balance</th> 
                                 <th class="centrar mi-placeholder clase_placeholder quitar_placeholder">Portfolio normality</th>
                              </tr>
                           </thead>

                           <tbody class="tbody_envios_antiguedad_mora">
                           
                           </tbody>

                           <tfoot class="tfooter_envios">
                           
                              <tr>
                                 <td class="centrar">Total</td>
                                 <td class="centrar total_antiguedad_mora">0</td>
                                 <td class="centrar total_normalidad_cartera">0.00%</td>
                              </tr>
 
                           </tfoot>

                        </table>
                     </div>

         </div>
      </div>
   </div>


   {**}
   <div class="col-md-12 mt-2">
      <div class="panel">
 
         <div class="panel-container show" id="ibox_form">
            <div id="chart-container-1" style="display: none;"></div>

            <div class="mostras_placeholder_graficos2 mi-placeholder" style="width: 100%;height: 400px;padding: 10px; border-radius: 4px; box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px; "></div>


         </div>
      </div>
   </div>
 

   {**}
   <div class="col-md-12 mt-2">
      <div class="panel">
 
         <div class="panel-container show" id="ibox_form">
               
            <div id="chart-container-2" style="display: none;"></div>

            <div class="mostras_placeholder_graficos3 mi-placeholder" style="width: 100%;height: 400px;padding: 10px; border-radius: 4px; box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px; "></div>
            
         </div>
      </div>
   </div>

 
 

</div>

 
{/block}

{block name="script"}

{literal}
<script>

   const URL_BASE = $(".tener_url_base").val(); 

   //$(".tbody_envios").html(
   //   '<tr><th colspan="10" class="centrar pt-4"> No information</th></tr>',
   //);

   $(document).ready(function() {

      let arr = [
         {
               "titulo": "Total loans",
               "valor": "$30,000.00"
         },
         {
               "titulo": "Total recovered",
               "valor": "$1,000.00"
         },
         {
               "titulo": "Percentage in arrears",
               "valor": "10.00%"
         },
         {
               "titulo": "Disbursement of the month",
               "valor": "2"
         }
      ];

      $(".contenedor_card").html(construccionHtmlCardPlaceholder(arr));

      placeholderTabla();

      $(".mostras_placeholder_graficos1").css("display", "");
      $(".mostras_placeholder_graficos2").css("display", "");
 
      cargarInformacion();

 
   });

   function placeholderTabla()
   {
      let arr_tabla = [
         {
               "dia_desde": "0",
               "dia_hasta": "30",
               "ultima_fecha": "2025-07-20",
               "saldo_pendiente": "2675.0768492813",
               "capital_pendiente": "2482.9391228533",
               "interes_pendiente": "192.137726428"
         },
         {
               "dia_desde": "31",
               "dia_hasta": "60",
               "ultima_fecha": "2025-06-27",
               "saldo_pendiente": "2675.0768492813",
               "capital_pendiente": "2422.010423146",
               "interes_pendiente": "253.06642613527"
         },
         {
               "dia_desde": "61",
               "dia_hasta": "90",
               "ultima_fecha": null,
               "saldo_pendiente": null,
               "capital_pendiente": null,
               "interes_pendiente": null
         },
         {
               "dia_desde": "91",
               "dia_hasta": "120",
               "ultima_fecha": null,
               "saldo_pendiente": null,
               "capital_pendiente": null,
               "interes_pendiente": null
         },
         {
               "dia_desde": "121",
               "dia_hasta": ">=",
               "ultima_fecha": null,
               "saldo_pendiente": null,
               "capital_pendiente": null,
               "interes_pendiente": null
         }
      ];

      let newRow = "";

      arr_tabla.forEach((element) => {

         let {
            dia_desde,
            dia_hasta,
            ultima_fecha,
            saldo_pendiente,
            capital_pendiente,
            interes_pendiente,
        } = element;
 
         newRow += '<tr>' +
                `<td class="centrar "> <div class="mi-placeholder clase_placeholder">"adasdasdasdass"</div> </td>` +
                `<td class="centrar "> <div class="mi-placeholder clase_placeholder">"adasdasdasdass"</div></td>` +
                `<td class="centrar "> <div class="mi-placeholder clase_placeholder">"adasdasdasdass"</div> </td>` +
                `<td class="centrar "> <div class="mi-placeholder clase_placeholder">"adasdasdasdass"</div> </td>` +
                `<td class="centrar "> <div class="mi-placeholder clase_placeholder">"adasdasdasdass"</div> </td>` +
               
               '</tr>';

      });

      $(".tbody_envios_antiguedad_mora").html(newRow);

      let newRowFotter =
            "<tr>" +
               '<td class="centrar mi-placeholder clase_placeholder">' + "Total" + "</td>" +
               '<td class="centrar mi-placeholder clase_placeholder">' + "as" + "</td>" +
               '<td class="centrar mi-placeholder clase_placeholder">' + " %" + "</td>" +
            "</tr>"; 

      $(".tfooter_envios").html(newRowFotter);
   }

   function cargarInformacion()
   {
      $.ajax({
         type: "POST",
         url: URL_BASE + "credit/post-data-dashboard-credit",
         //data: JSON.stringify(enviar_informacion), // Convertir datos a formato JSON
         contentType: "application/json",          // Tipo de contenido JSON
         success: function (response) {
 
            try {

               let info = JSON.parse(response);

               if (info.type == "success") {

                  //listado_cliente_mora

                  let listado_antiguedad = info.listado_antiguedad || [];
                  

                  if(listado_antiguedad.length == 0)
                  {
                     //$(".tbody_envios").html(
                     //   '<tr><th colspan="10" class="centrar pt-4"> No information</th></tr>',
                     //);
                  }else{

                     var newRow = "";
                     var newRowFotter = "";

                     var suma_total_mora = 0;
                     var suma_normalidad_cartera_real = 0;

                     var listado_circulo_antiguedad = [];

                     const sumas = listado_antiguedad.reduce((acc, item) => {
                        acc.saldo_pendiente += parseToFloat(item.saldo_pendiente);
                        acc.capital_pendiente += parseToFloat(item.capital_pendiente);
                        acc.interes_pendiente += parseToFloat(item.interes_pendiente);
                        return acc;
                     }, { saldo_pendiente: 0, capital_pendiente: 0, interes_pendiente: 0 });

                     var suma_total_normalidad = 0;

                     listado_antiguedad.forEach((element) => {

                        let {
                           dia_desde,
                           dia_hasta,
                           ultima_fecha,
                           saldo_pendiente,
                           capital_pendiente,
                           interes_pendiente,
                        } = element;

                        let concatenacion = "";

                        if( dia_hasta == ">=" ){
                           concatenacion = dia_desde + "  " + dia_hasta;
                        }else{
                           concatenacion = dia_desde + " - " + dia_hasta;
                        }

                        let normalidad = (parseToFloat(saldo_pendiente) / parseToFloat(sumas.saldo_pendiente)) * 100; 

                        suma_total_normalidad += normalidad; 


                        let variable = Number.isNaN(normalidad) ? '0.00 %' : formatNumber(normalidad) + " %"

                        newRow +=
                           "<tr>" +
                              '<td class="centrar">' + concatenacion + " Days" + "</td>" +
                              '<td class="centrar">' + "$ " + formatNumber(parseToFloat(interes_pendiente)) + "</td>" +
                              '<td class="centrar">' + "$ " + formatNumber(parseToFloat(capital_pendiente)) + "</td>" +
                              '<td class="centrar">' + "$ " + formatNumber(parseToFloat(saldo_pendiente)) + "</td>" +
                              '<td class="centrar">' + variable + "</td>" +
                           "</tr>";

                        listado_circulo_antiguedad.push(
                           {
                              name: concatenacion + " Days",
                              value: parseToFloat(saldo_pendiente)
                           }
                        );

                     });

                     $(".tbody_envios_antiguedad_mora").html(newRow);

                     $('.mi-placeholder').removeClass('mi-placeholder');
                     $('.clase_placeholder').removeClass('clase_placeholder');
 
                     newRowFotter =
                           "<tr>" +
                              '<td class="centrar">' + "Total" + "</td>" +
                              '<td class="centrar">' + "$ " + formatNumber(parseToFloat(sumas.interes_pendiente)) + "</td>" +
                              '<td class="centrar">' + "$ " + formatNumber(parseToFloat(sumas.capital_pendiente)) + "</td>" +
                              '<td class="centrar">' + "$ " + formatNumber(parseToFloat(sumas.saldo_pendiente)) + "</td>" +
                              '<td class="centrar">' + formatNumber(parseToFloat(suma_total_normalidad)) + " %" + "</td>" +
                           "</tr>"; 

                     $(".tfooter_envios").html(newRowFotter);

                     console.log("listado_circulo_antiguedad");
                     console.log(listado_circulo_antiguedad);
 
                     graficoCircular1(listado_circulo_antiguedad);

                  }

                  let arregloCard = info.arregloCard || [];

                  $(".contenedor_card").html(construccionHtmlCard(arregloCard));

                  $(".cantidad_cuotas").html(info.cantidad_cuotas_total);

                  let listado_cliente_mora = info.listado_cliente_mora || [];

                  graficoCircular2(listado_cliente_mora);
 
                  $(".mostras_placeholder_graficos1").css("display", "none");
                  $(".mostras_placeholder_graficos2").css("display", "none");

                  let listado_desembolso_prestamo_plan = info.listado_desembolso_prestamo_plan || [];
                  let listado_meses_desembolso_prestamo_plan = info.listado_meses_desembolso_prestamo_plan || [];

                  let meses_dpp = [];

                  listado_meses_desembolso_prestamo_plan.forEach((element) => {

                     let {
                        mes_actual,
                     } = element;

                     if(!meses_dpp.includes(mes_actual))
                     {
                        meses_dpp.push(mes_actual)
                     }
                  });

                  graficoDesembolsoPrestamoPlan(listado_desembolso_prestamo_plan, meses_dpp);

                  $(".mostras_placeholder_graficos3").css("display", "none");
                  
               } else if (info.type == "error") {

                  Swal.fire({
                     icon: "error",
                     title: "Oops...",
                     text: info.message,
                  });

                }
            } catch (error) {

               Swal.fire({
                  icon: "error",
                  title: "Oops...",
                  text: error,
               });

             }
         },
         error: function (xhr, status, error) {
            console.error("Error en la solicitud:", error);
         
            Swal.fire({
               icon: "error",
               title: "Oops...",
               text: error,
            });
 
         },
      });

  
   }

    
   let fecha = cargar_fecha();
   let fecha_iniciar = cargar_primer_dia_mes();

   $(".tener_fecha_desde").val(fecha_iniciar);
   $(".tener_fecha_hasta").val(fecha);


   $("#consultar_filtros").click(function () {

       

      
   });

 
   function isEmpty(value) {
       // Verificar si es null o undefined
       if (value == null) return true;

       // Verificar si es una cadena vacía
       if (typeof value === "string" && value.trim() === "") return true;

       // Verificar si es un array vacío
       if (Array.isArray(value) && value.length === 0) return true;

       // Verificar si es un objeto vacío
       if (typeof value === "object" && Object.keys(value).length === 0) return true;

       return false;
   }
 
   function cargar_fecha() {
      const today = new Date();

      // Formatear la fecha como YYYY-MM-DD
      const year = today.getFullYear();
      const month = String(today.getMonth() + 1).padStart(2, "0"); // Mes de 2 dígitos
      const day = String(today.getDate()).padStart(2, "0"); // Día de 2 dígitos

      const formattedDate = year + "-" + month + "-" + day;
      return formattedDate;
   }

   function cargar_primer_dia_mes() {
      const today = new Date();

      // Obtener el año y el mes actual
      const year = today.getFullYear();
      const month = String(today.getMonth() + 1).padStart(2, "0"); // Mes de 2 dígitos (0-11, por eso +1)

      // Establecer el día como 1
      const day = "01";

      // Formatear la fecha como YYYY-MM-DD
      const formattedDate = year + "-" + month + "-" + day;
      return formattedDate;
   }

   function select_html_usuario_sistema(arr) {
      if (arr.length == 0) {
         return;
      }

      var html = '<option value="">' + "None" + "</option>";

      arr.forEach((element) => {
         let value = element;

         html +=
            '<option value="' +
            value["id"] +
            '">' +
            value["fullname"] +
            "</option>";
      });

      return html;
   }

   function construccionHtmlCard(datos = [])
   {
      let html = '';

      datos.forEach(item => {
         html += `
            <div class="col-12 col-sm-3 mt-1" style="padding: 0px">
                  <div class="card cardStyle">
                     <div class="card-body position-relative" style="padding: 15px;">
                        <h5 style="font-size: 17px; margin: 0px; color: #434343; font-weight: 100;">
                              ${item.titulo}
                        </h5>
                        <h3 style="font-size: 24px; color: #434343; font-weight: 600;">
                              ${item.valor}
                        </h3>
                     </div>
                  </div>
            </div>
         `;
      });

      return html;
   }

   function construccionHtmlCardPlaceholder(datos = [])
   {
      let html = '';

      datos.forEach(item => {
         html += `
            <div class="col-12 col-sm-3 mt-1" style="padding: 0px">
                  <div class="card cardStyle">
                     <div class="card-body position-relative" style="padding: 15px;">
                        <h5 class="mi-placeholder" style="font-size: 17px; margin: 0px; color: transparent; font-weight: 100; user-select: none; border-radius: 5px;">
                              ${item.titulo}
                        </h5>
                        <h3 class="mi-placeholder mt-1" style="font-size: 24px; color: transparent; font-weight: 600; user-select: none; border-radius: 5px;">
                              ${item.valor}
                        </h3>
                     </div>
                  </div>
            </div>
         `;
      });

      return html;
   }

   function parseToFloat(input) {
      
      if ( isEmpty(input) ) {
         return 0;
      }

      // Si es un número (entero o float), retornarlo directamente
      if (typeof input === 'number' && !isNaN(input)) {
         return input;
      }

      // Si es un string, intentar convertirlo a float
      if (typeof input === 'string') {
        
         const normalizedInput = input.replace(',', '.');
         
         const parsed = parseFloat(normalizedInput);
         return isNaN(parsed) ? 0 : parsed;
      }

      
      return 0;
   }

   const formatNumber = (number) => {
      return Number(number).toLocaleString('en-US', {
         minimumFractionDigits: 2,
         maximumFractionDigits: 2
      });
   };

   function graficoCircular1(data = [])
   {
      $("#chart-container").css("display", "");

      // Inicializar el gráfico ECharts
      const myChart = echarts.init(document.getElementById('chart-container'));

      // Datos de ejemplo basados en tu tabla
      //const data = [
      //    { name: '0 - 30 Days', value: 1 },
      //    { name: '31 - 60 Days', value: 1 },
      //    { name: '61 - 90 Days', value: 0 },
      //    { name: '91 - 120 Days', value: 0 },
      //    { name: '121 >= Days', value: 0 }
      //];

      // Configuración del gráfico circular
      const option = {
          title: {
              text: 'Distribution of seniority by default',
              left: 'center',
              top: 20,
              textStyle: {
                  fontSize: 18
              }
          },
          tooltip: {
              trigger: 'item',
              formatter: function(params) {
                  return `${params.seriesName}<br/>${params.name}: $${formatNumber(params.value)} (${params.percent.toFixed(2)}%)`;
              }
          },
          legend: {
              orient: 'vertical',
              left: 10,
              top: 60
          },
          series: [
              {
                  name: 'Days',
                  type: 'pie',
                  radius: ['40%', '70%'], // Hacer un donut chart
                  center: ['50%', '60%'], // Centrar el gráfico
                  avoidLabelOverlap: true,
                  itemStyle: {
                      borderRadius: 5,
                      borderColor: '#fff',
                      borderWidth: 2
                  },
                  label: {
                      show: true,
                      position: 'outside',
                      formatter: function(params) {
                          return `${params.name}: $${formatNumber(params.value)} (${params.percent.toFixed(2)}%)`;
                      }
                  },
                  emphasis: {
                      label: {
                          show: true,
                          fontSize: 16,
                          fontWeight: 'bold'
                      }
                  },
                  data: data,
                  animationDuration: 1000
              }
          ]
      };

      // Aplicar la configuración al gráfico
      myChart.setOption(option);

      // Hacer el gráfico responsivo
      window.addEventListener('resize', () => myChart.resize());
   }

   /*
   function graficoCircular2(data = [])
   {
      $("#chart-container-1").css("display", "");

      // Inicializar el gráfico ECharts
      const myChart = echarts.init(document.getElementById('chart-container-1'));

      // Datos de ejemplo basados en tu tabla
      //const data = [
      //    { name: '0 - 30 Days', value: 1 },
      //    { name: '31 - 60 Days', value: 1 },
      //    { name: '61 - 90 Days', value: 0 },
      //    { name: '91 - 120 Days', value: 0 },
      //    { name: '121 >= Days', value: 0 }
      //];

      // Configuración del gráfico de dona anidado
            const option = {
                title: {
                    text: 'Distribution of seniority by default',
                    left: 'center',
                    top: 20,
                    textStyle: {
                        fontSize: 18
                    }
                },
                tooltip: {
                    trigger: 'item',
                    formatter: function(params) {
                        return `${params.seriesName}<br/>${params.name}: $${formatNumber(params.value)} (${params.percent.toFixed(2)}%)`;
                    }
                },
                legend: {
                    orient: 'vertical',
                    left: 10,
                    top: 60,
                    data: [...data.map(item => item.name)]
                },
                series: [
                    {
                        name: 'Outer Days',
                        type: 'pie',
                        radius: ['40%', '70%'], // Dona externa
                        center: ['50%', '60%'], // Centrar
                        avoidLabelOverlap: true,
                        itemStyle: {
                            borderRadius: 5,
                            borderColor: '#fff',
                            borderWidth: 2
                        },
                        label: {
                            show: true,
                            position: 'outside',
                            formatter: function(params) {
                                return `${params.name}: $${formatNumber(params.value)} (${params.percent.toFixed(2)}%)`;
                            }
                        },
                        emphasis: {
                            label: {
                                show: true,
                                fontSize: 16,
                                fontWeight: 'bold'
                            }
                        },
                        data: data,
                        animationDuration: 1000
                    },
                    {
                        name: 'Inner Categories',
                        type: 'pie',
                        radius: ['10%', '30%'], // Dona interna (más pequeña)
                        center: ['50%', '60%'], // Misma posición que la externa
                        avoidLabelOverlap: true,
                        itemStyle: {
                            borderRadius: 5,
                            borderColor: '#fff',
                            borderWidth: 2
                        },
                        label: {
                            show: true,
                            position: 'inside', // Etiquetas dentro para la dona interna
                            formatter: function(params) {
                                return `${params.name}: $${formatNumber(params.value)}`;
                            }
                        },
                        emphasis: {
                            label: {
                                show: true,
                                fontSize: 14,
                                fontWeight: 'bold'
                            }
                        },
                        data: dataInner,
                        animationDuration: 1000
                    }
                ]
            };

            // Aplicar la configuración al gráfico
            myChart.setOption(option);

            // Hacer el gráfico responsivo
            window.addEventListener('resize', () => myChart.resize());
   }
   */

   function graficoCircular2(data = [] ) {
      $("#chart-container-1").css("display", "");

      // Inicializar el gráfico ECharts
      const myChart = echarts.init(document.getElementById('chart-container-1'));
 
      // Configuración del gráfico de dona semicircular
      const option = {
          title: {
              text: 'Delinquency vs Clients in Good Standing',
              left: 'center',
              top: 10,
              textStyle: {
                  fontSize: 20,
                  fontWeight: 'bold',
                  color: '#333'
              },
              subtext: 'As of July 30, 2025',
              subtextStyle: {
                  fontSize: 12,
                  color: '#666'
              }
          },
          tooltip: {
              trigger: 'item',
              formatter: function(params) {
                  return `${params.seriesName}<br/>${params.name}: ${formatNumber(params.value)}% (${params.percent.toFixed(2)}%)`;
              },
              backgroundColor: 'rgba(50, 50, 50, 0.8)',
              textStyle: { color: '#fff' }
          },
          legend: {
              orient: 'vertical',
              left: '10',
              top: 60,
              textStyle: {
                  fontSize: 12,
                  color: '#555'
              },
              data: data.map(item => item.name)
          },
          series: [
              {
                  name: 'Distribution',
                  type: 'pie',
                  radius: ['40%', '70%'], // Dona semicircular
                  center: ['50%', '70%'], // Mover hacia abajo para mejor visualización
                  startAngle: 180, // Comienza en la parte superior (180°)
                  endAngle: 0, 
                  avoidLabelOverlap: true,
                  itemStyle: {
                      borderRadius: 8,
                      borderColor: '#fff',
                      borderWidth: 2,
                      color: params => [
                          '#5C7BD9', // Delinquency
                          '#91cc75'  // Clients in Good Standing
                      ][params.dataIndex]
                  },
                  label: {
                     show: true,
                     position: 'outside',
                     formatter: function(params) {
                         return `${params.name}: ${formatNumber(params.value)}%`;
                     }
                  },
                  emphasis: {
                      label: {
                          show: true,
                          fontSize: 16,
                          fontWeight: 'bold'
                      }
                  },
                  data: data.map(item => ({
                      name: item.name,
                      value: parseFloat(item.value)
                  })),
                  animationDuration: 1000
              }
          ]
      };

      // Aplicar la configuración al gráfico
      myChart.setOption(option);

      // Hacer el gráfico responsivo
      window.addEventListener('resize', () => myChart.resize());
   }

   function graficoDesembolsoPrestamoPlan(listado_desembolso_prestamo_plan = [], months = [])
   {
      // Datos proporcionados
      //let listado_desembolso_prestamo_plan = [
      //    {
      //        "monto_solicitado": "5000",
      //        "id_plan_pago_prospecto": "8",
      //        "nombre_plan_pago_prospecto": "Plan monto maximo 25 mil y minimo 20 mil",
      //        "dia_incicio_mes_actual": "2025-07-01",
      //        "dia_final_mes_actual": "2025-07-31",
      //        "nombre_mes_actual": "July 2025"
      //    },
      //    {
      //        "monto_solicitado": "1000",
      //        "id_plan_pago_prospecto": "9",
      //        "nombre_plan_pago_prospecto": "plan de 100000 monto maximo 110000 y monto minimo 90000",
      //        "dia_incicio_mes_actual": "2025-07-01",
      //        "dia_final_mes_actual": "2025-07-31",
      //        "nombre_mes_actual": "July 2025"
      //    },
      //    {
      //        "monto_solicitado": "20000",
      //        "id_plan_pago_prospecto": "10",
      //        "nombre_plan_pago_prospecto": "plan 25000 minimo 25000 y maximo 25000",
      //        "dia_incicio_mes_actual": "2025-07-01",
      //        "dia_final_mes_actual": "2025-07-31",
      //        "nombre_mes_actual": "July 2025"
      //    },
      //    {
      //        "monto_solicitado": "25000",
      //        "id_plan_pago_prospecto": "8",
      //        "nombre_plan_pago_prospecto": "Plan monto maximo 25 mil y minimo 20 mil",
      //        "dia_incicio_mes_actual": "2025-06-01",
      //        "dia_final_mes_actual": "2025-06-30",
      //        "nombre_mes_actual": "June 2025"
      //    }
      //];

      // Inicializar el gráfico ECharts


      $("#chart-container-2").css("display", "");

      const myChart = echarts.init(document.getElementById('chart-container-2'));

      // Generar los 12 meses (de julio 2025 a agosto 2024)
      //const months = [
      //    "July 2025", "June 2025", "May 2025", "April 2025", "March 2025",
      //    "February 2025", "January 2025", "December 2024", "November 2024",
      //    "October 2024", "September 2024", "August 2024"
      //];

      // Obtener nombres únicos de planes (sin Set, usando un enfoque manual)
      const uniquePlans = [];
      listado_desembolso_prestamo_plan.forEach(plan => {
         if (!uniquePlans.includes(plan.nombre_plan_pago_prospecto)) {
             uniquePlans.push(plan.nombre_plan_pago_prospecto);
         }
      });

      //console.log("uniquePlans");
      //console.log(uniquePlans);

      // Inicializar datos para cada plan como arreglo bidimensional
      //const planData = new Array(uniquePlans.length).fill().map(() => new Array(12).fill(0)); // Cantidad de planes por mes

      const planData = [];
      for (let i = 0; i < uniquePlans.length; i++) {
          planData[i] = [];
          for (let j = 0; j < 12; j++) {
              planData[i][j] = 0;
          }
      }

      //console.log("planData");
      //console.log(planData);

      // Llenar los datos por plan y mes
      //listado_desembolso_prestamo_plan.forEach(plan => {
      //   const monthIndex = months.indexOf(plan.nombre_mes_actual);
      //   const planIndex = uniquePlans.indexOf(plan.nombre_plan_pago_prospecto);
      //   if (monthIndex !== -1 && planIndex !== -1) {
      //       planData[planIndex][monthIndex] += parseFloat(plan.monto_solicitado) || 0;
      //   }
      //});

      var suma_total = 0;

      listado_desembolso_prestamo_plan.forEach(plan => {
          let monthIndex = -1;
          let planIndex = -1;
          for (let i = 0; i < months.length; i++) {
              if (months[i] === plan.nombre_mes_actual) {
                  monthIndex = i;
                  break;
              }
          }
          for (let i = 0; i < uniquePlans.length; i++) {
              if (uniquePlans[i] === plan.nombre_plan_pago_prospecto) {
                  planIndex = i;
                  break;
              }
          }
          if (monthIndex !== -1 && planIndex !== -1) {
              planData[planIndex][monthIndex] += parseFloat(plan.monto_solicitado) || 0;
          }


         suma_total += parseToFloat(plan.monto_solicitado); 


      });

      //console.log("planData");
      //console.log(planData);

      // Configuración del gráfico de líneas
        const option = {
            title: {
                text: 'Loan disbursement by plan last 12 months',
                left: 'center',
                top: 20,
                textStyle: {
                    fontSize: 18,
                    fontWeight: 'bold',
                    color: '#333'
                },
                subtext: '', // subtitulos
                subtextStyle: {
                    fontSize: 12,
                    color: '#666'
                }
            },
            tooltip: {
                trigger: 'axis',
                formatter: function(params) {
                    let tooltip = params[0].axisValue + '<br/>';
                    params.forEach(param => {
                        tooltip += `${param.seriesName}: $${param.value.toFixed(2)}<br/>`;
                    });
                    return tooltip;
                },
                backgroundColor: 'rgba(109, 57, 57, 0.8)',
                textStyle: { color: '#fff' }
            },
            legend: {
                data: uniquePlans,
                top: 50,
                textStyle: {
                    color: '#555',
                    fontSize: 12
                }
            },
            xAxis: {
                type: 'category',
                data: months,
                axisLabel: {
                    rotate: 45,
                    color: '#666'
                },
                axisLine: { lineStyle: { color: '#ccc' } }
            },
            yAxis: {
               type: 'value',
                name: 'Total Amount: $' + formatNumber(suma_total),
                nameLocation: 'end',
                //nameGap: 90, // Distancia base desde el borde derecho
                nameTextStyle: {
                    color: '#555',
                    padding: [0, -60, 0, 0] // [top, right, bottom, left] - 50px a la derecha
                },
                axisLine: { lineStyle: { color: '#ccc' } },
                splitLine: { lineStyle: { color: '#eee' } }
            },
            series: uniquePlans.map((plan, index) => ({
                name: plan,
                type: 'line',
                data: planData[index],
                smooth: true,
                itemStyle: {
                    color: [
                        '#91cc75', '#ee6666', '#fac858', '#73c0de'
                    ][index % 4] // Colores cíclicos
                },
                lineStyle: {
                    width: 2,
                    color: [
                        '#91cc75', '#ee6666', '#fac858', '#73c0de'
                    ][index % 4]
                },
                areaStyle: {
                    color: new echarts.graphic.LinearGradient(0, 0, 0, 1, [
                        { offset: 0, color: `rgba(${hexToRgb([
                            '#91cc75', '#ee6666', '#fac858', '#73c0de'
                        ][index % 4]).join(', ')}, 0.3)` },
                        { offset: 1, color: `rgba(${hexToRgb([
                            '#91cc75', '#ee6666', '#fac858', '#73c0de'
                        ][index % 4]).join(', ')}, 0)` }
                    ])
                }
            })),
            grid: {
                left: '3%',
                right: '4%',
                bottom: '10%',
                top: '25%', // Ajuste para bajar el gráfico del título
                containLabel: true
            }
        };

        // Función auxiliar para convertir hex a RGB
        function hexToRgb(hex) {
            const result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
            return result ? [
                parseInt(result[1], 16),
                parseInt(result[2], 16),
                parseInt(result[3], 16)
            ] : [0, 0, 0];
        }

        // Aplicar la configuración al gráfico
        myChart.setOption(option);

        // Hacer el gráfico responsivo
        window.addEventListener('resize', () => myChart.resize());
   }
   
 

</script>
{/literal}

{/block}