{extends file="$layouts_admin"}
{block name="head"}

   <link href="{$theme}default/css/grupo.css?v={$config['version']}" rel="stylesheet">
   <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/1.6.2/css/buttons.dataTables.min.css" />



{/block}

{block name="content"}

<style type="text/css">

    .list-group{
        max-height: 150px;
        margin-bottom: 10px;
        overflow:scroll;
        -webkit-overflow-scrolling: touch;
    }    

    table.estilosTabla > :not(caption) > * > * {
        /*
        padding-top: 5px !important;
        padding-bottom: 5px !important;
        */
    }

    .quitar_borde_puntos_suspencivos{
        border: none;
        background: transparent;
    }

    .quitar_borde_puntos_suspencivos.dropdown-toggle::after {
        display: none;
    }

    table.estilosTabla > :not(caption) > tr {
        border-bottom: 1px solid #dee2e6; /* Bootstrap's default border color */
    }

    table.estilosTabla > :not(caption) > * > * {
        border-bottom: 1px solid #dee2e6; /* Bootstrap's default border color */
        
    }

</style>
<div class="row">

    <div class="col-md-12">

       
        <div class="panel">
            <div class="panel-hdr">
                <h2 style="color: #666; font-weight: 600; "><span></span>List Messages</h2>
                <input type="text" class=" tener_url_base" value={$url_base} disabled hidden/>

            </div>
                                                         
            <div class="panel-container show" id="ibox_form">

                <div class="panel-content">

                    <div class="px-2">
                        
                        <div class="row contenedor" style="padding: 10px">
                            <div class="col-12 col-sm-6 pt-3">
                                <label for="fecha_desde"
                                    ><span style="color:#666;">Date from</span>
                                </label>
                                <input
                                    type="date"
                                    id="fecha_desde"
                                    name="fecha_desde"
                                    class="form-control form-control-sm tener_fecha_desde"
                                />


                            </div>
                            <div class="col-12 col-sm-6 pt-3">
                                <label for="fecha_hasta"
                                    ><span style="color:#666;">Date to date</span>
                                </label>
                                <input
                                    type="date"
                                    id="fecha_hasta"
                                    name="fecha_hasta"
                                    class="form-control form-control-sm tener_fecha_hasta"
                                />
                            </div>


                            <div class="col-12 col-sm-6 pt-3">
                                <label for="usuario_id"><span style="color:#666;">Users</span> </label>
                                <select
                                    class="form-control form-control-sm tener_usuario_id"
                                    name="usuario_id"
                                    id="usuario_id"
                                    style="width: 100%"
                                    placeholder="Select a Channel"
                                ></select>
                            </div>

                            <div class="col-12 col-sm-6 pt-3">
                                <label for="canal"><span style="color:#666;">Channel</span> </label>
                                <select
                                    class="form-control form-control-sm tener_canal"
                                    name="canal"
                                    id="canal"
                                    style="width: 100%"
                                    placeholder="Select a Channel"
                                >
                                    <option value="">None</option>
                                    <option value="whatsapp">Whatsapp</option>
                                    <option value="sms">sms</option>
                                    <option value="email">Email</option>
                                </select>
                            </div>

                        

                            <div class="col-12 col-sm-6 pt-3">
                                <label for="campaña"><span style="color:#666;">Campaign</span> </label>
                                <input
                                    type="text"
                                    id="campaña"
                                    name="campaña"
                                    class="form-control form-control-sm tener_campaña"
                                    value=""
                                />
                            </div>

                            <div class="col-12 col-sm-6 pt-3">
                                <label for="status"><span style="color:#666;">Status</span> </label>
                                <select
                                    class="form-control form-control-sm tener_status"
                                    name="status"
                                    id="status"
                                    style="width: 100%"
                                    placeholder="Select a Status"
                                >
                                    <option value="">None</option>
                                    <option value="1">Complete</option>
                                    <option value="2">Pending</option>
                                    <option value="3">Incomplete</option>
                                </select>
                            </div>


                            <div class="col-12 col-sm-12 pt-3">
                                <button
                                    type="button"
                                    class="btn btn-default"
                                    id="consultar_filtros"
                                    style="
                                        border-color: #d3cac0;
                                        border: 1px solid #d3cac0;
                                        float: right;
                                    "
                                >
                                    Select a template
                                </button>
                            </div>

                            <br />
                            <div class="col-12 col-sm-12 pt-4">
                            
                                <div class="table-responsive">
                                    <table class="table table-striped table-hover mt-3 estilosTabla"  id="clx_datatable">
                                        <thead>
                                        <tr>
                                            <th class="centrar">Send Date</th>
                                            <th class="centrar">Channel</th>
                                            <th class="centrar">Campaign</th>
                                            <th class="centrar">Config identifier</th>
                                            <th class="centrar">Total contacts</th>
                                            <th class="centrar">Total contacts sent</th>
                                            <th class="centrar">Total pending contacts</th>
                                            <th class="centrar">Status</th>
                                            <th class="centrar">Action</th>
                                        </tr>
                                        </thead>
                                        <tbody class="tbody_envios">
                                        
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            </div>

                       
                    </div>

                  

                </div>
 
                
               
            </div>
        </div>
    </div>
</div>




{/block}

{block name="script"}

<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.6.2/js/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.6.2/js/buttons.html5.min.js"></script>

<script>

    const URL_BASE = $(".tener_url_base").val();

    cargar_usuarios_sistema().then((listado_usuarios_admin) =>{
        $(".tener_usuario_id").html(
            select_html_usuario_sistema(listado_usuarios_admin),
        );
    });


    let fecha = cargar_fecha();
    $(".tener_fecha_desde").val(fecha);
    $(".tener_fecha_hasta").val(fecha);



    //$('#clx_datatable').DataTable();
   /*  var wp_table = $("#clx_datatable").DataTable({
        dom: 
        "<'row mb-3'<'col-sm-12 col-md-6 d-flex align-items-center justify-content-start'f><'col-sm-12 col-md-6 d-flex align-items-center justify-content-end'lB>>" +
        "<'row'<'col-sm-12'tr>>" +
        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
        buttons: [
            {
                extend: 'pdfHtml5',
                text: 'PDF',
                titleAttr: 'Generate PDF',
                className: 'btn-danger-light btn-sm mr-1'
            },
            {
                extend: 'excelHtml5',
                text: 'Excel',
                titleAttr: 'Generate Excel',
                className: 'btn-success-light btn-sm mr-1'
            },
            {
                extend: 'csvHtml5',
                text: 'CSV',
                titleAttr: 'Generate CSV',
                className: 'btn-primary-light btn-sm mr-1'
            },
            {
                extend: 'copyHtml5',
                text: 'Copy',
                titleAttr: 'Copy to clipboard',
                className: 'btn-info-light btn-sm mr-1'
            },
            {
                extend: 'print',
                text: 'Print',
                titleAttr: 'Print Table',
                className: 'btn-secondary-light btn-sm'
            }
        ],
        language: {
            emptyTable: "No data available",
            info: "Mostrando _START_ a _END_ de _TOTAL_ entradas",
            infoEmpty: "Mostrando 0 a 0 de 0 entradas",
            buttons: {
                pageLength: "Mostrar todo"
            },
            searchPlaceholder: "Buscar"
        },
        
    }); */

 

    
         $("#consultar_filtros").click(function () {
            let usuario_id = $(".tener_usuario_id").val() || "";
            let tener_canal = $(".tener_canal").val() || "";
            let nombre_campaña = $(".tener_campaña").val() || "";
            let status = $(".tener_status").val() || "";

            let enviar_informacion = {
               fecha_desde: $(".tener_fecha_desde").val() || "",
               fecha_hasta: $(".tener_fecha_hasta").val() || "",
               usuario_id: usuario_id,
               canal: tener_canal,
               nombre_campaña: nombre_campaña,
               status: status,
            };

            //console.log(enviar_informacion);
            //return;
            $("#consultar_filtros").prop("disabled", true);

            $.ajax({
               type: "POST",
               url: URL_BASE + "social/tener-listado-mensajes-grupales/",
               data: JSON.stringify(enviar_informacion), // Convertir datos a formato JSON
               contentType: "application/json", // Tipo de contenido JSON
               success: function (response) {
                  $("#consultar_filtros").prop("disabled", false);
                  //console.log("Respuesta del servidor:", response);
                  // Hacer algo con la respuesta del servidor
                  //$("#myModal").modal("hide");
                  $(".tbody_envios").html("");
                  try {
                     let info = JSON.parse(response);
                     if (info.type == "success") {
                        let arr = info.data;

                        if (arr == "") {
                           $(".tbody_envios").html(
                              '<tr><th colspan="9" class="centrar pt-4"> No information</th></tr>',
                           );
                        } else {
                           $(".tbody_envios").html(arr);
                        }

                        /*  if (Array.isArray(arr)) {
                           if (arr.length != 0) {
                              var newRow = "";

                              arr.forEach((element) => {
                                 let {
                                    id,
                                    campaign,
                                    crm_groups_id,
                                    channel,
                                    template,
                                    send_date,
                                    configuration_whatsapp_other_id,
                                    contacts_total,
                                    contact_sent,
                                    contacts_pending,
                                    state_description,
                                    state,
                                    users_id,
                                    user_fullname,
                                    user_username,
                                    config_identifier,
                                 } = element;

                                 // Crear una nueva fila de la tabla concatenando cadenas
                                 newRow +=
                                    "<tr>" +
                                    '<td class="centrar">' +
                                    send_date +
                                    "</td>" +
                                    '<td class="centrar">' +
                                    channel +
                                    "</td>" +
                                    '<td class="centrar">' +
                                    campaign +
                                    "</td>" +
                                    '<td class="centrar">' +
                                    config_identifier +
                                    "</td>" +
                                    '<td class="centrar">' +
                                    contacts_total +
                                    "</td>" +
                                    '<td class="centrar">' +
                                    contact_sent +
                                    "</td>" +
                                    '<td class="centrar">' +
                                    contacts_pending +
                                    "</td>" +
                                    '<td class="centrar">' +
                                    state_description +
                                    "</td>" +
                                    "</tr>";
                              });

                              // Agregar la nueva fila al tbody
                              $(".tbody_envios").html(newRow);
                           } else {
                              $(".tbody_envios").html(
                                 '<tr><th colspan="8" class="centrar pt-4"> No information</th></tr>',
                              );
                           }
                        }
                      */
                     } else {
                        alert("Error sending group messages");
                     }
                  } catch (error) {
                     $(".tbody_envios").html("");
                     alert("Error:" + error);
                  }
               },
               error: function (xhr, status, error) {
                  $("#consultar_filtros").prop("disabled", false);
                  $(".tbody_envios").html("");
                  console.error("Error en la solicitud:", error);
               },
            });
         });

 


         async function cargar_cabecera_account() {
            return new Promise((resolve, reject) => {
               $.get(
                  URL_BASE + "group/get-groups-account-headers/",
                  function (data) {
                     try {
                        let info = JSON.parse(data);
                        resolve(info.data);
                     } catch (error) {
                        console.log(
                           "Error al parsear la respuesta cargar_cabecera_account: " +
                              error.message,
                        );
                        reject({
                           type: "error",
                           data: {},
                        });
                     }
                  },
               ).fail(function (jqXHR, textStatus, errorThrown) {
                  console.log(
                     "Error en la solicitud cargar_cabecera_account: " +
                        textStatus +
                        " - " +
                        errorThrown,
                  );
                  reject({
                     type: "error",
                     data: {},
                  });
               });
            });
         }

         async function cargar_grupos() {
            return new Promise((resolve, reject) => {
               $.get(URL_BASE + "group/get-groups/", function (data) {
                  try {
                     let info = JSON.parse(data);
                     resolve(info.data);
                  } catch (error) {
                     console.log(
                        "Error al parsear la respuesta cargar_grupos: " +
                           error.message,
                     );
                     reject({
                        type: "error",
                        data: {},
                     });
                  }
               }).fail(function (jqXHR, textStatus, errorThrown) {
                  console.log(
                     "Error en la solicitud cargar_grupos: " +
                        textStatus +
                        " - " +
                        errorThrown,
                  );
                  reject({
                     type: "error",
                     data: {},
                  });
               });
            });
         }

         async function cargar_usuarios_sistema() {
            return new Promise((resolve, reject) => {
               $.get(
                  URL_BASE + "social/lista-usuarios-admin/",
                  function (data) {
                     try {
                        let info = JSON.parse(data);
                        resolve(info.data);
                     } catch (error) {
                        console.log(
                           "Error al parsear la respuesta cargar_grupos: " +
                              error.message,
                        );
                        reject({
                           type: "error",
                           data: {},
                        });
                     }
                  },
               ).fail(function (jqXHR, textStatus, errorThrown) {
                  console.log(
                     "Error en la solicitud cargar_grupos: " +
                        textStatus +
                        " - " +
                        errorThrown,
                  );
                  reject({
                     type: "error",
                     data: {},
                  });
               });
            });
         }

         function cargar_fecha() {
            const today = new Date();

            // Formatear la fecha como YYYY-MM-DD
            const year = today.getFullYear();
            const month = String(today.getMonth() + 1).padStart(2, "0"); // Mes de 2 dígitos
            const day = String(today.getDate()).padStart(2, "0"); // Día de 2 dígitos

            const formattedDate = year + "-" + month + "-" + day;
            return formattedDate;
         }

         function select_html_usuario_sistema(arr) {
            if (arr.length == 0) {
               return;
            }

            var html = '<option value="">' + "None" + "</option>";

            arr.forEach((element) => {
               let value = element;

               html +=
                  '<option value="' +
                  value["id"] +
                  '">' +
                  value["fullname"] +
                  "</option>";
            });

            return html;
         }
     

</script>
{/block}