{extends file="$layouts_admin"}
{block name="head"}




{/block}

{block name="content"}

<style type="text/css">

    .list-group{
        max-height: 150px;
        margin-bottom: 10px;
        overflow:scroll;
        -webkit-overflow-scrolling: touch;
    }    

</style>
            <div class="row">

                {* formulario lead *}
                <div class="col-md-12">


                    <div class="panel">
                        <div class="panel-hdr">
                            <h2><span></span>Add Lead History</h2>

                            <div class="panel-toolbar">
                                <div class="btn-group">
                                    <button class="btn btn-sm btn-primary enviarFromulario" > {$_L['Save']}</button>
                                </div>
                            </div>
                        </div>

                        <div class="panel-container show" id="ibox_form">

                            <div class="panel-content">

                                <div class="px-2">
                                    <div class="alert alert-danger" id="emsg" style="display: none;">
                                        <span id="emsgbody"></span>
                                    </div>

                                    <div class="alert alert-success" id="emsgSuccess" style="display: none;">
                                        <span id="emsgbodySuccess"></span>
                                    </div>

                                    <form id="rform">

                                        <div class="row">
            
                                            <div class="col-md-12 col-sm-12">

                                                <input type="text" hidden disabled value="{$user["id"]}" class="tener_usuario_id" >
                                                <input type="text" hidden disabled value="{$lead["id"]}" class="tener_leads_id" >
                                                <input type="text" hidden disabled value="{$user["username"]}" class="tener_username" >
                                                <input type="text" hidden disabled value="{$user["fullname"]}" class="tener_fullname" >
                                            
                                                <div class="mb-3 row">
                                                    <label for="email" class="col-sm-3"><span class="h6">Email</span><span class="text-danger">*</span></label>
                                                    <div class="col-sm-9">
                                                        <input type="email" id="email" name="email" class="form-control tener_email" autofocus>
                                                    </div>
                                                </div>                      
            
                                            </div>

                                            <div class="col-md-12 col-sm-12">
                                                <div class="mb-3 row">
                                                    <label for="telefono" class="col-sm-3"><span class="h6">Phone</span><span class="text-danger">*</span></label>
                                                    <div class="col-sm-9">
                                                        <input type="text" id="telefono" name="telefono" class="form-control tener_telefono" >
                                                    </div>
                                                </div>
                
                                            </div>

                                            <div class="col-md-12 col-sm-12 col-12">
                                            
                                                <div class="mb-3 row">
                                                    <label for="observacion" class="col-sm-3"><span class="h6">Observations</span><span class="text-danger">*</span></label>
                                                    <div class="col-sm-9">
                                                        <textarea id="observacion" class="form-control tener_observacion" name="observacion" rows="5" cols="33" ></textarea>                                          
                                                        
                                                    </div>
                                                </div>                      
            
                                            </div>
                            

                                    </form>

                                
                                </div>

                            

                            </div>
            
                        
                        </div>
                    </div>
                </div>
                {* fin formulario lead *}

                {* Historial de lead *}
                {if count($historial_leads) != 0 }
                    <div >
                        <div class="col-md-12">
                            
                            <div class="panel ">
                                <div class="panel-hdr">                                                                                                                       
                                    <h2><span></span>Lead History</h2>
                                </div>

                                <div class="panel-container show" id="ibox_form_observaciones">
                                    <div class="panel-content">
                                        <div class="px-0">
                                            
                                            <div class="table-responsive">

                                                <table id="clx_datatable" class="table table-striped w-100 sys_table footable">
                                                    <thead style="background: #f0f2ff">

                                                    <tr>
                                                        <th>Date</th>
                                                        <th>Hour</th>
                                                        <th>Username</th>
                                                        <th>Fullname</th>
                                                        <th>Phone</th>
                                                        <th>Email</th>
                                                        <th>Observations</th>
                                                
                                                    </tr>
                                                    </thead>
                                                    <tbody>

    

                                                    {foreach $historial_leads as $ds}
                                                        <tr>

                                                            <td>
                                                                {$ds['fecha']}
                                                            </td>

                                                            <td>
                                                                {$ds['hora']}
                                                            </td>

                                                            <td>
                                                                {$ds['username']}
                                                            </td>

                                                            <td>
                                                                {$ds['fullname']}
                                                            </td>

                                                            <td>
                                                                {$ds['telefono']}
                                                            </td>

                                                            <td>
                                                                {$ds['correo']}
                                                            </td>

                                                            <td>
                                                                {$ds['observaciones']}
                                                            </td>

                    
                                                        </tr>
                                                    {/foreach}

                                                    </tbody>



                                                </table>

                                            </div>
                                        
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                        </div>
                    </div>
                {/if}
                {* FIN Historial de lead *}

            </div>


             



{/block}

{block name="script"}
<script>

 
    $(document).ready(function () {

        $(".progress").hide();
        $("#emsg").hide();
        $("#emsgSuccess").hide();
        var _url = '{$_url}';
        
        $(".enviarFromulario").click(function (e) {
            e.preventDefault();
            
            if(validaciones() == true)
            {
               return;
            }
             
            $('#ibox_form').block({ message: "Please wait while the process is completed",
                    css: {
                        color: '#ffffff',        
                        border: 'none',         
                        padding: '10px',          
                        borderRadius: '5px',     
                        fontSize: '16px'          
                    } 
            });
             
            
            $("#emsg").hide();
            $("#emsgSuccess").hide();
 
                
            var informacionEnviar = {

                //info general
                tener_usuario_id:     $(".tener_usuario_id").val(),
                tener_leads_id:       $(".tener_leads_id").val(),
                tener_username:    $(".tener_username").val(),
                tener_fullname:    $(".tener_fullname").val(),

                //info formulario
                tener_email:     $(".tener_email").val(),
                tener_telefono:   $(".tener_telefono").val(),
                tener_observacion:  $(".tener_observacion").val(),
                
            }; 
   
            /* console.log(JSON.stringify(informacionEnviar));
            return; */

            $.post(base_url + 'leads/add-lead-history-post/', JSON.stringify(informacionEnviar)  ) //$( "#rform" ).serialize()
            .done(function (data) {
                 
                    $('#ibox_form').unblock();

                    console.log(data);
                    return;

                     

                     try {
                         const info = JSON.parse(data);
                       
                        if( info.type == "success")
                        {
                            //$('#ibox_form').unblock();
                            toastr.success(info.message);
                            window.location = info.redirect;

                            $(".tenerValorPorUsuario").val("0");
                            $(".tenerestado").val("1");
                            $(".tipoPagoSeleccionado").val("1");
                            $(".tenerValorMensual").val("0");                         

                        }else{
                            //$('#ibox_form').unblock();
                            var body = $("html, body");
                            body.animate({ scrollTop:0 }, '1000', 'swing');
                            $("#emsgbody").html(info.message);
                            $("#emsg").show("slow");
                        }
                    } catch (error) {
                        //$('#ibox_form').unblock();
                        var body = $("html, body");
                        body.animate({ scrollTop:0 }, '1000', 'swing');
                        $("#emsgbody").html(data);
                        $("#emsg").show("slow");
                    }
            });
        });


    });

  
    function isEmpty(value) {
        // Verificar si es null o undefined
        if (value == null) return true;

        // Verificar si es una cadena vacía
        if (typeof value === "string" && value.trim() === "") return true;

        // Verificar si es un array vacío
        if (Array.isArray(value) && value.length === 0) return true;

        // Verificar si es un objeto vacío
        if (typeof value === "object" && Object.keys(value).length === 0) return true;

        return false;
    }
 

    function validarSoloNumeros(input) {
        const number = parseInt(input, 10);
        return !isNaN(number) && number.toString() === input;
    }

    function validaciones()
    {
            
        if(isEmpty($(".tener_email").val()) == true)
        {
            toastr.error("!Email is required¡");
            return true;
        }

        if(isEmpty($(".tener_telefono").val()) == true)
        {
            toastr.error("!Phone is required¡");
            return true;
        }

        if(isEmpty($(".tener_observacion").val()) == true)
        {
            toastr.error("!Observations is required¡");
            return true;
        }

        var emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;

        if (!emailPattern.test($(".tener_email").val())) {
            toastr.error("!Email is invalid¡");
            return true;
        }  

        return false;     
    }


 
</script>
{/block}