{extends file="$layouts_admin"}
{block name="head"}

<link
  href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css"
  rel="stylesheet"
/>




{/block}

{block name="content"}

<style type="text/css">

    .list-group{
        max-height: 150px;
        margin-bottom: 10px;
        overflow:scroll;
        -webkit-overflow-scrolling: touch;
    }    

    .swal2-container {
         z-index: 9999;
      }

.wrapper {
  overflow: hidden;  
}

ul.breadcrumbs {
  margin: 0;
  padding: 0;
  display: flex; /* Cambiar a flex para un mejor ajuste en pantallas pequeñas */
  flex-wrap: wrap; /* Permitir que los elementos se ajusten en múltiples líneas si es necesario */
  justify-content:center;
}

ul.breadcrumbs li {
  position: relative;
  margin: 0;
  padding: 0;
  list-style: none;
  display: inline-block;
  border-left: 1px solid #ccc;
  transition: 0.3s ease;
}

ul.breadcrumbs li:hover:before {
  /* border-left: 10px solid #5e6e82; */
}

ul.breadcrumbs li:hover a {
  /* color: white;
  background: #5e6e82; */
 
}

ul.breadcrumbs li:before {
  content: "";
  position: absolute;
  right: -9px;
  top: 50%; /* Centrar el triángulo verticalmente */
  transform: translateY(-50%); /* Ajustar la posición */
  z-index: 20;
  border-left: 10px solid #fff;
  border-top: 22px solid transparent;
  border-bottom: 22px solid transparent;
  transition: 0.3s ease;
}

ul.breadcrumbs li:after {
  content: "";
  position: absolute;
  right: -10px;
  top: 50%; /* Centrar el triángulo verticalmente */
  transform: translateY(-50%); /* Ajustar la posición */
  z-index: 10;
  border-left: 10px solid #ccc;
  border-top: 22px solid transparent;
  border-bottom: 22px solid transparent;
}

ul.breadcrumbs li.active {
  background: #5e6e82; /* Fondo para el activo */
}

ul.breadcrumbs li.active a {
  color: white !important; /* Color del texto activo */
  padding: 0 15px 0 25px; /* Ajustar el padding */
  background: #5e6e82;
}

ul.breadcrumbs li.first {
  border-left: none;
}

ul.breadcrumbs li.first a {
  font-size: 18px;
  padding-left: 20px;
  border-radius: 5px 0px 0px 5px;
}

ul.breadcrumbs li.last:before {
  display: none;
}

ul.breadcrumbs li.last:after {
  display: none;
}

ul.breadcrumbs li.last a {
  padding-right: 20px;
  border-radius: 0px 40px 40px 0px;
}

ul.breadcrumbs li a {
  display: block;
  font-size: 12px;
  line-height: 40px;
  color: #757575;
  padding: 0px 15px 0px 25px;
  text-decoration: none;
  background: #fff;
  border: 1px solid #ddd;
  white-space: nowrap; /* Evitar que el texto se envuelva */
  overflow: hidden;
  transition: 0.3s ease;
}

ul.breadcrumbs li.active:before {
  display: block; /* Mostrar el triángulo en el activo */
}

ul.breadcrumbs li.active:after {
  display: block; /* Mostrar el triángulo secundario en el activo */
}

@media (max-width: 768px) {
  ul.breadcrumbs {
    flex-direction: column; /* Cambiar a una columna en pantallas más pequeñas */
  }

  ul.breadcrumbs li {
    border-left: none; /* Eliminar el borde izquierdo en pantallas pequeñas */
    margin-bottom: 5px; /* Espaciado entre elementos */
    margin-right: 10px;
  }
}
ul.breadcrumbs li.active:before {
  border-left: 10px solid #5e6e82; /* Cambia el color del triángulo al hacer hover sobre el activo */
}

.cursor_manito {
  cursor: pointer;
}


.quitar_margin_pading{
   padding: 0px;
   margin: 0px;
}


   .btn-edit {
         margin-bottom: 4px; 
         background-color: #001b3b; 
         color: white; 
         border: 1px solid rgb(211, 202, 192) !important; 
         box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px; 
         float: inline-end;
   }

   .btn-eliminar {
      margin-bottom: 4px;
      background-color: red;
      color: white;
      border: 1px solid rgb(211, 202, 192) !important;
      box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px;
      float: inline-end;
    }

   .btn-edit:hover i,
   .btn-eliminar:hover i {
      color: white; /* Mantén el color blanco del icono en hover */
   }



</style>

    <input
         type="text"
         value="{$url_base}"
         disabled
         hidden
         id="URL_BASE"
    />

    <input
         type="text"
         value="{$id_user}"
         disabled
         hidden
         id="ID_USER"
    />

   <input
         type="text"
         value="{$existe_registro}"
         disabled
         hidden
         id="existe_registro"
    />

    <input
         type="text"
         value="{$UUID_ENC}"
         disabled
         hidden
         id="UUID_ENC"
    />

    <input
         type="text"
         value="{$UUID}"
         disabled
         hidden
         id="UUID"
    />

    <input
         type="text"
         value="{$id_ifp}"
         disabled
         hidden
         id="id_ifp"
    />

   <input type="text" id="url_modulo_api_direccion_smarty" name="url_modulo_api_direccion_smarty" class="form-control url_modulo_api_direccion_smarty" value="{$url_modulo_api_direccion_smarty}" disabled hidden >
   <input type="text" id="key_modulo_api_direccion_smarty" name="key_modulo_api_direccion_smarty" class="form-control key_modulo_api_direccion_smarty" value="{$key_modulo_api_direccion_smarty}" disabled hidden  >
   <input type="text" id="host_modulo_api_direccion_smarty" name="host_modulo_api_direccion_smarty" class="form-control host_modulo_api_direccion_smarty" value="{$host_modulo_api_direccion_smarty}" disabled hidden  >
   <input type="text" id="referer_modulo_api_direccion_smarty" name="referer_modulo_api_direccion_smarty" class="form-control referer_modulo_api_direccion_smarty" value="{$referer_modulo_api_direccion_smarty}" disabled hidden  >

 
   <textarea class="listado_usuarios" value="{$listado_staff_json}" disabled hidden>{$listado_staff_json}</textarea>


<div class="row pantalla_cargada"  style="display: none;">
   <div class="col-12 col-lg-12 col-sm-12 col-md-12">
      <div class="panel">
         <div class="panel-hdr">
            <h2><span></span>Prospecting Stages <span class="ms-2 titulo_cabecera_credito"></span> </h2>
 
         </div>

         <div class="panel-container show" id="ibox_form">
            <div class="panel-content">
               <div class="wrapper">
                  <ul class="breadcrumbs">
                     
                     <li class="cursor_manito enableMenu" data-id="datos_prestamos" style="display: none;">
                        <a>Loan details</a>
                     </li>

                     <li class="cursor_manito enableMenu" data-id="historial_crediticio" style="display: none;">
                        <a>Credit history</a>
                     </li>

                     <li
                        class="active cursor_manito"
                        data-id="general_information"
                     >
                        <a>General information</a>
                     </li>

                     <li class="cursor_manito" data-id="referencia">
                        <a>References</a>
                     </li>

                     <li class="cursor_manito" data-id="documento_respaldo">
                        <a>Supporting documents</a>
                     </li>

                     <li class="cursor_manito" data-id="preaprobacion">
                        <a>Pre-approval</a>
                     </li>

                     <li class="cursor_manito" data-id="plan_pago">
                        <a>Payment plan</a>
                     </li>

                     <li class="cursor_manito" data-id="desembolzo">
                        <a>Disbursement</a>
                     </li>

                     <!--  -->
                  </ul>
               </div>
            </div>
         </div>
      </div>
   </div>

   {*informacion general*}
   <div class="col-md-12">
      <div class="panel">
         <div class="panel-hdr">
            <h2>General Information</h2>

            <div class="panel-toolbar">
               <div class="btn-group">

                  {*
                     <button
                        class="btn btn-sm btn-default waves-effect waves-themed abrir_modal_contacto"
                     >
                        Upload contact information
                     </button>
                  *}
                   

                  <button
                     class="btn btn-sm btn-default btn-edicion"
                     data-edicion="1"
                  >
                     <i class="fa-solid fa-pencil"></i>
                     <span class="btn-edicion-text">Enable editing</span>
                  </button>

               </div>
            </div>
         </div>

         <div class="panel-container show" id="ibox_form" style=" border-radius: 18px; ">
            <div class="panel-content" style=" padding-bottom: 0px; ">
               <div class="px-2">
                  <div
                     class="alert alert-danger"
                     id="emsg"
                     style="display: none"
                  >
                     <span id="emsgbody"></span>
                  </div>

                  <div
                     class="alert alert-success"
                     id="emsgSuccess"
                     style="display: none"
                  >
                     <span id="emsgbodySuccess"></span>
                  </div>

                  <form id="rform">
                     <div class="row">
                        <input
                           type="text"
                           id="customer_id_ig"
                           name="customer_id_ig"
                           class="form-control customer_id_ig"
                           disabled
                           hidden
                        />

                        <div class="col-md-6 col-sm-12">
                           <div class="mb-3 row">
                              <label
                                 for="tipo_identificacion_ig"
                                 class="col-sm-3"
                                 ><span class="h6">Type of identification</span
                                 ><span class="text-danger">*</span></label
                              >

                              <div class="col-sm-9">
                                 <select
                                    id="tipo_identificacion_ig"
                                    name="tipo_identificacion_ig"
                                    class="form-select tipo_identificacion_ig"
                                 >
                                    <option value="" selected="" disabled="">
                                       Select a Option
                                    </option>
                                    <option value="DNI">DNI</option>
                                    <option value="RTN">RTN</option>
                                    <option value="Passport">Passport</option>
                                    <option value="Other">Other</option>
                                 </select>
                              </div>
                           </div>
                        </div>

                        <div class="col-md-6 col-sm-12">
                           <div class="mb-3 row">
                              <label
                                 for="numero_identificacion_ig"
                                 class="col-sm-3"
                                 ><span class="h6">Identification number</span
                                 ><span class="text-danger">*</span></label
                              >
                              <div class="col-sm-9">
                                 <input
                                    type="text"
                                    id="numero_identificacion_ig"
                                    name="numero_identificacion_ig"
                                    class="form-control numero_identificacion_ig"
                                 />
                              </div>
                           </div>
                        </div>

                        <input
                           type="text"
                           id="identificador_uuid_enc"
                           name="identificador_uuid_enc"
                           class="form-control identificador_uuid_enc"
                           disabled
                           hidden
                        />

 
                     </div>
                  </form>

 
               </div>

               <hr>
            </div>

             

            <div class="row quitar_margin_pading">

               <div class="col-12 quitar_margin_pading">
                  <button
                     class="btn btn-sm btn-default waves-effect waves-themed guardar_tabla_identificacion" 
                     style=" float: inline-end; margin-right: 21px; margin-bottom: 10px; "
                  >
                     Add information
                  </button>
               </div>

               <div class="col-12 quitar_margin_pading">
                  <div class="table-responsive" style=" border-radius: 5px; ">
                     <table
                        class="table table-striped table-hover estilosTabla"
                        id="clx_datatable"
                        style="margin: 0px"
                     >
                        <thead>
                           <tr>
                              <th class="centrar">Type of identification</th>
                              <th class="centrar">Identification number</th>
                        
                              <th class="centrar"></th>
                           </tr>
                        </thead>

                        <tbody class="tbody_envios_identificador">

                           <tr><th colspan="4" class="centrar " style=" text-align: center; "> No information</th></tr>
      
                        </tbody>
                     </table>
                  </div>
               </div>
            
            </div>
 

         </div>
      </div>
   </div>

   {*informacion del contacto*}
   <div class="col-md-12">
      <div class="panel">
         <div class="panel-hdr">
            <h2>General contact information</h2>

            <div class="panel-toolbar">
               <div class="btn-group">
                  <button
                     class="btn btn-sm btn-success waves-effect waves-themed abrir_modal_contacto"
                  >
                     Upload contact information
                  </button>
               </div>
            </div>
         </div>

         <div class="panel-container show" id="ibox_form">
            <div class="panel-content">
               <div class="px-2">
                  
                   <div class="row">
                        
 
                        <div class="col-md-6 col-sm-12">
                           <div class="mb-3 row">
                              <label for="nombre_completo_ig" class="col-sm-3"
                                 ><span class="h6">Full name</span
                                 ><span class="text-danger">*</span></label
                              >
                              <div class="col-sm-9">
                                 <input
                                    type="text"
                                    id="nombre_completo_ig"
                                    name="nombre_completo_ig"
                                    class="form-control nombre_completo_ig"
                                    disabled
                                 />
                              </div>
                           </div>
                        </div>

                        <div class="col-md-6 col-sm-12">
                           <div class="mb-3 row">
                              <label
                                 for="correo_electronico_ig"
                                 class="col-sm-3"
                                 ><span class="h6">Email</span
                                 ><span class="text-danger">*</span></label
                              >
                              <div class="col-sm-9">
                                 <input
                                    type="text"
                                    id="correo_electronico_ig"
                                    name="correo_electronico_ig"
                                    class="form-control correo_electronico_ig"
                                    disabled
                                 />
                              </div>
                           </div>
                        </div>

                        <div class="col-md-6 col-sm-12">
                           <div class="mb-3 row">
                              <label for="telefono_ig" class="col-sm-3"
                                 ><span class="h6">Phone</span
                                 ><span class="text-danger">*</span></label
                              >
                              <div class="col-sm-9">
                                 <input
                                    type="text"
                                    id="telefono_ig"
                                    name="telefono_ig"
                                    class="form-control telefono_ig"
                                    disabled
                                 />
                              </div>
                           </div>
                        </div>

                        <div class="col-md-6 col-sm-12">
                           <div class="mb-3 row">
                              <label for="grupo_ig" class="col-sm-3"
                                 ><span class="h6">Group</span
                                 ><span class="text-danger">*</span></label
                              >
                              <div class="col-sm-9">
                                 <input
                                    type="text"
                                    id="grupo_ig"
                                    name="grupo_ig"
                                    class="form-control grupo_ig"
                                    disabled
                                 />

                                 <input
                                    type="text"
                                    id="grupo_id_ig"
                                    name="grupo_id_ig"
                                    class="form-control grupo_id_ig"
                                    disabled
                                    hidden
                                 />
                              </div>
                           </div>
                        </div>
                     </div>
                 
               </div>
            </div>
         </div>
      </div>
   </div>


   {**}
   <div class="col-md-12 mostrarSoloContacto" style="display:none">
      <div class="panel">
         <div class="panel-hdr">
            <h2>Additional contact information</h2>
         </div>

         <div class="panel-container show" id="ibox_form">
            <div class="panel-content">
               <div class="px-2">
                  <form id="rform">
                     <div class="row">
                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label for="sex_aci" class="col-sm-3"
                                 ><span class="h6">Sex</span
                                 ><span class="text-danger">*</span></label
                              >
                              <div class="col-sm-9">
                                 <select
                                    id="sex_aci"
                                    name="sex_aci"
                                    class="form-select sex_aci"
                                 >
                                    <option value="Male">Male</option>
                                    <option value="Female">Female</option>
                                 </select>
                              </div>
                           </div>
                        </div>

                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label for="fecha_nacimiento_aci" class="col-sm-3"
                                 ><span class="h6">Birthdate</span
                                 ><span class="text-danger">*</span></label
                              >
                              <div class="col-sm-9">
                                 <input
                                    type="date"
                                    id="fecha_nacimiento_aci"
                                    name="fecha_nacimiento_aci"
                                    class="form-control fecha_nacimiento_aci"
                                 />
                              </div>
                           </div>
                        </div>

                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label for="estado_civil_aci" class="col-sm-3"
                                 ><span class="h6">Marital status</span
                                 ><span class="text-danger">*</span></label
                              >
                              <div class="col-sm-9">
                                 <select
                                    id="estado_civil_aci"
                                    name="estado_civil_aci"
                                    class="form-select estado_civil_aci"
                                 >
                                    <option value="" selected disabled>
                                       Select a options
                                    </option>
                                    <option value="1">Married</option>
                                    <option value="2">Single</option>
                                    <option value="3">Divorced</option>
                                 </select>
                              </div>
                           </div>
                        </div>
                     </div>
                  </form>
               </div>
            </div>
         </div>
      </div>
   </div>

   {**}
   <div class="col-md-12 mostrarSoloContacto" style="display:none">
      <div class="panel">
         <div class="panel-hdr">
            <h2>Home Information</h2>
         </div>

         <div class="panel-container show" id="ibox_form">
            <div class="panel-content">
               <div class="px-2">
                  <form id="rform">
                     <div class="row">
                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label for="country_hi" class="col-sm-3"
                                 ><span class="h6">Country</span
                                 ><span class="text-danger">*</span></label
                              >
                              <div class="col-sm-9">
                                 <select
                                    name="country_hi"
                                    id="country_hi"
                                    class="form-control country_hi"
                                 >
                                    <option value="">
                                       <span></span>Select country
                                    </option>
                                    {$countries}
                                 </select>
                              </div>
                           </div>
                        </div>

                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label for="address" class="col-sm-3"
                                 ><span class="h6">Address</span
                                 ><span class="text-danger">*</span>
                              </label>
                              <div class="col-sm-9">
                                 <input
                                    type="text"
                                    autocomplete="off"
                                    id="address"
                                    name="address"
                                    class="form-control address"
                                 />

                                 <ol class="list-group" id="browsers"></ol>
                              </div>
                           </div>
                        </div>

                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label for="ciudad_hi" class="col-sm-3"
                                 ><span class="h6">City</span
                                 ><span class="text-danger">*</span></label
                              >
                              <div class="col-sm-9">
                                 <input
                                    type="text"
                                    id="ciudad_hi"
                                    name="ciudad_hi"
                                    class="form-control ciudad_hi"
                                 />
                              </div>
                           </div>
                        </div>

                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label for="estado_hi" class="col-sm-3"
                                 ><span class="h6">State/Region</span
                                 ><span class="text-danger">*</span></label
                              >
                              <div class="col-sm-9">
                                 <input
                                    type="text"
                                    id="estado_hi"
                                    name="estado_hi"
                                    class="form-control estado_hi"
                                 />
                              </div>
                           </div>
                        </div>

                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label for="zip_hi" class="col-sm-3"
                                 ><span class="h6">ZIP/Postal Code</span
                                 ><span class="text-danger">*</span></label
                              >
                              <div class="col-sm-9">
                                 <input
                                    type="text"
                                    id="zip_hi"
                                    name="zip_hi"
                                    class="form-control zip_hi"
                                 />
                              </div>
                           </div>
                        </div>

                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label
                                 for="direccion_completa_hi"
                                 class="col-sm-3"
                                 ><span class="h6">Full address</span
                                 ><span class="text-danger">*</span></label
                              >
                              <div class="col-sm-9">
                                 <textarea
                                    rows="3"
                                    id="direccion_completa_hi"
                                    name="direccion_completa_hi"
                                    class="form-control direccion_completa_hi"
                                 ></textarea>
                              </div>
                           </div>
                        </div>

                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label for="tipo_residencial_hi" class="col-sm-3"
                                 ><span class="h6">Type of residence</span
                                 ><span class="text-danger">*</span></label
                              >
                              <div class="col-sm-9">
                                 <select
                                    id="tipo_residencial_hi"
                                    name="tipo_residencial_hi"
                                    class="form-select tipo_residencial_hi"
                                 >
                                    <option value="" selected="" disabled="">
                                       Select a Option
                                    </option>
                                    <option value="Own">Own</option>
                                    <option value="Rented">Rented</option>
                                    <option value="Family">Family</option>
                                 </select>
                              </div>
                           </div>
                        </div>

                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label for="tiempo_residir_hi" class="col-sm-3"
                                 ><span class="h6">Time to reside</span
                                 ><span class="text-danger">*</span></label
                              >
                              <div class="col-sm-9">
                                 {*
                                    <input
                                       type="text"
                                       id="tiempo_residir_hi"
                                       name="tiempo_residir_hi"
                                       class="form-control tiempo_residir_hi"
                                    />
                                 *}
                                  

                                 <div class="input-group mb-3">
                                    <input
                                       class="form-control tiempo_residir_hi"
                                       type="number"
                                       id="tiempo_residir_hi"
                                       name="tiempo_residir_hi"
                                    /><span class="input-group-text" >Years</span>
                                 </div>

                              </div>
                           </div>
                        </div>

                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label
                                 for="numero_dependiente_economico_hi"
                                 class="col-sm-3"
                                 ><span class="h6"
                                    >Number of financial dependents</span
                                 ><span class="text-danger">*</span></label
                              >
                              <div class="col-sm-9">
                                 <input
                                    type="number"
                                    id="numero_dependiente_economico_hi"
                                    name="numero_dependiente_economico_hi"
                                    class="form-control numero_dependiente_economico_hi"
                                 />
                              </div>
                           </div>
                        </div>
                     </div>
                  </form>
               </div>
            </div>
         </div>
      </div>
   </div>

   {**}
   <div class="col-md-12 mostrarSoloContacto" style="display:none">
      <div class="panel">
         <div class="panel-hdr">
            <h2>Economic Information</h2>
         </div>

         <div class="panel-container show" id="ibox_form">
            <div class="panel-content">
               <div class="px-2">
                  <form id="rform">
                     <div class="row">
                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label
                                 for="ocupacion_economica_ei"
                                 class="col-sm-3"
                                 ><span class="h6">Current occupation</span
                                 ><span class="text-danger">*</span></label
                              >
                              <div class="col-sm-9">
                                 <input
                                    type="text"
                                    id="ocupacion_economica_ei"
                                    name="ocupacion_economica_ei"
                                    class="form-control ocupacion_economica_ei"
                                 />
                              </div>
                           </div>
                        </div>

                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label for="lugar_trabajo_ei" class="col-sm-3"
                                 ><span class="h6">Workplace</span
                                 ><span class="text-danger">*</span></label
                              >
                              <div class="col-sm-9">
                                 <input
                                    type="text"
                                    id="lugar_trabajo_ei"
                                    name="lugar_trabajo_ei"
                                    class="form-control lugar_trabajo_ei"
                                 />
                              </div>
                           </div>
                        </div>

                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label for="tiempo_laborando_ei" class="col-sm-3"
                                 ><span class="h6">Time working</span
                                 ><span class="text-danger">*</span></label
                              >
                              <div class="col-sm-9">
                              {*
                                 <input
                                    type="number"
                                    id="tiempo_laborando_ei"
                                    name="tiempo_laborando_ei"
                                    class="form-control tiempo_laborando_ei"
                                 />
                              *}
                                  
                                 <div class="input-group mb-3">
                                    <input
                                       class="form-control tiempo_laborando_ei"
                                       type="number"
                                       id="tiempo_laborando_ei"
                                       name="tiempo_laborando_ei"
                                    /><span class="input-group-text" >Years</span>
                                 </div>


                              </div>
                           </div>
                        </div>

                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label
                                 for="ingreso_mensual_aproximado_ei"
                                 class="col-sm-3"
                                 ><span class="h6"
                                    >Approximate monthly income</span
                                 ><span class="text-danger">*</span></label
                              >
                              <div class="col-sm-9">

                                 {*
                                    <input
                                       type="number"
                                       id="ingreso_mensual_aproximado_ei"
                                       name="ingreso_mensual_aproximado_ei"
                                       class="form-control ingreso_mensual_aproximado_ei"
                                    />
                                 *}
                                  
                                 <div class="input-group">
                                    <input
                                    type="number"
                                    id="ingreso_mensual_aproximado_ei"
                                    name="ingreso_mensual_aproximado_ei"
                                    class="form-control ingreso_mensual_aproximado_ei"
                                    />
                                    <span class="input-group-text" >$</span>
                                 </div>


                              </div>
                           </div>
                        </div>

                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label
                                 for="otros_ingresos_mensuales_ei"
                                 class="col-sm-3"
                                 ><span class="h6">Other monthly income</span
                                 ><span class="text-danger"></span
                              ></label>
                              <div class="col-sm-9">

                                 {*
                                    <input
                                       type="number"
                                       id="otros_ingresos_mensuales_ei"
                                       name="otros_ingresos_mensuales_ei"
                                       class="form-control otros_ingresos_mensuales_ei"
                                    />
                                 *}

                                 <div class="input-group">
                                    <input
                                       type="number"
                                       id="otros_ingresos_mensuales_ei"
                                       name="otros_ingresos_mensuales_ei"
                                       class="form-control otros_ingresos_mensuales_ei"
                                    />
                                    <span class="input-group-text" >$</span>
                                 </div>

                              </div>
                           </div>
                        </div>

                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label
                                 for="gastos_mensaules_aproximados_ei"
                                 class="col-sm-3"
                                 ><span class="h6"
                                    >Approximate monthly expenses</span
                                 ><span class="text-danger">*</span></label
                              >
                              <div class="col-sm-9">

                                 {*
                                    <input
                                       type="number"
                                       id="gastos_mensaules_aproximados_ei"
                                       name="gastos_mensaules_aproximados_ei"
                                       class="form-control gastos_mensaules_aproximados_ei"
                                    />
                                 *}
                                 
                                 <div class="input-group">
                                    <input
                                       type="number"
                                       id="gastos_mensaules_aproximados_ei"
                                       name="gastos_mensaules_aproximados_ei"
                                       class="form-control gastos_mensaules_aproximados_ei"
                                    />
                                    <span class="input-group-text" >$</span>
                                 </div>

                              </div>
                           </div>
                        </div>
                     </div>
                  </form>
               </div>
            </div>
         </div>
      </div>
   </div>

   {**}
   <div class="col-md-12 mostrarSoloContacto" style="display:none">
      <div class="panel">
         <div class="panel-hdr">
            <h2>Loan information</h2>
         </div>

         <div class="panel-container show" id="ibox_form">
            <div class="panel-content">
               <div class="px-2">
                  <form id="rform">
                     <div class="row">
                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label
                                 for="valor_monto_solicitado_li"
                                 class="col-sm-3"
                                 ><span class="h6"
                                    >Value of the requested amount</span
                                 ><span class="text-danger">*</span></label
                              >
                              <div class="col-sm-9">
                              {*
                              <input
                                    type="number"
                                    id="valor_monto_solicitado_li"
                                    name="valor_monto_solicitado_li"
                                    class="form-control valor_monto_solicitado_li"
                                 />
                              
                              *}
                                  

                                 <div class="input-group mb-3">
                                    <input
                                       type="number"
                                       id="valor_monto_solicitado_li"
                                       name="valor_monto_solicitado_li"
                                       class="form-control valor_monto_solicitado_li"
                                    />
                                    
                                    <span class="input-group-text" >Years</span>
                                 </div>
                              </div>
                           </div>
                        </div>

                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label for="motivo_prestamo_li" class="col-sm-3"
                                 ><span class="h6">Reason for the loan</span
                                 ><span class="text-danger">*</span></label
                              >
                              <div class="col-sm-9">
                                 <textarea
                                    rows="3"
                                    id="motivo_prestamo_li"
                                    name="motivo_prestamo_li"
                                    class="form-control motivo_prestamo_li"
                                 ></textarea>
                              </div>
                           </div>
                        </div>
                     </div>
 
                  </form>
               </div>
            </div>
         </div>
      </div>
   </div>

   {**}
   <div class="col-md-12 mostrarSoloContacto" style="display:none">
      <div class="panel">
         <div class="panel-hdr">
            <h2>Referenced by</h2>
         </div>

         <div class="panel-container show" id="ibox_form">
            <div class="panel-content">
               <div class="px-2">
                  <div>
                     <div class="row">

                        <div class="col-md-12 col-sm-12">
                           <div class="mb-3 row">
                              <label for="referenciado_por_id" class="col-sm-3"
                                 ><span class="h6">Referenced by</span
                                 ><span class="text-danger">*</span></label
                              >
                              <div class="col-sm-9">
                                 <select
                                    id="referenciado_por_id"
                                    name="referenciado_por_id"
                                    class="form-select referenciado_por_id"
                                 >
                                    <option value="-1" >None</option>
                                    <option value="0" >Other</option>
                                    {foreach $listado_staff as $ds}
                                        <option value="{$ds['id']}" >{$ds['fullname']}</option>
                                    {/foreach}
                                 </select>
                              </div>
                           </div>
                        </div>

                        <div class="col-md-12 col-sm-12 oultar_nombre_referenciado_por"  style="display: none;">
                           <div class="mb-3 row">
                              <label
                                 for="nombre_referenciado_por"
                                 class="col-sm-3"
                                 ><span class="h6"
                                    >Name</span
                                 ><span class="text-danger">*</span></label
                              >
                              <div class="col-sm-9">
                                 <input
                                    type="text"
                                    id="nombre_referenciado_por"
                                    name="nombre_referenciado_por"
                                    class="form-control nombre_referenciado_por"
                                 />
                              </div>
                           </div>
                        </div>
                    
                     </div>

                     
                     <div class="row">
                        <div class="col-md-12">
                           <div class="mb-3" style="float: inline-end">
                              <button
                                 class="btn btn-primary mt-3 waves-effect waves-themed guardar_siguiente"
                                 type="button"
                                 id="submit"
                              >
                                 Save and Next
                              </button>

                              <button
                                 class="btn btn-primary mt-3 waves-effect waves-themed loading_guardar_siguiente"
                                 style="display: none"
                                 disabled
                              >
                                 <div
                                    style="display: flex; align-items: center"
                                 >
                                    <span
                                       class="spinner-border spinner-border-sm"
                                       style="
                                          height: 20px;
                                          width: 20px;
                                          margin-right: 5px;
                                       "
                                       role="status"
                                       aria-hidden="true"
                                    ></span>
                                    Save and Next
                                 </div>
                              </button>
                           </div>
                        </div>
                     </div>

                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>

</div>

<div class="row cargando_pantalla " style=" margin: 0px; ">

   <div
      class="container"
      style="
         display: flex;
         justify-content: center;
         align-items: center;
         height: 45vh;
         box-shadow: 0 0 13px 0 rgba(31,17,173,.08);
         border-radius: 11px;
         background-color: white;
      "
   >
      <div style="text-align: center">
         <span
         class="spinner-border spinner-border-sm"
         style="height: 45px; width: 45px; margin-bottom: 10px"
         role="status"
         aria-hidden="true"
         ></span>
         <br />
         <strong>Please wait while the screen loads...</strong>
         <br />
      </div>
   </div>

</div>


      <div
         class="modal fade"
         id="modalMensaje"
         data-bs-backdrop="static"
         data-bs-keyboard="false"
         tabindex="-1"
         aria-labelledby="staticBackdropLabel"
         aria-hidden="true"
      >
         <div class="modal-dialog modal-dialog-centered ">
            <div class="modal-content">
               <div class="modal-header">
                  <h5 class="modal-title modal_titulo_mensaje" id="staticBackdropLabel">
                     Group Message
                  </h5>
                  <button
                     type="button"
                     class="btn-close btn_cerrar_confirmacion_modal"
                  ></button>
               </div>
               <div class="modal-body text-center">
                  <p class="modal_contenido_mensaje">
                     The group advertising campaign has been sent. For more
                  </p>
               </div>
            </div>
         </div>
      </div>

<div class="modal fade" id="modal_asignar_clientes_contactos" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel4" aria-hidden="true">
   <div class="modal-dialog modal-dialog-centered  modal-xl" style="max-width: 80%;">
      <div class="modal-content">
         <div class="modal-header">
         <h5 class="modal-title" id="staticBackdropLabel4"> Search Customer </span></h5>

         <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
         </div>
         <div class="modal-body pantalla_modal" style=" background: white; ">
            <div style="display: flex">
               <input
                  type="text"
                  placeholder="search"
                  class="form-control form-control-sm buscador_asignar_clientes"
                  style="margin-right: 10px"
               />
               <button
                  class="btn"
                  id="btn_filtro_buscador_clientes"
                  type="button"
                  style="border-color: #d3cac0;border: 1px solid #d3cac0;background-color: white;"
               >
                  Search
               </button>
            </div>   
            <br />   
            <div class="row">
               <div class="col-sm-12" style=" background: white; border-radius: 4px; ">
                  <div class="table-responsive" style="height: 401px">
                     <!-- Agregado -->
                     <table class="table">
                        <thead>
                           <tr>
                              <th class="centrar">Account</th>
                              <th class="centrar">Phone</th>
                              <th class="centrar">Email</th>
                              <th class="centrar">Address</th>
                              <th class="centrar">Company</th>
                              <th class="centrar"></th>

                           </tr>
                        </thead>
                        <tbody class="tbody_asignar_clientes">
                        {*

                           <tr>
                              <td class="centrar">Juan</td>
                              <td class="centrar">Juan@live.com</td>
                              <td class="centrar">Satelite</td>
                              <td class="centrar">
                                 <button
                                    class="btn btn-primary"
                                    type="button"
                                 >
                                    Add
                                 </button>
                              </td>
                           </tr>
                        *}

                        </tbody>
                     </table>
                  </div>
                  <!-- Cierre del div table-responsive -->
               </div>
            </div>   
            <!-- <select
               class="tener_select_contact"
               name="select_contact"
               id="select_contact"
               style="width: 100%"
            ></select> -->
         </div>

      </div>
   </div>
</div>

<div class="modal fade" id="ventana_confirmacion" tabindex="-1" aria-labelledby="exampleModalLabel__ventanaconfirmacion" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false" >
   <div class="modal-dialog modal-dialog-centered"  >
      <div class="modal-content" style="background-color:white">
         <div class="modal-header">
         <h2 class="titulo_modal_confirmar">Estas seguro de eliminar</h2>
            <button type="button" class="btn-close "  id="btn_close_ventana_confirmacion" ></button>
         </div>
         <div class="modal-body" style="background-color:white;border-radius:10px">
          
            <div class="row">
               <div class="col-md-12">
                  <div class="panel-container show" id="ibox_form">
                           <div class="panel-content">
                              <div class="px-2">
                                    <div class="alert alert-danger" id="emsg" style="display: none;">
                                       <span id="emsgbody"></span>
                                    </div>
                                    <input class="tipo_modal_confirmar" hidden disabled/> 
                                    <input class="data_id" hidden disabled/> 
                                    <div class="row">
                                          <div class="col-md-12 col-sm-12">

                                                <h4 class="mensaje_modal_confirmar" style="text-align:center; color:black">Estas seguro de eliminar</h4>
                                                 
                                                 <p class="mensaje_espera_moda_confirmacion mt-3" style="text-align:center; color:red; font-weight:600">Espere mientras termina el proceso</p>
                                          </div>
                                     
                                       </div>

                                       <div class="row mt-2">
                                          <div class="col-md-12">
                                                <div  style="float: inline-end;" >

                                                  
                                                   <button class="btn me-2" type="button" id="btn_cerrar_ventana_confirmacion" style=" background: #001b3b; ">close</button>
                                                   <button class="btn " type="button" id="btn_aplicar_ventana_confirmacion" style=" background: red; ">Remove</button>
                                              
                                                    
                                                </div>
                                          </div>
                                       </div>
                              </div>
                           </div>
                        </div>
               </div>
            </div>
          
         </div>
         
      </div>
   </div>
</div>
 
{/block}

{block name="script"}

{literal}
<script>

   var listado_usuarios = $(".listado_usuarios").val() || "";



   var URL_BASE = $("#URL_BASE").val();

   var ID_USER = $("#ID_USER").val();
   var url_dashboard = $("#url_dashboard").val();

   var UUID_ENC = $("#UUID_ENC").val();
   var UUID     = $("#UUID").val();
   var id_ifp   = $("#id_ifp").val();

   var roll_id = $("#roll_id").val();
   var existe_registro = $("#existe_registro").val();
   
   var COLOR_FONDO_VENTANA_CERRAR = "#001b3b";
   var COLOR_TEXT_VENTANA_CERRAR = "white";

   var COLOR_FONDO_VENTANA_CONFIRMACION = "red";
   var COLOR_TEXT_VENTANA_CONFIRMACION = "white";

   var COLOR_FONDO_VENTANA_IR = "#001b3b";
   var COLOR_TEXT_VENTANA_IR = "white";
       
   var abreviaciones_estados = [
      { value: 'AL', text: 'Alabama' },
      { value: 'AK', text: 'Alaska' },
      { value: 'AZ', text: 'Arizona' },
      { value: 'AR', text: 'Arkansas' },
      { value: 'CA', text: 'California' },
      { value: 'CO', text: 'Colorado' },
      { value: 'CT', text: 'Connecticut' },
      { value: 'DE', text: 'Delaware' },
      { value: 'FL', text: 'Florida' },
      { value: 'GA', text: 'Georgia' },
      { value: 'HI', text: 'Hawaii' },
      { value: 'ID', text: 'Idaho' },
      { value: 'IL', text: 'Illinois' },
      { value: 'IN', text: 'Indiana' },
      { value: 'IA', text: 'Iowa' },
      { value: 'KS', text: 'Kansas' },
      { value: 'KY', text: 'Kentucky' },
      { value: 'LA', text: 'Louisiana' },
      { value: 'ME', text: 'Maine' },
      { value: 'MD', text: 'Maryland' },
      { value: 'MA', text: 'Massachusetts' },
      { value: 'MI', text: 'Michigan' }, // Agregado
      { value: 'MN', text: 'Minnesota' }, // Agregado
      { value: 'MS', text: 'Mississippi' }, // Agregado
      { value: 'MO', text: 'Missouri' }, // Agregado
      { value: 'MT', text: 'Montana' }, // Agregado
      { value: 'NE', text: 'Nebraska' }, // Agregado
      { value: 'NV', text: 'Nevada' }, // Agregado
      { value: 'NH', text: 'New Hampshire' }, // Agregado
      { value: 'NJ', text: 'New Jersey' }, // Agregado
      { value: 'NM', text: 'New Mexico' }, // Agregado
      { value: 'NY', text: 'New York' }, // Agregado
      { value: 'NC', text: 'North Carolina' }, // Agregado
      { value: 'ND', text: 'North Dakota' }, // Agregado
      { value: 'OH', text: 'Ohio' }, // Agregado
      { value: 'OK', text: 'Oklahoma' }, // Agregado
      { value: 'OR', text: 'Oregon' }, // Agregado
      { value: 'PA', text: 'Pennsylvania' }, // Agregado
      { value: 'RI', text: 'Rhode Island' }, // Agregado
      { value: 'SC', text: 'South Carolina' }, // Agregado
      { value: 'SD', text: 'South Dakota' }, // Agregado
      { value: 'TN', text: 'Tennessee' }, // Agregado
      { value: 'TX', text: 'Texas' }, // Agregado
      { value: 'UT', text: 'Utah' }, // Agregado
      { value: 'VT', text: 'Vermont' }, // Agregado
      { value: 'VA', text: 'Virginia' }, // Agregado
      { value: 'WA', text: 'Washington' }, // Agregado
      { value: 'WV', text: 'West Virginia' }, // Agregado
      { value: 'WI', text: 'Wisconsin' }, // Agregado
      { value: 'WY', text: 'Wyoming' }, // Agregado
      { value: 'DC', text: 'District of Columbia' },  
   ];

   var menus_disponibles = {};

   var staff_users = [];

   var listado_identificador = [];
   var eliminar_listado_identificador = [];

 
   $(document).ready(function () {

      if(isEmpty(listado_usuarios) == false)
      {
         try {
            staff_users = JSON.parse(listado_usuarios);
            //console.log("Parsed listado_usuarios: ", staff_users);
             
         } catch (error) {
            console.error("Error parsing listado_usuarios: ", error);
         }  
      }

      cargarPrincipal();
 
      var _url = '{$_url}';
    
      //para activar el country_hi
      $country_hi = $(".country_hi");
      $country_hi.select2();

      $('#submit_modal_confirmacion_correo').on('click', function() {
          window.location = url_dashboard;    
      });

      $("#btn_aplicar_ventana_confirmacion").off("click")
      .on("click", function () {

         console.log("se dio click");

            $('#btn_aplicar_ventana_confirmacion').prop('disabled', true);
            $('#btn_close_ventana_confirmacion').prop('disabled', true);
            $('#btn_cerrar_ventana_confirmacion').prop('disabled', true);

            //$(".mensaje_espera_moda_confirmacion").text("Please wait while the process finishes...");

            let opcion_predefinida = $(".tipo_modal_confirmar").val();
            let data_id = $(".data_id").val();

            if(opcion_predefinida == "navegar_pantalla_siguiente")
            {
               window.location = URL_BASE + "credit/reference-prospecting/"+data_id;

            }

            if(opcion_predefinida == "eliminar_identificador")
            {
               let BusquedadInformacion = listado_identificador.find(function(item) {
                  return item.UUID_ENC == data_id;
               });
 
               if(BusquedadInformacion)
               {
                  
                  let indiceAEliminar = listado_identificador.findIndex(
                     (obj) => obj.UUID_ENC == data_id 
                  );

                  if (indiceAEliminar !== -1) {
                     listado_identificador.splice(indiceAEliminar, 1);

                     console.log("BusquedadInformacion llegamos")
                     console.log(BusquedadInformacion)

                     if(isEmpty(BusquedadInformacion.id) == false)
                     {
                        eliminar_listado_identificador.push(BusquedadInformacion);
                     }

                     $(".tbody_envios_identificador").html(tabla_html_identificador(listado_identificador));
                     eventosTablaIdentificador();

                     $("#ventana_confirmacion").modal("hide");

                  }

               }

            }
 
       
      });

      $(".guardar_tabla_identificacion").off("click")
      .on("click", function () {
         
         let tipo_identificacion_ig = $(".tipo_identificacion_ig").val();
         let numero_identificacion_ig = $(".numero_identificacion_ig").val();
         let identificador_uuid_enc = $(".identificador_uuid_enc").val();

         if(isEmpty(tipo_identificacion_ig))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.tipo_identificacion_ig');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "General Information" the field "Type of identification" is required.');
            return;
         }

         if(isEmpty(numero_identificacion_ig))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.numero_identificacion_ig');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "General Information" the field "Identification number" is required.');
            return;
         }

         if(isEmpty(identificador_uuid_enc))
         {

            let UUID = generateUUIDv4(); 
            let UUID_ENC = uuidToBase64UrlRFC7515(UUID); 

            let informacionArmada = {
               UUID: UUID,
               UUID_ENC: UUID_ENC,
               tipo_identificacion: tipo_identificacion_ig,
               numero_identificacion: numero_identificacion_ig,
            };

            console.log(informacionArmada);
            listado_identificador.push(informacionArmada);

            $(".tbody_envios_identificador").html(tabla_html_identificador(listado_identificador));
            eventosTablaIdentificador();
            
            $(".identificador_uuid_enc").val("");
            $(".tipo_identificacion_ig").val("");
            $(".numero_identificacion_ig").val("");

         }else{
            
            let BusquedadInformacion = listado_identificador.find(function(item) {
               return item.UUID_ENC == identificador_uuid_enc;
            });

            if(BusquedadInformacion)
            {
               BusquedadInformacion.tipo_identificacion   = tipo_identificacion_ig;
               BusquedadInformacion.numero_identificacion = numero_identificacion_ig;

               $(".identificador_uuid_enc").val("");
               $(".tipo_identificacion_ig").val("");
               $(".numero_identificacion_ig").val("");

               $(".tbody_envios_identificador").html(tabla_html_identificador(listado_identificador));
               eventosTablaIdentificador();
            }

         }

 
      });

 
      function generateUUIDv4() {
         // Generar un prefijo único basado en microsegundos (similar a uniqid en PHP)
         const time_low = Date.now().toString(16).padStart(8, '0') + Math.random().toString(16).slice(2, 6);

         // Generar 8 bytes aleatorios para completar el UUID (similar a random_bytes en PHP)
         const array = new Uint8Array(8);
         crypto.getRandomValues(array);
         const extra_bytes = Array.from(array, byte => byte.toString(16).padStart(2, '0')).join('');

         // Unir las partes y crear el UUID v4
         const uuid = [
            // 32 bits para "time_low"
            time_low.slice(0, 8),
            // 16 bits para "time_mid"
            time_low.slice(8, 12),
            // 16 bits para "time_hi_and_version" (empieza con 4 para UUID v4)
            '4' + extra_bytes.slice(0, 3),
            // 16 bits para "clk_seq_hi_res" (empieza con 8, 9, A o B para UUID v4)
            ((parseInt(extra_bytes.slice(3, 7), 16) & 0x3fff) | 0x8000).toString(16),
            // 48 bits para "node"
            extra_bytes.slice(7, 12) + Math.random().toString(16).slice(2, 7)
         ].join('-');

         return uuid;
      }

      function uuidToBase64UrlRFC7515(uuid) {
         // Eliminar los guiones del UUID
         const cleanUuid = uuid.replace(/-/g, '');

         // Convertir el UUID de hexadecimal a binario
         const binaryUuid = new Uint8Array(cleanUuid.match(/.{1,2}/g).map(byte => parseInt(byte, 16)));

         // Convertir el binario a Base64
         const base64 = btoa(String.fromCharCode(...binaryUuid));

         // Convertir Base64 a formato URL-safe (RFC 7515)
         const base64Url = base64.replace(/\+/g, '-').replace(/\//g, '_').replace(/=/g, '');

         return base64Url;
      }
 
      $("#btn_cerrar_ventana_confirmacion").off("click")
      .on("click", function () {
         
         $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
         $('#btn_close_ventana_confirmacion').prop('disabled', false);
         $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
         $("#ventana_confirmacion").modal("hide");
       
      });

      $("#btn_close_ventana_confirmacion").off("click")
      .on("click", function () {

         $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
         $('#btn_close_ventana_confirmacion').prop('disabled', false);
         $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
         
         $("#ventana_confirmacion").modal("hide");
       
      });
 

      $('#btn_copiar_hipervinculo').click(function() {

         const url = $('.url_access').attr('href');

         navigator.clipboard.writeText(url)
            .then(() => {
                  alert('URL copied to clipboard: ' + url);  
            })
            .catch(err => {
                  console.error('Error copying URL: ', err);  
            });
      });

      $('.cursor_manito').click(function() {

         const atributo_data =  $(this).attr('data-id');

         if(atributo_data == "datos_prestamos")
         {
            window.location = URL_BASE + "credit/data-loans/" + UUID_ENC;
         }

         if(atributo_data == "historial_crediticio")
         {
            window.location = URL_BASE + "credit/credit-history/" + UUID_ENC;
         }

         if(atributo_data == "general_information")
         {
            return;
            if(menus_disponibles.general_information == 1)
            {
               window.location = URL_BASE + "credit/new-prospecting/" + UUID_ENC;
            }else{
               $("#modalMensaje").modal("show");
               $(".modal_titulo_mensaje").text("Prospecting stage");
               $(".modal_contenido_mensaje").text("You must complete each of the stages to reach that point.");
               $(".btn_cerrar_confirmacion_modal").attr("disabled", false);
            }
            
         }

         if(atributo_data == "referencia")
         {
            if(menus_disponibles.referencia == 1)
            {
               window.location = URL_BASE + "credit/reference-prospecting/" + UUID_ENC;
            }else{
               $("#modalMensaje").modal("show");
               $(".modal_titulo_mensaje").text("Prospecting stage");
               $(".modal_contenido_mensaje").text("You must complete each of the stages to reach that point.");
               $(".btn_cerrar_confirmacion_modal").attr("disabled", false);
            }
         }

         if(atributo_data == "documento_respaldo")
         {
            if(menus_disponibles.documento_respaldo == 1)
            {
               window.location = URL_BASE + "credit/supporting-document-prospecting/" + UUID_ENC;
            }else{
               $("#modalMensaje").modal("show");
               $(".modal_titulo_mensaje").text("Prospecting stage");
               $(".modal_contenido_mensaje").text("You must complete each of the stages to reach that point.");
               $(".btn_cerrar_confirmacion_modal").attr("disabled", false);
            }
         }

         if(atributo_data == "preaprobacion")
         {
            if(menus_disponibles.preaprobacion == 1)
            {
               window.location = URL_BASE + "credit/pre-approval-prospecting/" + UUID_ENC;
            }else{
               $("#modalMensaje").modal("show");
               $(".modal_titulo_mensaje").text("Prospecting stage");
               $(".modal_contenido_mensaje").text("You must complete each of the stages to reach that point.");
               $(".btn_cerrar_confirmacion_modal").attr("disabled", false);
            }
         }

         if(atributo_data == "plan_pago")
         {
            if(menus_disponibles.plan_pago == 1)
            {
               window.location = URL_BASE + "credit/payment-plan-prospecting/" + UUID_ENC;
            }else{
               $("#modalMensaje").modal("show");
               $(".modal_titulo_mensaje").text("Prospecting stage");
               $(".modal_contenido_mensaje").text("You must complete each of the stages to reach that point.");
               $(".btn_cerrar_confirmacion_modal").attr("disabled", false);
            }
         }

         if(atributo_data == "desembolzo")
         {
            if(menus_disponibles.desembolzo == 1)
            {
               window.location = URL_BASE + "credit/disbursement-prospecting/" + UUID_ENC;
            }else{
               $("#modalMensaje").modal("show");
               $(".modal_titulo_mensaje").text("Prospecting stage");
               $(".modal_contenido_mensaje").text("You must complete each of the stages to reach that point.");
               $(".btn_cerrar_confirmacion_modal").attr("disabled", false);
            }
         }
 
      });

      $('.btn_cerrar_confirmacion_modal').click(function() {
         $("#modalMensaje").modal("hide");
      });

      $('.abrir_modal_contacto').click(function() {
         $("#modal_asignar_clientes_contactos").modal("show");
      });

      $(".btn-edicion").off("click")
      .on("click", function () {

         const edicionValue = $(this).data('edicion');

         //console.log("edicionValue");
         //console.log(edicionValue);

         if(edicionValue == "1")
         {
            $(this).data("edicion", "2");
            $(".btn-edicion-text").text("Disable editing");

            $(".btn-edicion-text").text("Disable editing");

            $('input, select, button, textarea').prop('disabled', false);

            $(".guardar_siguiente").text("Save and Next");

            $(".btn-edicion").data("edicion", "2").attr("data-edicion", "2");

         }else{
            $(this).data("edicion", "1");
            $(".btn-edicion-text").text("Enable editing");

            $('input, select, button, textarea').prop('disabled', true);

            $(".guardar_siguiente").text("Next");

            $(".btn-edicion").data("edicion", "1").attr("data-edicion", "1");
         }

         $('.nombre_completo_ig, .telefono_ig, .correo_electronico_ig, .grupo_ig').prop('disabled', true);

         $('.back').prop('disabled', false);
         $('.btn-edicion').prop('disabled', false);
       
      });

      $('.guardar_siguiente').click(function() {

         
         //if(menus_disponibles.general_information == 1){
         //   window.location = URL_BASE + "credit/reference-prospecting/" + UUID_ENC;
         //   return;
         //}

         ///<button
         ///   class="btn btn-sm btn-default btn-edicion"
         ///   data-edicion="1"
         ///>

         //$(".btn-edicion").data("edicion", "1").attr("data-edicion", "1");

         let btn_edicion = $(".btn-edicion").data("edicion");

         console.log(btn_edicion);
         console.log("btn_edicion");

         if(menus_disponibles.general_information == 1 && btn_edicion == 1){
            window.location = URL_BASE + "credit/reference-prospecting/" + UUID_ENC;
            return;
         }

         let customer_id_ig = $(".customer_id_ig").val();
         let grupo_id_ig = $(".grupo_id_ig").val();

         if(isEmpty(customer_id_ig))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.abrir_modal_contacto');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "General contact information" you must select a contact');
            return;
         }

         let sex_aci = $(".sex_aci").val();

         if(isEmpty(sex_aci))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.sex_aci');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Additional contact information" the field "Sex" is required.');
            return;
         }

         let fecha_nacimiento_aci = $(".fecha_nacimiento_aci").val();

         if(isEmpty(fecha_nacimiento_aci))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.fecha_nacimiento_aci');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Additional contact information" the field "Birthdate" is required.');
            return;
         }

         let estado_civil_aci = $(".estado_civil_aci").val();

         if(isEmpty(estado_civil_aci))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.estado_civil_aci');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Additional contact information" the field "Marital status" is required.');
            return;
         }

         //------------
         let country_hi  = $(".country_hi").val();

         if(isEmpty(country_hi ))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.country_hi');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Home Information" the field "Country" is required.');
            return;
         }

         let address = $(".address").val();

         if(isEmpty(address))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.address');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Home Information" the field "Address" is required.');
            return;
         }

         let ciudad_hi = $(".ciudad_hi").val();

         if(isEmpty(ciudad_hi))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.ciudad_hi');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Home Information" the field "City" is required.');
            return;
         }

         let estado_hi = $(".estado_hi").val();

         if(isEmpty(estado_hi))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.estado_hi');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Home Information" the field "State/Region" is required.');
            return;
         }
         
         let zip_hi = $(".zip_hi").val();

         if(isEmpty(zip_hi))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.zip_hi');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Home Information" the field "ZIP/Postal Code" is required.');
            return;
         }

         let direccion_completa_hi = $(".direccion_completa_hi").val();

         if(isEmpty(direccion_completa_hi))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.direccion_completa_hi');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Home Information" the field "Full address" is required.');
            return;
         }

         let tipo_residencial_hi = $(".tipo_residencial_hi").val();

         if(isEmpty(tipo_residencial_hi))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.tipo_residencial_hi');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Home Information" the field "Type of residence" is required.');
            return;
         }

         let tiempo_residir_hi = $(".tiempo_residir_hi").val();

         if(isEmpty(tiempo_residir_hi))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.tiempo_residir_hi');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Home Information" the field "Time to reside" is required.');
            return;
         }

         let numero_dependiente_economico_hi = $(".numero_dependiente_economico_hi").val();

         if(isEmpty(numero_dependiente_economico_hi))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.numero_dependiente_economico_hi');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Home Information" the field "Number of financial dependents" is required.');
            return;
         }

         let ocupacion_economica_ei = $(".ocupacion_economica_ei").val();

         if(isEmpty(ocupacion_economica_ei))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.ocupacion_economica_ei');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Economic Information" the field "Current occupation" is required.');
            return;
         }

         let lugar_trabajo_ei = $(".lugar_trabajo_ei").val();

         if(isEmpty(lugar_trabajo_ei))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.lugar_trabajo_ei');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Economic Information" the field "Workplace" is required.');
            return;
         }

         let tiempo_laborando_ei = $(".tiempo_laborando_ei").val();

         if(isEmpty(tiempo_laborando_ei))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.tiempo_laborando_ei');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Economic Information" the field "Time working (months)" is required.');
            return;
         }

         let ingreso_mensual_aproximado_ei = $(".ingreso_mensual_aproximado_ei").val();

         if(isEmpty(ingreso_mensual_aproximado_ei))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.ingreso_mensual_aproximado_ei');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Economic Information" the field "Approximate monthly income" is required.');
            return;
         }

         let otros_ingresos_mensuales_ei = $(".otros_ingresos_mensuales_ei").val();

        
         if(isEmpty(otros_ingresos_mensuales_ei))
         {
            otros_ingresos_mensuales_ei = 0;
            /* 
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.otros_ingresos_mensuales_ei');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Economic Information" the field "Other monthly income" is required.');
            return;
            */
         }
      

         let gastos_mensaules_aproximados_ei = $(".gastos_mensaules_aproximados_ei").val();

         if(isEmpty(gastos_mensaules_aproximados_ei))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.gastos_mensaules_aproximados_ei');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Economic Information" the field "Approximate monthly expenses" is required.');
            return;
         }

         let valor_monto_solicitado_li = $(".valor_monto_solicitado_li").val();

         if(isEmpty(valor_monto_solicitado_li))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.valor_monto_solicitado_li');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Loan information" the field "Value of the requested amount" is required.');
            return;
         }

         let motivo_prestamo_li = $(".motivo_prestamo_li").val();

         if(isEmpty(motivo_prestamo_li))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.motivo_prestamo_li');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Loan information" the field "Reason for the loan" is required.');
            return;
         }

         let referenciado_por_id = $(".referenciado_por_id").val();
         let nombre_referenciado_por = $(".nombre_referenciado_por").val();

         if(referenciado_por_id == "0")
         {

            if(isEmpty(motivo_prestamo_li) == true)
            {
               toastr.options.onclick = function() {
                  const targetDiv = document.querySelector('.referenciado_por_id');
                  
                  if (targetDiv) {
                     targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
                  }
               }

               toastr.error('!In "Referenced by" the field "Referenced by" is required.');
               return;
            }   
             
         }

         if(referenciado_por_id == "-1")
         {
            nombre_referenciado_por = "NONE";
         }

         let validacionCaracteres = validateFormFields();

         if(validacionCaracteres == true)
         {
            return;
         }

         if(listado_identificador.length == 0)
         {
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.motivo_prestamo_li');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "General Information" the field "You must enter one or more identifiers" is required.');
            return;
         }
 
         //$("#emsg").hide();
         //$("#emsgSuccess").hide();
 
         //$("#submit").prop("disabled", true); // Deshabilitar el botón

         //customer_id_ig
         //grupo_id_ig
             
         var informacionEnviar = {
            id_ifp:                          id_ifp,
             customer_id_ig:                 customer_id_ig,
             grupo_id_ig:                    grupo_id_ig,

             tipo_identificacion_ig:         null,//tipo_identificacion_ig,
             numero_identificacion_ig:       null,//numero_identificacion_ig,
             sex_aci:                        sex_aci,
             fecha_nacimiento_aci:           fecha_nacimiento_aci,
             estado_civil_aci:               estado_civil_aci,

             country_hi:                     country_hi,
             address:                        address,
             ciudad_hi:                      ciudad_hi,
             estado_hi:                      estado_hi,
             zip_hi:                         zip_hi,
             direccion_completa_hi:          direccion_completa_hi,

             tipo_residencial_hi:            tipo_residencial_hi,
             tiempo_residir_hi:              tiempo_residir_hi,
             numero_dependiente_economico_hi:   numero_dependiente_economico_hi,
             ocupacion_economica_ei:            ocupacion_economica_ei,
             lugar_trabajo_ei:                  lugar_trabajo_ei,
             tiempo_laborando_ei:               tiempo_laborando_ei,
             ingreso_mensual_aproximado_ei:     ingreso_mensual_aproximado_ei,
             otros_ingresos_mensuales_ei:       otros_ingresos_mensuales_ei,
             gastos_mensaules_aproximados_ei:   gastos_mensaules_aproximados_ei,
             valor_monto_solicitado_li:         valor_monto_solicitado_li,
             motivo_prestamo_li:                motivo_prestamo_li,

             referenciado_por_id:               referenciado_por_id,
             nombre_referenciado_por:           nombre_referenciado_por,
             
             listado_identificador: listado_identificador,
             eliminar_listado_identificador: eliminar_listado_identificador,
         }; 

         //var listado_identificador = [];
         //var eliminar_listado_identificador = [];

         console.log(JSON.stringify(informacionEnviar));
         //console.log("return aqui abajo")
         //alert("return aqui abajo");
         //return;

         //return;
         //window.location = URL_BASE + "credit/reference-prospecting/UUID_ENCRIPTION";
         //return;

         $('input, select, button, textarea').prop('disabled', true);
         //$('.nombre_completo_ig, .correo_electronico_ig, .telefono_ig, .grupo_ig').prop('disabled', false);

         $('.loading_guardar_siguiente').css('display', '');
         $('.guardar_siguiente').css('display', 'none');

 
         
         $.ajax({
            type: "POST",
            url: URL_BASE + "credit/post-informacion-general-prospeccion",
            data: JSON.stringify(informacionEnviar), // Convertir datos a formato JSON
            contentType: "application/json", // Tipo de contenido JSON
            success: function (response) {

               $('input, select, button, textarea').prop('disabled', false);
               $('.nombre_completo_ig, .correo_electronico_ig, .telefono_ig, .grupo_ig').prop('disabled', true);

               $('.loading_guardar_siguiente').css('display', 'none');
               $('.guardar_siguiente').css('display', '');
               
               //console.log("Respuesta del servidor:", response);
               // Hacer algo con la respuesta del servidor
      
               try {
                  let info = JSON.parse(response);

                  if (info.type == "success") {
 
                     //jajaja
 
                     toastr.success(
                         "Record added",
                         "Record added successfully",
                     );

                     setTimeout(() => {
                       window.location = URL_BASE + "credit/reference-prospecting/"+info.UUID_ENC;
                     }, 1000);
                     
                     //navegarPantallaSiguiente(info.UUID_ENC); 
                     

                  } else if (info.type == "error") {
                     //Swal.fire({
                     //   icon: "error",
                     //   title: "Oops...",
                     //   text: info.message,
                     //});

                     ventanaError("Opps there was an error", info.message);

                  }
               } catch (error) {
                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: error,
                  //});

                  ventanaError("Opps there was an error.", error);
               }
            },
            error: function (xhr, status, error) {
               console.error("Error en la solicitud:", error);
               // Manejar errores aquí
               //Swal.fire({
               //   icon: "error",
               //   title: "Oops...",
               //   text: error,
               //});

               ventanaError("Opps there was an error.", error);

               $('input, select, button, textarea').prop('disabled', false);
               $('.nombre_completo_ig, .correo_electronico_ig, .telefono_ig, .grupo_ig').prop('disabled', true);

               $('.loading_guardar_siguiente').css('display', 'none');
               $('.guardar_siguiente').css('display', '');

            },
         });

      });



    });

   function contadorPosicion()
   {
      //if(menus_disponibles.general_information == 1)
      //{
      //   menus_disponibles.referencia = 1;
      //}

      /*
      if(menus_disponibles.referencia == 1)
      {
         menus_disponibles.documento_respaldo = 1;
      }
       
      if(menus_disponibles.documento_respaldo == 1)
      {
         menus_disponibles.preaprobacion = 1;
      }

      if(menus_disponibles.preaprobacion == 1)
      {
         menus_disponibles.plan_pago = 1;
      }

      if(menus_disponibles.plan_pago == 1)
      {
         menus_disponibles.desembolzo = 1;
      }
      */

      // Ordered list of properties to process
      const propertiesToCheck = [
         "general_information",
         "referencia",
         "documento_respaldo",
         "preaprobacion",
         "plan_pago",
         "desembolzo"
      ];

      // Find the first "1" and set the next property (if it's "2") to "1"
      for (let i = 0; i < propertiesToCheck.length - 1; i++) {
         const currentProp = propertiesToCheck[i];
         if (menus_disponibles[currentProp] === "1") {
            const nextProp = propertiesToCheck[i + 1];
            if (menus_disponibles[nextProp] === "2") {
                  menus_disponibles[nextProp] = "1";
                  break; // Stop after updating the next property
            }
         }
      }
  
   }

   function cargarPrincipal()
   {

      console.log("id_ifp")
      console.log(id_ifp)

      if(isEmpty(id_ifp) == true)
      {

         $.ajax({
            type: "POST",
            url: URL_BASE + "credit/get-data-information-general-prospecting-new",
            //data: JSON.stringify(data),
            contentType: "application/json", // Tipo de contenido JSON
            success: function (response) {
   
               try {
                  let info = JSON.parse(response);

                  if (info.type == "success") {

                     var data_credit_type_identification = info.data_credit_type_identification || [];
                     $("#tipo_identificacion_ig").html(select_html(data_credit_type_identification));

                     $(".cargando_pantalla").css("display", "none");
                     $(".pantalla_cargada").css("display", "");
                     $(".btn-edicion").css("display", "none");
   
                  } else if (info.type == "error") {
                     //Swal.fire({
                     //   icon: "error",
                     //   title: "Oops...",
                     //   text: info.message,
                     //});

                     ventanaError("Opps there was an error", info.message);
                  }
               } catch (error) {
                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: error,
                  //});

                  ventanaError("Opps there was an error", error);
               }
            },
            error: function (xhr, status, error) {
               console.error("Error en la solicitud:", error);
               // Manejar errores aquí
               //Swal.fire({
               //   icon: "error",
               //   title: "Oops...",
               //   text: error,
               //});

               ventanaError("Opps there was an error", error);

            },
         });
 

      }else{

         let data = {
            id_gip: id_ifp,
         };

         //console.log("data");
         //console.log(data);
         //return;

         $.ajax({
            type: "POST",
            url: URL_BASE + "credit/get-data-information-general-prospecting",
            data: JSON.stringify(data),
            contentType: "application/json", // Tipo de contenido JSON
            success: function (response) {
   
               try {
                  let info = JSON.parse(response);

                  if (info.type == "success") {

                     menus_disponibles = info.menu_habilitados || {};

                     let dataIGP = info.data_gip || {};

                     console.log("dataIGP");
                     console.log(dataIGP);

                     var data_credit_type_identification = info.data_credit_type_identification || [];
                     $("#tipo_identificacion_ig").html(select_html(data_credit_type_identification));

                     listado_identificador = info.data_listado_identificador || [];

                     $(".tbody_envios_identificador").html(tabla_html_identificador(listado_identificador));
                     eventosTablaIdentificador();



                     if(Object.keys(dataIGP).length != 0)
                     {

                        customer_id_ig = dataIGP.customer_id_ig || ""; 
                        grupo_id_ig    = dataIGP.grupo_id_ig || "";
                        
                        $(".customer_id_ig").val(customer_id_ig);
                        $(".grupo_id_ig").val(grupo_id_ig);                        

                        $(".tipo_identificacion_ig").val(dataIGP.tipo_identificacion_ig);
                        $(".numero_identificacion_ig").val(dataIGP.numero_identificacion_ig);
                        $(".sex_aci").val(dataIGP.sex_aci);
                        $(".fecha_nacimiento_aci").val(dataIGP.fecha_nacimiento_aci);
                        $(".estado_civil_aci").val(dataIGP.estado_civil_aci);
                        $(".country_hi").val(dataIGP.country_hi);
                        $(".address").val(dataIGP.address);
                        $(".ciudad_hi").val(dataIGP.ciudad_hi);
                        $(".estado_hi").val(dataIGP.estado_hi);
                        $(".zip_hi").val(dataIGP.zip_hi);
                        $(".direccion_completa_hi").val(dataIGP.direccion_completa_hi);
                        $(".tipo_residencial_hi").val(dataIGP.tipo_residencial_hi);
                        $(".numero_dependiente_economico_hi").val(dataIGP.numero_dependiente_economico_hi);
                        $(".ocupacion_economica_ei").val(dataIGP.ocupacion_economica_ei);
                        $(".lugar_trabajo_ei").val(dataIGP.lugar_trabajo_ei);
                        $(".tiempo_laborando_ei").val(dataIGP.tiempo_laborando_ei);
                        $(".ingreso_mensual_aproximado_ei").val(dataIGP.ingreso_mensual_aproximado_ei);
                        $(".otros_ingresos_mensuales_ei").val(dataIGP.otros_ingresos_mensuales_ei);
                        $(".gastos_mensaules_aproximados_ei").val(dataIGP.gastos_mensaules_aproximados_ei);
                        $(".valor_monto_solicitado_li").val(dataIGP.valor_monto_solicitado_li);
                        $(".motivo_prestamo_li").val(dataIGP.motivo_prestamo_li);

                        $(".nombre_completo_ig").val(dataIGP.account);
                        $(".telefono_ig").val(dataIGP.phone);
                        $(".correo_electronico_ig").val(dataIGP.email);
                        $(".grupo_ig").val(dataIGP.gname);
                        $(".tiempo_residir_hi").val(dataIGP.tiempo_residir_hi);

                        $(".referenciado_por_id").val(dataIGP.referenciado_por_id);
                        $(".nombre_referenciado_por").val(dataIGP.nombre_referenciado_por);
 
                        $(".oultar_nombre_referenciado_por").css("display", "");

                        if(dataIGP.referenciado_por_id != "0")
                        {  
                           $(".oultar_nombre_referenciado_por").css("display", "none");
                        } 

                        //habilitar el modo de edicion
                        $(".btn-edicion").attr("data-edicion", "1");
                        $(".btn-edicion-text").text("Enabled editing");

                        $('input, select, button, textarea').prop('disabled', true);
                        $('.back').prop('disabled', false);
                        $('.btn-edicion').prop('disabled', false);
                        $('.guardar_siguiente').prop('disabled', false);

                        $(".guardar_siguiente").text("Next");

                        $(".abrir_modal_contacto").css("display", "none");


                        if(isEmpty(dataIGP.numero_credito) == true)
                        {
                           $(".titulo_cabecera_credito").text(" " + dataIGP.account);
                        }else{
                           $(".titulo_cabecera_credito").text(" No. Credit: " + dataIGP.numero_credito + " - " + dataIGP.account);
                        }

                        $(".mostrarSoloContacto").css("display", "");
            

                     } 


                      /*
                     if(menus_disponibles.preaprobacion == 1)
                     {
                        $(".btn-edicion").css("display", "none");
                        $(".guardar_rechazar").css("display", "none");
                        $(".guardar_borrador").css("display", "none");
                        $(".guardar_siguiente").css("display", "");

                        if(menus_disponibles.estado_prestamo != 5)
                        {
                           $(".guardar_siguiente").text("Next");
                           $(".guardar_siguiente").attr("disabled", false);
                        }else{
                           $(".guardar_siguiente").css("display", "none");
                        }
                        
                     }

                     
                     if(menus_disponibles.general_information == 1)
                     {
                        //habilitar el modo de edicion
                        $(".btn-edicion").attr("data-edicion", "2");
                        $(".btn-edicion-text").text("Disabled editing");

                        $('input, select, button, textarea').prop('disabled', false);
                        $('.back').prop('disabled', false);
                        $('.btn-edicion').prop('disabled', false);

                        $(".btn-edicion").css("display", "");
                        $(".guardar_siguiente").text("Next");

                        $('.guardar_siguiente').prop('disabled', true);

                        console.log("guardar_siguiente");
                     }
                     */

                     if(menus_disponibles.preaprobacion == 1)
                     {
                        $(".btn-edicion").css("display", "none");
                        $(".btn-eliminar-referencia-personal").css("display", "none");
                        $(".btn-edit-referencia-personal").css("display", "none");

                        $(".add_reference").css("display", "none");
                        $(".add_aval").css("display", "none");
                        $(".guardar_siguiente").css("display", "");

                        if(menus_disponibles.estado_prestamo != 5)
                        {
                           $(".guardar_siguiente").text("Next");
                           $(".guardar_siguiente").attr("disabled", false);
                        }
                        
                     }

                     if(menus_disponibles.desembolzo == 1 && menus_disponibles.estado_prestamo == 4)
                     {
                        $(".enableMenu").css("display", "");
                     }

                     console.log("menus_disponibles");
                     console.log(menus_disponibles);

                     contadorPosicion();

                      
                  

                     $(".cargando_pantalla").css("display", "none");
                     $(".pantalla_cargada").css("display", "");
   
                  } else if (info.type == "error") {
                     //Swal.fire({
                     //   icon: "error",
                     //   title: "Oops...",
                     //   text: info.message,
                     //});

                     ventanaError("Opps there was an error", info.message);
                  }
               } catch (error) {
                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: error,
                  //});

                  ventanaError("Opps there was an error", error);
               }
            },
            error: function (xhr, status, error) {
               console.error("Error en la solicitud:", error);
               // Manejar errores aquí
               //Swal.fire({
               //   icon: "error",
               //   title: "Oops...",
               //   text: error,
               //});

               ventanaError("Opps there was an error", error);

            },
         });

      }

   }

   function navegarPantallaSiguiente(UUID_ENC_)
   {
      $(".titulo_modal_confirmar").text("Record added");
      $(".mensaje_modal_confirmar").text("¡Record added successfully!");
      $(".mensaje_espera_moda_confirmacion").text("");
      $(".tipo_modal_confirmar").val("navegar_pantalla_siguiente");
      $(".data_id").val(UUID_ENC_);

      $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
      $('#btn_close_ventana_confirmacion').prop('disabled', false);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
 
      $('#btn_cerrar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR,
         'display': "none",
      });

      $('#btn_close_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR,
         'display': "none",
      });
 
      $('#btn_aplicar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_IR,
         'color': COLOR_TEXT_VENTANA_IR,
         'display': "",
      });

      $('#btn_aplicar_ventana_confirmacion').text("Continue");
 
      $("#ventana_confirmacion").modal("show");
   }


   function isEmpty(value) {
       // Verificar si es null o undefined
       if (value == null) return true;

       // Verificar si es una cadena vacía
       if (typeof value === "string" && value.trim() === "") return true;

       // Verificar si es un array vacío
       if (Array.isArray(value) && value.length === 0) return true;

       // Verificar si es un objeto vacío
       if (typeof value === "object" && Object.keys(value).length === 0) return true;

       return false;
   }

   function select_html(arreglo) {
      let html = "<option value='' selected disabled >Select a option</option>";
   
      arreglo.forEach(function (element) {
         let {
            id,
            name,
            activo,
        } = element;

         html += `<option value="${name}">${name}</option>`;
      });

      return html;
   }
 
   function validarSoloNumeros(input) {
       const number = parseInt(input, 10);
       return !isNaN(number) && number.toString() === input;
   }

   function validateEmail(email) {
      // Expresión regular para validar un formato de correo electrónico
      var emailPattern = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/;
      
      if (emailPattern.test(email)) {
         return true;  // Es un correo válido
      } else {
         return false;  // No es un correo válido
      }
   }

   $("#btn_filtro_buscador_clientes").click(async function () {
            
      console.log("btn_filtro_buscador_clientes");

      let filtro = $(".buscador_asignar_clientes").val() || "";

      if (isEmpty(filtro) == true) {
         Swal.fire("the search is empty!");
         return;
      }

      let filtro_staff = filtro.toLowerCase();

      let informacion = {
         filtro: filtro_staff,
      };

      console.log("informacion");
      console.log(informacion);

      $('#btn_filtro_buscador_clientes').prop('disabled', true);

      $.ajax({
            type: "POST",
            url: URL_BASE + "credit/filtra-listado-customers",
            data: JSON.stringify(informacion), // Convertir datos a formato JSON
            contentType: "application/json", // Tipo de contenido JSON
            success: function (response) {

               $('#btn_filtro_buscador_clientes').prop('disabled', false);
               
               //console.log("Respuesta del servidor:", response);
               // Hacer algo con la respuesta del servidor

   
               try {
                  let info = JSON.parse(response);

                  if (info.type == "success") {

                     let data = info.data || [];

                     console.log("data");
                     console.log(data);
                     
                     let miHtml = tabla_html_customers(data);
                     console.log("miHtml");
                     console.log(miHtml);

                     $(".tbody_asignar_clientes").html(miHtml);
                     
                     add_evento_select_cliente_contactos(data);

                      
                  } else if (info.type == "error") {
                     Swal.fire({
                        icon: "error",
                        title: "Oops...",
                        text: info.message,
                     });
                  }
               } catch (error) {
                  Swal.fire({
                     icon: "error",
                     title: "Oops...",
                     text: error,
                  });
               }
            },
            error: function (xhr, status, error) {
               console.error("Error en la solicitud:", error);
               // Manejar errores aquí
               Swal.fire({
                  icon: "error",
                  title: "Oops...",
                  text: error,
               });

               $('#btn_filtro_buscador_clientes').prop('disabled', false);

            },
         });
   
     
   });

   function tabla_html_customers(arreglo) {
      let html = "";
   
      arreglo.forEach(function (element) {
         let { id, account, phone, email, address, company } = element;

         html +=
            "<tr>" +
            //
            "<td class='centrar'>" +
            account +
            "</td>" +
            //
            "<td class='centrar'>" +
            phone +
            "</td>" +
            //
            "<td class='centrar'>" +
            email +
            "</td>" +
            //
            "<td class='centrar'>" +
            address +
            "</td>" +
            //
            //
            "<td class='centrar'>" +
            company +
            "</td>" +
            //
            "<td class='centrar'>" +
            "<button class='btn  btn_add_cliente_contacts' type='button' data-cliente_id='" +
            id +
            "' style='border-color: #d3cac0;border: 1px solid #d3cac0;background-color: white;'>Add</button>" +
            "</td>" +
            "</tr>";
      });

      return html;
   }

   function add_evento_select_cliente_contactos(arreglo_data = [])
   {
      $(".btn_add_cliente_contacts")
      .off("click")
      .on("click", function () {

         let {

            cliente_id,

         } = $(this).data();

         if(isEmpty(cliente_id))
         {
            toastr.error("!Customer ID is required¡");
            return;
         }

         let findData = arreglo_data.find((item) => item.id == cliente_id);

         if(findData)
         {
            $(".customer_id_ig").val(findData.id);
            $(".nombre_completo_ig").val(findData.account);
            $(".correo_electronico_ig").val(findData.email);
            $(".grupo_id_ig").val(findData.gid);
            $(".grupo_ig").val(findData.gname);
            $(".telefono_ig").val(findData.phone);
            $(".ocupacion_economica_ei").val(findData.position);
 
            $("#modal_asignar_clientes_contactos").modal("hide");

            toastr.success("!Customer added successfully¡");
            
            $(".mostrarSoloContacto").css("display", "");

         } else {
            toastr.error("!Customer not found¡");
         }

         console.log("cliente_id");
         console.log(cliente_id);  
 
      });
   }

   function validateFormFields() {
      const fields = [
         { selector: '.tipo_identificacion_ig', section: 'General Information', name: 'Type of identification' },
         { selector: '.numero_identificacion_ig', section: 'General Information', name: 'Identification number' },
         { selector: '.customer_id_ig', section: 'General contact information', name: 'Contact', target: '.abrir_modal_contacto' },
         { selector: '.sex_aci', section: 'Additional contact information', name: 'Sex' },
         { selector: '.fecha_nacimiento_aci', section: 'Additional contact information', name: 'Birthdate' },
         { selector: '.estado_civil_aci', section: 'Additional contact information', name: 'Marital status' },



         { selector: '.country_hi', section: 'Home Information', name: 'Country' },
         { selector: '.address', section: 'Home Information', name: 'Address' },
         { selector: '.ciudad_hi', section: 'Home Information', name: 'City' },
         { selector: '.estado_hi', section: 'Home Information', name: 'State/Region' },
         { selector: '.zip_hi', section: 'Home Information', name: 'ZIP/Postal Code' },


         { selector: '.direccion_completa_hi', section: 'Home Information', name: 'Full address' },
         { selector: '.tipo_residencial_hi', section: 'Home Information', name: 'Type of residence' },
         { selector: '.tiempo_residir_hi', section: 'Home Information', name: 'Time to reside' },
         { selector: '.numero_dependiente_economico_hi', section: 'Home Information', name: 'Number of financial dependents' },
         { selector: '.ocupacion_economica_ei', section: 'Economic Information', name: 'Current occupation' },
         { selector: '.lugar_trabajo_ei', section: 'Economic Information', name: 'Workplace' },
         { selector: '.tiempo_laborando_ei', section: 'Economic Information', name: 'Time working (months)' },
         { selector: '.ingreso_mensual_aproximado_ei', section: 'Economic Information', name: 'Approximate monthly income' },
         { selector: '.otros_ingresos_mensuales_ei', section: 'Economic Information', name: 'Other monthly income' },
         { selector: '.gastos_mensaules_aproximados_ei', section: 'Economic Information', name: 'Approximate monthly expenses' },
         { selector: '.valor_monto_solicitado_li', section: 'Loan information', name: 'Value of the requested amount' },
         { selector: '.motivo_prestamo_li', section: 'Loan information', name: 'Reason for the loan' }
      ];
 
 
      for (const field of fields) {
         const value = $(field.selector).val() || "";
         if (value && value.length > 255) {
               toastr.options.onclick = function() {
                  const targetDiv = document.querySelector(field.target || field.selector);
                  if (targetDiv) {
                     targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
                  }
               };
               toastr.error(`In "${field.section}" the field "${field.name}" cannot exceed 255 characters.`);
               return true;
         }
      }
      
      return false;
   }

   function serach_address(address, secundary, option = 1) {
      let url_modulo_api_direccion_smarty = $(
         ".url_modulo_api_direccion_smarty",
      ).val();
      let key_modulo_api_direccion_smarty = $(
         ".key_modulo_api_direccion_smarty",
      ).val();
      let host_modulo_api_direccion_smarty = $(
         ".host_modulo_api_direccion_smarty",
      ).val();
      let referer_modulo_api_direccion_smarty = $(
         ".referer_modulo_api_direccion_smarty",
      ).val();

      //console.log("url_modulo_api_direccion_smarty");
      //console.log(url_modulo_api_direccion_smarty);
      //console.log("key_modulo_api_direccion_smarty");
      //console.log(key_modulo_api_direccion_smarty);
      //console.log("host_modulo_api_direccion_smarty");
      //console.log(host_modulo_api_direccion_smarty);
      //console.log("referer_modulo_api_direccion_smarty");
      //console.log(referer_modulo_api_direccion_smarty);

      if (
         isEmpty(url_modulo_api_direccion_smarty) == true ||
         isEmpty(key_modulo_api_direccion_smarty) == true ||
         isEmpty(host_modulo_api_direccion_smarty) == true ||
         isEmpty(referer_modulo_api_direccion_smarty) == true
      ) {
         return;
      }

      var country_hi = $(".country_hi").val();
      let x = address.trim();
      if (x.length > 2 && country_hi === "United States") {
         var settings = {
            //"url": "https://us-autocomplete-pro.api.smarty.com/lookup?key=188805315395749398&search="+address+"&selected="+secundary+"&include_only_cities=&include_only_states=&include_only_zip_codes=&exclude_states=&prefer_cities=&prefer_states=&prefer_zip_codes=&source=all",
            url:
               url_modulo_api_direccion_smarty +
               "/lookup?key=" +
               key_modulo_api_direccion_smarty +
               "&search=" +
               address +
               "&selected=" +
               secundary +
               "&include_only_cities=&include_only_states=&include_only_zip_codes=&exclude_states=&prefer_cities=&prefer_states=&prefer_zip_codes=&source=all",
            method: "GET",
            timeout: 0,
            headers: {
               //"Host": "us-autocomplete-pro.api.smarty.com",
               //"Referer": "https://hispanosdeexitollc.com"
               Host: host_modulo_api_direccion_smarty,
               Referer: referer_modulo_api_direccion_smarty,
            },
         };

         $("#browsers").html("");
         $("#browsers").show();

         $.ajax(settings).done(function (response) {
            $.each(response.suggestions, function (k, v) {
               let text =
                  v.street_line +
                  " " +
                  v.secondary +
                  " " +
                  v.city +
                  ", " +
                  v.state +
                  " " +
                  v.zipcode;
               let line =
                  v.street_line +
                  " " +
                  v.secondary +
                  " (" +
                  v.entries +
                  ") " +
                  v.city +
                  ", " +
                  v.state +
                  " " +
                  v.zipcode;
               let line2 = v.street_line + " " + v.secondary;
               let entries =
                  v.entries > 1
                     ? '<a href="#" data-data1="' +
                     line +
                     '" data-data2="' +
                     line2 +
                     '" class="addresssec"><span class="badge bg-primary rounded-pill">+ ' +
                     v.entries +
                     " Address</span></a>"
                     : "";
               let option =
                  '<li class="list-group-item d-flex justify-content-between align-items-start cursor_manito"><div class="ms-2 me-auto address1" data-data1="' +
                  v.city +
                  '" data-data2="' +
                  v.state +
                  '" data-data3="' +
                  v.zipcode +
                  '" data-data4="' +
                  v.street_line +
                  " " +
                  v.secondary +
                  '"><div class="fw-bold">' +
                  text +
                  "</div></div>" +
                  entries +
                  "</li>";
               $("#browsers").append(option);
               x++;
            });
         });
      }
   }

   $("input[name='address']").on("input", function (e) {
      var address = $(this).val();
      var country_hi = $(".country_hi").val();
      let x = address.trim();
      if (x.length > 2 && country_hi === "United States") {
         address = address.replace(/,/g, "");
         address = address.replace(/ /g, "+");
         address = address.replace(/#/g, "%23");
         serach_address(address, "", 1);
      }
   });

   $(document).on("click", ".address1", function (e) {
      e.preventDefault();
      $(".ciudad_hi").val($(this).data("data1"));
       
      $(".zip_hi").val($(this).data("data3"));
      $(".direccion_completa_hi").val($(this).data("data4"));
      

      let estado = $(this).data("data2");

      let buscarEstado = abreviaciones_estados.find((data) => data.value == estado);
      
      if(buscarEstado)
      {
         $(".estado_hi").val(buscarEstado.text);
      }else{
         $(".estado_hi").val(estado);
      }
      $('#address').val($(this).data('data4') + ", " + estado + " " + $(this).data("data3"));

      $("#browsers").hide();
   });

   $(document).on("click", ".addresssec", function (e) {
      e.preventDefault();
      let address = $(this).data("data2");
      $("#address").val(address);
      let secundary = $(this).data("data1");
      secundary = secundary.replace(/,/g, "");
      secundary = secundary.replace(/ /g, "+");
      secundary = secundary.replace(/#/g, "%23");
      address = address.replace(/,/g, "");
      address = address.replace(/ /g, "+");
      address = address.replace(/#/g, "%23");
      serach_address(address, secundary, 2);
   });

   function ventanaError(titulo, mensaje) {
      $(".titulo_modal_confirmar").text(titulo);
      $(".mensaje_modal_confirmar").text(mensaje);
      $(".mensaje_espera_moda_confirmacion").text("");
      $(".tipo_modal_confirmar").val("registro_exito");
      $(".data_id").val("");

      $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
      $('#btn_close_ventana_confirmacion').prop('disabled', false);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
 
      $('#btn_cerrar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR
      });

      $('#btn_aplicar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CONFIRMACION,
         'color': COLOR_TEXT_VENTANA_CONFIRMACION,
         'display': "none"
      });
 
      $("#ventana_confirmacion").modal("show");
   }

   $('#referenciado_por_id').on('change', function() {
      const selectedValue = $(this).val(); // Obtiene el valor de la opción seleccionada (id)
      const selectedText = $(this).find('option:selected').text(); // Obtiene el texto de la opción seleccionada (fullname)
      
      console.log('ID seleccionado:', selectedValue);
      console.log('Nombre seleccionado:', selectedText);

      $(".nombre_referenciado_por").val("");
      $(".oultar_nombre_referenciado_por").css("display", "");

      if(selectedValue != 0 && selectedValue != -1)
      {
         $(".nombre_referenciado_por").val(selectedText);
         $(".oultar_nombre_referenciado_por").css("display", "none");
      } 

      if(selectedValue == -1)
      {
         $(".nombre_referenciado_por").val("NONE");
         $(".oultar_nombre_referenciado_por").css("display", "none");
      }
 
   });

   function tabla_html_identificador(arreglo) {
      let html = "";
      
      arreglo.forEach(function (element) {

         let {
            UUID,
            UUID_ENC,
            tipo_identificacion,
            numero_identificacion,
         } = element;
 
         
         if(isEmpty(tipo_identificacion) == true)
         {
            tipo_identificacion =  "";
         }

         if(isEmpty(numero_identificacion) == true)
         {
            numero_identificacion =  "";
         }

         html +=
               "<tr>" +
               "<td class='centrar'>" + tipo_identificacion + "</td>" +
               "<td class='centrar'>" + numero_identificacion + "</td>" +
 
               "<td class='centrar'>" +
               "<div class='row'>" +
               "<div class='col-12 centrar-botones'>" +
 
               "<button class='btn btn-sm btn-edit waves-effect waves-themed' data-id='" + UUID_ENC + "'>" +
               "<i class='fas fa-pencil-square tamano-icono' aria-hidden='true'></i>" +
               "</button>" +
               "<button class='btn btn-sm btn-eliminar waves-effect waves-themed' data-id='" + UUID_ENC + "'>" +
               "<i class='fas fa-trash tamano-icono' aria-hidden='true'></i>" +
               "</button>" +
               "</div>" +
               "</div>" +
               "</td>" +

               "</tr>";
      });

      return html;
   }

   function eventosTablaIdentificador()
   {

      $('.btn-edit').off('click');
      $('.btn-eliminar').off('click');

      $('.btn-edit').on('click', function() {
         var dataId = $(this).data('id');
         console.log('ID de la referencia:', dataId);
      
         let BusquedadInformacion = listado_identificador.find(function(item) {
            return item.UUID_ENC == dataId;
         });

         if(isEmpty(BusquedadInformacion) == false)
         {
            console.log("BusquedadInformacion");
            console.log(BusquedadInformacion);

            $(".identificador_uuid_enc").val(dataId);
            $(".tipo_identificacion_ig").val(BusquedadInformacion.tipo_identificacion);
            $(".numero_identificacion_ig").val(BusquedadInformacion.numero_identificacion);
 
         }

      });

      $('.btn-eliminar').on('click', function() {
         var dataId = $(this).data('id');
         console.log('ID de la referencia:', dataId);
      
         $(".titulo_modal_confirmar").text("You are sure?");
         $(".mensaje_modal_confirmar").text("Are you sure you want to delete this record?");
         $(".mensaje_espera_moda_confirmacion").text("");
         $(".tipo_modal_confirmar").val("eliminar_identificador");
         $(".data_id").val(dataId);

         $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
         $('#btn_close_ventana_confirmacion').prop('disabled', false);
         $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);

         //ventanaRegistroExito("Record deleted", "The record has been successfully deleted");
         //return;
         
         $('#btn_cerrar_ventana_confirmacion').css({
            'background-color': COLOR_FONDO_VENTANA_CERRAR,
            'color': COLOR_TEXT_VENTANA_CERRAR,
            'display': "",
            
         });

         $('#btn_aplicar_ventana_confirmacion').css({
            'background-color': COLOR_FONDO_VENTANA_CONFIRMACION,
            'color': COLOR_TEXT_VENTANA_CONFIRMACION,
            'display': "",
         });

         $("#ventana_confirmacion").modal("show");
 
      });
      

   }

 
 
</script>
{/literal}


{/block}