{extends file="$layouts_admin"}
{block name="head"}

 

<link
  href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css"
  rel="stylesheet"
/>


{/block}

{block name="content"}

<style type="text/css">

    .list-group{
        max-height: 150px;
        margin-bottom: 10px;
        overflow:scroll;
        -webkit-overflow-scrolling: touch;
    }    

    .swal2-container {
         z-index: 9999;
      }

.wrapper {
  overflow: hidden;  
}

ul.breadcrumbs {
  margin: 0;
  padding: 0;
  display: flex; /* Cambiar a flex para un mejor ajuste en pantallas pequeñas */
  flex-wrap: wrap; /* Permitir que los elementos se ajusten en múltiples líneas si es necesario */
  justify-content:center;
}

ul.breadcrumbs li {
  position: relative;
  margin: 0;
  padding: 0;
  list-style: none;
  display: inline-block;
  border-left: 1px solid #ccc;
  transition: 0.3s ease;
}

ul.breadcrumbs li:hover:before {
  /* border-left: 10px solid #5e6e82; */
}

ul.breadcrumbs li:hover a {
  /* color: white;
  background: #5e6e82; */
 
}

ul.breadcrumbs li:before {
  content: "";
  position: absolute;
  right: -9px;
  top: 50%; /* Centrar el triángulo verticalmente */
  transform: translateY(-50%); /* Ajustar la posición */
  z-index: 20;
  border-left: 10px solid #fff;
  border-top: 22px solid transparent;
  border-bottom: 22px solid transparent;
  transition: 0.3s ease;
}

ul.breadcrumbs li:after {
  content: "";
  position: absolute;
  right: -10px;
  top: 50%; /* Centrar el triángulo verticalmente */
  transform: translateY(-50%); /* Ajustar la posición */
  z-index: 10;
  border-left: 10px solid #ccc;
  border-top: 22px solid transparent;
  border-bottom: 22px solid transparent;
}

ul.breadcrumbs li.active {
  background: #5e6e82; /* Fondo para el activo */
}

ul.breadcrumbs li.active a {
  color: white !important; /* Color del texto activo */
  padding: 0 15px 0 25px; /* Ajustar el padding */
  background: #5e6e82;
}

ul.breadcrumbs li.first {
  border-left: none;
}

ul.breadcrumbs li.first a {
  font-size: 18px;
  padding-left: 20px;
  border-radius: 5px 0px 0px 5px;
}

ul.breadcrumbs li.last:before {
  display: none;
}

ul.breadcrumbs li.last:after {
  display: none;
}

ul.breadcrumbs li.last a {
  padding-right: 20px;
  border-radius: 0px 40px 40px 0px;
}

ul.breadcrumbs li a {
  display: block;
  font-size: 12px;
  line-height: 40px;
  color: #757575;
  padding: 0px 15px 0px 25px;
  text-decoration: none;
  background: #fff;
  border: 1px solid #ddd;
  white-space: nowrap; /* Evitar que el texto se envuelva */
  overflow: hidden;
  transition: 0.3s ease;
}

ul.breadcrumbs li.active:before {
  display: block; /* Mostrar el triángulo en el activo */
}

ul.breadcrumbs li.active:after {
  display: block; /* Mostrar el triángulo secundario en el activo */
}

@media (max-width: 768px) {
  ul.breadcrumbs {
    flex-direction: column; /* Cambiar a una columna en pantallas más pequeñas */
  }

  ul.breadcrumbs li {
    border-left: none; /* Eliminar el borde izquierdo en pantallas pequeñas */
    margin-bottom: 5px; /* Espaciado entre elementos */
    margin-right: 10px;
  }
}
ul.breadcrumbs li.active:before {
  border-left: 10px solid #5e6e82; /* Cambia el color del triángulo al hacer hover sobre el activo */
}

.cursor_manito {
  cursor: pointer;
}

table.estilosTabla > :not(caption) > * > * {
        /*
        padding-top: 5px !important;
        padding-bottom: 5px !important;
        */
    }

    .quitar_borde_puntos_suspencivos{
        border: none;
        background: transparent;
    }

    .quitar_borde_puntos_suspencivos.dropdown-toggle::after {
        display: none;
    }

    table.estilosTabla > :not(caption) > tr {
        border-bottom: 1px solid #dee2e6; /* Bootstrap's default border color */
    }

    table.estilosTabla > :not(caption) > * > * {
        border-bottom: 1px solid #dee2e6; /* Bootstrap's default border color */
   }

   .btn-edit-referencia-personal {
         margin-bottom: 4px; 
         background-color: #001b3b; 
         color: white; 
         border: 1px solid rgb(211, 202, 192) !important; 
         box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px; 
         float: inline-end;
    }

   .btn-eliminar-referencia-personal {
      margin-bottom: 4px;
      background-color: red;
      color: white;
      border: 1px solid rgb(211, 202, 192) !important;
      box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px;
      float: inline-end;
    }

   .btn-edit-referencia-personal:hover i,
   .btn-eliminar-referencia-personal:hover i {
      color: white; /* Mantén el color blanco del icono en hover */
   }

   .tamano-icono{
      font-size:small;
   }
    
   .centrar-botones{
      text-align: center;
      justify-content: center;
      display: flex;
      padding: 0px;
   }

   .btn-descargar {
         margin-bottom: 4px; 
         background-color: #001b3b; 
         color: white; 
         border: 1px solid rgb(211, 202, 192) !important; 
         box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px; 
         float: inline-end;
    }

   .btn-eliminar {
      margin-bottom: 4px;
      background-color: red;
      color: white;
      border: 1px solid rgb(211, 202, 192) !important;
      box-shadow: rgba(60, 64, 67, 0.3) 0px 1px 2px 0px, rgba(60, 64, 67, 0.15) 0px 1px 3px 1px;
      float: inline-end;
    }

   .btn-descargar:hover i,
   .btn-eliminar:hover i {
      color: white; /* Mantén el color blanco del icono en hover */
   }

   @media (max-width: 576px)
   {
      .btn_general_plan{
         margin-top: 10px;
      }
   }

   .texto-p {
      color: #32325d;
      font-weight: 600;
   }

   .descargas {
      font-size: 20px;
      cursor: pointer;
      font-weight: 600;
      color: black;
     
   }
  
</style>

    <input
         type="text"
         value="{$url_base}"
         disabled
         hidden
         id="URL_BASE"
    />

     <input
         type="text"
         value="{$UUID_ENC}"
         disabled
         hidden
         id="UUID_ENC"
    />

    <input
         type="text"
         value="{$UUID}"
         disabled
         hidden
         id="UUID"
    />

    <input
         type="text"
         value="{$id}"
         disabled
         hidden
         id="id"
    />

    <input
         type="text"
         value="{$id_user}"
         disabled
         hidden
         id="ID_USER"
    />

 
<div class="row pantalla_cargada"  style="display: none;">
  

   {**}
   <div class="col-md-12">
      <div class="panel">
         <div class="panel-hdr">
            
            <div class="row">
               <div class="col-12">      
                  <h2>Upload signed file</h2>
               </div>
            </div>
       
            
         </div>

         <div class="panel-container show" id="ibox_form">
            <div class="panel-content">
               <div class="px-2">
                  <div class="row">
                    
                     <div class="col-md-12 col-sm-12 show-presentation">
                        <div class="mb-3 row">
                           <label for="file" class="col-sm-3"
                              ><span class="h6"
                                 >Upload digital file of contract signed by
                                 client.</span
                              ><span class="text-danger">*</span></label
                           >
                           <div class="col-sm-9">
                              <input
                                 type="file"
                                 id="file"
                                 name="file"
                                 class="form-control file"
                              />
                           </div>
                        </div>
                     </div>

                     <div class="col-md-12 col-sm-12 ">
                        <p class="texto-p">
                           Note: Here you can upload your document so the client can download and sign for their requested credit.
                        </p>
                     </div>

                     {**}
                     <div class="row card_container"></div>
                  </div>

                  <div class="row">
                     <div class="col-md-12">
                        <div
                           class="mb-3"
                           style="display: flex; justify-content: end"
                        >

                           {*
                              <button
                                 class="btn btn-default mt-2 waves-effect waves-themed back"
                                 type="button"
                                 id="submit"
                              >
                                 Back
                              </button>
                           *}
                            

                           {*---*}
                           <button
                              class="btn btn-primary mt-2 waves-effect waves-themed guardar_siguiente"
                              type="button"
                              id="submit"
                           >
                              Upload files
                           </button>

                           <button
                              class="btn btn-primary mt-2 waves-effect waves-themed loading_guardar_siguiente"
                              style="display: none"
                              disabled
                           >
                              <div style="display: flex; align-items: center">
                                 <span
                                    class="spinner-border spinner-border-sm"
                                    style="
                                       height: 20px;
                                       width: 20px;
                                       margin-right: 5px;
                                    "
                                    role="status"
                                    aria-hidden="true"
                                 ></span>
                                 Upload files
                              </div>
                           </button>
                           {*---*}
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>

   {**}
   <div
      class="modal fade"
      id="modalMensaje"
      data-bs-backdrop="static"
      data-bs-keyboard="false"
      tabindex="-1"
      aria-labelledby="staticBackdropLabel"
      aria-hidden="true"
   >
      <div class="modal-dialog modal-dialog-centered">
         <div class="modal-content">
            <div class="modal-header">
               <h5
                  class="modal-title modal_titulo_mensaje"
                  id="staticBackdropLabel"
               >
                  Group Message
               </h5>
               <button
                  type="button"
                  class="btn-close btn_cerrar_confirmacion_modal"
               ></button>
            </div>
            <div class="modal-body text-center">
               <p class="modal_contenido_mensaje">
                  The group advertising campaign has been sent. For more
               </p>
            </div>
         </div>
      </div>
   </div>


   {**}
   <div
      class="modal fade"
      id="ventana_confirmacion"
      tabindex="-1"
      aria-labelledby="exampleModalLabel__ventanaconfirmacion"
      aria-hidden="true"
      data-bs-backdrop="static"
      data-bs-keyboard="false"
   >
      <div class="modal-dialog modal-dialog-centered">
         <div class="modal-content" style="background-color: white">
            <div class="modal-header">
               <h3 class="titulo_modal_confirmar">Estas seguro de eliminar</h3>
               <button
                  type="button"
                  class="btn-close"
                  id="btn_close_ventana_confirmacion"
               ></button>
            </div>
            <div
               class="modal-body"
               style="background-color: white; border-radius: 10px"
            >
               <div class="row">
                  <div class="col-md-12">
                     <div class="panel-container show" id="ibox_form">
                        <div class="panel-content">
                           <div class="px-2">
                              <div
                                 class="alert alert-danger"
                                 id="emsg"
                                 style="display: none"
                              >
                                 <span id="emsgbody"></span>
                              </div>
                              <input
                                 class="tipo_modal_confirmar"
                                 hidden
                                 disabled
                              />
                              <input class="data_id" hidden disabled />
                              <div class="row">
                                 <div class="col-md-12 col-sm-12">
                                    <h4
                                       class="mensaje_modal_confirmar"
                                       style="text-align: center; color: black"
                                    >
                                       Estas seguro de eliminar
                                    </h4>

                                    <p
                                       class="mensaje_espera_moda_confirmacion mt-3"
                                       style="
                                          text-align: center;
                                          color: red;
                                          font-weight: 600;
                                       "
                                    >
                                       Espere mientras termina el proceso
                                    </p>
                                 </div>
                              </div>

                              <div class="row mt-2">
                                 <div class="col-md-12">
                                    <div style="float: inline-end">
                                       <button
                                          class="btn me-2"
                                          type="button"
                                          id="btn_cerrar_ventana_confirmacion"
                                          style="background: #001b3b"
                                       >
                                          close
                                       </button>
                                       <button
                                          class="btn"
                                          type="button"
                                          id="btn_aplicar_ventana_confirmacion"
                                          style="background: red"
                                       >
                                          Remove
                                       </button>
                                    </div>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>


</div>

<div class="row cargando_pantalla " style=" margin: 0px; ">

   <div
      class="container"
      style="
         display: flex;
         justify-content: center;
         align-items: center;
         height: 45vh;
         box-shadow: 0 0 13px 0 rgba(31,17,173,.08);
         border-radius: 11px;
         background-color: white;
      "
   >
      <div style="text-align: center">
         <span
         class="spinner-border spinner-border-sm"
         style="height: 45px; width: 45px; margin-bottom: 10px"
         role="status"
         aria-hidden="true"
         ></span>
         <br />
         <strong>Please wait while the screen loads...</strong>
         <br />
      </div>
   </div>

</div>



{/block}

{block name="script"}

{literal}
<script>

   var URL_BASE = $("#URL_BASE").val();
   var ID_USER = $("#ID_USER").val();
   var url_dashboard = $("#url_dashboard").val();
   var roll_id = $("#roll_id").val();

   var UUID_ENC = $("#UUID_ENC").val();
   var UUID     = $("#UUID").val();
   var id   = $("#id").val();

   var COLOR_FONDO_VENTANA_CERRAR = "#001b3b";
   var COLOR_TEXT_VENTANA_CERRAR = "white";

   var COLOR_FONDO_VENTANA_CONFIRMACION = "red";
   var COLOR_TEXT_VENTANA_CONFIRMACION = "white";

   var COLOR_FONDO_VENTANA_IR = "#001b3b";
   var COLOR_TEXT_VENTANA_IR = "white";

   var base64 = "";
   var base64_original = "";
   var extension = "";
   var nombre_original = "";
 
   $(document).ready(function () {

      cargarPrincipal();
  
      $(".progress").hide();
      $("#emsg").hide();
      $("#emsgSuccess").hide();

      var _url = '{$_url}';
   
      $('#submit_modal_confirmacion_correo').on('click', function() {
         window.location = url_dashboard;    
      });
 
      $("#btn_aplicar_ventana_confirmacion").off("click")
      .on("click", function () {

            $('#btn_aplicar_ventana_confirmacion').prop('disabled', true);
            $('#btn_close_ventana_confirmacion').prop('disabled', true);
            $('#btn_cerrar_ventana_confirmacion').prop('disabled', true);
             
            let opcion_predefinida = $(".tipo_modal_confirmar").val();
            let data_id = $(".data_id").val();

            if(opcion_predefinida == "eliminar_card_documento")
            {
               $(".mensaje_espera_moda_confirmacion").text("Please wait while the process finishes...");

               $(".card_eliminar_" + data_id).remove();

               $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
               $('#btn_close_ventana_confirmacion').prop('disabled', false);
               $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
               
               //$("#ventana_confirmacion").modal("hide");

               ventanaRegistroExito("Record deleted", "¡The record has been successfully deleted!");

               $(".file").val("");

            }

            if(opcion_predefinida == "navegar_pantalla_siguiente")
            {
               window.location = URL_BASE + "credit/search-loans";
            }

            if(opcion_predefinida == "navegar_otras_pantallas")
            {
               window.location = URL_BASE + data_id;
            }
 
      });

      $("#btn_cerrar_ventana_confirmacion").off("click")
      .on("click", function () {
         
         $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
         $('#btn_close_ventana_confirmacion').prop('disabled', false);
         $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
         $("#ventana_confirmacion").modal("hide");
       
      });

      $("#btn_close_ventana_confirmacion").off("click")
      .on("click", function () {

         $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
         $('#btn_close_ventana_confirmacion').prop('disabled', false);
         $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
         
         $("#ventana_confirmacion").modal("hide");
       
      });

      $('.btn_cerrar_confirmacion_modal').click(function() {
         $("#modalMensaje").modal("hide");
      });

      $('.abrir_modal_contacto').click(function() {
         $("#modal_asignar_clientes_contactos").modal("show");
      });

      $('.back').click(function() {
          
         window.location = URL_BASE + "credit/pre-approval-prospecting/" + UUID_ENC;

      });

      $('.guardar_siguiente').click(function() {

         //window.location = URL_BASE + "credit/disbursement-prospecting/UUID_ENCRIPTION";
         //return;

         //cuando se le de click a guardar y siguiente, se cambira el estado
         guardarInformacion(1);
          
      });
 
      function guardarInformacion(esBorrador = 2)
      {
         
         if(isEmpty(base64))
         {
             
            toastr.options.onclick = function() {
               const targetDiv = document.querySelector('.plan_crediticio');
               
               if (targetDiv) {
                   targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
               }
            }

            toastr.error('!In "Upload signed file" the field "Upload digital file of contract signed by client" is required.');
            return;
         }
 
         let informacionFront = {
            id: id,
            base64: base64,
            base64_original: base64_original,
            nombre_original: nombre_original,
            extension: extension
         };

         $('input, select, button, textarea').prop('disabled', true);
       
         if(esBorrador == 1)
         {
            $('.loading_guardar_siguiente').css('display', '');
            $('.guardar_siguiente').css('display', 'none');
         }

         console.log(JSON.stringify(informacionFront));
         console.log("return aqui abajo")
         return;

         $.ajax({
            type: "POST",
            url: URL_BASE + "credit/post-upload-signed-file",
            data: JSON.stringify(informacionFront), // Convertir datos a formato JSON
            contentType: "application/json", // Tipo de contenido JSON
            success: function (response) {

               $('input, select, button, textarea').prop('disabled', false);
               $('.valor_monto_solicitado_li, .motivo_prestamo_li').prop('disabled', true);

               if(esBorrador == 1)
               {
                  $('.loading_guardar_siguiente').css('display', 'none');
                  $('.guardar_siguiente').css('display', '');
               }
 
               try {
                  let info = JSON.parse(response);

                  if (info.type == "success") {

                     if(esBorrador == 1)
                     {
                        ventanaRegistroExito("Draft saved successfully", "¡Draft saved successfully, you can edit again!"); 
                     }
                    
 
                  } else if (info.type == "error") {

                     //Swal.fire({
                     //   icon: "error",
                     //   title: "Oops...",
                     //   text: info.message,
                     //});

                     ventanaError("Opps there was an error", info.message);
                  }
               } catch (error) {

                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: error,
                  //});

                  ventanaError("Opps there was an error", error);
               }
            },
            error: function (xhr, status, error) {
               console.error("Error en la solicitud:", error);
            
               //Swal.fire({
               //   icon: "error",
               //   title: "Oops...",
               //   text: error,
               //});

               ventanaError("Opps there was an error", error);

               $('input, select, button, textarea').prop('disabled', false);
               $('.valor_monto_solicitado_li, .motivo_prestamo_li').prop('disabled', true);
 
               if(esBorrador == 1)
               {
                  $('.loading_guardar_siguiente').css('display', 'none');
                  $('.guardar_siguiente').css('display', '');
               }

            },
         });
 

      }

      function getFileBase64AndExtension(inputSelector, callback) {
         const fileInput = $(inputSelector)[0];
         if (!fileInput || !fileInput.files || fileInput.files.length === 0) {
            callback({ error: "No file selected" });
            return;
         }

         const file = fileInput.files[0];
         const reader = new FileReader();
         
         // Get file extension
         const fileName = file.name;
         const extension = fileName.split('.').pop().toLowerCase();

         reader.onload = function(e) {
            const base64String = e.target.result; // Full data URL (e.g., "data:image/png;base64,...")
            callback({
                  base64: base64String,
                  extension: extension,
                  name: file.name
            });
         };
 
         reader.onerror = function() {
            callback({ error: "Error reading file" });
         };

         reader.readAsDataURL(file);
      }

      // Example usage:
      $('.file').on('change', function() {
         getFileBase64AndExtension('#file', function(result) {
            if (result.error) {
                  toastr.error(result.error);
                  return;
            }

            base64_original  = result.base64;
            const base64Data = result.base64.split(',')[1]; // Extract only the Base64 part
            
            //console.log('Base64:', base64Data);
            //console.log('Extension:', );

            base64          = base64Data;
            extension       = result.extension;
            nombre_original = result.name;

            $(".card_container").html(generateCardHtml("id", extension, base64_original, nombre_original));
             
            eliminarDocumento();

            // Optional: Show success message
            //toastr.success(`File processed: ${result.extension} format`);
         });
      });


   });
 
   function cargarPrincipal()
   {

      if(isEmpty(id))
      {
         $(".cargando_pantalla").css("display", "none");
         $(".pantalla_cargada").css("display", "");

      }else{
         let data = {
            id: id,
         };

         console.log(JSON.stringify(data));
         //return;

         $.ajax({
            type: "POST",
            url: URL_BASE + "credit/get-upload-signed-file",
            data: JSON.stringify(data),
            contentType: "application/json", // Tipo de contenido JSON
            success: function (response) {
   
               try {
                  let info = JSON.parse(response);

                  if (info.type == "success") {

                     let data_disbursed = info.data_disbursed || {};
   
                     if(Object.keys(data_disbursed).length != 0)
                     {

                        //habilitar el modo de edicion
                        $(".btn-edicion").attr("data-edicion", "1");
                        $(".btn-edicion-text").text("Enabled editing");

                        $('input, select, button, textarea').prop('disabled', false);
                        $('.back').prop('disabled', false);
                        $('.btn-edicion').prop('disabled', false);

                        //$(".guardar_siguiente").css("display", "none");

                        let tipoArchivo = data_disbursed.extension || "";
                        let downloadUrl = data_disbursed.url_completa || "";
                        let fileName = data_disbursed.nombre_original || "";
    
                        $(".card_container").html(generateCardHtmlURL(id, tipoArchivo, downloadUrl, fileName));
                        
                        $(".btn-eliminar").css("display", "none");
                        //$(".show-presentation").css("display", "none");

                        $('.guardar_siguiente').prop('disabled', false);

                     }else{

                        /*
                        //habilitar el modo de edicion
                        $(".btn-edicion").attr("data-edicion", "2");
                        $(".btn-edicion-text").text("Disabled editing");

                        $('input, select, button, textarea').prop('disabled', false);
                        $('.valor_monto_solicitado_li, .motivo_prestamo_li').prop('disabled', true);

                        $('.back').prop('disabled', false);
                        $('.btn-edicion').prop('disabled', false);

                        $(".btn-edicion").css("display", "none");

                        $('.plan_crediticio, .cliente_aprueba, .btn_general_plan, .guardar_borrador, .guardar_siguiente ').prop('disabled', false);
                        */
                     }
 
                     $(".cargando_pantalla").css("display", "none");
                     $(".pantalla_cargada").css("display", "");
   
                  } else if (info.type == "error") {
                     //Swal.fire({
                     //   icon: "error",
                     //   title: "Oops...",
                     //   text: info.message,
                     //});

                     ventanaError("Opps there was an error", info.message);
                  }
               } catch (error) {
                  //Swal.fire({
                  //   icon: "error",
                  //   title: "Oops...",
                  //   text: error,
                  //});

                  ventanaError("Opps there was an error", error);
               }
            },
            error: function (xhr, status, error) {
               console.error("Error en la solicitud:", error);
               // Manejar errores aquí
               //Swal.fire({
               //   icon: "error",
               //   title: "Oops...",
               //   text: error,
               //});

               ventanaError("Opps there was an error", error);

            },
         });
      }
 
   }

   function eliminarDocumento() 
   {
      $('.btn-eliminar').off('click');

      $('.btn-eliminar').on('click', function() {
         
         let data_id = $(this).data("id");
         console.log("data_id eliminar: " + data_id);

         $(".titulo_modal_confirmar").text("You are sure?");
         $(".mensaje_modal_confirmar").text("Are you sure you want to delete this record?");
         $(".mensaje_espera_moda_confirmacion").text("");
         $(".tipo_modal_confirmar").val("eliminar_card_documento");
         $(".data_id").val(data_id);

         $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
         $('#btn_close_ventana_confirmacion').prop('disabled', false);
         $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);

         //ventanaRegistroExito("Record deleted", "The record has been successfully deleted");
         //return;
          
         $('#btn_cerrar_ventana_confirmacion').css({
            'background-color': COLOR_FONDO_VENTANA_CERRAR,
            'color': COLOR_TEXT_VENTANA_CERRAR,
            'display': "",
         });

         $('#btn_aplicar_ventana_confirmacion').css({
            'background-color': COLOR_FONDO_VENTANA_CONFIRMACION,
            'color': COLOR_TEXT_VENTANA_CONFIRMACION,
            'display': "",
         });
 
         $("#ventana_confirmacion").modal("show");

         //$(".card_eliminar_" + data_id).remove();

      });

 
   }
 
   function ventanaRegistroExito(titulo, mensaje) {
      $(".titulo_modal_confirmar").text(titulo);
      $(".mensaje_modal_confirmar").text(mensaje);
      $(".mensaje_espera_moda_confirmacion").text("");
      $(".tipo_modal_confirmar").val("registro_exito");
      $(".data_id").val("");

      $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
      $('#btn_close_ventana_confirmacion').prop('disabled', false);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
       
      $('#btn_cerrar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR
      });

      $('#btn_aplicar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CONFIRMACION,
         'color': COLOR_TEXT_VENTANA_CONFIRMACION,
         'display': "none"
      });
 
      $("#ventana_confirmacion").modal("show");
   }

   function isEmpty(value) {
       // Verificar si es null o undefined
       if (value == null) return true;

       // Verificar si es una cadena vacía
       if (typeof value === "string" && value.trim() === "") return true;

       // Verificar si es un array vacío
       if (Array.isArray(value) && value.length === 0) return true;

       // Verificar si es un objeto vacío
       if (typeof value === "object" && Object.keys(value).length === 0) return true;

       return false;
   }
 
   function validarSoloNumeros(input) {
       const number = parseInt(input, 10);
       return !isNaN(number) && number.toString() === input;
   }

   function validateEmail(email) {
      // Expresión regular para validar un formato de correo electrónico
      var emailPattern = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/;
      
      if (emailPattern.test(email)) {
         return true;  // Es un correo válido
      } else {
         return false;  // No es un correo válido
      }
   }
 
   function isInvalidEmail(email) {
      const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
      return !emailRegex.test(email);
   }

   function getRandomInt(min, max) {
      return Math.floor(Math.random() * (max - min + 1)) + min;
   }

   function validateFormFields() {
      const fields = [
         { selector: '.referencias_contactadas', section: 'Pre-approval', name: 'Were references contacted?' },
         { selector: '.cliente_nuevo', section: 'Pre-approval', name: 'Are you a new customer?' },
         { selector: '.relacion_ingreso_cuota', section: 'Pre-approval', name: 'Income quota ratio' },
         { selector: '.documentacion_completa', section: 'Pre-approval', name: 'Complete documentation?' },
         { selector: '.calificacion_final', section: 'Pre-approval', name: 'Final grade' },
         { selector: '.banco', section: 'Account information', name: 'Bank' },
         { selector: '.tipo_cuenta', section: 'Account information', name: 'Account type' },
         { selector: '.numero_cuenta', section: 'Account information', name: 'Account number' },
         { selector: '.metodo_pago', section: 'Payment methods', name: 'Payment methods' }
      ];

      for (const field of fields) {
         const value = $(field.selector).val();
         if (value && value.length > 255) {
               toastr.options.onclick = function() {
                  const targetDiv = document.querySelector(field.selector);
                  if (targetDiv) {
                     targetDiv.scrollIntoView({ behavior: 'smooth', block: 'start' });
                  }
               };
               toastr.error(`In "${field.section}" the field "${field.name}" cannot exceed 255 characters.`);
               return true;
         }
      }
      
      return false;
   }

   function generateCardHtmlURL(id, tipoArchivo, downloadUrl, fileName) {
      // Input validation
      if (!id || !tipoArchivo || !downloadUrl) {
         console.error('Missing required parameters in generateCardHtml');
         return '';
      }

      // Sanitize inputs to prevent XSS
      const sanitize = (str) => {
         const div = document.createElement('div');
         div.textContent = str;
         return div.innerHTML;
      };

      const sanitizedId = sanitize(id);
      const sanitizedTipoArchivo = sanitize(tipoArchivo);
      const sanitizedNombre = sanitize(fileName);
      const sanitizedDownloadUrl = String(downloadUrl);
      const sanitizedFileName = fileName ? sanitize(fileName) : `document.${sanitizedTipoArchivo.toLowerCase()}`;

      // Validate tipoArchivo for safe filename
      const validExtension = /^[a-zA-Z0-9]+$/.test(sanitizedTipoArchivo);
      if (!validExtension) {
         console.error('Invalid file extension:', sanitizedTipoArchivo);
         return '';
      }

      return `
         <div class="col-12 col-sm-6 pt-4 card_eliminar_${sanitizedId}">
               <div class="card  " style="width: 100%; max-width: 300px;">
                  <div class="card-body">
                     <h5 class="card-title">File type: <span class="card_tipo_archivo">${sanitizedTipoArchivo}</span></h5>
                     <h5 class="card-title">File name: <span class="card_tipo_archivo">${sanitizedFileName}</span></h5>
                     <div class="row">
                           <div class="col-12">
                               
                              <a class="btn btn-sm btn-descargar waves-effect waves-themed" data-id="${sanitizedId}" href="${sanitizedDownloadUrl}" download="${sanitizedFileName}">
                                 <i class="fas fa-download tamano-icono" aria-hidden="true"></i>
                              </a>
                           </div>
                     </div>
                  </div>
               </div>
         </div>
      `;

      //<button class="btn btn-sm btn-eliminar waves-effect waves-themed" data-id="${sanitizedId}">
      //   <i class="fas fa-trash tamano-icono" aria-hidden="true"></i>
      //</button>
   }

   function generateCardHtml(id, tipoArchivo, base64Data, fileName) {
      // Input validation
      if (!id || !tipoArchivo || !base64Data) {
         console.error('Missing required parameters in generateCardHtml');
         return '';
      }

      // Sanitize inputs to prevent XSS
      const sanitize = (str) => {
         const div = document.createElement('div');
         div.textContent = str;
         return div.innerHTML;
      };

      const sanitizedId = sanitize(id);
      const sanitizedTipoArchivo = sanitize(tipoArchivo);
      const sanitizedFileName = fileName ? sanitize(fileName) : `document.${sanitizedTipoArchivo.toLowerCase()}`;

      // Validate tipoArchivo for safe filename
      const validExtension = /^[a-zA-Z0-9]+$/.test(sanitizedTipoArchivo);
      if (!validExtension) {
         console.error('Invalid file extension:', sanitizedTipoArchivo);
         return '';
      }
   

      return `
         <div class="col-12 col-sm-6 pt-4 card_eliminar_${sanitizedId}">
            <div class="card" style="width: 100%; max-width: 300px;">
               <div class="card-body">
                  <h5 class="card-title">File type: <span class="card_tipo_archivo">${sanitizedTipoArchivo}</span></h5>
                  <h5 class="card-title">File name: <span class="card_tipo_archivo">${sanitizedFileName}</span></h5>
                  <div class="row">
                     <div class="col-12">
                         
                        <a class="btn btn-sm btn-descargar waves-effect waves-themed" data-id="${sanitizedId}" href="${base64Data}" download="${sanitizedFileName}">
                           <i class="fas fa-download tamano-icono" aria-hidden="true"></i>
                        </a>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      `;

      //<button class="btn btn-sm btn-eliminar waves-effect waves-themed" data-id="${sanitizedId}">
      //   <i class="fas fa-trash tamano-icono" aria-hidden="true"></i>
      //</button>
   }
 
   function navegarPantallaSiguiente(UUID_ENC_)
   {
      $(".titulo_modal_confirmar").text("Record added");
      $(".mensaje_modal_confirmar").text("¡Record added successfully!");
      $(".mensaje_espera_moda_confirmacion").text("");
      $(".tipo_modal_confirmar").val("navegar_pantalla_siguiente");
      $(".data_id").val(UUID_ENC_);

      $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
      $('#btn_close_ventana_confirmacion').prop('disabled', false);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
 
      $('#btn_cerrar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR,
         'display': "none",
      });

      $('#btn_close_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR,
         'display': "none",
      });
 
      $('#btn_aplicar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_IR,
         'color': COLOR_TEXT_VENTANA_IR,
         'display': "",
      });

      $('#btn_aplicar_ventana_confirmacion').text("Continue");
 
      $("#ventana_confirmacion").modal("show");
   }

   function navegarPantallaListado(titulo="", mensaje="", url="")
   {
      $(".titulo_modal_confirmar").text(titulo);
      $(".mensaje_modal_confirmar").text(mensaje);
      $(".mensaje_espera_moda_confirmacion").text("");
      $(".tipo_modal_confirmar").val("navegar_otras_pantallas");
      $(".data_id").val(url);

      $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
      $('#btn_close_ventana_confirmacion').prop('disabled', false);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
 
      $('#btn_cerrar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR,
         'display': "none",
      });

      $('#btn_close_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR,
         'display': "none",
      });
 
      $('#btn_aplicar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_IR,
         'color': COLOR_TEXT_VENTANA_IR,
         'display': "",
      });

      $('#btn_aplicar_ventana_confirmacion').text("Continue");
 
      $("#ventana_confirmacion").modal("show");
   }

   function ventanaError(titulo, mensaje) {
      $(".titulo_modal_confirmar").text(titulo);
      $(".mensaje_modal_confirmar").text(mensaje);
      $(".mensaje_espera_moda_confirmacion").text("");
      $(".tipo_modal_confirmar").val("registro_exito");
      $(".data_id").val("");

      $('#btn_aplicar_ventana_confirmacion').prop('disabled', false);
      $('#btn_close_ventana_confirmacion').prop('disabled', false);
      $('#btn_cerrar_ventana_confirmacion').prop('disabled', false);
 
      $('#btn_cerrar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CERRAR,
         'color': COLOR_TEXT_VENTANA_CERRAR
      });

      $('#btn_aplicar_ventana_confirmacion').css({
         'background-color': COLOR_FONDO_VENTANA_CONFIRMACION,
         'color': COLOR_TEXT_VENTANA_CONFIRMACION,
         'display': "none"
      });
 
      $("#ventana_confirmacion").modal("show");
   }


</script>
{/literal}


{/block}