<?php

namespace App\Controllers\Auth;

use App\Services\Auth\PasswordResetService;
use Symfony\Component\Mailer\Exception\TransportExceptionInterface;

class AuthController
{
    public function forgotPasswordPost()
    {
        global $config;

        $username = _post('username');
        $service = new PasswordResetService();

        $success = false;

        if ($username !== '') {

            try {

                $success = $service->sendResetLink($username, $config);

            } catch (TransportExceptionInterface $e) {

                http_response_code(200);
                echo json_encode([
                    'status' => 'error',
                    'message' => 'SMTP credentials invalid or rejected by server',
                ]);
                exit;

            } catch (\Throwable $e) {

                http_response_code(200);
                echo json_encode([
                    'status' => 'error',
                    'message' => 'Email service error',
                ]);
                exit;

            }
            
        }

        if ($success) {

            http_response_code(200);
            echo json_encode([
                'status' => 'success',
                'message' => 'Check your email to reset Password',
                'redirect' => true,
                'redirect_url' => 'login/'
            ]);
            exit;

        } else {

            http_response_code(200);
            echo json_encode([
                'status' => 'error',
                'message' => 'User not found'
            ]);
            exit;

        }
    }

}
