<?php
namespace App\Controllers;
use Contact;
use App\Controllers\BaseController;
use App\Models\Company as Company;
use App\Models\User as User;
use App\Services\Auth\PermissionService;

class CompanyController extends BaseController
{

    public function list()
    {

        header('Content-Type: application/json');
        $user = User::_info();

        $companies = Company::select([
            'id', 'logo_url', 'code', 'company_name', 'email', 'id', 'phone'
        ])->orderBy('id', 'desc');


        if (PermissionService::hasAccess($user->roleid, 'companies', 'all_data')) {
            $companies = $companies->where('aid', $user->id);
        }

        $companies = $companies->get();

        $response = [
            'data' => $companies
        ];

        http_response_code(200);
        echo json_encode($response);
        exit;
    }
}
