<?php
namespace App\Controllers;
use ORM;
use PDO;
use Contact;
use App\Models\Tags;
use App\Models\User;
use App\Services\Auth\PermissionService;
use App\Services\InvoiceService;
use App\Database\ConnectionFactory;
use App\Controllers\BaseController;


class CustomerController extends BaseController
{

    public function list()
    {
        header('Content-Type: application/json');
        $user = User::_info();

        $has_delete_permission = PermissionService::hasAccess($user->roleid, 'customers', 'delete');
        $has_edit_permission   = PermissionService::hasAccess($user->roleid, 'customers', 'edit');

        $pdo = ORM::get_db();
        $stmt = $pdo->prepare("
            SELECT id, account, email, phone, company, gname, gid, code, address
            FROM crm_accounts
            WHERE type = 'Customer'
            ORDER BY id DESC
        ");
        $stmt->execute();
        $contacts = $stmt->fetchAll(PDO::FETCH_ASSOC);

        $response = [
            'data' => $contacts,
            'has_delete_permission' => $has_delete_permission,
            'has_edit_permission' => $has_edit_permission,
        ];

        http_response_code(200);
        echo json_encode($response);
        exit;
    }

    public function getSummary($cid)
    {
        header('Content-Type: application/json');

        if (!$cid) {
            http_response_code(400);
            echo json_encode(['error' => 'Customer ID is required']);
            exit;
        }

        $customer = ORM::for_table('crm_accounts')->find($cid);

        if (!$customer) {
            http_response_code(404);
            echo json_encode(['error' => 'Customer not found']);
            exit;
        }

        // Total In (cr) y Total Out (dr)
        $totalIn  = ORM::for_table('sys_transactions')->where('payerid', $cid)->sum('cr') ?: 0;
        $totalOut = ORM::for_table('sys_transactions')->where('payeeid', $cid)->sum('dr') ?: 0;

        // Profit / Loss
        if ($totalIn > $totalOut) {
            $status = 'Profit';
            $amount = $totalIn - $totalOut;
            $cssClass = 'green';
        } else {
            $status = 'Loss';
            $amount = $totalOut - $totalIn;
            $cssClass = 'danger';
        }

        // Custom fields
        $customFields = ORM::for_table('crm_customfields')
            ->where('ctype', 'crm')
            ->order_by_asc('id')
            ->find_many();

        // Staffs
        $staffs = User::all()->keyBy('id')->all();

        $response = [
            'customer'       => $customer->as_array(),
            'total_in'       => $totalIn,
            'total_out'      => $totalOut,
            'status'         => $status,
            'amount'         => $amount,
            'css_class'      => $cssClass,
            'custom_fields'  => $customFields->as_array(),
            'staffs'         => $staffs,
        ];

        //Event::trigger('contacts/summary_display', [&$response]);

        http_response_code(200);
        echo json_encode($response);
        exit;
    }


    public function updateContact($id)
    {
        global $_L, $config;

        header('Content-Type: application/json');

        $user = User::_info();

        if (!has_access($user->roleid, 'customers', 'edit')) {
            http_response_code(403); // Forbidden
            echo json_encode(
                ['error' => 'Permission Denied']
            );
            exit;
        }

        $id = $id ?: _post('fcid');
        $d = ORM::for_table('crm_accounts')->find($id);

        if ($d) {
            $clientDb = null;

            try {
                $clientDb = ConnectionFactory::client();
            } catch (\Exception $e) {
                echo json_encode($e->getMessage());
                exit;
            }

            $companies = json_decode(_post('companies'), true);
            $review_rating = _post('review_rating');

            $review_rating = ($review_rating == '2' || empty($review_rating)) ? null : 1;
            //$review_rating = $review_rating == '2' || empty($review_rating) ? null : 1;

            $arrCompanies = [];


            // Must select a company
            /*if (!is_array($companies) || count($companies) < 1) {
                http_response_code(200);
                echo json_encode([
                    'status'  => 'error',
                    'code'    => 'COMPANY_SELECTION_MISSING',
                    'message' => 'You must select at least one company.',
                ]);
                exit;
            }*/

            $arrCompanies = $companies;

            $companies_deletes = _post('companies_deletes');

            if (!empty($companies_deletes)) {
                $arrCompaniesDelete = json_decode($companies_deletes, true) ?: [];

                $arrCompaniesDelete = array_values(array_filter($arrCompaniesDelete, function ($v) {
                    return is_numeric($v);
                }));

                if (!empty($arrCompaniesDelete)) {
                    $placeholders = implode(',', array_fill(0, count($arrCompaniesDelete), '?'));
                    $stmtDelete = $clientDb->prepare("DELETE FROM `crm_accounts_company` WHERE idCompany IN ($placeholders)");
                    if ($stmtDelete) {
                        $stmtDelete->execute($arrCompaniesDelete);
                    }
                }
            }

            foreach ($arrCompanies as $item) {
                $id_compania = $item['id'] ?? null;
                $UUID = $item['UUID'] ?? null;
                $UUID_ENC = $item['UUID_ENC'] ?? null;
                $idCompany = $item['idCompany'] ?? null;

                if (empty($id_compania) && $UUID && $UUID_ENC && $idCompany) {
                    $sql = "INSERT INTO `crm_accounts_company`(
                                `UUID`,
                                `UUID_ENC`,
                                `idCompany`,
                                `crm_account_id`
                            )
                            VALUES(
                                ?,
                                ?,
                                ?,
                                ?
                            )";

                    $stmt_detalles = $clientDb->prepare($sql);
                    if (!$stmt_detalles) {
                        continue;
                    }

                    $stmt_detalles->execute([
                        $UUID,
                        $UUID_ENC,
                        $idCompany,
                        $id
                    ]);
                }
            }

            $old_account = $d->account;

            $account = _post('account');

            $company_id = _post('company_id');

            $company = '';
            $cid = 0;

            if ($company_id != '' && $company_id != '0') {
                $company_db = db_find_one('sys_companies', $company_id);

                if ($company_db) {
                    $company = $company_db->company_name;
                    $cid = $company_id;
                }
            }

            $email = _post('edit_email');

            $tagsInput = _post('tags', '');
            $tags = $tagsInput ? array_filter(array_map('trim', explode(',', $tagsInput))) : [];

            $currency = _post('currency', '0');

            if ($currency == '') {
                $currency = '0';
            }

            $phone = _post('phone');
            $address = _post('address');
            $city = _post('city');
            $state = _post('state');
            $zip = _post('zip');
            $country = _post('country');
            $nationality = _post('nationality');

            $username = _post('username');

            $type_customer = _post('customer');
            $type_supplier = _post('supplier');

            $type = $type_customer . ',' . $type_supplier;
            $type = trim($type, ',');

            if ($type == '') {
                $type = 'Customer';
            }

            if ($account == '') {                
                echo json_encode([
                    'status' => 'error',
                    'message' => 'Name is required'
                ]);
                exit;
            }


            if ($email != '') {
                if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                    //$msg .= $_L['Invalid Email'] . ' <br>';

                    echo json_encode([
                        'status' => 'error',
                        'message' => 'Invalid Email'
                    ]);
                    exit;
                }

                if ($email != $d['email']) {
                    $f = ORM::for_table('crm_accounts')
                        ->where('email', $email)
                        ->first();

                    if ($f) {
                        echo json_encode([
                            'status' => 'error',
                            'message' => 'Email already exist'
                        ]);
                        exit;
                    }
                }
            }

            Tags::saveTags($tags, 'Contacts');

            $gid = _post('group');

            $secondary_email = _post('secondary_email');

            if ($secondary_email != '' && !filter_var($secondary_email, FILTER_VALIDATE_EMAIL)) {
                $secondary_email = '';
            }
            $gname = '';

            if ($gid != '') {
                $g = db_find_one('crm_groups', $gid);
                if ($g) {
                    $gname = $g['gname'];
                }
            } else {
                $gid = 0;
                $gname = '';
            }

            $owner_id = _post('owner_id', 0);

            $password = _post('password');


            $position = _post('position');
            $notas = _post('notas');
            $codigo_pais = _post('codigo_pais');

            $d = ORM::for_table('crm_accounts')->find($id);
            $d->account = $account;
            $d->company = $company;
            $d->o = $owner_id;
            $d->nationality = $nationality;

            $d->email = $email;
            $d->tags = \Arr::arr_to_str($tags);

            $d->phone = $codigo_pais . $phone;
            $d->position = $position;
            $d->notas = $notas;
            $d->notes = $notas;
            $d->codigo_pais = $codigo_pais;
            $d->telephone_number = $phone;

            $d->address = $address;
            $d->city = $city;
            $d->zip = $zip;
            $d->state = $state;
            $d->country = $country;

            $d->type = $type;

            $d->username = $username;

            $d->gname = $gname;
            $d->gid = $gid;

            $d->currency = $currency;
            $d->rating_review = $review_rating;

            $d->fax = _post('fax');

            $d->code = _post('code');

            $d->secondary_email = $secondary_email;

            if ($config['show_business_number']) {
                $d->business_number = _post('business_number');
            }

            if ($password != '') {
                $d->password = \Password::_crypt($password);
            }

            $d->save();

            ORM::for_table('crm_customfieldsvalues')
                ->where('relid', $id)
                ->delete_many();

            $fs = ORM::for_table('crm_customfields')
                ->order_by_asc('id')
                ->find_many();

            foreach ($fs as $f) {
                $fvalue = _post('cf' . $f['id']);
                $fc = ORM::for_table('crm_customfieldsvalues')->create();
                $fc->fieldid = $f['id'];
                $fc->relid = $id;
                $fc->fvalue = $fvalue;
                $fc->save();
            }

            if ($account != $old_account) {
                $sql = "update sys_invoices set account='$account' where account='$old_account'";

                ORM::execute($sql);
            }

            //$successMessage = is_array($_L) && isset($_L['account_updated_successfully']) ? $_L['account_updated_successfully'] : 'Account updated successfully';
            //_msglog('s', $successMessage);

            $clientDb = null;

            http_response_code(200);
            echo json_encode([
                'status' => 'success',
                'id' => $id // Customer Id
            ]);
            exit;

        } else {

            http_response_code(200);
            echo json_encode([
                'status' => 'error',
                'code' => 'ACCOUNT_NOT_FOUND',
                'message' => 'The requested account does not exist.'
            ]);
            exit;
            
        }
    }

    public function getPaymentMethods()
    {
        header('Content-Type: application/json');
        
        $contactId = _post('cid');
        
        if (empty($contactId)) {
            echo json_encode(['status' => 'error', 'message' => 'Contact ID is required']);
            exit;
        }

        $paymentMethods = ORM::for_table('credit_plan_payment_method')
            ->where('crm_account_id', $contactId)
            ->order_by_desc('id')
            ->find_many();

        $result = [];
        foreach ($paymentMethods as $pm) {
            $last4 = '';
            if (!empty($pm->numero_tarjeta)) {
                $last4 = substr($pm->numero_tarjeta, -4);
            }
            
            $result[] = [
                'id' => $pm->id,
                'type' => $pm->tipo_cuenta ?? 'Checking Account',
                'name' => $pm->titular_tarjeta ?? 'N/A',
                'bank' => $pm->banco_metodo_pago ?? 'Unknown Bank',
                'last_4_digits' => $last4,
                'routing_number' => $pm->numero_ruta_metodo_pago ?? '',
                'customer_id' => $pm->customer_id ?? '',
                'payment_method' => $pm->payment_method ?? '',
                'configuracion_stripe_id' => $pm->configuracion_stripe_id ?? null
            ];
        }

        echo json_encode(['status' => 'success', 'data' => $result]);
        exit;
    }

    public function getPaymentMethodsTable()
    {
        header('Content-Type: application/json');

        $contactId = _post('cid');

        if (empty($contactId)) {
            echo json_encode(['status' => 'error', 'message' => 'Contact ID is required']);
            exit;
        }

        $typeNames = [
            '1' => 'Savings account',
            '2' => 'Checking Account',
            '3' => 'Credit Card',
        ];

        $paymentMethods = ORM::for_table('credit_plan_payment_method')
            ->where('crm_account_id', $contactId)
            ->order_by_desc('id')
            ->find_many();

        $result = [];
        foreach ($paymentMethods as $pm) {
            $last4 = '';
            if (!empty($pm->numero_tarjeta)) {
                $last4 = substr($pm->numero_tarjeta, -4);
            }

            $estadoId = $pm->estado_id ?? '';
            $useCreditCard = $pm->use_credit_card ?? '';

            $estadoNombre = ((string) $estadoId === '1') ? 'Active' : 'Inactive';
            $useCreditCardNombre = ((string) $useCreditCard === '1') ? 'Predetermined' : 'Secondary';

            $tipoCuenta = (string) ($pm->tipo_cuenta ?? '');

            $result[] = [
                'id' => $pm->id,
                'UUID' => $pm->UUID,
                'UUID_ENC' => $pm->UUID_ENC,
                'tipo_cuenta' => $pm->tipo_cuenta,
                'nombre_tipo_cuenta' => $typeNames[$tipoCuenta] ?? '',
                'tipo_pasarela_pago' => $pm->tipo_pasarela_pago ?? '',
                'titular_tarjeta' => $pm->titular_tarjeta ?? '',
                'numero_tarjeta' => $pm->numero_tarjeta ?? '',
                'codigo_ccv' => $pm->codigo_ccv ?? '',
                'exp_month' => $pm->exp_month ?? '',
                'exp_year' => $pm->exp_year ?? '',
                'estado_id' => $estadoId,
                'estado_nombre' => $estadoNombre,
                'use_credit_card' => $useCreditCard,
                'use_credit_card_nombre' => $useCreditCardNombre,
                'banco_metodo_pago' => $pm->banco_metodo_pago ?? '',
                'nombre_banco_metodo_pago' => $pm->nombre_banco_metodo_pago ?? '',
                'numero_ruta_metodo_pago' => $pm->numero_ruta_metodo_pago ?? '',
                'tipo_titular_metodo_pago' => $pm->tipo_titular_metodo_pago ?? '',
                'email_metodo_pago' => $pm->email_metodo_pago ?? '',
                'last_4_digits' => $last4,
                'verificado' => $pm->verificado ?? '',
                'tipo_verificacion_micro_deposito' => $pm->tipo_verificacion_micro_deposito ?? '',
                'configuracion_stripe_id' => $pm->configuracion_stripe_id ?? null,
                'payment_method' => $pm->payment_method ?? '',
                'customer_id' => $pm->customer_id ?? '',
                'setup_intent' => $pm->setup_intent ?? ''
            ];
        }

        echo json_encode(['status' => 'success', 'data' => $result]);
        exit;
    }

    public function postPaymentMethodCustomer()
    {
        header('Content-Type: application/json');

        $payload = json_decode(file_get_contents('php://input'), true) ?: [];
        $customerId = $payload['customer_id'] ?? null;

        if (empty($customerId)) {
            echo json_encode([
                'type' => 'error',
                'message' => '!The client id is required.',
                'data' => [],
            ]);
            exit;
        }

        $customer = ORM::for_table('crm_accounts')->find_one($customerId);
        if (!$customer) {
            echo json_encode([
                'type' => 'error',
                'message' => 'Customer not found.',
                'data' => [],
            ]);
            exit;
        }

        $arregloPlanes = $payload['arreglo_planes'] ?? [];
        $eliminarMetodos = $payload['eliminar_metodo_pagos'] ?? [];

        if (!empty($eliminarMetodos)) {
            foreach ($eliminarMetodos as $item) {
                $id = $item['id'] ?? null;
                $uuidEnc = $item['UUID_ENC'] ?? null;

                if ($id) {
                    $pm = ORM::for_table('credit_plan_payment_method')
                        ->where('crm_account_id', $customerId)
                        ->find_one($id);
                    if ($pm) {
                        $this->detachStripePaymentMethod($pm);
                        $pm->delete();
                    }
                    continue;
                }

                if ($uuidEnc) {
                    $pm = ORM::for_table('credit_plan_payment_method')
                        ->where('crm_account_id', $customerId)
                        ->where('UUID_ENC', $uuidEnc)
                        ->find_one();
                    if ($pm) {
                        $this->detachStripePaymentMethod($pm);
                        $pm->delete();
                    }
                }
            }
        }

        $allowedFields = [
            'tipo_cuenta',
            'tipo_pasarela_pago',
            'titular_tarjeta',
            'numero_tarjeta',
            'codigo_ccv',
            'exp_month',
            'exp_year',
            'estado_id',
            'use_credit_card',
            'cnon_tarjetas_square',
            'UUID',
            'UUID_ENC',
            'banco_metodo_pago',
            'nombre_banco_metodo_pago',
            'numero_ruta_metodo_pago',
            'tipo_titular_metodo_pago',
            'email_metodo_pago',
            'configuracion_stripe_id',
            'payment_method',
            'customer_id',
            'verificado',
            'tipo_verificacion_micro_deposito',
            'setup_intent',
            'configuracion_pasarela_pago',
        ];

        $pdo = ORM::get_db();
        $stmt = $pdo->query("DESCRIBE credit_plan_payment_method");
        $dbColumns = $stmt ? array_column($stmt->fetchAll(PDO::FETCH_ASSOC), 'Field') : [];
        if (!empty($dbColumns)) {
            $allowedFields = array_values(array_intersect($allowedFields, $dbColumns));
        }

        foreach ($arregloPlanes as $item) {
            if (!is_array($item)) {
                continue;
            }

            $id = $item['id'] ?? null;
            $pm = null;

            if (!empty($id)) {
                $pm = ORM::for_table('credit_plan_payment_method')
                    ->where('crm_account_id', $customerId)
                    ->find_one($id);
            }

            $gatewayId = (int) ($item['configuracion_stripe_id'] ?? 0);
            if ($gatewayId > 0) {
                $gateway = ORM::for_table('sys_pg')->find_one($gatewayId);
                $processor = strtolower((string) ($gateway->processor ?? ''));
                if ($gateway && $processor === 'stripe') {
                    $item['configuracion_pasarela_pago'] = json_encode([
                        'id_stripe' => (string) $gatewayId,
                        'pk_stripe' => (string) ($gateway->value ?? ''),
                        'sk_stripe' => (string) ($gateway->c1 ?? ''),
                    ]);
                }
            }

            if (!$pm) {
                $pm = ORM::for_table('credit_plan_payment_method')->create();
                $pm->crm_account_id = $customerId;
            }

            foreach ($allowedFields as $field) {
                if (array_key_exists($field, $item)) {
                    $pm->$field = $item[$field];
                }
            }

            $pm->save();
        }

        $paymentMethods = ORM::for_table('credit_plan_payment_method')
            ->where('crm_account_id', $customerId)
            ->order_by_desc('id')
            ->find_many();

        $result = [];
        foreach ($paymentMethods as $pm) {
            $result[] = $pm->as_array();
        }

        echo json_encode([
            'type' => 'success',
            'message' => '',
            'data_credit_plan_payment_method' => $result,
            'arreglo_lista_errores_metodos' => [],
        ]);
        exit;
    }

    private function detachStripePaymentMethod($paymentMethod): void
    {
        $paymentMethodId = trim((string) ($paymentMethod->payment_method ?? ''));
        $stripeCustomerId = trim((string) ($paymentMethod->customer_id ?? ''));
        $gatewayId = (int) ($paymentMethod->configuracion_stripe_id ?? 0);

        if ($paymentMethodId === '' || $stripeCustomerId === '') {
            return;
        }

        $gateway = ORM::for_table('sys_pg')
            ->where('id', $gatewayId)
            ->where('status', 'Active')
            ->find_one();

        if (!$gateway || empty($gateway->c1)) {
            return;
        }

        require __DIR__ . '/../../stripe/init.php';

        try {
            $stripe = new \Stripe\StripeClient($gateway->c1);
            $stripe->paymentMethods->detach($paymentMethodId, []);
        } catch (\Throwable $e) {
            // Best effort; ignore detach failures.
        }
    }

    public function verifyBankAccountCode()
    {
        header('Content-Type: application/json');

        $payload = json_decode(file_get_contents('php://input'), true) ?: [];
        $descriptionCode = strtoupper(trim((string) ($payload['description_code'] ?? '')));
        $uuidEnc = trim((string) ($payload['dc_uuid_enc'] ?? ''));
        $customerId = (int) ($payload['customer_id'] ?? 0);

        if ($descriptionCode === '') {
            echo json_encode(['status' => 'error', 'message' => 'The field code is required.']);
            exit;
        }

        if ($uuidEnc === '') {
            echo json_encode(['status' => 'error', 'message' => 'The identification is required.']);
            exit;
        }

        if ($customerId <= 0) {
            echo json_encode(['status' => 'error', 'message' => 'Customer ID is required.']);
            exit;
        }

        $paymentMethod = ORM::for_table('credit_plan_payment_method')
            ->where('crm_account_id', $customerId)
            ->where('UUID_ENC', $uuidEnc)
            ->find_one();

        if (!$paymentMethod) {
            echo json_encode(['status' => 'error', 'message' => 'The record was not found in the database.']);
            exit;
        }

        $setupIntentId = trim((string) ($paymentMethod->setup_intent ?? ''));
        $gatewayId = (int) ($paymentMethod->configuracion_stripe_id ?? 0);

        if ($setupIntentId === '') {
            echo json_encode(['status' => 'error', 'message' => 'The setup intent is missing.']);
            exit;
        }

        $gateway = ORM::for_table('sys_pg')
            ->where('id', $gatewayId)
            ->where('status', 'Active')
            ->find_one();

        if (!$gateway || empty($gateway->c1)) {
            echo json_encode(['status' => 'error', 'message' => 'The payment gateway does not exist or is inactive.']);
            exit;
        }

        require __DIR__ . '/../../stripe/init.php';

        try {
            $stripe = new \Stripe\StripeClient($gateway->c1);
            $verified = $stripe->setupIntents->verifyMicrodeposits(
                $setupIntentId,
                ['descriptor_code' => $descriptionCode]
            );

            if (($verified->status ?? '') === 'succeeded') {
                $paymentMethod->verificado = 1;
                $paymentMethod->save();
            }

            echo json_encode([
                'status' => 'success',
                'message' => ($verified->status ?? '') === 'succeeded'
                    ? 'Operation successful, the account is verified.'
                    : 'The status of the operation is ' . ($verified->status ?? 'unknown'),
            ]);
            exit;
        } catch (\Throwable $e) {
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
            exit;
        }
    }

    public function getInvoices()
    {
        header('Content-Type: application/json');

        $contactId = (int) _post('cid');

        if (empty($contactId)) {
            http_response_code(400);
            echo json_encode(['status' => 'error', 'message' => 'Contact ID is required']);
            exit;
        }

        $service = new InvoiceService();
        $invoices = $service->getCustomerInvoices($contactId);

        echo json_encode(['status' => 'success', 'data' => $invoices]);
        exit;
    }        
        
}
