<?php
namespace App\Controllers;

use App\Services\FormDownloadService;
use Exception;
use RuntimeException;
use InvalidArgumentException;

class FormDownloadController
{
    protected FormDownloadService $service;

    public function __construct()
    {
        $this->service = new FormDownloadService();
    }

    public function getW7(string $uuid)
    {
        return $this->respond(fn() => ['data' => $this->service->getW7($uuid)]);
    }

    public function get656(string $uuid)
    {
        return $this->respond(fn() => ['data' => $this->service->get656($uuid)]);
    }

    public function get433A(string $uuid)
    {
        return $this->respond(fn() => $this->service->get433A($uuid));
    }

    protected function respond(callable $callback)
    {
        header('Content-Type: application/json');
        try {
            $result = $callback();
            $payload = array_merge([
                'type' => 'success',
                'message' => 'OK',
            ], $result);
            echo json_encode($payload);
        } catch (InvalidArgumentException $e) {
            http_response_code(400);
            echo json_encode(['type' => 'error', 'message' => $e->getMessage()]);
        } catch (RuntimeException $e) {
            http_response_code(404);
            echo json_encode(['type' => 'error', 'message' => $e->getMessage()]);
        } catch (Exception $e) {
            http_response_code(500);
            echo json_encode(['type' => 'error', 'message' => $e->getMessage()]);
        }
        exit;
    }
}
