<?php
namespace App\Controllers;

use App\Services\OcrService;
use Exception;
use InvalidArgumentException;

class FormOcrController
{
    protected OcrService $service;

    public function __construct()
    {
        $this->service = new OcrService();
    }

    public function process()
    {
        header('Content-Type: application/json');

        try {
            if (empty($_FILES['file']) || !is_uploaded_file($_FILES['file']['tmp_name'])) {
                throw new InvalidArgumentException('No file uploaded');
            }

            $fileTmp = $_FILES['file']['tmp_name'];
            $fileSize = $_FILES['file']['size'] ?? 0;

            if ($fileSize > 8 * 1024 * 1024) {
                throw new InvalidArgumentException('File too large (max 8MB)');
            }

            $fields = $this->service->extractFields($fileTmp);

            echo json_encode([
                'type'    => 'success',
                'message' => 'OK',
                'data'    => $fields,
            ]);
            exit;
        } catch (InvalidArgumentException $e) {
            http_response_code(400);
            echo json_encode(['type' => 'error', 'message' => $e->getMessage()]);
            exit;
        } catch (Exception $e) {
            http_response_code(500);
            echo json_encode(['type' => 'error', 'message' => $e->getMessage()]);
            exit;
        }
    }
}
