<?php

namespace App\Controllers;

class InvoicesStatusController
{
    public function handleStripeWebhook()
    {
        header('Content-Type: application/json');

        $raw = file_get_contents('php://input');
        $payload = json_decode($raw, true);

        if (!is_array($payload)) {
            http_response_code(400);
            echo json_encode(['error' => 'invalid json']);
            exit;
        }

        $type = $payload['type'] ?? '';

        $db = trim((string)($_ENV['DB_DATABASE'] ?? ''));
        $status = null;

        $payment_id = null;

        if ($type === 'terminal.reader.action_succeeded') {
            $status = $payload['data']['object']['action']['status'] ?? null;
            $payment_id = $payload['data']['object']['action']['process_payment_intent']['payment_intent'] ?? null;
        } elseif ($type === 'payment_intent.succeeded') {
            $status = $payload['data']['object']['status'] ?? null;
            $payment_id = $payload['data']['object']['id'] ?? null;
        } else {
            http_response_code(200);
            echo json_encode(['status' => 'success', 'ignored' => true]);
            exit;
        }

        if ($db === '' || !is_string($status) || $status === '') {
            http_response_code(400);
            echo json_encode([
                'status' => 'error',
                'message' => 'DB or status missing'
            ]);
            exit;
        }

        $data = [
            'db'     => $db,
            'payment_id' => $payment_id,
            'status' => $status,
            'type'   => $type,
            'source' => 'stripe',
        ];

        $result = $this->notifyNode($data);

        // Siempre responder 200 a Stripe
        if (($result['ok'] ?? false) !== true) {
            error_log('notifyNode failed: ' . json_encode($result));
        }

        http_response_code(200);
        echo json_encode([
            'status' => 'success',
            'payment_id' => $payment_id,
            'stripe_status' => $status,
            'type' => $type,
            'source' =>'stripe'
        ]);
        exit;
    }

    private function notifyNode(array $data): array
    {
        $base = rtrim((string)($_ENV['SOCKET_URL'] ?? ''), '/');
        if ($base === '') {
            return ['ok' => false, 'error' => 'SOCKET_URL missing'];
        }

        $url = $base . '/socket-chat-v1/internal/invoices-status';

        $ch = curl_init($url);
        curl_setopt_array($ch, [
            CURLOPT_POST            => true,
            CURLOPT_POSTFIELDS      => json_encode($data),
            CURLOPT_RETURNTRANSFER  => true,
            CURLOPT_HTTPHEADER      => [
                'Content-Type: application/json',
                // 'X-Internal-Token: ' . ($_ENV['SOCKET_INTERNAL_TOKEN'] ?? ''),
            ],
            CURLOPT_TIMEOUT         => 4,
            CURLOPT_CONNECTTIMEOUT  => 2,
        ]);

        $resp = curl_exec($ch);
        $err  = curl_error($ch);
        $code = (int) curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($resp === false) {
            return ['ok' => false, 'error' => $err, 'http_code' => $code];
        }

        return [
            'ok'        => ($code >= 200 && $code < 300),
            'http_code' => $code,
            'response'  => $resp,
        ];
    }
}
