<?php
namespace App\Controllers;

//use Aws\SecretsManager\SecretsManagerClient;
use App\Controllers\BaseController;
use App\Models\Contact;
use App\Models\User;
use ORM;
use Stripe\StripeClient;
use App\Controllers\TemplateInvoicesController;


class StripeController extends BaseController
{

    // Manual endpoint to validate a payment link when Stripe webhook did not run in time (PDO + transactions).
    public function validatePaymentLink()
    {
        header('Content-Type: application/json');

        $idStripe = _post('id_stripe');

        if (empty($idStripe)) {
            echo json_encode(['status' => 'error', 'message' => 'id_stripe is required']);
            exit;
        }

        $pdo = ORM::get_db(); // PDO

        try {
            $pdo->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);
            $pdo->beginTransaction();

            // 1) Fetch payment link
            $stmt = $pdo->prepare("SELECT * FROM payment_links WHERE id_stripe = :id_stripe LIMIT 1");
            $stmt->execute([':id_stripe' => $idStripe]);
            $paymentLink = $stmt->fetch(\PDO::FETCH_ASSOC);

            if (empty($paymentLink)) {
                $pdo->rollBack();
                echo json_encode(['status' => 'Error', 'message' => 'Payment link not found']);
                exit;
            }

            if (strtolower($paymentLink['payment_status']) === 'paid') {
                $pdo->rollBack();
                echo json_encode(['status' => 'Success', 'message' => 'Payment link already processed']);
                exit;
            }

            
            $sessionId = $paymentLink['id_stripe'];
            
            $secretKeyDb = $paymentLink['secret_key_pg'] ?? null;
            $secretKey = $this->resolveStripeSecretKey($secretKeyDb);

            // 2) Consult Stripe for current session status
            try {

                $stripe = new StripeClient($secretKey);
                $session = $stripe->checkout->sessions->retrieve($sessionId, []);

            } catch (\Exception $e) {

                $pdo->rollBack();
                echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
                exit;

            }

            $paymentStatus = $session->payment_status ?? '';
            $paymentIntent = $session->payment_intent ?? '';

            if (empty($paymentStatus)) {
                $paymentStatus = 'paid';
            }

            $idTransactionsTemp = $paymentLink['id_transactions_temp'];
            $idInvoice          = $paymentLink['id_invoice'];
            $amount             = (float) $paymentLink['amount'];

            // 3) Insert transaction from temp
            $insertSql = "INSERT INTO sys_transactions (account,account_id,project_id,employee_id,item_id,invoice_id,asset_id,type,code,sub_type,cat_id,category,amount,payer,payee,payerid,payeeid,method,ref,status,description,item,tags,tax,date,dr,cr,bal,iid,currency_iso_code,currency,currency_symbol,currency_prefix,currency_suffix,currency_rate,base_amount,company_id,vid,aid,staff_id,created_at,updated_at,updated_by,attachments,source,rid,pid,archived,trash,flag,c1,c2,c3,c4,c5,purchase_id, name_pg,staff_id_pago)
                            SELECT account,account_id,project_id,employee_id,item_id,invoice_id,asset_id,type,code,sub_type,cat_id,category,amount,payer,payee,payerid,payeeid,method,ref,status,description,item,tags,tax,date,dr,cr,bal,iid,currency_iso_code,currency,currency_symbol,currency_prefix,currency_suffix,currency_rate,base_amount,company_id,vid,aid,staff_id,created_at,updated_at,updated_by,attachments,source,rid,pid,archived,trash,flag,c1,c2,c3,c4,c5,purchase_id,name_pg,staff_id_pago
                            FROM sys_transactions_temp WHERE id = :id_temp";

            $stmtInsert = $pdo->prepare($insertSql);

            if (!$stmtInsert->execute([':id_temp' => $idTransactionsTemp])) {
                $pdo->rollBack();
                echo json_encode(['status' => 'error', 'message' => 'sys_transactions insert failed']);
                exit;
            }

            // 4) Fetch invoice and update
            $stmtInv = $pdo->prepare("SELECT credit,total,id,`status`, fm_id_partner_center FROM sys_invoices WHERE id = :id_invoice");
            $stmtInv->execute([':id_invoice' => $idInvoice]);
            $invoiceRow = $stmtInv->fetch(\PDO::FETCH_ASSOC);

            if (empty($invoiceRow)) {
                $pdo->rollBack();
                echo json_encode(['status' => 'error', 'message' => 'invoice not found']);
                exit;
            }

            $pc = $invoiceRow['credit'];
            $it = $invoiceRow['total'];
            $dp = $it - $pc;
            $statusInvoice = ($dp == $amount || $dp < $amount) ? 'Paid' : 'Partially Paid';
            $credit = $pc + $amount;
            $valorEnviarResena = $invoiceRow['status'] == "Unpaid" ? "true" : "false";
            $fmIdPartnerCenter = $invoiceRow['fm_id_partner_center'];

            $stmtUpdateInv = $pdo->prepare("UPDATE sys_invoices SET credit = :credit, status = :status WHERE id = :id");
            $stmtUpdateInv->execute([
                ':credit' => $credit,
                ':status' => $statusInvoice,
                ':id'     => $idInvoice,
            ]);

            // 5) Update payment link
            $dateNow = date('Y-m-d H:i:s');
            $stmtUpdateLink = $pdo->prepare("UPDATE payment_links SET payment_status = :status, date_verify = :date WHERE id_stripe = :id_stripe");
            $stmtUpdateLink->execute([
                ':status'     => $paymentStatus,
                ':date'       => $dateNow,
                ':id_stripe' => $idStripe,
            ]);

            $pdo->commit();

            // 6) Notificaci?n de pago recibido (fuera de la transacci?n)
            $notifPayload = [
                "invoices_id"   => $idInvoice,
                "tipo_pago"     => "pago_recibido",
                "factura_nueva" => $valorEnviarResena
            ];

            
            TemplateInvoicesController::sendReceivedPaymentNotification($notifPayload);


            // 7) Registro en partner center si aplica
            if (!empty($fmIdPartnerCenter)) {
                $isAdminPartnerCRM = $pdo->query("SELECT `value` FROM `sys_appconfig` WHERE setting = 'crm_partnert_administrativo'")->fetch(\PDO::FETCH_ASSOC);

                if (!empty($isAdminPartnerCRM) && $isAdminPartnerCRM["value"] == 1) {
                    $dataSysTransactionsTemp = $pdo->prepare("SELECT * FROM `sys_transactions_temp` WHERE id = :id");
                    $dataSysTransactionsTemp->execute([':id' => $idTransactionsTemp]);
                    $txTempRow = $dataSysTransactionsTemp->fetch(\PDO::FETCH_ASSOC);

                    if (!empty($txTempRow)) {
                        $dataRegister = [
                            "fm_id"         => $fmIdPartnerCenter,
                            "monto"         => $amount,
                            "metodo"        => $txTempRow["method"],
                            "pasarela_pago" => "Stripe",
                            "fecha_pago"    => $dateNow,
                            "status_pago"   => $statusInvoice == "Paid" ? 1 : 2,
                            "id_stripe"     => $sessionId,
                            //"secret_key_pg" => $secretKey,
                            "payment_intent" => $paymentIntent,
                        ];

                        insertRegister($dataRegister);
                    }
                }
            }

            echo json_encode(['status' => 'Success', 'message' => 'Payment link validated', 'payment_status' => $paymentStatus]);
        } catch (\Exception $e) {
            if ($pdo && $pdo->inTransaction()) {
                $pdo->rollBack();
            }
            echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
        }
    }

    // Port of invoices.php "add-payment-post" case to a controller method
    public function addPaymentPost()
    {
        header('Content-Type: application/json');
        global $config;
        
        $user = User::_info();

        $nombre_pasarela = "";
        $tid = 0;
        $msg = '';
        $id_stripe_response = null;
        $iid = _post('iid');
        $account = _post('account');

        $collectedByStaffId = _post('staff') ?: $user->id;
        $staff = ORM::for_table('sys_users')->find_one($collectedByStaffId);

        if (!$staff) {
            echo json_encode([
                "message"       => "Staff user not found",
                "status"        => "error",
                "type_method"   => "",
            ]);
            exit;
        }
        $collectedByStaffName = $staff->fullname;

        $pgateway          = _post('pgateway'); // pasarelas de pago
        $type_pgateway     = _post('type_pgateway');
        $getTerminalReader = _post('getTerminalReader'); // terminales POS
        $bankAccounts      = _post('bankAccounts'); // cuentas bancarias en stripe

        $secret_key_stripe = "";

        if ($account == '') {
            echo json_encode([
                "message"       => "Select An Account before continue",
                "status"        => "error",
                "type_method"   => "",
            ]);
            exit;
        }

        $date = _post('date');
        $amount = _post('amount');

        $currency_iso_code = _post('currency');

        // metodo seleccionado
        $pmethod = _post('pmethod');

        if (empty($pmethod)) {
            echo json_encode([
                "message"       => "!The method is required¡",
                "status"        => "error",
                "type_method"   => "",
            ]);
            exit;
        }

        $i = ORM::for_table('sys_invoices')->find($iid);
        if (!$i) {
            echo json_encode([
                "message"       => "Invoice not found",
                "status"        => "error",
                "type_method"   => "",
            ]);
            exit;
        }

        $mysqli = new \mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);
        $mysqli->set_charset("utf8");

        $tener_invoices = $mysqli->query("SELECT * FROM sys_invoices WHERE id='$iid'")->fetch_all(MYSQLI_ASSOC);

        if (count($tener_invoices) == 0) {
            echo json_encode([
                "message"       => "¡Invoice not found!",
                "status"        => "error",
                "type_method"   => $pmethod,
            ]);
            exit;
        }

        $staff_id = $tener_invoices[0]["aid"];

        if (empty($currency_iso_code)) {
            $currency_iso_code = $i['currency_iso_code'] ?? $config['home_currency'];
        }

        $amount = createFromCurrency($amount, $currency_iso_code);

        $rate = 1.00;

        if (!empty($currency_iso_code) && ($currency_iso_code != $config['home_currency'])) {
            $find_currency = \Currency::where('iso_code', $currency_iso_code)->first();
            if ($find_currency) {
                $rate = $find_currency->rate;
            }
        }

        $payerid = _post('payer');

        $getSysMethods = $mysqli->query("SELECT * FROM sys_pmethods WHERE id= $pmethod")->fetch_assoc();

        if (empty($getSysMethods)) {
            echo json_encode([
                "message"       => "¡Method not found!",
                "status"        => "error",
                "type_method"   => $pmethod,
            ]);
            exit;
        }

        $pmethod_id       = $getSysMethods["id"];
        $pmethod          = $getSysMethods["name"];

        $id_reader_stripe = null;

        $secret_key_stripe = null;
        $configuration_id_stripe = null;

        $payment_method_account_bank = null;
        $customer_id_account_bank    = null;

        // terminal POS (Stripe)
        if ($pmethod_id == 4) {
            if (empty($getTerminalReader)) {
                echo json_encode([
                    "message"       => "¡The POS terminal id is required!",
                    "status"        => "error",
                    "type_method"   => $pmethod_id,
                ]);
                exit;
            }

            $getDataReaderTerminal = $mysqli->query("SELECT * FROM `reader_terminal` WHERE id = $getTerminalReader")->fetch_assoc();

            if (empty($getDataReaderTerminal)) {
                echo json_encode([
                    "message"       => "¡Method not found!",
                    "status"        => "error",
                    "type_method"   => $pmethod_id,
                ]);
                exit;
            }


            $id_reader_stripe = $this->resolveStripeReaderId(
                $getDataReaderTerminal["id_reader_stripe"] ?? null
            );


            if (empty($id_reader_stripe)) {
                echo json_encode([
                    "message"       => "¡The selected reader does not have an identifier provided by Stripe!",
                    "status"        => "error",
                    "type_method"   => $pmethod_id,
                ]);
                exit;
            }

            $pgateway = $getDataReaderTerminal["stripe_configuration_id"];

            if (empty($pgateway)) {
                echo json_encode([
                    "message"       => "¡The reader's configuration id is empty. The Stripe configuration id is empty!",
                    "status"        => "error",
                    "type_method"   => $pmethod_id,
                ]);
                exit;
            }

            $gateway_config = ORM::get_db()
                ->query("SELECT * FROM sys_pg WHERE id='$pgateway' AND status='Active'")
                ->fetch(\PDO::FETCH_ASSOC);
        
            if (empty($gateway_config)) {
                echo json_encode([
                    "message" => "The Stripe configuration for the POS terminal is inactive or does not exist.",
                    "status" => "error",
                    "type_method" => $pmethod_id,
                ]);
                exit;
            }
        
            $nombre_pasarela = $gateway_config["identificador"] ?? "";
            $secret_key_db = $gateway_config["c1"] ?? null;
            $public_key_stripe = $gateway_config["value"] ?? null;
        
            require __DIR__ . '/../../stripe/init.php';

            $secret_key_stripe = $this->resolveStripeSecretKey($secret_key_db);
        
            try {
                
                $stripe = new \Stripe\StripeClient($secret_key_stripe);
                $data_stripe = $stripe->accounts->retrieve();    
                
            } catch (\Stripe\Exception\AuthenticationException $e) {
                $response = [
                    "message"       => "The Stripe configuration for the POS terminal is inactive or invalid",
                    "status"        => "error",
                    "type_method"   => $pmethod_id,
                ];

                echo json_encode($response);
                exit;
            } catch (\Exception $e) {
                echo json_encode([
                    "message" => "Stripe config invalid: " . $e->getMessage(),
                    "status" => "error",
                    "type_method" => $pmethod_id,
                ]);
                exit;
            }
        }

        // cuentas bancarias
        if ($pmethod_id == 2) {
            if (empty($bankAccounts)) {
                echo json_encode([
                    "message"       => "¡The bank account ID is required!",
                    "status"        => "error",
                    "type_method"   => $pmethod_id,
                ]);
                exit;
            }

            $getDataBankAccount = $mysqli->query("SELECT * FROM `credit_plan_payment_method` WHERE id = $bankAccounts")->fetch_assoc();

            if (empty($getDataBankAccount)) {
                echo json_encode([
                    "message"       => "¡The bank account ID was not found in the database!",
                    "status"        => "error",
                    "type_method"   => $pmethod_id,
                ]);
                exit;
            }

            $configuracion_stripe_id = $getDataBankAccount["configuracion_stripe_id"];

            $payment_method_account_bank = $getDataBankAccount["payment_method"];
            $customer_id_account_bank    = $getDataBankAccount["customer_id"];

            $gateway_config = ORM::get_db()->query("SELECT * FROM sys_pg where id = '$configuracion_stripe_id' AND status='Active'")->fetch(\PDO::FETCH_ASSOC);

            if (empty($gateway_config) == true) {
                echo json_encode([
                    "message"       => "¡The payment gateway configured in the bank account is inactive or was not found!",
                    "status"        => "error",
                    "type_method"   => $pmethod_id,
                ]);
                exit;
            }

            $secret_key_db       = $gateway_config["c1"];
            $public_key_stripe       = $gateway_config["value"];
            $configuration_id_stripe = $gateway_config["id"];

            require __DIR__ . '/../../stripe/init.php';

            $secret_key_stripe = $this->resolveStripeSecretKey($secret_key_db);

            try {
                $stripe = new \Stripe\StripeClient($secret_key_stripe);
                $stripe->accounts->retrieve();
            } catch (\Stripe\Exception\AuthenticationException $e) {
                echo json_encode([
                    "message"       => "¡The payment gateway configured in the bank account is inactive or was not found!",
                    "status"        => "error",
                    "type_method"   => $pmethod_id,
                ]);
                exit;
            } catch (\Exception $e) {
                echo json_encode([
                    "message"       => "Error in the selected payment gateway: " . $e->getMessage(),
                    "status"        => "error",
                    "type_method"   => $pmethod_id,
                ]);
                exit;
            }
        }

        $ref = _post('ref');
        if ($payerid == '') {
            $payerid = '0';
        }

        $payer = '';

        if ($payerid != '0') {
            $payer_find = Contact::find($payerid);

            if ($payer_find) {
                $payer = $payer_find->account;
            }
        }

        $currencies = \Currency::all();
        $tr_currency = '0';
        $tr_currency_symbol = '';
        $tr_currency_rate = '1.0000';

        $cat = _post('cats', 0);
        $category_name = '';
        $cat_id = 0;
        if (!empty($cat)) {
            $catetory = \TransactionCategory::find($cat);
            if ($catetory) {
                $category_name = $catetory->name;
                $cat_id = $catetory->id;
            }
        }

        $invoice = \Invoice::find($iid);
        if (!$invoice) {
            echo json_encode([
                "message"       => "Invoice not found",
                "status"        => "error",
                "type_method"   => $pmethod_id,
            ]);
            exit;
        }

        $currency_iso_code = $config['home_currency'];

        if ($invoice && $invoice->currency_iso_code) {
            $currency_iso_code = $invoice->currency_iso_code;
        }

        $errors = [];

        if ($payerid === '0') {
            $errors[] = 'Payer not found';
        }
        
        $description = trim((string) _post('description'));
        if ($description === '') {
            $errors[] = 'Description is required';
        }
        
        if ($account === '' || $account === null) {
            $errors[] = 'Please choose an account';
        }

        if (!empty($errors)) {
            echo json_encode([
                "status"      => "error",
                "type_method" => $pmethod_id ?? "",
                "message"     => implode(" | ", $errors),
                "errors"      => $errors,
            ]);
            exit;
        }

        // procesar pago (tras validar datos)
        $account_find = \Account::find($account);
        if (!$account_find) {
            echo json_encode([
                "message"       => "Account not found",
                "status"        => "error",
                "type_method"   => $pmethod_id,
            ]);
            exit;
        }
        $amount_total = $amount;

        $d = ($pmethod_id == 3) || ($pmethod_id == 4) || ($pmethod_id == 2) ? ORM::for_table('sys_transactions_temp')->create() : new \Transaction();
        $d->account = $account_find->account;
        $d->account_id = $account_find->id;
        $d->type = 'Income';
        $d->payerid = $payerid;
        $d->amount = $amount;
        $d->category = $category_name;
        $d->cat_id = $cat_id;
        $d->method = $pmethod;
        $d->ref = $ref;
        $d->tags = '';
        $d->description = $description;
        $d->date = $date;
        $d->dr = '0.00';
        $d->cr = $amount;

        $d->iid = $iid;
        $d->currency = $tr_currency;
        $d->currency_symbol = $tr_currency_symbol;
        $d->currency_rate = $rate;

        $d->currency_iso_code = $currency_iso_code;

        $d->payer = $payer;
        $d->payee = '';

        $d->status = 'Cleared';
        $d->tax = '0.00';
        $d->aid = $collectedByStaffId;
        $d->staff_id_pago = $collectedByStaffId;

        $d->name_pg = "";

        $d->vid = _raid(8);

        $d->updated_at = date('Y-m-d H:i:s');

        $d->staff_id = $collectedByStaffId;

        try {
            $d->save();
            $tid = (int) $d->id;
        } catch (\Exception $e) {
            echo json_encode([
                "message"       => "Stripe: " . $e->getMessage(),
                "status"        => "error",
                "type_method"   => $pmethod_id,
            ]);
            exit;
        }

        // tarjeta (link de pago)
        if ($pmethod_id == 3) {

            $gateway_config = ORM::get_db()->query("SELECT * FROM sys_pg where id='$pgateway' AND status='Active'")->fetch(\PDO::FETCH_ASSOC);

            if (empty($gateway_config) == true) {
                $this->rollbackTempTransaction($tid);

                echo json_encode([
                    "message"       => "¡You must enable the payment gateway. Setting > Payment Gateway. Your type must be Stripe!",
                    "status"        => "error",
                    "type_method"   => $pmethod_id,
                ]);
                exit;
            }

            $name_ = $gateway_config["name"];

            if ($name_ == "Stripe") {
                $type_pgateway = 1;
            }

            if ($name_ == "Square") {
                $type_pgateway = 2;
            }

            $nombre_pasarela = $gateway_config["identificador"];

            $aplication_id   = $gateway_config["value"];
            $acceso_token    = $gateway_config["c1"];
            $location_id     = $gateway_config["c2"];
            $version         = $gateway_config["c3"];
            $url_api_square  = "";

            if ($type_pgateway == 1) {
                $secret_key_db = $gateway_config["c1"];
                $public_key_stripe = $gateway_config["value"];

                require __DIR__ . '/../../stripe/init.php';

                $secret_key_stripe = $this->resolveStripeSecretKey($secret_key_db);

                try {

                    $stripe = new \Stripe\StripeClient($secret_key_stripe);
                    $stripe->accounts->retrieve();

                } catch (\Stripe\Exception\AuthenticationException $e) {

                    $this->rollbackTempTransaction($tid);
                    echo json_encode([
                        "message"       => "Error: " . $e->getMessage(),
                        "status"        => "error",
                        "type_method"   => $pmethod_id,
                    ]);
                    exit;

                } catch (\Exception $e) {

                    $this->rollbackTempTransaction($tid);
                    echo json_encode([
                        "message"       => "Error: " . $e->getMessage(),
                        "status"        => "error",
                        "type_method"   => $pmethod_id,
                    ]);
                    exit;

                }

            }

            if ($type_pgateway == 2) {
                $dataConfiguracion = ORM::get_db()->query("SELECT * FROM sys_appconfig where setting = 'url_api_square'; ")->fetch(\PDO::FETCH_ASSOC);

                if (empty($dataConfiguracion) || empty($dataConfiguracion["value"])) {
                    $this->rollbackTempTransaction($tid);

                    echo json_encode([
                        "message"       => "¡There's no URL to create a payment link with Square. Contact support!",
                        "status"        => "error",
                        "type_method"   => $pmethod_id,
                    ]);
                    exit;
                }

                $url_api_square = $dataConfiguracion["value"];
            }

            $tot = intval(floatval($amount) * 100);

            $length = 10;
            $llave = substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, $length);
            $date = date('Ymdhis');
            $token = $date . $llave;
            $opciones = ['cost' => 12];
            $token_encrypt = password_hash($token, PASSWORD_BCRYPT, $opciones);
            $date = date('Y-m-d H:i:s');

            if ($type_pgateway == 1) {
                ORM::get_db()->query(
                    "INSERT INTO payment_links (id_invoice, id_stripe, id_transactions_temp, token, token_encrypt, amount, date_create, url, secret_key_pg, public_key_pg) VALUES ('$iid', '', '$tid', '$token', '$token_encrypt', '$amount', '$date', '', '$secret_key_stripe', '$public_key_stripe')"
                );
            }

            if ($type_pgateway == 2) {
                ORM::get_db()->query(
                    "INSERT INTO payment_links (id_invoice, id_stripe, id_transactions_temp, token, token_encrypt, amount, date_create, url, secret_key_pg, public_key_pg, version_square, token_square, location_ids_square) VALUES ('$iid', '', '$tid', '$token', '$token_encrypt', '$amount', '$date', '', '', '', '$version', '$acceso_token', '$location_id')"
                );
            }

            $id_payment = ORM::get_db()->lastInsertId();

            if ($type_pgateway == 1) {
                try {
                    $stripe = new \Stripe\StripeClient($secret_key_stripe);
                    $checkout_session = $stripe->checkout->sessions->create([
                        'line_items' => [[
                            'price_data' => [
                                'currency' => 'usd',
                                'product_data' => [
                                    'name' => $description,
                                ],
                                'unit_amount' => $tot,
                            ],
                            'quantity' => 1,
                        ]],
                        'mode' => 'payment',
                        'payment_intent_data' => [
                            'description' => 'A payment link was successfully created. The invoice number is: ' . $invoice->invoicenum . $invoice->cn,
                            'metadata' => [
                                'id_payment'   => (string) $id_payment,
                                'id_invoice'   => (string) $iid,
                                'type_payment' => 'payment_link',
                            ],
                        ],
                        'metadata' => [
                            'id_payment'   => (string) $id_payment,
                            'id_invoice'   => (string) $iid,
                            'type_payment' => 'payment_link',
                        ],
                        'success_url' => U . "valid&tkn=" . $token_encrypt . "&id_payment=$id_payment",
                        'cancel_url' => U . "cancel&tkn=" . $token_encrypt . "&id_payment=$id_payment",
                    ]);

                    $id_stripe = $checkout_session->id;
                    $id_stripe_response = $id_stripe;
                    $url = $checkout_session->url;

                    ORM::get_db()->query("UPDATE payment_links SET id_stripe='$id_stripe', url='$url', type_payment = 'Stripe' WHERE id_payment='$id_payment'");
                } catch (\Stripe\Exception\AuthenticationException $e) {
                    ORM::get_db()->query("DELETE FROM `payment_links` WHERE id_payment='$id_payment'");
                    $this->rollbackTempTransaction($tid);

                    echo json_encode([
                        "message"       => "Error creating payment link: " . $e->getMessage(),
                        "status"        => "error",
                        "type_method"   => $pmethod_id,
                    ]);
                    exit;
                } catch (\Exception $e) {
                    ORM::get_db()->query("DELETE FROM `payment_links` WHERE id_payment='$id_payment'");
                    $this->rollbackTempTransaction($tid);

                    echo json_encode([
                        "message"       => "Error creating payment link: " . $e->getMessage(),
                        "status"        => "error",
                        "type_method"   => $pmethod_id,
                    ]);
                    exit;
                }
            }

            if ($type_pgateway == 2) {
                $informacion = [
                    "url" => $url_api_square,
                    "version" => $version,
                    "token" => $acceso_token,
                    "redirect_url" => U . "valid-square&tkn=" . $token_encrypt . "&id_payment=$id_payment",
                    "location_id" => $location_id,
                    "amount" => $tot,
                    "descripcion" => 'A payment link was successfully created. The invoice number is: ' . $invoice->invoicenum . $invoice->cn,
                ];

                $salida = creacionLinkPagoSquare($informacion);

                if ($salida["status"] == false) {
                    ORM::get_db()->query("DELETE FROM `payment_links` WHERE id_payment='$id_payment'");
                    $this->rollbackTempTransaction($tid);

                    echo json_encode([
                        "message"       => $salida["mensaje"],
                        "status"        => "error",
                        "type_method"   => $pmethod_id,
                    ]);
                    exit;
                }

                $id_square = $salida["payment_link_id"];
                $url       = $salida["long_url"];
                $order_id  = $salida["order_id"];

                ORM::get_db()->query("UPDATE payment_links SET orden_id_square = '$order_id', id_square='$id_square', url='$url', type_payment = 'Square' WHERE id_payment='$id_payment'");
            }

            if (!empty($nombre_pasarela)) {
                $d->name_pg = $nombre_pasarela;
                $d->save();
            }

            // Se marcaba invoice como pagada
            
            /*$i->amount_last_paid = $amount;
            $i->date_last_paid   = date('Y-m-d H:i:s');
            $i->datepaid   = date('Y-m-d H:i:s');
            $i->save();*/
        } else {
            // terminal pos
            if ($pmethod_id == 4) {

                if (!empty($nombre_pasarela)) {
                    $d->name_pg = $nombre_pasarela;
                    $d->save();
                }
        
                
                try {
                    $tot = intval(floatval($amount) * 100);

                    $length         = 10;
                    $llave          = substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, $length);
                    $date           = date('Ymdhis');
                    $token          = $date . $llave;
                    $opciones       = ['cost' => 12];
                    $token_encrypt  = password_hash($token, PASSWORD_BCRYPT, $opciones);
                    $date           = date('Y-m-d H:i:s');

                    $stripe = new \Stripe\StripeClient($secret_key_stripe);

                    //$currency = strtolower($currency_iso_code ?: 'usd');
                    $currency = "USD";
                    $invoiceNum  = $invoice->invoicenum . $invoice->cn;
                    $customer = $account_find->account;
                    $customerName = !empty($payer) ? $payer : $account_find->account;
                    $staff_team = $staff ? $staff->fullname : $user->fullname;

                    $paymentIntent = $stripe->paymentIntents->create([
                        'amount'                => $tot,
                        'currency'              => $currency,
                        'description'           => 'POS - Invoice '. $invoiceNum . ' - Collected by ' . $staff_team,
                        'payment_method_types'  => ['card_present'],
                        'metadata' => [
                            'terminal_identification'   => $getDataReaderTerminal["identification"] ?? '',
                            'terminal_id_reader_stripe' => $id_reader_stripe,
                            'invoice_number'            => $invoiceNum,
                            'customer'                  => $customerName,
                            'staff'                     => $staff_team,
                            'description'               => $description
                        ]
                    ]);

                    $paymentIntentId = $paymentIntent->id;
                    $id_stripe_response = $paymentIntentId;

                    $result = $stripe->terminal->readers->processPaymentIntent(
                        $id_reader_stripe,
                        [
                            'payment_intent' => $paymentIntentId
                        ]
                    );

                    $mysqli = null;

                    $processPaymentIntent = $result->id;

                    try {
                        $mysqli = new \mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);
                        $mysqli->set_charset("utf8");

                        $DB_NAME = DB_NAME;

                        $sql = "INSERT INTO $DB_NAME.payment_terminal (
                                `payment_intent_id`,
                                `process_payment_intent_id`,
                                `id_invoice`,
                                `id_transactions_temp`,
                                `amount`,
                                `secret_key_pg`,
                                `public_key_pg`,
                                `payment_status`,
                                `date_create`,
                                `account`,
                                `account_id`,
                                `name_staff`,
                                `id_staff`
                            ) VALUES (
                                ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?
                            )";

                        $date = date('Y-m-d H:i:s');

                        $stmt = $mysqli->prepare($sql);

                        $payment_status = "Unpaid";

                        $accountName    = $account_find->account;
                        $account_id = $account_find->id;
                        $name_staff = $collectedByStaffName;
                        $id_staff   = $collectedByStaffId;

                        $stmt->bind_param(
                            'sssssssssssss',
                            $paymentIntentId,
                            $processPaymentIntent,
                            $iid,
                            $tid,
                            $amount,
                            $secret_key_stripe,
                            $public_key_stripe,
                            $payment_status,
                            $date,
                            $accountName,
                            $account_id,
                            $name_staff,
                            $id_staff
                        );

                        $stmt->execute();
                        $stmt->close();
                    } catch (\Exception  $e) {
                        $this->rollbackTempTransaction($tid);

                        echo json_encode([
                            "message"       => "Connection error: " . $e->getMessage(),
                            "status"        => "error",
                            "type_method"   => $pmethod_id,
                        ]);
                        exit;
                    }
                } catch (\Stripe\Exception\AuthenticationException $e) {
                    $this->rollbackTempTransaction($tid);

                    echo json_encode([
                        "message"       => "!The selected payment gateway's SECRET KEY is invalid!",
                        "status"        => "error",
                        "type_method"   => $pmethod_id,
                    ]);
                    exit;
                } catch (\Stripe\Exception\ApiErrorException $e) {
                    $this->rollbackTempTransaction($tid);

                    echo json_encode([
                        "message"       => "Stripe: " . $e->getMessage(),
                        "status"        => "error",
                        "type_method"   => $pmethod_id,
                    ]);
                    exit;
                } catch (\Exception $e) {                    
                    $this->rollbackTempTransaction($tid);

                    echo json_encode([
                        "message"       => "Stripe: " . $e->getMessage(),
                        "status"        => "error",
                        "type_method"   => $pmethod_id,
                    ]);
                    exit;
                }
            } else {
                // cuentas bancarias
                if ($pmethod_id == 2) {
                    $date           = date('Y-m-d H:i:s');

                    $datos = [
                        "sk_stripe"      => $secret_key_stripe,
                        "amount"         => $amount,
                        "payment_method" => $payment_method_account_bank,
                        "customer_id"    => $customer_id_account_bank,
                        "type_payment"   => "invoices",
                    ];

                    $res = $this->createStripePayment($datos);

                    if (empty($res) || ($res["status"] ?? false) != true) {
                        $this->rollbackTempTransaction($tid);
                        echo json_encode([
                            "message" => $res["mensaje"] ?? "Error creating Stripe payment",
                            "status"        => "error",
                            "type_method"   => $pmethod_id,
                        ]);
                        exit;
                    }

                    if ($res["status"] == true) {
                        $id_stripe             = $res["id_stripe"];
                        $id_stripe_response    = $id_stripe;
                        $payment_method_stripe = $res["payment_method_stripe"];

                        $mysqli = null;

                        try {
                            $mysqli = new \mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);
                            $mysqli->set_charset("utf8");

                            $DB_NAME = DB_NAME;

                            $sql = "INSERT INTO $DB_NAME.invoice_details_bank_account (
                                    `UUID`,
                                    `UUID_ENC`,
                                    `account`,
                                    `account_id`,
                                    `invoices_id`,
                                    `id_transactions_temp`,
                                    `amount`,
                                    `payment_status`,
                                    `configuration_id_stripe`,
                                    `sk_stripe`,
                                    `pi_stripe`,
                                    `payment_method_stripe`,
                                    `date_create`,
                                    `name_staff`,
                                    `id_staff`
                                ) VALUES (
                                    ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?
                                )";

                            $date = date('Y-m-d H:i:s');

                            $stmt = $mysqli->prepare($sql);

                            $payment_status = 2;

                            $UUID     = generateUUIDv4New();
                            $UUID_ENC = uuidToBase64UrlRFC7515New($UUID);

                            $accountName    = $account_find->account;
                            $account_id = $account_find->id;
                            $name_staff = $collectedByStaffName;
                            $id_staff   = $collectedByStaffId;

                            $stmt->bind_param(
                                'sssssssssssssss',
                                $UUID,
                                $UUID_ENC,
                                $accountName,
                                $account_id,
                                $iid,
                                $tid,
                                $amount,
                                $payment_status,
                                $configuration_id_stripe,
                                $secret_key_stripe,
                                $id_stripe,
                                $payment_method_stripe,
                                $date,
                                $name_staff,
                                $id_staff
                            );

                            $stmt->execute();
                            $stmt->close();

                            $i = ORM::for_table('sys_invoices')->find($iid);

                            if ($i) {
                                $valor_enviar_resena = $i["status"] == "Unpaid" ? "true" : "false";
                                $pc = $i['credit'];
                                $it = $i['total'];
                                $dp = $it - $pc;
                                $i->status = $dp == $amount || $dp < $amount ? 'Paid' : 'Partially Paid';
                                $i->credit = $pc + $amount;
                                $i->amount_last_paid = $amount;
                                $i->date_last_paid   = date('Y-m-d H:i:s');
                                $i->datepaid   = date('Y-m-d H:i:s');
                                $i->save();
                            }
                        } catch (\Exception  $e) {
                            $this->rollbackTempTransaction($tid);

                            echo json_encode([
                                "message"       => "Connection error: " . $e->getMessage(),
                                "status"        => "error",
                                "type_method"   => $pmethod_id,
                            ]);
                            exit;
                        }
                    }
                } else {
                    $i = ORM::for_table('sys_invoices')->find($iid);

                    if ($i) {
                        $fm_id_partner_center = $i->fm_id_partner_center;
                        $date_paid = date('Y-m-d H:i:s');

                        $valor_enviar_resena = $i["status"] == "Unpaid" ? "true" : "false";
                        $pc = $i['credit'];
                        $it = $i['total'];
                        $dp = $it - $pc;
                        $i->status = $dp == $amount || $dp < $amount ? 'Paid' : 'Partially Paid';
                        $i->credit = $pc + $amount;
                        $i->amount_last_paid = $amount;
                        $i->date_last_paid   = $date_paid;
                        $i->datepaid         = $date_paid;
                        $i->save();

                        $status = $dp == $amount || $dp < $amount ? 'Paid' : 'Partially Paid';

                        if (!empty($fm_id_partner_center)) {
                            $isAdminPartnerCRM = $mysqli->query("SELECT `value` FROM `sys_appconfig` WHERE setting = 'crm_partnert_administrativo' ")->fetch_assoc();

                            if (!empty($isAdminPartnerCRM)) {
                                if ($isAdminPartnerCRM["value"] == 1) {
                                    $dataRegister = [
                                        "fm_id"         => $fm_id_partner_center,
                                        "monto"         => $amount_total,
                                        "metodo"        => $pmethod,
                                        "pasarela_pago" => "",
                                        "fecha_pago"    => $date_paid,
                                        "status_pago"   => $status == "Paid" ? 1 : 2,
                                    ];

                                    insertRegister($dataRegister);
                                }
                            }
                        }
                    }
                }
            }
        }

        _log(
            'New Deposit: ' .
            $description .
            ' [TrID: ' .
            $tid .
            ' | Amount: ' .
            $amount .
            ']',
            'Admin',
            $collectedByStaffId
        );
        _msglog('s', 'Transaction Added Successfully');

        $response = [
            "message"                => "Transaction completed successfully",
            "status"                 => "success",
            "type_method"            => $pmethod_id,
            "sys_transaction_temp"   => $tid,
        ];
        if (!empty($id_stripe_response)) {
            $response["id_stripe"] = $id_stripe_response;
        }

        echo json_encode($response);
        exit;
    }

    private function resolveStripeSecretKey(?string $dbSecretKey = null): string
    {
        $env = $_ENV['APP_ENV'] ?? getenv('APP_ENV') ?? 'prod';
        
        // Local
        if ($env === 'local') {
            $secret = $this->getStripeSecretKey();
            $this->guardStripeKeyForEnv($secret);
            return $secret;
        }

        // Prod
        $secret = $dbSecretKey;
        //$secret = $dbSecretKey ?: ($_ENV['STRIPE_SECRET_KEY'] ?? getenv('STRIPE_SECRET_KEY') ?? '');
        $this->guardStripeKeyForEnv($secret);
        return $secret;
    }


    private function guardStripeKeyForEnv($key)
    {
        $env = $_ENV['APP_ENV'] ?? getenv('APP_ENV') ?? 'prod';
        $key = (string)($key ?? '');

        if ($env !== 'prod' && str_starts_with($key, 'sk_live_')) {
            throw new \Exception("Bloqueado: {$env} no puede usar Stripe LIVE key.");
        }

        if ($env === 'prod' && str_starts_with($key, 'sk_test_')) {
            throw new \Exception("Bloqueado: producción no puede usar Stripe TEST key.");
        }

        if ($key === '') {
            throw new \Exception("Stripe secret key vacía.");
        }
    }

    private function getStripeSecretKey()
    {
        $env = $_ENV['APP_ENV'] ?? getenv('APP_ENV') ?? 'prod';
    
        // local
        if ($env === 'local') {
            $secret = $_ENV['STRIPE_TEST_KEY'] ?? getenv('STRIPE_TEST_KEY') ?? '';
            if (!$secret) {
                throw new \Exception('Falta STRIPE_TEST_KEY en entorno local');
            }
    
            if (str_starts_with($secret, 'sk_live_')) {
                throw new \Exception('LOCAL no puede usar Stripe LIVE key');
            }
    
            return $secret;
        }
    
        // prod
        $secret = $_ENV['STRIPE_SECRET_KEY'] ?? getenv('STRIPE_SECRET_KEY') ?? '';
        if (!$secret) {
            throw new \Exception('Falta STRIPE_SECRET_KEY en producción');
        }
    
        if (str_starts_with($secret, 'sk_test_')) {
            throw new \Exception('PRODUCCIÓN no puede usar Stripe TEST key');
        }
    
        return $secret;
    }

    private function resolveStripeReaderId($dbReaderId)
    {
        $env = $_ENV['APP_ENV'] ?? getenv('APP_ENV') ?? 'prod';

        // Local reader de test desde env
        if ($env === 'local') {
            $reader = $_ENV['STRIPE_TEST_READER_ID'] ?? getenv('STRIPE_TEST_READER_ID') ?? '';
            if ($reader === '') {
                throw new \Exception('Falta STRIPE_TEST_READER_ID en local');
            }
            if (!str_starts_with($reader, 'tmr_')) {
                throw new \Exception('STRIPE_TEST_READER_ID inválido');
            }
            return $reader;
        }

        // Prod reader de DB (live)
        if (!$dbReaderId) {
            throw new \Exception('Reader Stripe no configurado en producción');
        }
        return $dbReaderId;
    }


    private function rollbackTempTransaction($tid)
    {
        $tid = (int)$tid;
        if ($tid > 0) {
            ORM::get_db()->query("DELETE FROM sys_transactions_temp WHERE id={$tid}");
        }

    }

    public function createStripePayment($datos)
    {
        $SECRET_KEY_ADMIN = $datos["sk_stripe"];
        $tot              = $datos["amount"];
        $payment_method   = $datos["payment_method"];
        $customer_id      = $datos["customer_id"];
    
        //en este punto existen dos:
        //credit_line que es para lineas de credito
        //invoices que es para invoices. esto me servira para condicionante en el apartado de webhook para stripe
        $type_payment     = $datos["type_payment"];
    
        try {
    
            $stripe = new \Stripe\StripeClient($SECRET_KEY_ADMIN);
    
            //echo $tot; exit;
    
            $tot = intval(floatval($tot) * 100);
    
            $paymentIntent = $stripe->paymentIntents->create([
                'amount' => $tot, // Monto en centavos (e.g., $10.00)
                'currency' => 'usd',
                'payment_method_types' => ['us_bank_account'],
                'payment_method' => $payment_method,
                'customer' => $customer_id,
                'confirmation_method' => 'manual',
                'confirm' => true, // Confirmar inmediatamente
                //desde aqui es codigo nuevo
                'payment_method_options' => [
                    'us_bank_account' => [
                        'verification_method' => 'instant'  // ¡ACTIVA EL DÉBITO RÁPIDO!
                    ]
                ],
                //hasta aqui es otro codigo nuevo
                'mandate_data' => [
                    'customer_acceptance' => [
                        'type' => 'online',
                        'online' => [
                            'ip_address' => $_SERVER['REMOTE_ADDR'] ?? '127.0.0.1',
                            'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? 'php-client',
                        ],
                    ],
                ],
                'metadata' => [
                    'type_payment' => $type_payment, // ID del pedido en tu sistema
                ],
            ]);
    
    
            /* $fileContent = "Fecha: {$timestamp}\n";
            $fileContent .= "Es JSON válido: " . ($isJson ? "Sí" : "No") . "\n";
            $fileContent .= "Datos: " . json_encode($paymentIntent) . "\n";
            
            $filename = "post_stripe.txt";
            file_put_contents($filename, $fileContent); */
    
            //echo json_encode($paymentIntent); exit;
     
            $salida = [
                "status"                => true,
                "id_stripe"             => $paymentIntent->id,
                "payment_method_stripe" => $paymentIntent->payment_method,
                "mensaje"               => "",
            ];
    
            return $salida;
     
        } catch (\Stripe\Exception\ApiErrorException $e) {
            // Captura errores de Stripe
            //echo "Error de Stripe: " . $e->getMessage() . PHP_EOL;
            //break;
    
            $salida = [
                "status"                => false,
                "id_stripe"             => "",
                "payment_method_stripe" => "",
                "mensaje"               => $e->getMessage(),
            ];
    
            return $salida;
           
        } catch (Exception $e) {
            // Captura errores generales
            //echo "Error general: " . $e->getMessage() . PHP_EOL;
            //break;
           
            $salida = [
                "status"                => false,
                "id_stripe"             => "",
                "payment_method_stripe" => "",
                "mensaje"               => $e->getMessage(),
            ];
    
            return $salida;
    
        }
    }
    
}
