<?php
namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\Transaction;
use App\Models\User;
use ORM;

class TransactionController extends BaseController
{
    public function deleteTransaction()
    {
        header('Content-Type: application/json');

        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            http_response_code(405);
            echo json_encode([
                'status' => 'error',
                'message' => 'Method not allowed. Use POST.',
            ]);
            exit;
        }

        $user = User::_info();
        if (!has_access($user->roleid, 'transactions', 'delete')) {
            http_response_code(403);
            echo json_encode([
                'status' => 'error',
                'message' => 'Permission Denied',
            ]);
            exit;
        }

        $id = (int) _post('id');
        if (empty($id)) {
            http_response_code(400);
            echo json_encode([
                'status' => 'error',
                'message' => 'Invalid transaction id',
            ]);
            exit;
        }

        $transaction = ORM::for_table('sys_transactions')->find_one($id);
        if (!$transaction) {
            http_response_code(404);
            echo json_encode([
                'status' => 'error',
                'message' => 'Transaction not found',
            ]);
            exit;
        }

        $method = strtolower(trim($transaction['method'] ?? ''));
        if ($method !== 'cash') {
            http_response_code(400);
            echo json_encode([
                'status' => 'error',
                'message' => 'Only cash transactions can be deleted',
            ]);
            exit;
        }

        if (Transaction::remove($id)) {
            Transaction::rebuildCatData();
            http_response_code(200);
            echo json_encode([
                'status' => 'success',
                'message' => 'Transaction deleted',
            ]);
            exit;
        }

        http_response_code(404);
        echo json_encode([
            'status' => 'error',
            'message' => 'Transaction not found',
        ]);
        exit;
    }
}
