<?php
namespace App\Database;

use Illuminate\Database\Capsule\Manager as Capsule;

class Connection
{
    protected $capsule;
    protected $configdb;

    public function __construct()
    {
        $this->capsule = new Capsule;
        $this->configdb = require __DIR__ . '/../config/database.php';

        $this->capsule->addConnection([
            'driver'    => $this->configdb['driver'] ?? 'mysql',
            'host'      => $this->configdb['host'],
            'database'  => $this->configdb['database'],
            'username'  => $this->configdb['username'],
            'password'  => $this->configdb['password'],
            'charset'   => $this->configdb['charset'] ?? 'utf8',
            'collation' => $this->configdb['collation'] ?? 'utf8_unicode_ci',
            'prefix'    => $this->configdb['prefix'] ?? '',
        ]);

        $this->capsule->bootEloquent();
    }


    public function getCapsule()
    {
        return $this->capsule;
    }
}
