<?php

namespace App\Database;

use PDO;

final class ConnectionFactory
{
    private static ?PDO $clientDb = null;

    public static function client(): PDO
    {
        if (self::$clientDb instanceof PDO) {
            return self::$clientDb;
        }

        $dbConfig = require __DIR__ . '/../config/database.php';

        $driver  = $dbConfig['driver'] ?? 'mysql';
        $host    = $dbConfig['host'] ?? 'localhost';
        $port    = $dbConfig['port'] ?? '';
        $dbname  = $dbConfig['database'] ?? '';
        $user    = $dbConfig['username'] ?? '';
        $pass    = $dbConfig['password'] ?? '';
        $options = $dbConfig['options'] ?? [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
        ];

        $dsnParts = array_filter([
            "host={$host}",
            $port ? "port={$port}" : null,
            "dbname={$dbname}",
            "charset=utf8mb4",
        ]);

        $dsn = $driver . ':' . implode(';', $dsnParts);

        self::$clientDb = new PDO($dsn, $user, $pass, $options);
        return self::$clientDb;
    }
}
