<?php
namespace App\Library;

class UUIDHelper
{
    /**
     * Generate a UUID v4 using random bytes.
     */
    public static function generateUniqueId(): string
    {
        $data = random_bytes(16);

        // Set version to 0100
        $data[6] = chr((ord($data[6]) & 0x0f) | 0x40);
        // Set bits 6-7 to 10
        $data[8] = chr((ord($data[8]) & 0x3f) | 0x80);

        $hex = bin2hex($data);

        return sprintf(
            '%s-%s-%s-%s-%s',
            substr($hex, 0, 8),
            substr($hex, 8, 4),
            substr($hex, 12, 4),
            substr($hex, 16, 4),
            substr($hex, 20, 12)
        );
    }

    /**
     * Convert a UUID (hex with hyphens) to Base64 URL-safe (RFC 7515).
     */
    public static function convertToBase64(string $uuid): string
    {
        $clean = str_replace('-', '', $uuid);
        if (strlen($clean) !== 32) {
            throw new InvalidArgumentException('UUID must be 32 hex characters (hyphens optional).');
        }

        $binary = hex2bin($clean);
        $base64 = base64_encode($binary);

        return rtrim(strtr($base64, '+/', '-_'), '=');
    }
}
