<?php

namespace App\Middleware;

class AuthMiddleware
{
    /**
     * Ensure request has an authenticated user.
     * Returns user info on success, sends 401 on failure.
     */
    public static function ensureAuthenticated()
    {
        if (session_status() !== PHP_SESSION_ACTIVE) {
            session_start();
        }

        // Use existing auth helper
        $user = \User::_info();

        if (!$user) {
            header('Content-Type: application/json', true, 401);
            echo json_encode([
                'status' => 'error',
                'message' => 'Unauthorized',
            ]);
            exit;
        }

        return $user;
    }
}
