<?php

namespace App\Middleware;

class PlaidAuthMiddleware
{
    /**
     * Ensure request has an authenticated client.
     * Returns client info on success, sends 401 on failure.
     */
    public static function ensureAuthenticatedClient()
    {
        if (session_status() !== PHP_SESSION_ACTIVE) {
            session_start();
        }

        $client_token = $_COOKIE['cloudonex_client_token'] ?? $_SESSION['cloudonex_client_token'] ?? null;
        if ($client_token) {
            $client = \ORM::for_table('crm_accounts')
                ->where('token', $client_token)
                ->first();
            if ($client) {
                return $client;
            }
        }

        $user = \User::_info();
        if ($user) {
            return $user;
        }

        header('Content-Type: application/json', true, 401);
        echo json_encode([
            'error' => 'NO',
            'message' => 'Invalid or expired session',
        ]);
        exit;
    }
}
