<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Database\Connection;
use ORM;

class Contact extends Model
{
    protected $table = 'crm_accounts';

    protected static function booted()
    {
        $capsule = new Connection();
        static::setConnectionResolver($capsule->getCapsule()->getDatabaseManager());
    }

    /**
     * @return array
     */
    public static function asArray()
    {
        return Contact::all()
        ->keyBy('id')
        ->toArray();
    }

    public static function _detail()
    {
        $d = false;

        if (isset($_COOKIE['cloudonex_client_token'])) {
            $cloudonex_client_token = $_COOKIE['cloudonex_client_token'];
        } elseif (isset($_SESSION['cloudonex_client_token'])) {
            $cloudonex_client_token = $_SESSION['cloudonex_client_token'];
        } else {
            exit(
                'You have logged out. <a href="' .
                    U .
                    'client/login/">Click Here to Login.</a>'
            );
        }

        $d = ORM::for_table('crm_accounts')
            ->where('token', $cloudonex_client_token)
            ->first();

        if (!$d) {
            exit(
                'You have logged out. <a href="' .
                    U .
                    'client/login/">Click Here to Login.</a>'
            );
        }

        return $d;
    }

    public static function hasLoginToken()
    {
        if (isset($_COOKIE['cloudonex_client_token'])) {
            return true;
        }
        return isset($_SESSION['cloudonex_client_token']);
    }

    /**
     * @return bool
     */
    public static function isLoggedIn()
    {
        if (isset($_COOKIE['cloudonex_client_token'])) {
            $cloudonex_client_token = $_COOKIE['cloudonex_client_token'];
        } elseif (isset($_SESSION['cloudonex_client_token'])) {
            $cloudonex_client_token = $_SESSION['cloudonex_client_token'];
        } else {
            return false;
        }

        return self::where('token', $cloudonex_client_token)->first();
    }

    /**
     * @return mixed
     */
    public static function getAllContacts()
    {
        return Contact::select(['id', 'account', 'email', 'phone', 'company'])
        ->orderBy('id', 'desc')
        ->get();
    }

    public static function customers()
    {
        return self::select(['id', 'account', 'email', 'phone', 'company'])
        ->orderBy('id', 'desc')
        ->limit(2000)
        ->get();
    }

    public function verificationadress($address, $city,  $state, $zip){
        $address=str_replace(" ", "+", $address);
        $city=str_replace(" ", "+", $city);
        $state=str_replace(" ", "+", $state);
        $zip=str_replace(" ", "+", $zip);

        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => 'https://us-street.api.smarty.com/street-address?auth-id=3dadaa18-e8dc-c515-2949-34143a71d983&auth-token=VhYXG5hydMiGmbim2ErS&license=us-core-cloud&street='.$address.'&city='.$city.'&state='.$state.'&zipcode='.$zip.'',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'GET',
      ));

        $response = curl_exec($curl);
        curl_close($curl);
        $datos=json_decode($response);

        if (count($datos) > 0) {
            return true;
        }
        return false;


    }


}
