<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Database\Connection;

class User extends Model
{
    protected $table = 'sys_users';

    protected static function booted()
    {
        $capsule = new Connection();
        static::setConnectionResolver($capsule->getCapsule()->getDatabaseManager());
    }

    public static function _info()
    {
        $id = $_SESSION['uid'] ?? null;
        
        if (!$id) {
            echo json_encode([
                'error'   => 'UNAUTHENTICATED',
                'message' => 'Invalid or expired session'
            ]);
            exit;
        }

        return self::find($id);
    }

    public static function admin()
    {
        if(isset($_SESSION['uid']))
        {
            return self::find($_SESSION['uid']);
        }
        return false;
    }

}
