<?php

namespace App\Repositories;

use ORM;

class InvoiceRepository
{
    public function findByCustomerId(int $customerId): array
    {
        $rows = ORM::for_table('sys_invoices')
            ->select('id')
            ->select('invoicenum')
            ->select('cn')
            ->select('total')
            ->select('status')
            ->select('currency')
            ->select('date')
            ->where('userid', $customerId)
            ->where_not_in('status', ['Paid', 'Cancelled', 'Canceled'])
            ->order_by_desc('id')
            ->find_array();

        foreach ($rows as &$row) {
            $invoicenum = (string) ($row['invoicenum'] ?? '');
            $cn = (string) ($row['cn'] ?? '');
            $row['invoice_display'] = $invoicenum . $cn;
        }

        return $rows;
    }
}
