<?php

namespace App\Repositories;

use ORM;

class UserRepository
{
    public function findByUsername(string $username)
    {
        return ORM::for_table('sys_users')
            ->where('username', $username)
            ->first();
    }

    public function setResetToken(int $userId, string $token, int $expiresAt)
    {
        $user = ORM::for_table('sys_users')->find_one($userId);
        if (!$user) {
            return false;
        }

        $user->pwresetkey = $token;
        $user->keyexpire = $expiresAt;
        $user->save();

        return $user;
    }
}
