<?php
//require_once __DIR__ . '/../../../vendor/autoload.php';
//error_reporting(E_ALL); ini_set('display_errors', 1); ini_set('display_startup_errors', 1);

$API_PATH = "/api";

// Dashboard Controller
$router->get("{$API_PATH}/dashboard/data", 'DashboardController@getDashboardData');
$router->get("{$API_PATH}/dashboard/sales", 'DashboardController@getDashboardSalesData');
$router->get("{$API_PATH}/dashboard/user/data", 'EmployeeDashboardController@getDashboardData');
$router->post("{$API_PATH}/dashboard/user/data", 'EmployeeDashboardController@getDashboardData');

// Smarty API Controller
$router->get("{$API_PATH}/address/suggest", 'SmartyAPIController@suggestAddress');
$router->get("{$API_PATH}/address/select-unit", 'SmartyAPIController@selectUnit');

// Customer Controller
$router->post("{$API_PATH}/contacts/list", 'CustomerController@list');
$router->get("{$API_PATH}/contacts/summary/{id}", 'CustomerController@getSummary');
$router->post("{$API_PATH}/contacts/update/{id}", 'CustomerController@updateContact');
$router->post("{$API_PATH}/contacts/invoices", 'CustomerController@getInvoices');
$router->post("{$API_PATH}/contacts/payment-methods", 'CustomerController@getPaymentMethods');
$router->post("{$API_PATH}/contacts/payment-methods/table", 'CustomerController@getPaymentMethodsTable');
$router->post("{$API_PATH}/contacts/post-payment-method-customer", 'CustomerController@postPaymentMethodCustomer');
$router->post("{$API_PATH}/contacts/payment-methods/verify-bank-code", 'CustomerController@verifyBankAccountCode');


// Invoice Controller
$router->get("{$API_PATH}/invoices/{id}/context", 'InvoiceController@getInvoiceContext');
$router->get("{$API_PATH}/invoices/{id}", 'InvoiceController@getInvoiceById');

// Transaction Controller
$router->post("{$API_PATH}/transactions/delete", 'TransactionController@deleteTransaction');

// Plaid Controller
$router->post("{$API_PATH}/plaid/create_link_token", 'PlaidController@createLinkToken');
$router->post("{$API_PATH}/plaid/exchange_public_token", 'PlaidController@exchangePublicToken');
$router->post("{$API_PATH}/plaid/transactions", 'PlaidController@getTransactions');
$router->get("{$API_PATH}/plaid/connection/status", 'PlaidController@connectionStatus');

// PBX Controller
$router->post("{$API_PATH}/pbx/authenticate", 'PbxController@authenticate');
$router->post("{$API_PATH}/pbx/cdr", 'PbxController@getCdr');
$router->post("{$API_PATH}/pbx/cdr/sync", 'PbxController@syncCdrCache');
$router->get("{$API_PATH}/pbx/connection/status", 'PbxController@connectionStatus');

// Stripe Controller
$router->post("{$API_PATH}/stripe/validate-link", 'StripeController@validatePaymentLink');
$router->post("{$API_PATH}/stripe/payment", 'StripeController@addPaymentPost');

$router->post("{$API_PATH}/webhooks/stripe/invoice-status", 'InvoicesStatusController@handleStripeWebhook');

// Billing (Stripe)
$router->post("{$API_PATH}/billing/customers", 'BillingController@createCustomer');
$router->post("{$API_PATH}/billing/config", 'BillingController@getConfig');
$router->post("{$API_PATH}/billing/gateways", 'BillingController@listGateways');
$router->post("{$API_PATH}/billing/plans", 'BillingController@listPlans');
$router->post("{$API_PATH}/billing/setup-intents", 'BillingController@createSetupIntent');
$router->post("{$API_PATH}/billing/payment-methods/default", 'BillingController@setDefaultPaymentMethod');
$router->post("{$API_PATH}/billing/payment-methods/list", 'BillingController@listPaymentMethods');
$router->post("{$API_PATH}/billing/payment-methods/save", 'BillingController@savePaymentMethod');
$router->post("{$API_PATH}/billing/payment-methods/default/get", 'BillingController@getDefaultPaymentMethod');
$router->post("{$API_PATH}/billing/payment-methods/bank-setup", 'BillingController@createBankAccountSetup');
$router->post("{$API_PATH}/billing/subscriptions", 'BillingController@createSubscription');
$router->post("{$API_PATH}/billing/subscriptions/list", 'BillingController@listSubscriptions');
$router->post("{$API_PATH}/billing/subscriptions/cancel", 'BillingController@cancelSubscriptionOrInvoice');
$router->post("{$API_PATH}/billing/subscriptions/cancel-immediate", 'BillingController@cancelSubscriptionOrInvoiceImmediate');
$router->post("{$API_PATH}/webhooks/stripe", 'BillingController@handleStripeWebhook');

// Company Controller
$router->post("{$API_PATH}/company/list", 'CompanyController@list');


// Forms download
$router->post("{$API_PATH}/form/w7/{uuid}", 'FormDownloadController@getW7');
$router->post("{$API_PATH}/form/656/{uuid}", 'FormDownloadController@get656');
$router->post("{$API_PATH}/form/433a/{uuid}", 'FormDownloadController@get433A');

// Forms OCR
$router->post("{$API_PATH}/form/ocr", 'FormOcrController@process');

// Auth (public)
$router->post("{$API_PATH}/auth/password/recover", 'Auth\AuthController@forgotPasswordPost');

// 404
$router->set404(function() {});

$router->run();
